/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.ActionTable;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassConditionProtectionTable;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.IndexTable;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.pwfl.archive.ArchiveStorageService;
import com.suncode.pwfl.archive.Directory;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import jxl.CellView;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.log4j.Logger;

@Deprecated(since="4.2", forRemoval=true)
public class ExportDocClasses
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ExportDocClasses.class);

    @AdvancedTask(name="ExportDocClasses", description="ExportDocClasses_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ExportDocClassesToXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************************ ExportDocClassesToXLS(sXLSPath=" + sXLSPath + ") *************************"));
        long startTime = new Date().getTime();
        File xls = new File(sXLSPath);
        WorkbookSettings wbs = new WorkbookSettings();
        WritableWorkbook workbook = null;
        WritableFont times12font = null;
        WritableCellFormat times12format = null;
        CellView cellView = null;
        int columnPos = 0;
        int rowPos = 1;
        DBManagement dbm = new DBManagement();
        ArrayList allDocClassesList = null;
        ArrayList indexesForDocClassList = null;
        ArrayList actionsForDocClassList = null;
        ArrayList protectionForDocClassList = null;
        HashMap<String, Integer> docClassIndexNameAndRowPosForMapping = null;
        try {
            int i;
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            wbs.setEncoding("ISO-8859-2");
            workbook = Workbook.createWorkbook((File)xls, (WorkbookSettings)wbs);
            WritableSheet docClassesSheet = workbook.createSheet("Klasy dokument\u00f3w", 0);
            log.info((Object)"Utworzono arkusz do eksportu klas dokument\u00f3w");
            String[] colIDsDocClass = new String[]{"Nazwa klasy", "Opis klasy", "Wa\u017cno\u015b\u0107 liczba dni", "Wa\u017cno\u015b\u0107 do dnia", "Wa\u017cno\u015b\u0107 okres", "Katalog zapisu dokument\u00f3w", "Indeksowanie", "Szyfrowanie", "Kompresja", "Algorytm kodowania", "D\u0142ugo\u015b\u0107 klucza"};
            String[] colIDsIndex = new String[]{"Nazwa indeksu", "Opis indeksu", "Typ indeksu", "Warto\u015bci", "Zmienne do mapowania"};
            String[] colIDsAction = new String[]{"Nazwa akcji", "\u0179rod\u0142o akcji", "Typ akcji", "Nazwa procesu", "Adres URL skryptu", "Czy mapowa\u0107?"};
            String[] colIDsProtection = new String[]{"Nazwa u\u017cytkownika/grupy", "Grupa", "Poziom uprawnienia", "Dodawanie dokument\u00f3w", "Typ warunku", "Warunek"};
            times12font = new WritableFont(WritableFont.TIMES, 12);
            times12font.setBoldStyle(WritableFont.BOLD);
            times12font.setColour(Colour.BLACK);
            cellView = new CellView();
            cellView.setAutosize(true);
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.AQUA);
            for (i = 0; i < colIDsDocClass.length; ++i) {
                CUFTools.addCellToXLSSheet(docClassesSheet, columnPos, 0, colIDsDocClass[i], times12format, cellView);
                ++columnPos;
            }
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.YELLOW);
            for (i = 0; i < colIDsIndex.length; ++i) {
                CUFTools.addCellToXLSSheet(docClassesSheet, columnPos, 0, colIDsIndex[i], times12format, cellView);
                ++columnPos;
            }
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.ORANGE);
            for (i = 0; i < colIDsAction.length; ++i) {
                CUFTools.addCellToXLSSheet(docClassesSheet, columnPos, 0, colIDsAction[i], times12format, cellView);
                ++columnPos;
            }
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.LIGHT_GREEN);
            for (i = 0; i < colIDsProtection.length; ++i) {
                CUFTools.addCellToXLSSheet(docClassesSheet, columnPos, 0, colIDsProtection[i], times12format, cellView);
                ++columnPos;
            }
            ArchiveStorageService as = ServiceFactory.getArchiveStorageService();
            log.info((Object)"Utworzono naglowki w arkuszu");
            log.info((Object)"Pobieranie klas dokumentow");
            allDocClassesList = dbm.GetAllDocClasses();
            if (allDocClassesList != null && allDocClassesList.size() > 0) {
                for (DocClassTable oneDocClass : allDocClassesList) {
                    Directory dirTable;
                    columnPos = 0;
                    if (oneDocClass == null) continue;
                    Long docClassId = oneDocClass.getId();
                    String docClassName = oneDocClass.getDocClassName();
                    String docClassDescr = oneDocClass.getDocClassDescription();
                    String docClassExpType = oneDocClass.getDocClassExpiretionType();
                    String docClassExpDate = oneDocClass.getDocClassExpiretionDate();
                    Long docClassDirId = oneDocClass.getDocClassDirectoryId();
                    String docClassDirName = "";
                    String docClassIndexing = oneDocClass.getDocClassIndex();
                    String docClassCompressing = oneDocClass.getDocClassCompressing();
                    String docClassEncoding = oneDocClass.getDocClassEncoding();
                    String docClassCipher = oneDocClass.getCipherAlgorithm();
                    Long lDocClassKeyLength = oneDocClass.getKeyLength();
                    Object docClassKeyLength = "";
                    log.info((Object)("Eksportowanie danych o klasie dokumentow " + docClassName));
                    CUFTools.addCellToXLSSheet(docClassesSheet, columnPos, rowPos, docClassName, null, cellView);
                    CUFTools.addCellToXLSSheet(docClassesSheet, ++columnPos, rowPos, docClassDescr, null, cellView);
                    ++columnPos;
                    if (docClassExpType.equalsIgnoreCase("period")) {
                        columnPos = 4;
                    } else if (docClassExpType.equalsIgnoreCase("endDay")) {
                        columnPos = 3;
                    }
                    CUFTools.addCellToXLSSheet(docClassesSheet, columnPos, rowPos, docClassExpDate, null, cellView);
                    columnPos = 5;
                    if (docClassDirId != null && docClassDirId > 0L && (dirTable = as.getDirectory(docClassDirId, new String[0])) != null) {
                        docClassDirName = dirTable.getDirectoryName();
                    }
                    CUFTools.addCellToXLSSheet(docClassesSheet, columnPos, rowPos, docClassDirName, null, cellView);
                    CUFTools.addCellToXLSSheet(docClassesSheet, ++columnPos, rowPos, docClassIndexing, null, cellView);
                    CUFTools.addCellToXLSSheet(docClassesSheet, ++columnPos, rowPos, docClassCompressing, null, cellView);
                    CUFTools.addCellToXLSSheet(docClassesSheet, ++columnPos, rowPos, docClassEncoding, null, cellView);
                    CUFTools.addCellToXLSSheet(docClassesSheet, ++columnPos, rowPos, docClassCipher, null, cellView);
                    ++columnPos;
                    if (lDocClassKeyLength != null && lDocClassKeyLength > 0L) {
                        docClassKeyLength = lDocClassKeyLength == 56L ? String.valueOf(docClassKeyLength) + " (tylko dla DES)" : (lDocClassKeyLength == 512L ? String.valueOf(docClassKeyLength) + " (tylko dla RC2)" : (lDocClassKeyLength == 1024L ? String.valueOf(docClassKeyLength) + " (tylko dla RC2)" : String.valueOf(docClassKeyLength)));
                    }
                    CUFTools.addCellToXLSSheet(docClassesSheet, columnPos, rowPos, (String)docClassKeyLength, null, cellView);
                    ++columnPos;
                    log.info((Object)("Pobieranie indeksow dla klasy dokumentow " + docClassName));
                    indexesForDocClassList = DBManagement.GetAllIndecies((String)docClassId.toString());
                    if (indexesForDocClassList != null && indexesForDocClassList.size() > 0) {
                        docClassIndexNameAndRowPosForMapping = new HashMap<String, Integer>();
                        for (IndexTable oneIndex : indexesForDocClassList) {
                            if (oneIndex == null) continue;
                            ++rowPos;
                            columnPos = 11;
                            String indexName = oneIndex.getIndexName();
                            String indexDescr = oneIndex.getIndexDescription();
                            String indexType = oneIndex.getIndexTypeName();
                            String indexDefaultValues = oneIndex.getIndexValues();
                            log.info((Object)("Eksportowanie danych o indeksie " + indexName));
                            CUFTools.addCellToXLSSheet(docClassesSheet, columnPos, rowPos, indexName, null, cellView);
                            CUFTools.addCellToXLSSheet(docClassesSheet, ++columnPos, rowPos, indexDescr, null, cellView);
                            CUFTools.addCellToXLSSheet(docClassesSheet, ++columnPos, rowPos, indexType, null, cellView);
                            CUFTools.addCellToXLSSheet(docClassesSheet, ++columnPos, rowPos, indexDefaultValues, null, cellView);
                            ++columnPos;
                            docClassIndexNameAndRowPosForMapping.put(indexName, rowPos);
                        }
                    } else {
                        log.info((Object)("Brak indeksow dla klasy dokumentow " + docClassName));
                    }
                    log.info((Object)("Pobieranie akcji dla klasy dokumentow " + docClassName));
                    actionsForDocClassList = DBManagement.GetAllActions((String)docClassId.toString());
                    if (actionsForDocClassList != null && actionsForDocClassList.size() > 0) {
                        for (ActionTable oneAction : actionsForDocClassList) {
                            if (oneAction == null) continue;
                            ++rowPos;
                            columnPos = 16;
                            String actionName = oneAction.getActionName();
                            String actionSource = oneAction.getActionSourceName();
                            String actionType = oneAction.getActionTypeName();
                            String actionValue = oneAction.getActionValue();
                            String actionValue2 = oneAction.getActionValue2();
                            String doMapping = "false";
                            String procDefId = "";
                            log.info((Object)("Eksportowanie danych o akcji " + actionName));
                            CUFTools.addCellToXLSSheet(docClassesSheet, columnPos, rowPos, actionName, null, cellView);
                            ++columnPos;
                            if (actionSource == null) {
                                actionSource = "";
                            }
                            if (actionSource.equalsIgnoreCase("newDocument")) {
                                actionSource = "Nowy dokument";
                            } else if (actionSource.equalsIgnoreCase("changeDocument")) {
                                actionSource = "Zmiana dokumentu";
                            } else if (actionSource.equalsIgnoreCase("deleteDocument")) {
                                actionSource = "Usuni\u0119cie dokumentu";
                            } else if (actionSource.equalsIgnoreCase("attachDocument")) {
                                actionSource = "Pod\u0142\u0105czenie dokumentu";
                            } else if (actionSource.equalsIgnoreCase("dettachDocument")) {
                                actionSource = "Od\u0142\u0105czenie dokumentu";
                            } else if (actionSource.equalsIgnoreCase("expireDocument")) {
                                actionSource = "Wyga\u015bni\u0119cie dokumentu";
                            }
                            CUFTools.addCellToXLSSheet(docClassesSheet, columnPos, rowPos, actionSource, null, cellView);
                            ++columnPos;
                            if (actionType == null) {
                                actionType = "";
                            }
                            if (actionType.equalsIgnoreCase("start") || actionType.equalsIgnoreCase("startScript")) {
                                actionType = "Uruchom skrypt";
                            } else if (actionType.equalsIgnoreCase("newProcess")) {
                                actionType = "Utw\u00f3rz nowy proces";
                            } else if (actionType.equalsIgnoreCase("addDocToProcess")) {
                                actionType = "Pod\u0142\u0105cz dokument do procesu";
                            } else if (actionType.equalsIgnoreCase("synchronizeIndecies")) {
                                actionType = "Synchronizuj indeksy";
                            }
                            CUFTools.addCellToXLSSheet(docClassesSheet, columnPos, rowPos, actionType, null, cellView);
                            ++columnPos;
                            if (actionType.equalsIgnoreCase("Uruchom skrypt")) {
                                columnPos = 20;
                            } else {
                                procDefId = actionValue;
                                actionValue = CUFTools.getProcessNameForProcDefId(actionValue);
                            }
                            CUFTools.addCellToXLSSheet(docClassesSheet, columnPos, rowPos, actionValue, null, cellView);
                            columnPos = 21;
                            if (!Tools.isNullOrEmpty((String)actionValue2) && !actionValue2.equalsIgnoreCase("n/a")) {
                                String[] value2SplitTable;
                                doMapping = "true";
                                for (String oneSplit : value2SplitTable = actionValue2.split("&")) {
                                    Integer mappingPos;
                                    String indexName;
                                    String[] secondSplitTable = oneSplit.split("=");
                                    if (secondSplitTable.length != 2) continue;
                                    IndexTable indexTable = DBManagement.getIndex((String)secondSplitTable[0]);
                                    if (indexTable == null || Tools.isNullOrEmpty((String)(indexName = indexTable.getIndexName())) || (mappingPos = (Integer)docClassIndexNameAndRowPosForMapping.get(indexName)) == null) continue;
                                    String variableName = CUFTools.getVarNameForVarId(procDefId, secondSplitTable[1]);
                                    CUFTools.addCellToXLSSheet(docClassesSheet, 15, mappingPos, variableName, null, cellView);
                                }
                            }
                            CUFTools.addCellToXLSSheet(docClassesSheet, columnPos, rowPos, doMapping, null, cellView);
                            ++columnPos;
                        }
                    } else {
                        log.info((Object)("Brak akcji dla klasy dokumentow " + docClassName));
                    }
                    log.info((Object)("Pobieranie praw dla klasy dokumentow " + docClassName));
                    protectionForDocClassList = dbm.GetAllDocClassConditionProtection(docClassId.toString());
                    if (protectionForDocClassList != null && protectionForDocClassList.size() > 0) {
                        for (DocClassConditionProtectionTable oneProtection : protectionForDocClassList) {
                            if (oneProtection == null) continue;
                            ++rowPos;
                            columnPos = 22;
                            String userId = oneProtection.getUserId();
                            String isGroup = oneProtection.getIsGroup();
                            boolean bIsGroup = true;
                            String rightLevel = "";
                            String addDoc = "false";
                            String conditionType = oneProtection.getConditionType();
                            String condition = oneProtection.getCondition();
                            log.info((Object)("Eksportowanie danych o prawach dla klasy dokumentow " + docClassName));
                            CUFTools.addCellToXLSSheet(docClassesSheet, columnPos, rowPos, userId, null, cellView);
                            ++columnPos;
                            if (isGroup != null && isGroup.equalsIgnoreCase("false")) {
                                bIsGroup = false;
                            }
                            CUFTools.addCellToXLSSheet(docClassesSheet, columnPos, rowPos, isGroup, null, cellView);
                            ++columnPos;
                            Set resourceIdsForRight = null;
                            boolean bRightLevelFound = false;
                            resourceIdsForRight = Authorization.listRights((String)RightTreeBuilder.builder().system().archive().docClasses().custom((Object)docClassId).delete().build(), (boolean)bIsGroup);
                            if (resourceIdsForRight != null && resourceIdsForRight.size() > 0 && resourceIdsForRight.contains(userId)) {
                                rightLevel = "Usuwanie";
                                bRightLevelFound = true;
                            }
                            if (!bRightLevelFound && (resourceIdsForRight = Authorization.listRights((String)RightTreeBuilder.builder().system().archive().docClasses().custom((Object)docClassId).modify().build(), (boolean)bIsGroup)) != null && resourceIdsForRight.size() > 0 && resourceIdsForRight.contains(userId)) {
                                rightLevel = "Modyfikacja";
                                bRightLevelFound = true;
                            }
                            if (!bRightLevelFound && (resourceIdsForRight = Authorization.listRights((String)RightTreeBuilder.builder().system().archive().docClasses().custom((Object)docClassId).read().build(), (boolean)bIsGroup)) != null && resourceIdsForRight.size() > 0 && resourceIdsForRight.contains(userId)) {
                                rightLevel = "Odczyt";
                                bRightLevelFound = true;
                            }
                            CUFTools.addCellToXLSSheet(docClassesSheet, columnPos, rowPos, rightLevel, null, cellView);
                            ++columnPos;
                            resourceIdsForRight = Authorization.listRights((String)RightTreeBuilder.builder().system().archive().docClasses().custom((Object)docClassId).release().build(), (boolean)bIsGroup);
                            if (resourceIdsForRight != null && resourceIdsForRight.size() > 0 && resourceIdsForRight.contains(userId)) {
                                addDoc = "true";
                                bRightLevelFound = true;
                            }
                            CUFTools.addCellToXLSSheet(docClassesSheet, columnPos, rowPos, addDoc, null, cellView);
                            ++columnPos;
                            if (conditionType != null) {
                                if (conditionType.equalsIgnoreCase("userProcessesDocuments")) {
                                    conditionType = "Dokumenty w zadaniach u\u017cytkownika";
                                } else if (conditionType.equalsIgnoreCase("compareValues")) {
                                    conditionType = "Por\u00f3wnanie warto\u015bci";
                                }
                            }
                            CUFTools.addCellToXLSSheet(docClassesSheet, columnPos, rowPos, conditionType, null, cellView);
                            CUFTools.addCellToXLSSheet(docClassesSheet, ++columnPos, rowPos, condition, null, cellView);
                            ++columnPos;
                        }
                    } else {
                        log.info((Object)("Brak praw dla klasy dokumentow " + docClassName));
                    }
                    ++rowPos;
                }
            } else {
                log.info((Object)"Brak klas dokumentow w systemie");
            }
            workbook.write();
            workbook.close();
            log.info((Object)("Eksport klas dokumentow do pliku " + sXLSPath + " zakonczony sukcesem"));
        }
        catch (CUFException e) {
            taskLog.error((Object)e.getMessage());
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            try {
                if (xls != null && xls.exists()) {
                    log.warn((Object)("Blad podczas eksportowania klas dokumentow. Usuwanie niepoprawnie utworzonego pliku xls z lokalizacji " + sXLSPath));
                    workbook.close();
                    xls.delete();
                    log.info((Object)"Niepoprawnie utworzony plik xls zostal usuniety");
                }
            }
            catch (Exception ex) {
                taskLog.error((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)ex);
            }
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ExportDocClassesToXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }
}

