/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.PlannedExternalTask.ImportDefaultViews;
import com.plusmpm.CUF.util.PlannedExternalTask.ImportDelegations;
import com.plusmpm.CUF.util.PlannedExternalTask.ImportDevices;
import com.plusmpm.CUF.util.PlannedExternalTask.ImportDirectories;
import com.plusmpm.CUF.util.PlannedExternalTask.ImportDocClasses;
import com.plusmpm.CUF.util.PlannedExternalTask.ImportDocumentTemplates;
import com.plusmpm.CUF.util.PlannedExternalTask.ImportDocumentViews;
import com.plusmpm.CUF.util.PlannedExternalTask.ImportLinks;
import com.plusmpm.CUF.util.PlannedExternalTask.ImportNotifications;
import com.plusmpm.CUF.util.PlannedExternalTask.ImportPlannedExternalTasks;
import com.plusmpm.CUF.util.PlannedExternalTask.ImportProcessesProtection;
import com.plusmpm.CUF.util.PlannedExternalTask.ImportProcessesSettings;
import com.plusmpm.CUF.util.PlannedExternalTask.ImportRights;
import com.plusmpm.CUF.util.PlannedExternalTask.ImportViews;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import java.io.File;
import java.util.Date;
import org.apache.log4j.Logger;

public class ImportSystemSettings
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ImportSystemSettings.class);

    @AdvancedTask(name="ImportSystemSettingsFromXLSFiles", description="ImportSystemSettingsFromXLSFiles_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ImportSystemSettingsFromXLSFiles(@TaskParam(name="pathXls", description="pathXls_desc") String sDirPath) {
        log.info((Object)("************************ ImportSystemSettingsFromXLSFiles(sDirPath=" + sDirPath + ") *************************"));
        long startTime = new Date().getTime();
        File dir = null;
        Object sXLSPath = "";
        try {
            if (Tools.isNullOrEmpty((String)sDirPath)) {
                throw new CUFException("Nie podano sciezki do plikow xls z ustawieniami systemowymi");
            }
            if ((sDirPath = CUFTools.convertBackslashesToSlashes(sDirPath)).endsWith("/")) {
                sDirPath = sDirPath.substring(0, sDirPath.length() - 1);
            }
            if ((dir = new File(sDirPath)) == null || !dir.exists()) {
                throw new CUFException("Katalog z ustawieniami systemowymi nie istnieje w lokalizacji " + sDirPath);
            }
            log.info((Object)("Pliki xls zostana pobrane z katalogu " + sDirPath));
            log.info((Object)"Rozpoczecie procesu importu ustawien systemowych");
            log.info((Object)"Import struktury organizacyjnej");
            sXLSPath = sDirPath + "/CUF_struktura_organizacyjna.xls";
            log.info((Object)"Import uprawnien dla procesow");
            sXLSPath = sDirPath + "/CUF_uprawnienia_dla_procesow.xls";
            new ImportProcessesProtection().ImportProcessesProtectionFromXLS((String)sXLSPath);
            log.info((Object)"Import uprawnien");
            sXLSPath = sDirPath + "/CUF_uprawnienia.xls";
            new ImportRights().ImportRightsFromXLS((String)sXLSPath);
            log.info((Object)"Import urzadzen");
            sXLSPath = sDirPath + "/CUF_urzadzenia.xls";
            new ImportDevices().ImportDevicesFromXLS((String)sXLSPath);
            log.info((Object)"Import katalogow");
            sXLSPath = sDirPath + "/CUF_katalogi.xls";
            new ImportDirectories().ImportDirectoriesFromXLS((String)sXLSPath);
            log.info((Object)"Import klas dokumentow");
            sXLSPath = sDirPath + "/CUF_klasy_dokumentow.xls";
            new ImportDocClasses().ImportDocClassesFromXLS((String)sXLSPath);
            log.info((Object)"Import zestawow dokumentow");
            sXLSPath = sDirPath + "/CUF_zestawy_dokumentow.xls";
            new ImportLinks().ImportLinksFromXLS((String)sXLSPath);
            log.info((Object)"Import szablonow dokumentow");
            sXLSPath = sDirPath + "/CUF_szablony_dokumentow.xls";
            new ImportDocumentTemplates().ImportDocumentTemplatesFromXLS((String)sXLSPath);
            log.info((Object)"Import widokow dokumentow");
            sXLSPath = sDirPath + "/CUF_widoki_dokumentow.xls";
            new ImportDocumentViews().ImportDocumentViewsFromXLS((String)sXLSPath);
            log.info((Object)"Import powiadomien");
            sXLSPath = sDirPath + "/CUF_powiadomienia.xls";
            new ImportNotifications().ImportNotificationsFromXLS((String)sXLSPath);
            log.info((Object)"Import zastepstw");
            sXLSPath = sDirPath + "/CUF_zastepstwa.xls";
            new ImportDelegations().ImportDelegationsFromXLS((String)sXLSPath);
            log.info((Object)"Import zadan zaplanowanych");
            sXLSPath = sDirPath + "/CUF_zadania_zaplanowane.xls";
            new ImportPlannedExternalTasks().ImportScheduledTasksFromXLS((String)sXLSPath);
            log.info((Object)"Import widokow");
            sXLSPath = sDirPath + "/CUF_widoki.xls";
            new ImportViews().ImportViewsFromXLS((String)sXLSPath);
            log.info((Object)"Import widokow domyslnych i paneli uzytkownika");
            sXLSPath = sDirPath + "/CUF_widoki_domyslne.xls";
            new ImportDefaultViews().ImportDefaultViewsFromXLS((String)sXLSPath);
            log.info((Object)"Import ustawien procesow");
            sXLSPath = sDirPath + "/CUF_ustawienia_procesow.xls";
            new ImportProcessesSettings().ImportProcessesSettingsFromXLS((String)sXLSPath);
            log.info((Object)"Zakonczenie procesu importu ustawien systemowych");
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ImportSystemSettingsFromXLSFiles: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }
}

