/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension;

import com.plusmpm.CUF.util.extension.ServletFile;
import com.plusmpm.util.Tools;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletTools {
    private static final Logger log = LoggerFactory.getLogger(ServletTools.class);
    private static String serverAddress;
    private static int serverPort;
    private static String contextPath;
    public static final String CONTENT_DISPOSITION = "Content-disposition";
    public static final String FORM_DATA = "form-data";
    public static final String ATTACHMENT = "attachment";

    public static Map<String, Object> getParametersFromMultiPart(HttpServletRequest req) throws ServletException, IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (Part part : req.getParts()) {
            if (ServletTools.isFormField(part)) {
                params.put(ServletTools.getFieldName(part), IOUtils.toString((InputStream)part.getInputStream(), (String)"UTF-8"));
            } else {
                String filePath = part.getName();
                if (Tools.isNullOrEmpty((String)filePath)) {
                    throw new IllegalArgumentException("Nie wybrano pliku");
                }
                String fileName = FilenameUtils.getName((String)filePath);
                ServletFile f = new ServletFile(fileName, part.getInputStream());
                params.put(ServletTools.getFieldName(part), f);
            }
            req.setAttribute(ServletTools.getFieldName(part), params.get(ServletTools.getFieldName(part)));
        }
        return params;
    }

    public static boolean isFormField(Part part) {
        return ServletTools.getFileName(part.getHeader(CONTENT_DISPOSITION.toLowerCase(Locale.ENGLISH))) == null;
    }

    public static String getContextPath() {
        return contextPath;
    }

    public static void setContextPath(String contextPath) {
        ServletTools.contextPath = contextPath;
    }

    public static String getFieldName(Part part) {
        return ServletTools.getFieldName(part.getHeader(CONTENT_DISPOSITION.toLowerCase()));
    }

    private static String getFieldName(String contentDisposition) {
        if (StringUtils.isBlank((CharSequence)contentDisposition)) {
            return null;
        }
        String contentDispositionValue = contentDisposition.toLowerCase();
        if (contentDispositionValue.startsWith(FORM_DATA)) {
            return ServletTools.extractParameter("name", contentDispositionValue);
        }
        return null;
    }

    private static String getFileName(String contentDisposition) {
        if (StringUtils.isBlank((CharSequence)contentDisposition)) {
            return null;
        }
        String contentDispositionValue = contentDisposition.toLowerCase();
        if (contentDispositionValue.startsWith(FORM_DATA) || contentDispositionValue.startsWith(ATTACHMENT)) {
            return ServletTools.extractParameter("filename", contentDispositionValue);
        }
        return null;
    }

    private static String extractParameter(String name, String input) {
        String pattern = name + "=\"([^\"]+)\"";
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(input);
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        return null;
    }
}

