/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.plusmpm.CUF.database.storage.DynamicTableStorage;
import com.plusmpm.CUF.database.storage.DynamicTableStorageManager;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.util.Tools;
import com.plusmpm.util.json.extjs.gson.GsonCustomUtils;
import com.plusmpm.util.json.extjs.objects.JsonStore;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;

public class DynamicTableStorageSetDefault
extends HttpServlet {
    public static Logger log = Logger.getLogger(DynamicTableStorageSetDefault.class);
    private static final long serialVersionUID = 1L;

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)"************************* DynamicTableStorageSetDefault Servlet ****************************");
        PrintWriter printWriter = null;
        JsonStore jsonStore = null;
        GsonCustomUtils gsonCustomUtils = null;
        ArrayList records = null;
        boolean bSuccess = false;
        Object answerMessage = "";
        String defaultStorageName = "";
        boolean bHasDefaultStorage = false;
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        String owner = "";
        try {
            List<DynamicTableStorage> currentStorage;
            records = new ArrayList();
            String storageName = request.getParameter("storageName");
            owner = request.getParameter("owner");
            String tabTitle = request.getParameter("tabTitle");
            if (Tools.isNullOrEmpty((String)storageName)) {
                throw new CUFException("Brak nazwy zestawu danych.");
            }
            if (Tools.isNullOrEmpty((String)owner)) {
                throw new CUFException("Nie zidentyfikowano w\u0142a\u015bciciela zestawu. Nie mo\u017cna ustawi\u0107 zestawu danych o nazwie " + storageName + " jako domy\u015blny.");
            }
            if (Tools.isNullOrEmpty((String)tabTitle)) {
                throw new CUFException("Tabela nie posiada tytu\u0142u. Nie mo\u017cna ustawi\u0107 zestawu danych o nazwie " + storageName + " jako domy\u015blny.");
            }
            defaultStorageName = DynamicTableStorageManager.getDefaultDynamicTableStorageNameForUser(owner, tabTitle);
            if (!Tools.isNullOrEmpty((String)defaultStorageName)) {
                log.info((Object)("Tabela " + tabTitle + " posiada domyslny zestaw danych. Jego nazwa to " + defaultStorageName));
                HashMap<String, String> defaultStorageInfo = new HashMap<String, String>();
                defaultStorageInfo.put("defaultStorageName", defaultStorageName);
                records.add(defaultStorageInfo);
                bHasDefaultStorage = true;
            }
            if (bHasDefaultStorage) {
                if (defaultStorageName.equals(storageName)) {
                    throw new CUFException("Zestaw danych o nazwie " + storageName + " jest ju\u017c domy\u015blnym zestawem danych dla tabeli " + tabTitle + ".");
                }
                List<DynamicTableStorage> defaultStorage = DynamicTableStorageManager.getDefaultDynamicTableStorageForUser(owner, tabTitle);
                log.info((Object)("Anulowanie poprzedniego domyslnego zestawu danych o nazwie " + defaultStorageName + " dla tabeli " + tabTitle));
                for (DynamicTableStorage oneData : defaultStorage) {
                    oneData.setDefaultStorage("false");
                    DynamicTableStorageManager.update(oneData);
                }
            }
            if ((currentStorage = DynamicTableStorageManager.getDynamicTableStorageByNameAndUser(storageName, owner, tabTitle)) == null || currentStorage.size() == 0) {
                throw new CUFException("Zestaw danych o nazwie " + storageName + " dla tabeli " + tabTitle + " nie istnieje.");
            }
            log.info((Object)("Ustawianie zestawu danych o nazwie " + storageName + " jako domyslnego dla tabeli " + tabTitle));
            for (DynamicTableStorage oneData : currentStorage) {
                oneData.setDefaultStorage("true");
                DynamicTableStorageManager.update(oneData);
            }
            if (defaultStorageName == null) {
                defaultStorageName = "";
            }
            bSuccess = true;
            answerMessage = "Ustawiono zestaw danych o nazwie " + storageName + " jako domyslny.";
            log.info((Object)("Ustawiono zestaw danych o nazwie " + storageName + " jako domyslny"));
        }
        catch (CUFException e) {
            bSuccess = false;
            answerMessage = e.getMessage();
            log.warn(answerMessage);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            try {
                bSuccess = false;
                answerMessage = "B\u0142\u0105d podczas ustawiania domy\u015blnego zestawu danych dla u\u017cytkownika " + DynamicTableStorageSetDefault.getOwnerRealName(uga, owner);
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        finally {
            try {
                jsonStore = new JsonStore();
                jsonStore.setSuccess(Boolean.valueOf(bSuccess));
                jsonStore.setMessage((String)answerMessage);
                jsonStore.setRecords(records);
                gsonCustomUtils = new GsonCustomUtils();
                String sJsonData = gsonCustomUtils.getJsonForExtJsonStore(jsonStore);
                response.setContentType("application/json;charset=UTF-8");
                printWriter = response.getWriter();
                printWriter.print(sJsonData);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private static String getOwnerRealName(UserGroupAdministration uga, String userId) throws Exception {
        Object realName = "";
        if (!Tools.isNullOrEmpty((String)userId)) {
            if (uga.doesUserExist(userId)) {
                realName = uga.getUserRealName(userId);
                if (Tools.isNullOrEmpty((String)realName)) {
                    realName = userId + " (login)";
                }
            } else {
                realName = userId + " (login)";
            }
        } else {
            realName = "brak";
        }
        return realName;
    }
}

