/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.ArchiveServices;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.ActionTable;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassConditionProtectionTable;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.IndexTable;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.pwfl.archive.ArchiveStorageService;
import com.suncode.pwfl.archive.Directory;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;

public class ImportDocClasses
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ImportDocClasses.class);

    @AdvancedTask(name="ImportDocClassesFromXLS", description="ImportDocClassesFromXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ImportDocClassesFromXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************************ ImportDocClassesFromXLS(sXLSPath=" + sXLSPath + " ) *************************"));
        long startTime = new Date().getTime();
        File xls = null;
        WorkbookSettings wbs = null;
        Workbook workbook = null;
        HashMap<String, Integer> header = new HashMap<String, Integer>();
        DBManagement dbm = new DBManagement();
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        boolean bContinue = true;
        String helpDocClassName = "";
        long docClassId = -1L;
        long docClassIndexId = -1L;
        HashMap<String, String> mappings = null;
        try {
            int i;
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            xls = new File(sXLSPath);
            if (xls == null || !xls.exists()) {
                throw new CUFException("Plik xls nie istnieje w lokalizacji " + sXLSPath);
            }
            wbs = new WorkbookSettings();
            wbs.setEncoding("ISO-8859-2");
            workbook = Workbook.getWorkbook((File)xls, (WorkbookSettings)wbs);
            Sheet sheet = workbook.getSheet("Klasy dokument\u00f3w");
            if (sheet == null) {
                throw new CUFException("Brak arkusza Klasy dokument\u00f3w w pliku xls w lokalizacji " + sXLSPath);
            }
            for (i = 0; i < 28; ++i) {
                String cell = sheet.getCell(i, 0).getContents();
                header.put(cell, i);
            }
            log.info((Object)"Poprawne rozpoznanie arkusza z klasami dokumentow");
            for (i = 1; i < sheet.getRows(); ++i) {
                try {
                    String docClassName = sheet.getCell(((Integer)header.get("Nazwa klasy")).intValue(), i).getContents();
                    String docClassDescr = sheet.getCell(((Integer)header.get("Opis klasy")).intValue(), i).getContents();
                    String expirationDays = sheet.getCell(((Integer)header.get("Wa\u017cno\u015b\u0107 liczba dni")).intValue(), i).getContents();
                    String expirationToDay = sheet.getCell(((Integer)header.get("Wa\u017cno\u015b\u0107 do dnia")).intValue(), i).getContents();
                    String expirationPeriod = sheet.getCell(((Integer)header.get("Wa\u017cno\u015b\u0107 okres")).intValue(), i).getContents();
                    String expirationDocumentType = "";
                    String expirationDate = "";
                    String dirName = sheet.getCell(((Integer)header.get("Katalog zapisu dokument\u00f3w")).intValue(), i).getContents();
                    String indexing = sheet.getCell(((Integer)header.get("Indeksowanie")).intValue(), i).getContents();
                    String encoding = sheet.getCell(((Integer)header.get("Szyfrowanie")).intValue(), i).getContents();
                    String compressing = sheet.getCell(((Integer)header.get("Kompresja")).intValue(), i).getContents();
                    String cipherAlgorithm = sheet.getCell(((Integer)header.get("Algorytm kodowania")).intValue(), i).getContents();
                    String keyLength = sheet.getCell(((Integer)header.get("D\u0142ugo\u015b\u0107 klucza")).intValue(), i).getContents();
                    Long lKeyLength = new Long(0L);
                    String indexName = sheet.getCell(((Integer)header.get("Nazwa indeksu")).intValue(), i).getContents();
                    String indexDescr = sheet.getCell(((Integer)header.get("Opis indeksu")).intValue(), i).getContents();
                    String indexType = sheet.getCell(((Integer)header.get("Typ indeksu")).intValue(), i).getContents();
                    String indexValues = sheet.getCell(((Integer)header.get("Warto\u015bci")).intValue(), i).getContents();
                    String variableForMapping = sheet.getCell(((Integer)header.get("Zmienne do mapowania")).intValue(), i).getContents();
                    String actionName = sheet.getCell(((Integer)header.get("Nazwa akcji")).intValue(), i).getContents();
                    String actionSource = sheet.getCell(((Integer)header.get("\u0179rod\u0142o akcji")).intValue(), i).getContents();
                    String actionType = sheet.getCell(((Integer)header.get("Typ akcji")).intValue(), i).getContents();
                    String processName = sheet.getCell(((Integer)header.get("Nazwa procesu")).intValue(), i).getContents();
                    String scriptUrl = sheet.getCell(((Integer)header.get("Adres URL skryptu")).intValue(), i).getContents();
                    String actionValue = "";
                    Object actionValue2 = "";
                    String doMapping = sheet.getCell(((Integer)header.get("Czy mapowa\u0107?")).intValue(), i).getContents();
                    String resourceId = sheet.getCell(((Integer)header.get("Nazwa u\u017cytkownika/grupy")).intValue(), i).getContents();
                    String isGroup = sheet.getCell(((Integer)header.get("Grupa")).intValue(), i).getContents();
                    String rightLevel = sheet.getCell(((Integer)header.get("Poziom uprawnienia")).intValue(), i).getContents();
                    String addDocument = sheet.getCell(((Integer)header.get("Dodawanie dokument\u00f3w")).intValue(), i).getContents();
                    String conditionType = sheet.getCell(((Integer)header.get("Typ warunku")).intValue(), i).getContents();
                    String condition = sheet.getCell(((Integer)header.get("Warunek")).intValue(), i).getContents();
                    if (!Tools.isNullOrEmpty((String)docClassName)) {
                        helpDocClassName = docClassName;
                        docClassId = -1L;
                        docClassIndexId = -1L;
                        mappings = new HashMap<String, String>();
                        if (ArchiveServices.DoesDocClassExist(docClassName)) {
                            bContinue = false;
                            throw new CUFException("Klasa dokumentow o nazwie " + docClassName + " istnieje juz w systemie");
                        }
                        if (docClassDescr == null) {
                            docClassDescr = "";
                        }
                        if (!Tools.isNullOrEmpty((String)expirationDays)) {
                            expirationDocumentType = "dayCnt";
                            expirationDate = expirationDays;
                        } else if (!Tools.isNullOrEmpty((String)expirationToDay)) {
                            expirationDocumentType = "endDay";
                            expirationDate = expirationToDay;
                        } else if (!Tools.isNullOrEmpty((String)expirationPeriod)) {
                            expirationDocumentType = "period";
                            expirationDate = expirationPeriod;
                        } else {
                            expirationDocumentType = "dayCnt";
                            expirationDate = null;
                        }
                        if (cipherAlgorithm == null) {
                            cipherAlgorithm = "";
                        }
                        if (!(cipherAlgorithm.equalsIgnoreCase("Blowfish") || cipherAlgorithm.equalsIgnoreCase("AES") || cipherAlgorithm.equalsIgnoreCase("DES") || cipherAlgorithm.equalsIgnoreCase("RC2") || cipherAlgorithm.equalsIgnoreCase(""))) {
                            bContinue = false;
                            throw new CUFException("Niepoprawna nazwa algorytmu kodowania dla klasy dokumentow o nazwie " + docClassName);
                        }
                        if (!Tools.isNullOrEmpty((String)cipherAlgorithm)) {
                            if (Tools.isNullOrEmpty((String)keyLength) || keyLength.equalsIgnoreCase("0")) {
                                lKeyLength = new Long(0L);
                            } else if (keyLength.equalsIgnoreCase("56 (dla DES)")) {
                                lKeyLength = new Long(56L);
                            } else if (keyLength.equalsIgnoreCase("128")) {
                                lKeyLength = new Long(128L);
                            } else if (keyLength.equalsIgnoreCase("192")) {
                                lKeyLength = new Long(192L);
                            } else if (keyLength.equalsIgnoreCase("256")) {
                                lKeyLength = new Long(256L);
                            } else if (keyLength.equalsIgnoreCase("512 (tylko dla RC2)")) {
                                lKeyLength = new Long(512L);
                            } else if (keyLength.equalsIgnoreCase("1024 (tylko dla RC2)")) {
                                lKeyLength = new Long(1024L);
                            } else {
                                bContinue = false;
                                throw new CUFException("Niepoprawna dlugosc klucza dla algorytmu kodowania dla klasy dokumentow o nazwie " + docClassName);
                            }
                        }
                        if (!indexing.equalsIgnoreCase("false") && !indexing.equalsIgnoreCase("true")) {
                            bContinue = false;
                            throw new CUFException("Niepoprawna wartosc kolumny Indeksowanie dla klasy dokumentow o nazwie " + docClassName);
                        }
                        indexing = indexing.toLowerCase();
                        if (!encoding.equalsIgnoreCase("false") && !encoding.equalsIgnoreCase("true")) {
                            bContinue = false;
                            throw new CUFException("Niepoprawna wartosc kolumny Szyfrowanie dla klasy dokumentow o nazwie " + docClassName);
                        }
                        encoding = encoding.toLowerCase();
                        if (!compressing.equalsIgnoreCase("false") && !compressing.equalsIgnoreCase("true")) {
                            bContinue = false;
                            throw new CUFException("Niepoprawna wartosc kolumny Kompresja dla klasy dokumentow o nazwie " + docClassName);
                        }
                        compressing = compressing.toLowerCase();
                        long dirId = ImportDocClasses.getDirectoryId(dirName);
                        if (dirId == -1L) {
                            bContinue = false;
                            throw new CUFException("Katalog o nazwie " + dirName + " podany dla klasy dokumentow o nazwie " + docClassName + " nie istnieje w systemie");
                        }
                        DocClassTable docClassTable = new DocClassTable(docClassName, docClassDescr, expirationDate, expirationDocumentType, Long.valueOf(dirId), encoding, compressing);
                        docClassTable.setCipherAlgorithm(cipherAlgorithm);
                        docClassTable.setKeyLength(lKeyLength);
                        docClassTable.setDocClassIndex(indexing);
                        Long lMaxIdx = dbm.getMaxOrderDocClass();
                        if (lMaxIdx == null) {
                            lMaxIdx = new Long(-1L);
                        }
                        docClassTable.setDocClassOrderId(Long.valueOf(lMaxIdx + 1L));
                        docClassId = dbm.addDocClass(docClassTable);
                        if (docClassId == -1L) {
                            bContinue = false;
                            throw new CUFException("Blad podczas dodawania klasy dokumentow o nazwie " + docClassName + " do systemu");
                        }
                        String sFullDirPath = Tools.GetFullDirPath((String)String.valueOf(docClassTable.getId()));
                        docClassTable.setDocClassIndexPath(sFullDirPath + "indexDir_" + String.valueOf(docClassTable.getId()));
                        long changeId = dbm.changeDocClass(docClassTable);
                        if (changeId == -1L) {
                            bContinue = false;
                            throw new CUFException("Blad podczas dodawania klasy dokumentow o nazwie " + docClassName + " do systemu");
                        }
                        bContinue = true;
                        log.info((Object)("Poprawnie dodano klase dokumentow o nazwie " + docClassName + " do systemu"));
                    }
                    if (!bContinue) continue;
                    try {
                        DocClassConditionProtectionTable docClassConditionProtectionTable;
                        long conditionProtectionId;
                        if (!Tools.isNullOrEmpty((String)indexName)) {
                            docClassIndexId = -1L;
                            long checkDocClasskIndexId = ImportDocClasses.getDocClassIndexId(String.valueOf(docClassId), indexName);
                            if (checkDocClasskIndexId != -1L) {
                                throw new CUFException("Indeks o nazwie " + indexName + " istnieje dla klasy dokumentow o nazwie " + helpDocClassName + " w systemie");
                            }
                            if (indexDescr == null) {
                                indexDescr = "";
                            }
                            if (indexValues == null) {
                                indexValues = "";
                            }
                            if (Tools.isNullOrEmpty((String)indexType)) {
                                throw new CUFException("Nie podano typu indeksu o nazwie " + indexName + " dla klasy dokumentow o nazwie " + helpDocClassName + " w pliku xls");
                            }
                            if (indexType.equalsIgnoreCase("Ca\u0142kowity")) {
                                indexType = "integer";
                            } else if (indexType.equalsIgnoreCase("Zmiennoprzecinkowy")) {
                                indexType = "float";
                            } else if (indexType.equalsIgnoreCase("Tekstowy")) {
                                indexType = "string";
                            } else if (indexType.equalsIgnoreCase("Data")) {
                                indexType = "date";
                            } else if (indexType.equalsIgnoreCase("Lista warto\u015bci")) {
                                indexType = "list";
                            } else {
                                throw new CUFException("Nieznany typ indeksu o nazwie " + indexName + " dla klasy dokumentow o nazwie " + helpDocClassName + " w pliku xls");
                            }
                            IndexTable indexTable = new IndexTable(Long.valueOf(docClassId), indexName, indexDescr, indexType, indexValues);
                            docClassIndexId = dbm.addIndex(indexTable);
                            if (docClassIndexId == -1L) {
                                throw new CUFException("Blad podczas dodawania indeksu o nazwie " + indexName + " do systemu dla klasy dokumentow o nazwie " + helpDocClassName);
                            }
                            log.info((Object)("Poprawnie dodano indeks o nazwie " + indexName + " do systemu dla klasy dokumentow o nazwie " + helpDocClassName));
                            if (!Tools.isNullOrEmpty((String)variableForMapping)) {
                                mappings.put(indexName, variableForMapping);
                            }
                        }
                        if (!Tools.isNullOrEmpty((String)actionName)) {
                            ActionTable actionTable;
                            long docClassActionId;
                            if (ArchiveServices.DoesActionExist(String.valueOf(docClassId), actionName)) {
                                throw new CUFException("Akcja o nazwie " + actionName + " istnieje dla klasy dokumentow o nazwie " + helpDocClassName + " w systemie");
                            }
                            if (actionSource == null) {
                                actionSource = "";
                            }
                            if (actionSource.equalsIgnoreCase("Nowy dokument")) {
                                actionSource = "newDocument";
                            } else if (actionSource.equalsIgnoreCase("Zmiana dokumentu")) {
                                actionSource = "changeDocument";
                            } else if (actionSource.equalsIgnoreCase("Usuni\u0119cie dokumentu")) {
                                actionSource = "deleteDocument";
                            } else if (actionSource.equalsIgnoreCase("Pod\u0142\u0105czenie dokumentu")) {
                                actionSource = "attachDocument";
                            } else if (actionSource.equalsIgnoreCase("Od\u0142\u0105czenie dokumentu")) {
                                actionSource = "dettachDocument";
                            } else if (actionSource.equalsIgnoreCase("Wyga\u015bni\u0119cie dokumentu")) {
                                actionSource = "expireDocument";
                            } else {
                                throw new CUFException("Niepoprawne zrodlo akcji o nazwie " + actionName + " dla klasy dokumentow " + helpDocClassName);
                            }
                            if (actionType == null) {
                                actionType = "";
                            }
                            if (actionType.equalsIgnoreCase("Uruchom skrypt")) {
                                actionType = "startScript";
                            } else if (actionType.equalsIgnoreCase("Utw\u00f3rz nowy proces")) {
                                actionType = "newProcess";
                            } else if (actionType.equalsIgnoreCase("Pod\u0142\u0105cz dokument do procesu")) {
                                actionType = "addDocToProcess";
                            } else if (actionType.equalsIgnoreCase("Synchronizuj indeksy")) {
                                actionType = "synchronizeIndecies";
                            } else {
                                throw new CUFException("Niepoprawny typ akcji o nazwie " + actionName + " dla klasy dokumentow " + helpDocClassName);
                            }
                            if (!actionType.equalsIgnoreCase("startScript") && !Tools.isNullOrEmpty((String)processName)) {
                                actionValue = CUFTools.getProcDefIdForProcessName(processName);
                            } else if (actionType.equalsIgnoreCase("startScript") && !Tools.isNullOrEmpty((String)scriptUrl)) {
                                actionValue = scriptUrl;
                            } else {
                                throw new CUFException("Niepoprawna definicja pol akcji o nazwie " + actionName + " dla klasy dokumentow " + helpDocClassName);
                            }
                            if (!Tools.isNullOrEmpty((String)doMapping) && doMapping.equalsIgnoreCase("true") && !actionType.equalsIgnoreCase("startScript")) {
                                if (mappings == null || mappings.size() == 0) {
                                    actionValue2 = "";
                                } else {
                                    for (String key : mappings.keySet()) {
                                        String value = (String)mappings.get(key);
                                        if (Tools.isNullOrEmpty((String)actionValue2)) {
                                            actionValue2 = ImportDocClasses.getDocClassIndexId(String.valueOf(docClassId), key) + "=" + CUFTools.getVarIdForVarName(actionValue, value);
                                            continue;
                                        }
                                        actionValue2 = (String)actionValue2 + "&" + ImportDocClasses.getDocClassIndexId(String.valueOf(docClassId), key) + "=" + CUFTools.getVarIdForVarName(actionValue, value);
                                    }
                                }
                            }
                            if ((docClassActionId = dbm.addAction(actionTable = new ActionTable(new Long(docClassId), actionName, actionSource, actionType, actionValue, (String)actionValue2))) == -1L) {
                                throw new CUFException("Blad podczas dodawania akcji o nazwie " + actionName + " do systemu dla klasy dokumentow o nazwie " + helpDocClassName);
                            }
                            log.info((Object)("Poprawnie dodano akcje o nazwie " + actionName + " do systemu dla klasy dokumentow o nazwie " + helpDocClassName));
                        }
                        if (Tools.isNullOrEmpty((String)resourceId)) continue;
                        if (Tools.isNullOrEmpty((String)isGroup) || Tools.isNullOrEmpty((String)rightLevel)) {
                            throw new CUFException("Nie podano wszystkich danych dla praw do klasy dokumentow o nazwie " + helpDocClassName + " w pliku xls");
                        }
                        if (!isGroup.equalsIgnoreCase("false") && !isGroup.equalsIgnoreCase("true")) {
                            throw new CUFException("Niedozwolona wartosc w kolumnie Grupa dla prawa do klasy dokumentow o nazwie " + helpDocClassName + " dla zasobu " + resourceId);
                        }
                        isGroup.toLowerCase();
                        if (isGroup.equalsIgnoreCase("false")) {
                            if (!uga.doesUserExist(resourceId)) {
                                throw new CUFException("Uzytownik " + resourceId + " nie istnieje w systemie, przerwanie dodawania praw dla klasy dokumentow o nazwie " + helpDocClassName);
                            }
                        } else if (!uga.doesUserExist(resourceId)) {
                            throw new CUFException("Grupa " + resourceId + " nie istnieje w systemie, przerwanie dodawania praw dla klasy dokumentow o nazwie " + helpDocClassName);
                        }
                        if (addDocument != null && !addDocument.equalsIgnoreCase("true") && !addDocument.equalsIgnoreCase("false")) {
                            throw new CUFException("Niedozwolona wartosc w kolumnie Dodawanie dokument\u00f3w dla prawa do klasy dokumentow o nazwie " + helpDocClassName + " dla zasobu " + resourceId);
                        }
                        if (conditionType != null) {
                            if (conditionType.equalsIgnoreCase("Dokumenty w zadaniach u\u017cytkownika")) {
                                conditionType = "userProcessesDocuments";
                            } else if (conditionType.equalsIgnoreCase("Por\u00f3wnanie warto\u015bci")) {
                                conditionType = "compareValues";
                            } else {
                                throw new CUFException("Niedozwolona wartosc w kolumnie Typ warunku dla prawa do klasy dokumentow o nazwie " + helpDocClassName + " dla zasobu " + resourceId);
                            }
                        }
                        if (condition == null) {
                            condition = "";
                        }
                        if (rightLevel.equalsIgnoreCase("Odczyt")) {
                            Authorization.addRight((String)RightTreeBuilder.builder().system().archive().docClasses().custom((Object)docClassId).read().build(), (String)resourceId, (boolean)Boolean.valueOf(isGroup));
                            log.info((Object)("Dodanie praw do odczytu klasy dokumentow o nazwie " + helpDocClassName + " dla " + resourceId));
                        } else if (rightLevel.equalsIgnoreCase("Modyfikacja")) {
                            Authorization.addRight((String)RightTreeBuilder.builder().system().archive().docClasses().custom((Object)docClassId).read().build(), (String)resourceId, (boolean)Boolean.valueOf(isGroup));
                            Authorization.addRight((String)RightTreeBuilder.builder().system().archive().docClasses().custom((Object)docClassId).modify().build(), (String)resourceId, (boolean)Boolean.valueOf(isGroup));
                            log.info((Object)("Dodanie praw do odczytu i modyfikacji klasy dokumentow o nazwie " + helpDocClassName + " dla " + resourceId));
                        } else if (rightLevel.equalsIgnoreCase("Usuwanie")) {
                            Authorization.addRight((String)RightTreeBuilder.builder().system().archive().docClasses().custom((Object)docClassId).read().build(), (String)resourceId, (boolean)Boolean.valueOf(isGroup));
                            Authorization.addRight((String)RightTreeBuilder.builder().system().archive().docClasses().custom((Object)docClassId).modify().build(), (String)resourceId, (boolean)Boolean.valueOf(isGroup));
                            Authorization.addRight((String)RightTreeBuilder.builder().system().archive().docClasses().custom((Object)docClassId).delete().build(), (String)resourceId, (boolean)Boolean.valueOf(isGroup));
                            log.info((Object)("Dodanie praw do odczytu, modyfikacji i usuwania klasy dokumentow o nazwie " + helpDocClassName + " dla " + resourceId));
                        } else {
                            throw new CUFException("Niedozwolona wartosc w kolumnie Poziom uprawnienia dla prawa do klasy dokumentow o nazwie " + helpDocClassName + " dla zasobu " + resourceId);
                        }
                        if (addDocument.equalsIgnoreCase("true")) {
                            Authorization.addRight((String)RightTreeBuilder.builder().system().archive().docClasses().custom((Object)docClassId).release().build(), (String)resourceId, (boolean)Boolean.valueOf(isGroup));
                            log.info((Object)("Dodanie praw do dodawania dokumentow dla klasy dokumentow o nazwie " + helpDocClassName + " dla " + resourceId));
                        }
                        if (conditionType != null && (conditionProtectionId = dbm.addDocClassConditionProtection(docClassConditionProtectionTable = new DocClassConditionProtectionTable(String.valueOf(docClassId), resourceId, String.valueOf(isGroup), conditionType, condition))) == -1L) {
                            throw new CUFException("Blad podczas dodawania uprawnien warunkowych dla klasy dokumentow o nazwie " + helpDocClassName);
                        }
                        log.info((Object)("Poprawnie dodano uprawniena dla " + resourceId));
                    }
                    catch (CUFException e) {
                        taskLog.error((Object)e.getMessage());
                        log.warn((Object)e.getMessage());
                    }
                    catch (Exception e) {
                        taskLog.error((Object)e.getMessage());
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                catch (CUFException e) {
                    log.warn((Object)e.getMessage());
                    continue;
                }
                catch (Exception e) {
                    taskLog.error((Object)e.getMessage());
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            log.info((Object)"Zakonczono import klas dokumentow");
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ImportDocClassesFromXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    private static long getDirectoryId(String sDirName) throws Exception {
        log.trace((Object)("************ getDirectoryId(sDirName=" + sDirName + ") ************"));
        long id = -1L;
        ArchiveStorageService as = ServiceFactory.getArchiveStorageService();
        List allDirs = as.getAllDirectories(new String[0]);
        if (allDirs != null && allDirs.size() > 0) {
            for (Directory oneDir : allDirs) {
                String sThisDirName;
                if (oneDir == null || (sThisDirName = oneDir.getDirectoryName()) == null || !sThisDirName.equalsIgnoreCase(sDirName)) continue;
                Long lId = oneDir.getId();
                if (lId == null) break;
                id = lId;
                break;
            }
        }
        return id;
    }

    private static long getDocClassIndexId(String sDocClassId, String sDocClassIndexName) throws Exception {
        Long id;
        log.trace((Object)("************ getDocClassIndexId(sDocClassId=" + sDocClassId + ", sDocClassIndexName=" + sDocClassIndexName + ") ************"));
        long linkIndexId = -1L;
        DBManagement dbm = new DBManagement();
        IndexTable indexTable = dbm.getIndexByNameInDocClass(sDocClassId, sDocClassIndexName);
        if (indexTable != null && (id = indexTable.getId()) != null) {
            linkIndexId = id;
        }
        return linkIndexId;
    }
}

