/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.automatictask.mail.receivers;

import com.suncode.cuf.automatictask.mail.ReceiverTypes;
import com.suncode.cuf.automatictask.mail.SendMailSender;
import com.suncode.cuf.automatictask.mail.receivers.Receiver;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.util.FinderFactory;
import jakarta.mail.MessagingException;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class PositionNameReceiver
implements Receiver {
    private String positionName;

    @Override
    public ReceiverTypes getType() {
        return ReceiverTypes.POSITION_BY_NAME;
    }

    @Override
    public void send(String receiverId, String subject, String content, List<WfDocument> attachments, List<String> excludedEmails, String processId) throws MessagingException {
        this.positionName = receiverId;
        PositionFinder positionFinder = FinderFactory.getPositionFinder();
        for (Position position : positionFinder.findByName(this.positionName, new String[]{"user"})) {
            User user = position.getUser();
            if (excludedEmails.contains(user.getEmail())) continue;
            SendMailSender.getInstance().send(user.getEmail(), subject, content, attachments);
            excludedEmails.add(user.getEmail());
        }
    }
}

