/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.AdvanceSearchVariableTable;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.UserSearchViewProtectionTable;
import com.plusmpm.database.UserSearchViewTable;
import com.plusmpm.database.variableDistinguish.VariableDistinguishDB;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.pwfl.view.ViewAccessLevel;
import com.suncode.pwfl.view.distinction.VariableDistinguishTable;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;

public class ImportViews
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ImportViews.class);

    @AdvancedTask(name="ImportViewsFromXLS", description="ImportViewsFromXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    @Deprecated
    public void ImportViewsFromXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************ ImportViewsFromXLS(sXLSPath=" + sXLSPath + ") ************"));
        long startTime = new Date().getTime();
        File xls = null;
        WorkbookSettings wbs = null;
        Workbook workbook = null;
        HashMap<String, Integer> header = new HashMap<String, Integer>();
        DBManagement dbm = new DBManagement();
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        boolean bContinue = true;
        String helpViewName = "";
        long viewId = -1L;
        try {
            int i;
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            xls = new File(sXLSPath);
            if (xls == null || !xls.exists()) {
                throw new CUFException("Plik xls nie istnieje w lokalizacji " + sXLSPath);
            }
            wbs = new WorkbookSettings();
            wbs.setEncoding("ISO-8859-2");
            workbook = Workbook.getWorkbook((File)xls, (WorkbookSettings)wbs);
            Sheet sheet = workbook.getSheet("Widoki");
            if (sheet == null) {
                throw new CUFException("Brak arkusza Widoki w pliku xls w lokalizacji " + sXLSPath);
            }
            for (i = 0; i < sheet.getColumns(); ++i) {
                String cell = sheet.getCell(i, 0).getContents();
                header.put(cell, i);
            }
            log.info((Object)"Poprawne rozpoznanie arkusza z widokami");
            for (i = 1; i < sheet.getRows(); ++i) {
                try {
                    String viewName = sheet.getCell(((Integer)header.get("Nazwa widoku")).intValue(), i).getContents();
                    String viewDescr = sheet.getCell(((Integer)header.get("Opis")).intValue(), i).getContents();
                    String userId = sheet.getCell(((Integer)header.get("W\u0142a\u015bciciel")).intValue(), i).getContents();
                    String accessLevel = sheet.getCell(((Integer)header.get("Poziom dost\u0119pu")).intValue(), i).getContents();
                    String source = sheet.getCell(((Integer)header.get("\u0179r\u00f3d\u0142o")).intValue(), i).getContents();
                    String formOnResult = sheet.getCell(((Integer)header.get("Otw\u00f3rz filtr wynik\u00f3w")).intValue(), i).getContents();
                    String searchResultsOn = sheet.getCell(((Integer)header.get("Poka\u017c wyniki wyszukiwania")).intValue(), i).getContents();
                    String groupAcceptance = sheet.getCell(((Integer)header.get("Akceptacja grupowa")).intValue(), i).getContents();
                    String acceptFromAllPages = sheet.getCell(((Integer)header.get("Akceptuj zadania ze wszystkich stron")).intValue(), i).getContents();
                    String values = sheet.getCell(((Integer)header.get("Warto\u015bci")).intValue(), i).getContents();
                    String variableId = sheet.getCell(((Integer)header.get("Id zmiennej")).intValue(), i).getContents();
                    String active = sheet.getCell(((Integer)header.get("Aktywna")).intValue(), i).getContents();
                    String showFilter = header.containsKey("Poka\u017c w filtrach") ? sheet.getCell(((Integer)header.get("Poka\u017c w filtrach")).intValue(), i).getContents() : active;
                    String position = sheet.getCell(((Integer)header.get("Pozycja")).intValue(), i).getContents();
                    String sortType = sheet.getCell(((Integer)header.get("Sortuj")).intValue(), i).getContents();
                    String variableValueFrom = sheet.getCell(((Integer)header.get("Od")).intValue(), i).getContents();
                    String variableValueTo = sheet.getCell(((Integer)header.get("Do")).intValue(), i).getContents();
                    String ignoreCase = sheet.getCell(((Integer)header.get("Pomijaj wielko\u015b\u0107 liter")).intValue(), i).getContents();
                    String formatVariableName = sheet.getCell(((Integer)header.get("Nazwa zmiennej (format)")).intValue(), i).getContents();
                    String formatVariableId = sheet.getCell(((Integer)header.get("Id zmiennej (format)")).intValue(), i).getContents();
                    String formatVariableValueFrom = sheet.getCell(((Integer)header.get("Warto\u015b\u0107 zmiennej od")).intValue(), i).getContents();
                    String formatVariableValueTo = sheet.getCell(((Integer)header.get("Warto\u015b\u0107 zmiennej do")).intValue(), i).getContents();
                    String imagePath = sheet.getCell(((Integer)header.get("\u015acie\u017cka do obrazu")).intValue(), i).getContents();
                    String display = sheet.getCell(((Integer)header.get("Spos\u00f3b wy\u015bwietlania")).intValue(), i).getContents();
                    String format = sheet.getCell(((Integer)header.get("Format wy\u015bwietlania")).intValue(), i).getContents();
                    String textColor = sheet.getCell(((Integer)header.get("Kolor tekstu")).intValue(), i).getContents();
                    String isGroup = sheet.getCell(((Integer)header.get("Grupa")).intValue(), i).getContents();
                    String resourceId = sheet.getCell(((Integer)header.get("Login / Nazwa grupy")).intValue(), i).getContents();
                    if (!Tools.isNullOrEmpty((String)viewName)) {
                        helpViewName = viewName;
                        viewId = -1L;
                        if (Tools.isNullOrEmpty((String)userId)) {
                            bContinue = false;
                            throw new CUFException("Nie podano wlasciciela widoku o nazwie " + viewName);
                        }
                        if (!uga.doesUserExist(userId)) {
                            bContinue = false;
                            throw new CUFException("Uzytkownik " + userId + " nie istnieje w systemie. Nie mozna przypisac widoku");
                        }
                        if (CUFTools.doesViewExistForUser(userId, viewName)) {
                            bContinue = false;
                            throw new CUFException("Widok o nazwie " + viewName + " istnieje juz dla uzytkownika " + userId);
                        }
                        if (accessLevel != null && accessLevel.equalsIgnoreCase("Publiczny")) {
                            accessLevel = ViewAccessLevel.PUBLIC.name();
                        } else if (accessLevel != null && accessLevel.equalsIgnoreCase("Prywatny")) {
                            accessLevel = ViewAccessLevel.PRIVATE.name();
                        } else {
                            bContinue = false;
                            throw new CUFException("Nieznany poziom dostepu dla widoku o nazwie " + viewName);
                        }
                        formOnResult = formOnResult != null && formOnResult.equalsIgnoreCase("tak") ? "true" : "false";
                        searchResultsOn = searchResultsOn != null && searchResultsOn.equalsIgnoreCase("tak") ? "true" : "false";
                        groupAcceptance = groupAcceptance != null && groupAcceptance.equalsIgnoreCase("tak") ? "true" : "false";
                        acceptFromAllPages = acceptFromAllPages != null && acceptFromAllPages.equalsIgnoreCase("tak") ? "true" : "false";
                        UserSearchViewTable userSearchView = new UserSearchViewTable(viewName, viewDescr, ViewAccessLevel.valueOf((String)accessLevel), source, userId, values);
                        userSearchView.setShowFormOnResult(formOnResult);
                        userSearchView.setAcceptManyTasks(groupAcceptance);
                        userSearchView.setShowSearchResultOnResult(searchResultsOn);
                        userSearchView.setAcceptFromAllPages(acceptFromAllPages);
                        viewId = dbm.addUserSearchView(userSearchView);
                        if (viewId == -1L) {
                            bContinue = false;
                            throw new CUFException("Blad podczas dodawania do systemu widoku o nazwie " + viewName + " dla uzytkownika " + userId);
                        }
                        bContinue = true;
                        log.info((Object)("Poprawnie dodano do systemu widok o nazwie " + viewName + " dla uzytkownika " + userId));
                    }
                    if (!bContinue) continue;
                    try {
                        if (!Tools.isNullOrEmpty((String)variableId)) {
                            active = active != null && active.equalsIgnoreCase("tak") ? "on" : null;
                            showFilter = showFilter != null && showFilter.equalsIgnoreCase("tak") ? "on" : null;
                            if (position == null || position.equalsIgnoreCase("brak")) {
                                position = "999";
                            }
                            if (variableId.equalsIgnoreCase("procDefId") && variableId.equalsIgnoreCase("onlyLoggedUserTask") && variableId.equalsIgnoreCase("onlyActiveTask")) {
                                position = null;
                            }
                            sortType = sortType != null && sortType.equalsIgnoreCase("Rosn\u0105co") ? "asc" : (sortType != null && sortType.equalsIgnoreCase("Malej\u0105co") ? "desc" : null);
                            if (Tools.isNullOrEmpty((String)variableValueFrom)) {
                                variableValueFrom = null;
                            }
                            if (Tools.isNullOrEmpty((String)variableValueTo)) {
                                variableValueTo = null;
                            }
                            ignoreCase = ignoreCase != null && ignoreCase.equalsIgnoreCase("tak") ? "on" : null;
                            AdvanceSearchVariableTable advanceSearchVariableTable = new AdvanceSearchVariableTable(String.valueOf(viewId), variableId, variableValueFrom, variableValueTo, sortType, position, active, ignoreCase);
                            advanceSearchVariableTable.setShowFilter(showFilter);
                            long advanceSearchVariableId = dbm.addAdvanceSearchVariable(advanceSearchVariableTable);
                            if (advanceSearchVariableId == -1L) {
                                throw new CUFException("Blad podczas dodawania do widoku o nazwie " + helpViewName + " zmiennej " + variableId);
                            }
                            log.info((Object)("Poprawnie dodano zmienna o identyfikatorze " + variableId + " do widoku o nazwie " + helpViewName));
                        }
                        if (!Tools.isNullOrEmpty((String)formatVariableName) || !Tools.isNullOrEmpty((String)formatVariableId)) {
                            if (Tools.isNullOrEmpty((String)formatVariableName)) {
                                throw new CUFException("Dla widoku o nazwie " + helpViewName + " dla zmiennej o identyfikatorze " + formatVariableId + " podczas okreslania jej formatowania nie podano nazwy zmiennej");
                            }
                            if (Tools.isNullOrEmpty((String)formatVariableId)) {
                                throw new CUFException("Dla widoku o nazwie " + helpViewName + " dla zmiennej o nazwie " + formatVariableName + " podczas okreslania jej formatowania nie podano idenfytikatora zmiennej");
                            }
                            if (Tools.isNullOrEmpty((String)formatVariableValueFrom)) {
                                formatVariableValueFrom = null;
                            }
                            if (Tools.isNullOrEmpty((String)formatVariableValueTo)) {
                                formatVariableValueTo = null;
                            }
                            if (imagePath == null) {
                                imagePath = "";
                            }
                            VariableDistinguishTable variableDistinguish = new VariableDistinguishTable(String.valueOf(viewId), formatVariableId, formatVariableName, textColor, display, format, formatVariableValueFrom, formatVariableValueTo);
                            VariableDistinguishDB.addVariableDistinguish((VariableDistinguishTable)variableDistinguish);
                            log.info((Object)("Poprawnie dodano formatowanie zmiennej o nazwie " + formatVariableName + " do widoku o nazwie " + helpViewName));
                        }
                        if (Tools.isNullOrEmpty((String)resourceId)) continue;
                        if (Tools.isNullOrEmpty((String)isGroup)) {
                            throw new CUFException("Dla widoku o nazwie " + helpViewName + " nie okreslono, czy odbiorca jest grupa czy uzytkownikiem");
                        }
                        if (isGroup.equalsIgnoreCase("tak")) {
                            isGroup = "true";
                        } else if (isGroup.equalsIgnoreCase("nie")) {
                            isGroup = "false";
                        } else {
                            throw new CUFException("Dla widoku o nazwie " + helpViewName + " nie okreslono poprawnie, czy odbiorca jest grupa czy uzytkownikiem");
                        }
                        UserSearchViewProtectionTable userSearchViewProtectionTable = new UserSearchViewProtectionTable(Long.valueOf(viewId), resourceId, isGroup);
                        long userShareId = dbm.addUserSearchViewProtection(userSearchViewProtectionTable);
                        if (userShareId == -1L) {
                            throw new CUFException("Blad podczas dodawania do widoku o nazwie " + helpViewName + " odbiorcy " + resourceId);
                        }
                        log.info((Object)("Poprawnie dodano odbiorce " + resourceId + " do widoku o nazwie " + helpViewName));
                    }
                    catch (CUFException e) {
                        log.warn((Object)e.getMessage());
                    }
                    catch (Exception e) {
                        taskLog.error((Object)e.getMessage());
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                catch (CUFException e) {
                    log.warn((Object)e.getMessage());
                    continue;
                }
                catch (Exception e) {
                    taskLog.error((Object)e.getMessage());
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            log.info((Object)"Zakonczono import widokow");
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ImportViewsFromXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }
}

