/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.ArchiveServices;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.IndexTable;
import com.plusmpm.database.files.Files;
import com.plusmpm.database.files.FilesManager;
import com.plusmpm.database.hibernate.HibernateUtil;
import com.plusmpm.database.scheduledTasks.ScheduledTasksMethods;
import com.plusmpm.database.scheduledTasks.ScheduledTasksParametersTable;
import com.plusmpm.database.scheduledTasks.ScheduledTasksTable;
import com.plusmpm.util.DocumentData;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.pwfl.archive.WfFileVersion;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class CopyArchiveBetweenWorkflows
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(CopyArchiveBetweenWorkflows.class);

    @AdvancedTask(name="CopyArchive", description="CopyArchive_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void CopyArchive(@TaskParam(name="advancedTask.paramName.sourceClassCABW", description="advancedTask.paramDesc.sourceClassCABW") String sSourceClass, @TaskParam(name="advancedTask.paramName.destClassCABW", description="advancedTask.paramDesc.destClassCABW") String sDestClass, @TaskParam(name="advancedTask.paramName.urlCABW", description="advancedTask.paramDesc.urlCABW") String sURL, @TaskParam(name="advancedTask.paramName.keysCABW", description="advancedTask.paramDesc.keysCABW") String sKeys, @TaskParam(name="advancedTask.paramName.fromCABW", description="advancedTask.paramDesc.fromCABW") String sFrom, @TaskParam(name="advancedTask.paramName.toCABW", description="advancedTask.paramDesc.toCABW") String sTo, @TaskParam(name="advancedTask.paramName.actionCABW", description="advancedTask.paramDesc.actionCABW") String sAction, @TaskParam(name="advancedTask.paramName.login", description="advancedTask.paramDesc.loginCABW") String sLogin, @TaskParam(name="advancedTask.paramName.password", description="advancedTask.paramDesc.passwordCABW") String sPassword) {
        long startTime;
        block41: {
            log.info((Object)("************************ CopyArchive(sSourceClass=" + sSourceClass + ", sDestClass=" + sDestClass + ", sURL=" + sURL + ", sKeys=" + sKeys + ", sFrom=" + sFrom + ", sTo=" + sTo + ", sAction=" + sAction + ", sLogin=" + sLogin + ", sPassword=" + sPassword + ") *************************"));
            startTime = new Date().getTime();
            boolean changeParam = true;
            DBManagement dbm = new DBManagement();
            try {
                DocClassTable docClassTable = dbm.getDocClassByName(sSourceClass);
                if (docClassTable != null) {
                    String docClassId = docClassTable.getId().toString();
                    ArrayList indexesForDocClass = DBManagement.GetAllIndecies((String)docClassId);
                    if (indexesForDocClass != null && indexesForDocClass.size() > 0) {
                        HashMap hmIndecies = new HashMap();
                        Object allKeys = "";
                        String destClassId = "";
                        for (int i = 0; i < indexesForDocClass.size(); ++i) {
                            hmIndecies.put(indexesForDocClass.get(i), "");
                            allKeys = i != indexesForDocClass.size() - 1 ? (String)allKeys + ((IndexTable)indexesForDocClass.get(i)).getIndexName() + "," : (String)allKeys + ((IndexTable)indexesForDocClass.get(i)).getIndexName();
                        }
                        if (sKeys.equalsIgnoreCase("ALL")) {
                            sKeys = allKeys;
                        }
                        if (sTo.equalsIgnoreCase("NOW")) {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            sTo = sdf.format(new Date(startTime));
                        }
                        log.info((Object)("Szukanie dokumentow dodanych od dnia " + sFrom + " do dnia " + sTo));
                        ArrayList listOfDocs = DBManagement.SearchDocClass(hmIndecies, (String)docClassId, (String)"admin", (String)sFrom, (String)sTo, (int)0, (int)0, (int)0, (int)0, (long)0L);
                        if (listOfDocs != null && listOfDocs.size() > 0) {
                            log.info((Object)("Znaleziona ilosc dokumentow: " + listOfDocs.size()));
                            log.info((Object)("Proces pobierania identyfikatorow indeksow z systemu Workflow " + sURL));
                            String[] docClassesIDs = ArchiveServices.GetDocClassesIDsWithNamesWS(sURL, sLogin, sPassword);
                            String[] indeciesIDs = null;
                            if (docClassesIDs != null) {
                                for (int a = 0; a < docClassesIDs.length; ++a) {
                                    String[] IDAndName = docClassesIDs[a].split(";");
                                    if (!IDAndName[1].equalsIgnoreCase(sDestClass)) continue;
                                    destClassId = IDAndName[0];
                                    String[] help = ArchiveServices.GetIndeciesIDsWithNamesWS(sURL, IDAndName[0], sLogin, sPassword);
                                    if (help != null) {
                                        indeciesIDs = new String[help.length];
                                        indeciesIDs = help;
                                        break;
                                    }
                                    log.info((Object)("Blad podczas pobierania identyfikatorow indeksow z systemu Workflow " + sURL));
                                    break;
                                }
                                log.info((Object)("Proces sprawdzanie istnienia dokumentow w systemie Workflow " + sURL));
                                if (indeciesIDs != null) {
                                    if (indeciesIDs.length == hmIndecies.size()) {
                                        for (int i = 0; i < listOfDocs.size(); ++i) {
                                            log.info((Object)("------> Analizowanie dokumentu numer: " + (i + 1)));
                                            FilesManager fm = new FilesManager();
                                            String docId = String.valueOf(((DocumentData)listOfDocs.get(i)).getLDocumentId());
                                            Long fileIdMain = ((DocumentData)listOfDocs.get(i)).getLFileId();
                                            log.info((Object)("Id znalezionego dokumentu: " + docId));
                                            log.info((Object)("Id pliku: " + fileIdMain.toString()));
                                            List<WfFileVersion> fileVersionsList = ArchiveServices.GetAllVersionsOfFile(fileIdMain);
                                            int howManyVersions = 0;
                                            howManyVersions = sAction.equalsIgnoreCase("ALLVERSIONS") ? fileVersionsList.size() : 1;
                                            if (fileVersionsList != null && fileVersionsList.size() > 0) {
                                                for (int c = howManyVersions - 1; c >= 0; --c) {
                                                    Long fileId = fileVersionsList.get(c).getFile().getId();
                                                    Long fileIdForPrepareIndeciesFunc = fileVersionsList.get(0).getFile().getId();
                                                    String[] prepareIndecies = ArchiveServices.PrepareIndeciesValuesForKeys(docClassId, fileIdForPrepareIndeciesFunc.toString(), sKeys);
                                                    String sVersion = String.valueOf(fileVersionsList.get(c).getVersion());
                                                    String foundFileId = ArchiveServices.CheckIfDocumentExistsWS(sURL, sDestClass, prepareIndecies, sLogin, sPassword);
                                                    Files file = fm.GetFile(fileId);
                                                    File fileToCopy = new File(file.getPath() + file.getName());
                                                    String sDescription = file.getDescription();
                                                    if (fileToCopy.exists()) {
                                                        String[] indeciesValuesForDocument = ArchiveServices.PrepareIndeciesValuesForKeys(docClassId, fileIdForPrepareIndeciesFunc.toString(), (String)allKeys);
                                                        Object[] asIndecies = ArchiveServices.ConnectIndexesWithIDs(indeciesIDs, indeciesValuesForDocument);
                                                        if (asIndecies != null) {
                                                            if (!foundFileId.equalsIgnoreCase("-1")) {
                                                                log.info((Object)("Dokument o fileId=" + fileId + " w obecnym systemie istnieje juz w systemie " + sURL + " w klasie " + sDestClass));
                                                                if (sAction.equalsIgnoreCase("ALLVERSIONS")) {
                                                                    log.info((Object)"Sprawdzanie wersji dokumentu");
                                                                    String ver = ArchiveServices.CheckVersionWS(sURL, foundFileId, sLogin, sPassword);
                                                                    if (!Tools.isNullOrEmpty((String)ver)) {
                                                                        int firstSysVer = Integer.valueOf(sVersion);
                                                                        int secondSysVer = Integer.valueOf(ver);
                                                                        if (secondSysVer < firstSysVer) {
                                                                            int res = ArchiveServices.AddFileToArchiveWS(sURL, destClassId, asIndecies, fileToCopy, sDescription, sAction, sLogin, sPassword);
                                                                            if (res > 0) {
                                                                                log.info((Object)("Zapis pliku " + fileToCopy.getName() + " i indeksow do archiwum jako nowa wersja dokumentu w systemie Workflow " + sURL + " w klasie " + sDestClass + " zakonczony powodzeniem"));
                                                                                continue;
                                                                            }
                                                                            log.info((Object)("Zapis pliku " + fileToCopy.getName() + " i indeksow do archiwum jako nowa wersja dokumentu w systemie Workflow " + sURL + " w klasie " + sDestClass + " zakonczony niepowodzeniem"));
                                                                            changeParam = false;
                                                                            continue;
                                                                        }
                                                                        log.info((Object)("Obecna wersja dokumentu juz istnieje. Dokument nie bedzie dodany do archiwum w systemie " + sURL + " w klasie " + sDestClass));
                                                                        continue;
                                                                    }
                                                                    log.info((Object)("Blad podczas pobierania wersji dokumentu z systemu " + sURL));
                                                                    changeParam = false;
                                                                    continue;
                                                                }
                                                                if (sAction.equalsIgnoreCase("NEWVERSION")) {
                                                                    int res = ArchiveServices.AddFileToArchiveWS(sURL, destClassId, asIndecies, fileToCopy, sDescription, sAction, sLogin, sPassword);
                                                                    if (res > 0) {
                                                                        log.info((Object)("Zapis pliku " + fileToCopy.getName() + " i indeksow do archiwum jako nowa wersja dokumentu w systemie Workflow " + sURL + " w klasie " + sDestClass + " zakonczony powodzeniem"));
                                                                        continue;
                                                                    }
                                                                    log.info((Object)("Zapis pliku " + fileToCopy.getName() + " i indeksow do archiwum jako nowa wersja dokumentu w systemie Workflow " + sURL + " w klasie " + sDestClass + " zakonczony niepowodzeniem"));
                                                                    changeParam = false;
                                                                    continue;
                                                                }
                                                                if (sAction.equalsIgnoreCase("NEWFILE")) {
                                                                    int res = ArchiveServices.AddFileToArchiveWS(sURL, destClassId, asIndecies, fileToCopy, sDescription, sAction, sLogin, sPassword);
                                                                    if (res > 0) {
                                                                        log.info((Object)("Zapis pliku " + fileToCopy.getName() + " i indeksow do archiwum jako nowy dokument w systemie Workflow " + sURL + " w klasie " + sDestClass + " zakonczony powodzeniem"));
                                                                        continue;
                                                                    }
                                                                    log.info((Object)("Zapis pliku " + fileToCopy.getName() + " i indeksow do archiwum jako nowy dokument w systemie Workflow " + sURL + " w klasie " + sDestClass + " zakonczony niepowodzeniem"));
                                                                    changeParam = false;
                                                                    continue;
                                                                }
                                                                log.info((Object)("Nieznana akcja. Dokument nie zostanie przekopiowany do systemu Workflow " + sURL));
                                                                continue;
                                                            }
                                                            log.info((Object)("Dokument o fileId=" + fileId + " w obecnym systemie nie istnieje w systemie " + sURL + " w klasie " + sDestClass));
                                                            int res = ArchiveServices.AddFileToArchiveWS(sURL, destClassId, asIndecies, fileToCopy, sDescription, "NEWFILE", sLogin, sPassword);
                                                            if (res > 0) {
                                                                log.info((Object)("Zapis pliku " + fileToCopy.getName() + " i indeksow do archiwum w systemie Workflow " + sURL + " w klasie " + sDestClass + " zakonczony powodzeniem"));
                                                                continue;
                                                            }
                                                            log.info((Object)("Zapis pliku " + fileToCopy.getName() + " i indeksow do archiwum w systemie Workflow " + sURL + " w klasie " + sDestClass + " zakonczony niepowodzeniem"));
                                                            continue;
                                                        }
                                                        log.info((Object)("Blad podczas tworzenia powiazan identyfikatorow indeksow z systemu " + sURL + " z wartosciami indeksow z obecnego systemu"));
                                                        changeParam = false;
                                                        continue;
                                                    }
                                                    log.info((Object)("Plik " + fileToCopy.toString() + " nie istnieje"));
                                                    changeParam = false;
                                                }
                                                continue;
                                            }
                                            log.info((Object)("Blad podczas pobierania wersji pliku o identyfikatorze " + fileIdMain.toString()));
                                            changeParam = false;
                                        }
                                    } else {
                                        log.info((Object)("Niezgodnosc ilosci indeksow w klasie " + sSourceClass + " i klasie " + sDestClass + " w systemie " + sURL));
                                        changeParam = false;
                                    }
                                } else {
                                    log.info((Object)("Blad podczas pobierania identyfikatorow indeksow z systemu Workflow " + sURL));
                                    changeParam = false;
                                }
                            } else {
                                log.info((Object)("Blad podczas pobierania identyfikatorow klas dokumentow z systemu Workflow " + sURL));
                                changeParam = false;
                            }
                        } else {
                            log.info((Object)("Brak dokumnetow w klasie dokumentow " + sSourceClass + " z okresu od " + sFrom + " do " + sTo));
                        }
                    } else {
                        log.info((Object)("Klasa dokumentow " + sSourceClass + " nie posiada indeksow"));
                        changeParam = false;
                    }
                } else {
                    log.info((Object)("Klasa zrodlowa dokumentow " + sSourceClass + " nie istnieje w systemie. Stworz ja lub popraw parametry zadania"));
                    changeParam = false;
                }
                if (!changeParam) break block41;
                try {
                    ScheduledTasksMethods manager = new ScheduledTasksMethods();
                    List ListOfScheduledTasksTable = manager.getAllScheduledTasks();
                    CopyArchiveBetweenWorkflows object = new CopyArchiveBetweenWorkflows();
                    String thisFunctionName = "";
                    StackTraceElement[] e = Thread.currentThread().getStackTrace();
                    if (e != null && e.length > 1) {
                        thisFunctionName = e[1].getMethodName();
                    }
                    String thisPackageName = ((Object)((Object)object)).getClass().getPackage().getName();
                    String thisClassName = ((Object)((Object)object)).getClass().getName();
                    if (thisClassName.lastIndexOf(46) > 0) {
                        thisClassName = thisClassName.substring(thisClassName.lastIndexOf(46) + 1);
                    }
                    String thisTask = thisPackageName + "." + thisClassName + "." + thisFunctionName;
                    if (ListOfScheduledTasksTable == null) break block41;
                    for (ScheduledTasksTable scheduledTasksTable : ListOfScheduledTasksTable) {
                        if (scheduledTasksTable == null) continue;
                        String className = scheduledTasksTable.getClass_name();
                        String methodName = scheduledTasksTable.getMethod_name();
                        String task = className + "." + methodName;
                        boolean processing = scheduledTasksTable.getIs_processing();
                        if (!processing || !thisTask.equalsIgnoreCase(task)) continue;
                        long taskId = scheduledTasksTable.getId();
                        List<ScheduledTasksParametersTable> ListOfParams = this.getListOfParams(taskId);
                        if (ListOfParams != null) {
                            for (ScheduledTasksParametersTable scheduledTasksParametersTable : ListOfParams) {
                                if (scheduledTasksParametersTable == null) continue;
                                int pos = scheduledTasksParametersTable.getParameter_position();
                                String value = scheduledTasksParametersTable.getParameter_value();
                                if (value == null || !value.equalsIgnoreCase(sFrom) || pos != 4) continue;
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                String oneParamValue = sdf.format(new Date(startTime));
                                scheduledTasksParametersTable.setParameter_value(oneParamValue);
                                ScheduledTasksMethods.changeScheduledTaskParameter((ScheduledTasksParametersTable)scheduledTasksParametersTable);
                                log.info((Object)("Zmieniono parametr wykonywania zadania zaplanowanego CopyArchive. Parametr od kiedy szukac dokumenty zmieniony na czas rozpoczecia wykonywania zadania: " + oneParamValue));
                            }
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    taskLog.info((Object)e.getMessage());
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                taskLog.info((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego CopyArchive: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ScheduledTasksParametersTable> getListOfParams(long id) {
        List result = null;
        Session session = null;
        Transaction transaction = null;
        try {
            session = HibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            result = session.createQuery("from ScheduledTasksParametersTable where scheduled_task_id=:ident").setParameter("ident", (Object)id).list();
            transaction.commit();
        }
        catch (HibernateException e) {
            taskLog.info((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            taskLog.info((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        return result;
    }
}

