/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.CUF.util.extension.JsonMessage;
import com.plusmpm.CUF.util.extension.ServletFile;
import com.plusmpm.CUF.util.extension.ServletTools;
import com.suncode.cuf.exception.CUFServiceException;
import com.suncode.cuf.io.office.ExcelReader;
import com.suncode.cuf.io.office.model.DuplicatedColumnException;
import com.suncode.cuf.io.office.model.SheetDefinition;
import com.suncode.cuf.plannedtask.administration.structure.helper.StructureMappings;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.form.datachooser.automapping.AutoMappingExecutor;
import com.suncode.pwfl.workflow.form.datachooser.automapping.AutoMappingExecutorConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ImportDTFromExcel
extends HttpServlet {
    public static Logger log = Logger.getLogger(ImportDTFromExcel.class);
    private static final long serialVersionUID = 1L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        log.info((Object)"************************* ExportTable Servlet ****************************");
        log.info((Object)"Params:");
        JsonMessage jm = new JsonMessage();
        ObjectMapper om = new ObjectMapper();
        resp.setContentType("text/html;charset=UTF-8");
        try {
            Map<String, Object> params = ServletTools.getParametersFromMultiPart(req);
            String processId = req.getParameter("processId");
            String activityId = req.getParameter("activityId");
            List<String> headers = this.readHeaders(req.getParameter("headers"));
            String columnsJson = req.getParameter("columns");
            Map columns = columnsJson == null ? null : (Map)om.readValue(columnsJson, (TypeReference)new TypeReference<Map<String, String>>(){});
            String columnsToImportJson = req.getParameter("columnsToImport");
            List columnsToImport = columnsToImportJson == null ? null : (List)om.readValue(columnsToImportJson, (TypeReference)new TypeReference<List<String>>(){});
            String dataChoosersWithSuspendedAutomappingsJson = req.getParameter("dataChoosersWithSuspendedAutomappings");
            Set dataChoosersWithSuspendedAutomappings = dataChoosersWithSuspendedAutomappingsJson == null ? null : (Set)om.readValue(dataChoosersWithSuspendedAutomappingsJson, (TypeReference)new TypeReference<Set<String>>(){});
            boolean override = Boolean.parseBoolean(req.getParameter("override"));
            ServletFile sf = (ServletFile)params.get("file");
            ExcelReader er = new ExcelReader();
            er.setReplaceSemicolons(true);
            SheetDefinition sheet = er.readFirstSheet(sf.getInputStream(), columns == null ? null : new ExcelHeadersMappings(columns), columnsToImport);
            for (String requiredHeader : headers) {
                boolean found = false;
                for (String header : sheet.getHeaders()) {
                    if (!header.equals(requiredHeader)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                jm.setSuccess(false);
                jm.setErrorMsg("Niepoprawne nag\u0142\u00f3wki. Plik nie zawiera kolumny o nag\u0142\u00f3wku: " + requiredHeader);
                String json = om.writeValueAsString((Object)jm);
                resp.getWriter().print(json);
                resp.getWriter().close();
                return;
            }
            List<Map<String, Object>> data = sheet.getData();
            data = this.applyDataChooserMappings(data, override, dataChoosersWithSuspendedAutomappings, processId, activityId);
            jm.setData(data);
            if (er.isSemicolonPresentInValues()) {
                jm.setMessage(MessageHelper.getMessage((String)"semicolonsReplaced"));
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            om.setDateFormat((DateFormat)df);
            String json = om.writeValueAsString((Object)jm);
            resp.getWriter().print(json);
            resp.getWriter().close();
        }
        catch (DuplicatedColumnException e) {
            log.error((Object)e, (Throwable)e);
            jm.setSuccess(false);
            jm.setErrorMsg("Niepoprawne nag\u0142\u00f3wki. Plik zawiera zduplikowan\u0105 kolumn\u0119 o nag\u0142\u00f3wku: " + e.getHeader());
            String json = om.writeValueAsString((Object)jm);
            resp.getWriter().print(json);
            resp.getWriter().close();
        }
        catch (CUFServiceException e) {
            log.error((Object)e, (Throwable)e);
            jm.setSuccess(false);
            jm.setErrorMsg(e.getMessage());
            String json = om.writeValueAsString((Object)jm);
            resp.getWriter().print(json);
            resp.getWriter().close();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            jm.setSuccess(false);
            jm.setErrorMsg("Nieznany b\u0142\u0105d");
            String json = om.writeValueAsString((Object)jm);
            resp.getWriter().print(json);
            resp.getWriter().close();
        }
    }

    private List<String> readHeaders(String sHeaders) throws JsonParseException, JsonMappingException, IOException {
        log.info((Object)("headers before decode: " + sHeaders));
        sHeaders = URLDecoder.decode(sHeaders, "UTF-8");
        log.info((Object)("headers after decode: " + sHeaders));
        ObjectMapper om = new ObjectMapper();
        List list = (List)om.readValue(sHeaders, (TypeReference)new TypeReference<List<String>>(){});
        return list;
    }

    private List<Map<String, Object>> applyDataChooserMappings(List<Map<String, Object>> importedData, boolean override, Set<String> dataChoosersWithSuspendedAutomappings, String processId, String activityId) {
        if (StringUtils.isBlank((CharSequence)processId) || StringUtils.isBlank((CharSequence)activityId)) {
            return importedData;
        }
        AutoMappingExecutor autoMappingExecutor = (AutoMappingExecutor)SpringContext.getBean(AutoMappingExecutor.class);
        AutoMappingExecutorConfig config = new AutoMappingExecutorConfig(importedData, processId, activityId);
        config.setOverrideCurrentGridValues(override);
        config.setDataChoosersWithSuspendedAutomappings(dataChoosersWithSuspendedAutomappings);
        return autoMappingExecutor.applyDataChoosersAutoMappings(config).getData();
    }

    class ExcelHeadersMappings
    implements StructureMappings {
        private Map<String, String> reverseMappings;
        private Map<String, String> mappings;
        private String[] columnNames;

        public ExcelHeadersMappings(Map<String, String> mappings) {
            this.mappings = mappings;
            this.reverseMappings = this.resolveReverseMappings();
            this.columnNames = this.resolveColumnNames();
        }

        private Map<String, String> resolveReverseMappings() {
            return this.mappings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        }

        private String[] resolveColumnNames() {
            return this.mappings.keySet().toArray(new String[0]);
        }

        @Override
        public String[] getColumnNames() {
            return this.columnNames;
        }

        @Override
        public Map<String, String> getColumnMappings() {
            return this.mappings;
        }

        @Override
        public Map<String, String> getReverseColumnMappings() {
            return this.reverseMappings;
        }

        @Override
        public String[] getOptionalColumns() {
            return null;
        }

        @Override
        public boolean shouldValidateColumns() {
            return false;
        }
    }
}

