/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.UserSearchViewTable;
import com.plusmpm.database.notifications.NotificationDefTable;
import com.plusmpm.database.notifications.NotificationProcActTable;
import com.plusmpm.database.notifications.NotificationRecipientTable;
import com.plusmpm.util.Tools;
import com.plusmpm.util.workflowData.ProcessData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jxl.Cell;
import jxl.CellType;
import jxl.CellView;
import jxl.NumberCell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.CellFormat;
import jxl.read.biff.BiffException;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.UserTransaction;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;
import org.enhydra.shark.xpdl.elements.Activities;
import org.enhydra.shark.xpdl.elements.Activity;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class CUFTools {
    public static Logger log = Logger.getLogger(CUFTools.class);
    private static int indentNumChars;
    private static int lineLength;
    private static boolean singleLine;
    public static String[] MIMETypesTable;
    public static String[] ExtsTable;

    public static String addDaysToDate(String invDate, String dayToAdd) throws Exception {
        log.trace((Object)("************************* addDaysToDate(invDate=" + invDate + ", dayToAdd=" + dayToAdd + ") ********************"));
        int dueDate = Integer.parseInt(dayToAdd);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateOfPay = new SimpleDateFormat("yyyy-MM-dd");
        Date date = simpleDateFormat.parse(invDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, dueDate);
        String dayOfPayStr = dateOfPay.format(calendar.getTime());
        return dayOfPayStr;
    }

    public static String getLastDateInMonth(String strDate) throws Exception {
        log.trace((Object)("************************* getLastDateInMonth(strDate=" + strDate + ") ********************"));
        String strLastDateInMonth = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = simpleDateFormat.parse(strDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int lastDate = calendar.getActualMaximum(5);
        calendar.set(5, lastDate);
        strLastDateInMonth = simpleDateFormat.format(calendar.getTime());
        return strLastDateInMonth;
    }

    @Deprecated
    public static Double Round(Double Rval, int Rpl) {
        log.trace((Object)("************************* Round(Rval=" + String.valueOf(Rval) + ", Rpl=" + Rpl + ") ********************"));
        Double p = Math.pow(10.0, Rpl);
        Rval = Rval * p;
        Long tmp = Math.round(Rval);
        return Double.valueOf(tmp.longValue()) / p;
    }

    public static List<String> getGroupForUser(String userId) throws Exception {
        log.trace((Object)("************************* getGroupForUser(userId=" + userId + ") ********************"));
        UserTransaction userTransaction = null;
        ArrayList<String> groupList = null;
        try {
            String[] groups;
            groupList = new ArrayList<String>();
            userTransaction = Shark.getInstance().createUserTransaction();
            UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
            for (String group : groups = uga.getAllGroupnames(userTransaction)) {
                if (!uga.doesUserBelongToGroup(userTransaction, group, userId)) continue;
                groupList.add(group);
            }
            ArrayList<String> arrayList = groupList;
            return arrayList;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            userTransaction.release();
        }
    }

    public static String removeCharsFromEnd(int lenghtFromEnd, String str) throws Exception {
        log.trace((Object)("************************* removeCharsFromEnd(lenghtFromEnd=" + String.valueOf(lenghtFromEnd) + ", str=" + str + ") ********************"));
        StringBuilder stringBuilder = new StringBuilder(str);
        stringBuilder.replace(stringBuilder.length() - lenghtFromEnd, stringBuilder.length(), "");
        return stringBuilder.toString();
    }

    public static String editor(String str, boolean removeSpaces, boolean upperCase) {
        log.trace((Object)("************************* editor(str=" + (String)str + ", removeSpaces=" + String.valueOf(removeSpaces) + ", upperCase=" + String.valueOf(upperCase) + ") ********************"));
        if (removeSpaces) {
            str = ((String)str).replaceAll("_", "&nbsp;");
        }
        str = ((String)str).replaceAll("hA4", "\u0104");
        str = ((String)str).replaceAll("h8F", "\u0106");
        str = ((String)str).replaceAll("hA8", "\u0118");
        str = ((String)str).replaceAll("h9D", "\u0141");
        str = ((String)str).replaceAll("hE0", "\u00d3");
        str = ((String)str).replaceAll("h97", "\u015a");
        str = ((String)str).replaceAll("hBD", "\u017b");
        str = ((String)str).replaceAll("h8D", "\u0179");
        str = ((String)str).replaceAll("hA5", "\u0105");
        str = ((String)str).replaceAll("h86", "\u0107");
        str = ((String)str).replaceAll("hA9", "\u0119");
        str = ((String)str).replaceAll("h88", "\u0142");
        str = ((String)str).replaceAll("hA2", "\u00f3");
        str = ((String)str).replaceAll("h98", "\u015b");
        str = ((String)str).replaceAll("hBE", "\u017c");
        str = ((String)str).replaceAll("hAB", "\u017a");
        if (upperCase) {
            str = ((String)str).substring(0, 1).toUpperCase() + ((String)str).substring(1, ((String)str).length());
        }
        return str;
    }

    public static String changeParamSearch(String sText, String sFromParam, String sToParam) throws Exception {
        log.trace((Object)("************************* changeParamSearch(sText=" + sText + ", sFromParam=" + sFromParam + ", sToParam=" + sToParam + " ) ********************"));
        String result = "";
        if (sText != null && sText.compareToIgnoreCase("") != 0 && sFromParam != null && sFromParam.compareToIgnoreCase("") != 0 && sToParam != null && sToParam.compareToIgnoreCase("") != 0) {
            result = sText.replace(sFromParam, sToParam);
        }
        return result;
    }

    public static String removeSpaces(String str) throws Exception {
        log.trace((Object)("************************* removeSpaces(str=" + (String)str + ") ********************"));
        String[] sTab = ((String)str).split(" ");
        str = "";
        for (int j = 0; j < sTab.length; ++j) {
            str = (String)str + sTab[j];
        }
        return str;
    }

    public static String convertCondition(String str) throws Exception {
        log.trace((Object)("************************* convertCondition(str=" + str + ") ********************"));
        if (str != null && str.compareToIgnoreCase("") != 0) {
            str = str.replaceAll("/", " ");
            str = str.replaceAll("!", "'");
            str = str.replaceAll("--", "=");
        }
        return str;
    }

    public static String cutSpaces(String value) {
        log.trace((Object)("************ cutSpaces(value=" + value + ") ************"));
        try {
            if (value != null) {
                while (value.startsWith(" ")) {
                    value = value.substring(1, value.length());
                }
                while (value.endsWith(" ")) {
                    value = value.substring(0, value.length() - 1);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return value;
    }

    public static String[] convertListOfHashMapsToStringTable(List<HashMap<String, String>> list) {
        log.trace((Object)"************ convertListOfHashMapsToStringTable(List<HashMap<String, String>>) *************");
        String[] table = new String[list.size()];
        try {
            for (int i = 0; i < list.size(); ++i) {
                Object oneElement = "";
                if (list.get(i) != null && list.get(i).size() > 0) {
                    for (String key : list.get(i).keySet()) {
                        String value = list.get(i).get(key);
                        oneElement = (String)oneElement + key + "=" + value + ";";
                    }
                    if (((String)oneElement).length() > 0) {
                        oneElement = ((String)oneElement).substring(0, ((String)oneElement).length() - 1);
                    }
                }
                table[i] = oneElement;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return table;
    }

    public static List<HashMap<String, String>> convertStringTableToListOfHashMaps(String[] table) {
        log.trace((Object)"************ convertStringTableToListOfHashMaps(String[]) ************");
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        HashMap<String, String> oneHashMap = null;
        try {
            if (table == null) {
                return null;
            }
            for (String oneElement : table) {
                String[] semicolonSplit = oneElement.split(";", -1);
                oneHashMap = new HashMap<String, String>();
                for (String oneSplit : semicolonSplit) {
                    String[] equalSplit = oneSplit.split("=", -1);
                    if (equalSplit[0] != null && !equalSplit[0].equals("null")) {
                        if (equalSplit[1] != null && !equalSplit[1].equals("null")) {
                            oneHashMap.put(equalSplit[0], equalSplit[1]);
                            continue;
                        }
                        oneHashMap.put(equalSplit[0], null);
                        continue;
                    }
                    if (equalSplit[1] != null && !equalSplit[1].equals("null")) {
                        oneHashMap.put(null, equalSplit[1]);
                        continue;
                    }
                    oneHashMap.put(null, null);
                }
                list.add(oneHashMap);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertXMLFileToStringFromFilePath(String filePath) {
        log.trace((Object)("********** convertXMLFileToStringFromFilePath(filePath=" + filePath + ") **********"));
        String xmlContent = null;
        FileInputStream inputStream = null;
        InputStreamReader reader = null;
        InputSource inputSource = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            File xmlFile = new File(filePath);
            if (xmlFile == null || !xmlFile.exists()) {
                throw new CUFException("Plik XML nie istnieje w podanej lokalizacji " + filePath);
            }
            inputStream = new FileInputStream(xmlFile);
            reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            inputSource = new InputSource(reader);
            documentBuilderFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            Document doc = documentBuilderFactory.newDocumentBuilder().parse(inputSource);
            StringWriter stw = new StringWriter();
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.transform(new DOMSource(doc), new StreamResult(stw));
            if (stw != null) {
                xmlContent = stw.toString();
            }
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return xmlContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertXMLFileToStringFromInputStream(InputStream inputStream) {
        log.trace((Object)"********** convertXMLFileInputStreamToStringFromFilePath(InputStream) **********");
        String xmlContent = null;
        InputStreamReader reader = null;
        InputSource inputSource = null;
        try {
            if (inputStream == null || inputStream.available() == 0) {
                throw new CUFException("Strumien danych do pliku XML jest pusty");
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            reader = new InputStreamReader(inputStream, "UTF-8");
            inputSource = new InputSource(reader);
            documentBuilderFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            Document doc = documentBuilderFactory.newDocumentBuilder().parse(inputSource);
            StringWriter stw = new StringWriter();
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.transform(new DOMSource(doc), new StreamResult(stw));
            if (stw != null) {
                xmlContent = stw.toString();
            }
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return xmlContent;
    }

    public static Document convertStringToXMLFile(String xmlContent) {
        log.trace((Object)"************ convertStringToXMLFile(String xmlContent) ************");
        Document xmlFile = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            xmlFile = builder.parse(new InputSource(new StringReader(xmlContent)));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return xmlFile;
    }

    public static InputStream getInputStreamForDocumentObject(Document doc) {
        log.trace((Object)"************ getInputStreamForDocumentObject(Document) ************");
        ByteArrayInputStream inputStream = null;
        try {
            if (doc != null) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                DOMSource xmlSource = new DOMSource(doc);
                StreamResult outputTarget = new StreamResult(outputStream);
                TransformerFactory.newInstance().newTransformer().transform(xmlSource, outputTarget);
                inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return inputStream;
    }

    public static String formatXML(String s) {
        log.trace((Object)"************ formatXML(String s) ************");
        indentNumChars = 2;
        lineLength = 120;
        return CUFTools.format(s, 0);
    }

    public static String formatXML(String s, int initialIndent) {
        log.trace((Object)("************ formatXML(String s,initialIndent=" + String.valueOf(initialIndent) + ") ************"));
        indentNumChars = 2;
        lineLength = 120;
        return CUFTools.format(s, initialIndent);
    }

    private static String format(String s, int initialIndent) {
        log.trace((Object)("************ format(String s,initialIndent=" + String.valueOf(initialIndent) + ") ************"));
        String formattedXML = null;
        int indent = initialIndent;
        StringBuilder sb = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        try {
            if (Tools.isNullOrEmpty((String)lineSeparator)) {
                throw new Exception("Nie udalo sie pobrac systemowego znaku konca linii");
            }
            for (int i = 0; i < s.length(); ++i) {
                char currentChar = s.charAt(i);
                if (currentChar == '<') {
                    char nextChar = s.charAt(i + 1);
                    if (nextChar == '/') {
                        indent -= indentNumChars;
                    }
                    if (!singleLine) {
                        sb.append(CUFTools.buildWhitespace(indent));
                    }
                    if (nextChar != '?' && nextChar != '!' && nextChar != '/') {
                        indent += indentNumChars;
                    }
                    singleLine = false;
                }
                sb.append(currentChar);
                if (currentChar != '>') continue;
                if (s.charAt(i - 1) == '/') {
                    indent -= indentNumChars;
                    sb.append(lineSeparator);
                    continue;
                }
                int nextStartElementPos = s.indexOf(60, i);
                if (nextStartElementPos > i + 1) {
                    String textBetweenElements = s.substring(i + 1, nextStartElementPos);
                    if (textBetweenElements.replaceAll(lineSeparator, "").length() == 0) {
                        sb.append(textBetweenElements + lineSeparator);
                    } else if ((double)textBetweenElements.length() <= (double)lineLength * 0.5) {
                        sb.append(textBetweenElements);
                        singleLine = true;
                    } else {
                        sb.append(lineSeparator + CUFTools.lineWrap(textBetweenElements, lineLength, indent, null, lineSeparator) + lineSeparator);
                    }
                    i = nextStartElementPos - 1;
                    continue;
                }
                sb.append(lineSeparator);
            }
            if (sb != null) {
                formattedXML = sb.toString();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return formattedXML;
    }

    private static String buildWhitespace(int numChars) {
        log.trace((Object)("************ buildWhitespace(numChars=" + String.valueOf(numChars) + ") ************"));
        String whitespace = "";
        StringBuilder sb = new StringBuilder();
        try {
            for (int i = 0; i < numChars; ++i) {
                sb.append(" ");
            }
            if (sb != null) {
                whitespace = sb.toString();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return whitespace;
    }

    private static String lineWrap(String s, int lineLength, Integer indent, String linePrefix, String lineSeparator) {
        log.trace((Object)("************ lineWrap(String s, lineLength=" + String.valueOf(lineLength) + ", indent=" + String.valueOf(indent) + ", linePrefix=" + linePrefix + ", String lineSeparator) ************"));
        String linewrap = null;
        StringBuilder sb = new StringBuilder();
        try {
            if (s == null) {
                return null;
            }
            int lineStartPos = 0;
            boolean firstLine = true;
            while (lineStartPos < s.length()) {
                int lineEndPos;
                if (!firstLine) {
                    sb.append(lineSeparator);
                } else {
                    firstLine = false;
                }
                if (lineStartPos + lineLength > s.length()) {
                    lineEndPos = s.length() - 1;
                } else {
                    for (lineEndPos = lineStartPos + lineLength - 1; lineEndPos > lineStartPos && s.charAt(lineEndPos) != ' ' && s.charAt(lineEndPos) != '\t'; --lineEndPos) {
                    }
                }
                sb.append(CUFTools.buildWhitespace(indent));
                if (linePrefix != null) {
                    sb.append(linePrefix);
                }
                sb.append(s.substring(lineStartPos, lineEndPos + 1));
                lineStartPos = lineEndPos + 1;
            }
            if (sb != null) {
                linewrap = sb.toString();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return linewrap;
    }

    public static String plannedTaskDuration(long duration) {
        log.trace((Object)("************ plannedTaskDuration(duration=" + String.valueOf(duration) + ") ************"));
        Object res = "";
        try {
            long days = TimeUnit.MILLISECONDS.toDays(duration);
            long hours = TimeUnit.MILLISECONDS.toHours(duration) - TimeUnit.DAYS.toHours(TimeUnit.MILLISECONDS.toDays(duration));
            long minutes = TimeUnit.MILLISECONDS.toMinutes(duration) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(duration));
            long seconds = TimeUnit.MILLISECONDS.toSeconds(duration) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(duration));
            long miliseconds = TimeUnit.MILLISECONDS.toMillis(duration) - TimeUnit.SECONDS.toMillis(TimeUnit.MILLISECONDS.toSeconds(duration));
            res = days > 0L ? days + " dni, " + hours + " godzin, " + minutes + " minut, " + seconds + " sekund, " + miliseconds + " milisekund" : (hours > 0L ? hours + " godzin, " + minutes + " minut, " + seconds + " sekund, " + miliseconds + " milisekund" : (minutes > 0L ? minutes + " minut, " + seconds + " sekund, " + miliseconds + " milisekund" : (seconds > 0L ? seconds + " sekund, " + miliseconds + " milisekund" : (miliseconds > 0L ? miliseconds + " milisekund" : "ponizej jednej milisekundy"))));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            res = "Blad podczas obliczania czasu";
        }
        return res;
    }

    public static String getExtFromMIME(String sSubtype) {
        log.trace((Object)("************ getExtFromMIME(sSubtype=" + sSubtype + ") ************"));
        String sExt = "";
        try {
            if (!Tools.isNullOrEmpty((String)sSubtype)) {
                sSubtype = sSubtype.toLowerCase();
            }
            HashMap<String, String> getExt = new HashMap<String, String>();
            if (MIMETypesTable.length == ExtsTable.length) {
                for (int i = 0; i < MIMETypesTable.length; ++i) {
                    String[] helpTable = MIMETypesTable[i].split("/");
                    getExt.put(helpTable[1], ExtsTable[i]);
                }
                String extForSubtype = (String)getExt.get(sSubtype);
                if (!Tools.isNullOrEmpty((String)extForSubtype)) {
                    sExt = extForSubtype;
                }
            } else {
                log.info((Object)"Niezgodnosc ilosci typow i rozszerzen w tabelach MIMETypesTable i ExtsTable");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sExt;
    }

    public static String getMIMETypeFromExt(String sExt) {
        log.trace((Object)("************ getMIMETypeFromExt(sExt=" + sExt + ") ************"));
        String MIMEType = "";
        try {
            if (!Tools.isNullOrEmpty((String)sExt)) {
                sExt = sExt.toLowerCase();
            }
            HashMap<String, String> getMIME = new HashMap<String, String>();
            if (MIMETypesTable.length == ExtsTable.length) {
                for (int i = 0; i < MIMETypesTable.length; ++i) {
                    getMIME.put(ExtsTable[i], MIMETypesTable[i]);
                }
                String key = "";
                block3: for (int i = 0; i < ExtsTable.length; ++i) {
                    String[] helpTable = ExtsTable[i].split(";");
                    for (int j = 0; j < helpTable.length; ++j) {
                        if (!helpTable[j].equalsIgnoreCase(sExt)) continue;
                        key = ExtsTable[i];
                        continue block3;
                    }
                }
                String typeForExt = (String)getMIME.get(key);
                if (!Tools.isNullOrEmpty((String)typeForExt)) {
                    MIMEType = typeForExt;
                }
            } else {
                log.info((Object)"Niezgodnosc ilosci typow i rozszerzen w tabelach MIMETypesTable i ExtsTable");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return MIMEType;
    }

    public static String getStatusNameForLanguage(String state, String sLanguage, boolean bIsProcess) {
        log.trace((Object)("************ getStatusNameForLanguage(state=" + state + ", sLanguage=" + sLanguage + ", bIsProcess=" + String.valueOf(bIsProcess) + ") ************"));
        String finalState = null;
        try {
            if (state != null) {
                if (bIsProcess) {
                    if (sLanguage.equalsIgnoreCase("ENG")) {
                        if (state.equalsIgnoreCase("Uruchomiony")) {
                            finalState = "Running";
                        } else if (state.equalsIgnoreCase("Oczekuj\u0105cy na uruchomienie")) {
                            finalState = "Open not started";
                        } else if (state.equalsIgnoreCase("Zawieszony")) {
                            finalState = "Suspended";
                        } else if (state.equalsIgnoreCase("Zako\u0144czony")) {
                            finalState = "Finished";
                        } else if (state.equalsIgnoreCase("Przerwany")) {
                            finalState = "Lost";
                        } else if (state.equalsIgnoreCase("Anulowany")) {
                            finalState = "Canceled";
                        }
                    } else {
                        finalState = state;
                    }
                } else if (sLanguage.equalsIgnoreCase("ENG")) {
                    if (state.equalsIgnoreCase("Uruchomione")) {
                        finalState = "Running";
                    } else if (state.equalsIgnoreCase("Oczekuj\u0105ce na uruchomienie")) {
                        finalState = "Waiting for start";
                    } else if (state.equalsIgnoreCase("Zawieszone")) {
                        finalState = "Suspended";
                    } else if (state.equalsIgnoreCase("Zako\u0144czone")) {
                        finalState = "Finished";
                    } else if (state.equalsIgnoreCase("Przerwane")) {
                        finalState = "Lost";
                    } else if (state.equalsIgnoreCase("Anulowane")) {
                        finalState = "Canceled";
                    }
                } else {
                    finalState = state;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return finalState;
    }

    public static HashMap<String, String[]> getColumnValues(String file, String[] keys, int numberSheet) throws BiffException, IOException, CUFException {
        log.trace((Object)("************ getColumnValues(file=" + file + ", String[], numberSheet=" + numberSheet + ") *************"));
        File fp = new File(file);
        WorkbookSettings wbs = new WorkbookSettings();
        wbs.setEncoding("ISO-8859-2");
        Workbook wb = Workbook.getWorkbook((File)fp, (WorkbookSettings)wbs);
        Sheet sheet = wb.getSheet(numberSheet);
        int columns = sheet.getColumns();
        int rows = sheet.getRows();
        HashMap<String, String[]> colVal = new HashMap<String, String[]>();
        for (int i = 0; i < keys.length; ++i) {
            String[] data;
            String key = keys[i];
            Cell foundCell = sheet.findCell(key, 0, 0, columns, 0, false);
            if (foundCell != null) {
                int col = foundCell.getColumn();
                data = new String[rows - 1];
                for (int row = 1; row < rows; ++row) {
                    Cell cell = sheet.getCell(col, row);
                    data[row - 1] = NumberCell.class.isInstance(cell) ? String.valueOf(((NumberCell)cell).getValue()) : sheet.getCell(col, row).getContents();
                }
            } else {
                throw new CUFException("Nie znaleziono kolumny o nazwie " + key + " w arkuszu kalkulacyjnym");
            }
            colVal.put(key, data);
        }
        return colVal;
    }

    public static List<Map<String, String>> getListColumnValues(String file, String[] keys) throws BiffException, IOException, CUFException {
        log.trace((Object)("************ getListColumnValues(file=" + file + ", String[]) *************"));
        HashMap<String, String[]> bufResponse = CUFTools.getColumnValues(file, keys, 0);
        ArrayList<Map<String, String>> response = new ArrayList<Map<String, String>>();
        Object[] set = bufResponse.keySet().toArray();
        for (int i = 0; i < set.length; ++i) {
            String[] oneResTab = bufResponse.get(set[i]);
            if (oneResTab == null) continue;
            for (int j = 0; j < oneResTab.length; ++j) {
                if (response.size() > j) {
                    ((Map)response.get(j)).put(set[i].toString(), oneResTab[j]);
                    continue;
                }
                HashMap<String, String> oneResult = new HashMap<String, String>();
                oneResult.put(set[i].toString(), oneResTab[j]);
                response.add(oneResult);
            }
        }
        return response;
    }

    public static HashMap<String, String[]> getColumnValuesWithTypeValidation(String file, Map<String, String> idTypeMap, int numberSheet) throws Exception {
        log.trace((Object)("************ getColumnValuesWithTypeValidation(file=" + file + ", Map<String, String>, numberSheet=" + numberSheet + ") *************"));
        File fp = new File(file);
        WorkbookSettings wbs = new WorkbookSettings();
        wbs.setEncoding("ISO-8859-2");
        Workbook wb = Workbook.getWorkbook((File)fp, (WorkbookSettings)wbs);
        Sheet sheet = wb.getSheet(numberSheet);
        int columns = sheet.getColumns();
        int rows = sheet.getRows();
        HashMap colVal = new HashMap();
        for (String key : idTypeMap.keySet()) {
            Cell foundCell = sheet.findCell(key, 0, 0, columns, 0, false);
            log.info((Object)("Kolumna " + key));
            if (foundCell != null) {
                int col = foundCell.getColumn();
                String[] data = new String[rows - 1];
                for (int row = 1; row < rows; ++row) {
                    CellType ct = sheet.getCell(col, row).getType();
                    if (ct.toString().equals("Empty")) {
                        log.info((Object)("Kolumna: " + key + " Wiersz: " + row + " jest pusta, wiec przechodz\u0119 do nast\u0119pnej kolumny"));
                        data[row - 1] = "";
                        continue;
                    }
                    if (idTypeMap.get(key).equals("date")) {
                        log.info((Object)"Typ data");
                        String value = sheet.getCell(col, row).getContents();
                        try {
                            String[] date = new String[3];
                            if (value.contains("-")) {
                                date = value.split("-");
                            } else if (value.contains(".")) {
                                date = value.split("\\.");
                                String tmp = date[0];
                                date[0] = date[2];
                                date[2] = tmp;
                            } else {
                                throw new Exception();
                            }
                            if (date[0].length() == 2) {
                                date[0] = "20" + date[0];
                            }
                            int y = Integer.valueOf(date[0]);
                            int m = Integer.valueOf(date[1]);
                            int d = Integer.valueOf(date[2]);
                            if (m > 0 && m < 13 && y > 0 && date[0].length() == 4 && date[1].length() == 2 && date[2].length() == 2) {
                                Calendar c = Calendar.getInstance();
                                c.set(1, y);
                                c.set(2, m - 1);
                                c.set(5, 1);
                                int daysInMonth = c.getActualMaximum(5);
                                if (daysInMonth < d) {
                                    throw new Exception();
                                }
                            } else {
                                throw new Exception();
                            }
                            data[row - 1] = date[0] + "-" + date[1] + "-" + date[2];
                            log.info((Object)"Wczytano date");
                            continue;
                        }
                        catch (Exception e) {
                            String msg = "Nieprawid\u0142owy typ w kolumnie '" + key + "', wiersz: " + row + ", lub nieprawid\u0142owy format daty.";
                            log.info((Object)msg);
                            throw new Exception(msg);
                        }
                    }
                    if (idTypeMap.get(key).equals("float")) {
                        log.info((Object)"Typ float");
                        NumberCell cell = null;
                        String value = "";
                        try {
                            try {
                                cell = (NumberCell)sheet.getCell(col, row);
                                log.info((Object)("Value " + cell.getValue()));
                                value = String.valueOf(cell.getValue());
                            }
                            catch (Exception e1) {
                                value = sheet.getCell(col, row).getContents();
                                value = value.replace(",", ".");
                                Double.parseDouble(value);
                            }
                        }
                        catch (Exception e) {
                            String msg = "Nieprawid\u0142owy typ w kolumnie '" + key + "', wiersz: " + row;
                            log.error((Object)e, (Throwable)e);
                            throw new Exception(msg);
                        }
                        data[row - 1] = value;
                        continue;
                    }
                    if (idTypeMap.get(key).equals("string")) {
                        log.info((Object)"Typ string");
                        data[row - 1] = sheet.getCell(col, row).getContents();
                        continue;
                    }
                    String msg = "Nieprawid\u0142owy typ w kolumnie '" + key + "', wiersz: " + row;
                    log.info((Object)msg);
                    throw new Exception(msg);
                }
                colVal.put(key, data);
                continue;
            }
            throw new CUFException("Nie znaleziono kolumny o nazwie " + key + " w arkuszu kalkulacyjnym");
        }
        colVal = (HashMap)CUFTools.removeEmptyRowsAndReplaceSem(colVal, rows - 1);
        return colVal;
    }

    private static Map<String, String[]> removeEmptyRowsAndReplaceSem(Map<String, String[]> rows, int rowCount) {
        HashMap<String, String[]> newRows = new HashMap<String, String[]>();
        boolean rowIdx = false;
        int newRowCount = rowCount;
        ArrayList<Integer> emptyIdx = new ArrayList<Integer>();
        for (int i = 0; i < rowCount; ++i) {
            boolean isEmpty = true;
            for (String col : rows.keySet()) {
                String[] colVals = rows.get(col);
                if (colVals.length < i || colVals[i] == null || Tools.isNullOrEmpty((String)colVals[i].trim())) continue;
                isEmpty = false;
                break;
            }
            if (!isEmpty) continue;
            emptyIdx.add(i);
            --newRowCount;
        }
        for (String col : rows.keySet()) {
            String[] colVals = rows.get(col);
            ArrayList<String> list = new ArrayList<String>();
            for (String colV : colVals) {
                list.add(colV.replaceAll(";", ","));
            }
            int removed = 0;
            for (Integer idx : emptyIdx) {
                int i = idx;
                list.remove(i - removed);
                ++removed;
            }
            String[] newCols = new String[newRowCount];
            for (int i = 0; i < newCols.length; ++i) {
                newCols[i] = (String)list.get(i);
            }
            newRows.put(col, newCols);
        }
        return newRows;
    }

    public static List<Map<String, String>> getListColumnValuesWithTypeValidation(String file, Map<String, String> idTypeMap) throws Exception {
        log.trace((Object)("************ getListColumnValuesWithTypeValidation(file=" + file + ",  Map<String, String>) *************"));
        HashMap<String, String[]> bufResponse = CUFTools.getColumnValuesWithTypeValidation(file, idTypeMap, 0);
        ArrayList<Map<String, String>> response = new ArrayList<Map<String, String>>();
        Object[] set = bufResponse.keySet().toArray();
        for (int i = 0; i < set.length; ++i) {
            String[] oneResTab = bufResponse.get(set[i]);
            if (oneResTab == null) continue;
            for (int j = 0; j < oneResTab.length; ++j) {
                if (response.size() > j) {
                    ((Map)response.get(j)).put(set[i].toString(), oneResTab[j]);
                    continue;
                }
                HashMap<String, String> oneResult = new HashMap<String, String>();
                oneResult.put(set[i].toString(), oneResTab[j]);
                response.add(oneResult);
            }
        }
        return response;
    }

    public static String convertBackslashesToSlashes(String sText) throws Exception {
        log.trace((Object)"********** convertBackslashesToSlashes( sText ) *************");
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(sText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '\\') {
                result.append("/");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        sText = result.toString();
        return sText;
    }

    public static HashMap<String, String[]> getColumnValues(String file, String[] keys) throws BiffException, IOException, CUFException {
        log.trace((Object)("************ getColumnValues(file=" + file + ", String[]) *************"));
        return CUFTools.getColumnValues(file, keys, 0);
    }

    public static String[] getColumnValues(String file, String keys) throws BiffException, IOException, CUFException {
        log.trace((Object)("************ getColumnValues(file=" + file + ", keys=" + keys + ") *************"));
        return CUFTools.getColumnValues(file, new String[]{keys}, 0).get(keys);
    }

    public static String[] getColumnValues(String file, String keys, int numberSheet) throws BiffException, IOException, CUFException {
        log.trace((Object)("************ getColumnValues(file=" + file + ", keys=" + keys + ", numberSheet=" + String.valueOf(numberSheet) + ") *************"));
        return CUFTools.getColumnValues(file, new String[]{keys}, numberSheet).get(keys);
    }

    public static void addCellToXLSSheet(WritableSheet sheet, int colPos, int rowPos, String value, WritableCellFormat cellFormat, CellView cellView) throws Exception {
        Label label = null;
        if (value == null) {
            value = "";
        }
        label = cellFormat != null ? new Label(colPos, rowPos, value, (CellFormat)cellFormat) : new Label(colPos, rowPos, value);
        sheet.addCell((WritableCell)label);
        if (cellView != null) {
            sheet.setColumnView(colPos, cellView);
        }
    }

    public static String getVarNameForVarId(String sProcDefId, String sVarId) {
        String sVarName;
        block3: {
            log.trace((Object)("************ getVarNameForVarId(sProcDefId=" + sProcDefId + ", sVarId=" + sVarId + ") ************"));
            sVarName = "";
            try {
                if (Tools.isNullOrEmpty((String)sProcDefId)) break block3;
                ProcessData processData = new ProcessData();
                Map mAllProcVar = ProcessData.getProcessVariableIdNameMap((String)sProcDefId);
                if (mAllProcVar == null || mAllProcVar.size() <= 0 || Tools.isNullOrEmpty((String)sVarId)) break block3;
                for (String id : mAllProcVar.keySet()) {
                    Object oName = mAllProcVar.get(id);
                    if (!id.equalsIgnoreCase(sVarId) || oName == null) continue;
                    sVarName = oName.toString();
                    break;
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return sVarName;
    }

    public static String getVarIdForVarName(String sProcDefId, String sVarName) {
        String sVarId;
        block3: {
            log.trace((Object)("************ getVarIdForVarName(sProcDefId=" + sProcDefId + ", sVarName=" + sVarName + ") ************"));
            sVarId = "";
            try {
                ProcessData processData = new ProcessData();
                Map mAllProcVar = ProcessData.getProcessVariableIdNameMap((String)sProcDefId);
                if (mAllProcVar == null || mAllProcVar.size() <= 0 || Tools.isNullOrEmpty((String)sVarName)) break block3;
                for (String id : mAllProcVar.keySet()) {
                    String thisVarName;
                    Object oName = mAllProcVar.get(id);
                    if (oName == null || !(thisVarName = oName.toString()).equalsIgnoreCase(sVarName)) continue;
                    sVarId = id;
                    break;
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return sVarId;
    }

    public static String getProcessNameForProcDefId(String sProcDefId) {
        String sProcessName;
        block3: {
            log.trace((Object)("************ getProcessNameForProcDefId(sProcDefId=" + sProcDefId + ") ************"));
            sProcessName = "";
            try {
                ProcessData processData;
                Map processDefIdsAndNamesMap;
                if (Tools.isNullOrEmpty((String)sProcDefId) || (processDefIdsAndNamesMap = (processData = new ProcessData()).getProcessDefIdsNames()) == null) break block3;
                for (String thisProcDefId : processDefIdsAndNamesMap.keySet()) {
                    if (!thisProcDefId.equalsIgnoreCase(sProcDefId)) continue;
                    sProcessName = (String)processDefIdsAndNamesMap.get(thisProcDefId);
                    break;
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return sProcessName;
    }

    public static String getProcDefIdForProcessName(String sProcessName) {
        String sProcDefId;
        block3: {
            log.trace((Object)("************ getProcDefIdForProcessName(sProcessName=" + sProcessName + ") ************"));
            sProcDefId = "";
            try {
                ProcessData processData = new ProcessData();
                Map processDefIdsAndNamesMap = processData.getProcessDefIdsNames();
                if (processDefIdsAndNamesMap == null) break block3;
                for (String thisProcDefId : processDefIdsAndNamesMap.keySet()) {
                    String thisProcessName = (String)processDefIdsAndNamesMap.get(thisProcDefId);
                    if (thisProcessName == null || !thisProcessName.equalsIgnoreCase(sProcessName)) continue;
                    sProcDefId = thisProcDefId;
                    break;
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return sProcDefId;
    }

    public static String getActivityNameForActDefId(String sProcDefId, String sActDefId) {
        log.trace((Object)("************ getActivityNameForActDefId(sProcDefId=" + sProcDefId + ", sActDefId=) ************"));
        String sActivityName = "";
        try {
            Activity activity;
            ProcessData processData;
            Activities activities;
            if (!Tools.isNullOrEmpty((String)sProcDefId) && !Tools.isNullOrEmpty((String)sActDefId) && (activities = (processData = new ProcessData()).getAllActivities(sProcDefId)) != null && (activity = activities.getActivity(sActDefId)) != null) {
                sActivityName = activity.getName();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sActivityName;
    }

    public static String getActDefIdForActivityName(String sProcDefId, String sActivityName) {
        String sActDefId;
        block3: {
            log.trace((Object)("************ getActDefIdForActivityName(sProcDefId=" + sProcDefId + ", sActivityName=" + sActivityName + ") ************"));
            sActDefId = "";
            try {
                ProcessData processData = new ProcessData();
                Activities activities = processData.getAllActivities(sProcDefId);
                if (activities == null) break block3;
                for (int i = 0; i < activities.size(); ++i) {
                    String thisActivityName;
                    Activity activity = (Activity)activities.get(i);
                    if (activity == null || (thisActivityName = activity.getName()) == null || !thisActivityName.equalsIgnoreCase(sActivityName)) continue;
                    sActDefId = activity.getId();
                    break;
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return sActDefId;
    }

    public static boolean doesNotificationDefExist(String sProcDefId, String sNotificationName) throws Exception {
        log.trace((Object)("************ doesNotificationDefExist(sProcDefId=" + sProcDefId + ", sNotificationName=" + sNotificationName + ") ************"));
        boolean bExists = false;
        DBManagement dbm = new DBManagement();
        ArrayList notifications = dbm.getNotificationDefByProcessDefId(sProcDefId);
        if (notifications != null && notifications.size() > 0) {
            for (NotificationDefTable oneNotification : notifications) {
                String thisNotificationName;
                if (oneNotification == null || (thisNotificationName = oneNotification.getName()) == null || !thisNotificationName.equals(sNotificationName)) continue;
                bExists = true;
                break;
            }
        }
        return bExists;
    }

    public static boolean doesNotificationRecipientExist(String sNotificationId, String sRecipientType, String sRecipientVal) throws Exception {
        log.trace((Object)("************ doesNotificationRecipientExist(sNotificationId=" + sNotificationId + ", sRecipientType=" + sRecipientType + ", sRecipientVal=" + sRecipientVal + ") ************"));
        boolean bExists = false;
        DBManagement dbm = new DBManagement();
        ArrayList recipients = dbm.getNotificationRecipientByNotificationDefId(sNotificationId);
        if (recipients != null && recipients.size() > 0) {
            for (NotificationRecipientTable oneRecipient : recipients) {
                if (oneRecipient == null) continue;
                String thisRecipientType = oneRecipient.getRecipientType();
                String thisRecipientVal = oneRecipient.getRecipientVal();
                if (thisRecipientType == null || thisRecipientVal == null || !thisRecipientType.equalsIgnoreCase(sRecipientType) || !thisRecipientVal.equalsIgnoreCase(sRecipientVal)) continue;
                bExists = true;
                break;
            }
        }
        return bExists;
    }

    public static boolean doesNotificationActivityExist(String sNotificationId, String sActDefId) throws Exception {
        log.trace((Object)("************ doesNotificationActivityExist(sNotificationId=" + sNotificationId + ", sActDefId=" + sActDefId + ") ************"));
        boolean bExists = false;
        DBManagement dbm = new DBManagement();
        ArrayList activities = dbm.getNotificationProcActByNotificationDefId(sNotificationId);
        if (activities != null && activities.size() > 0) {
            for (NotificationProcActTable oneActivity : activities) {
                String thisActDefId;
                if (oneActivity == null || (thisActDefId = oneActivity.getActivityDefId()) == null || !thisActDefId.equalsIgnoreCase(sActDefId)) continue;
                bExists = true;
                break;
            }
        }
        return bExists;
    }

    public static boolean doesViewExistForUser(String userId, String viewName) throws Exception {
        boolean bExists = false;
        DBManagement dbm = new DBManagement();
        ArrayList userViews = null;
        if (userId == null) {
            throw new Exception("Brak loginu uzytkownika");
        }
        userViews = dbm.GetAllUserSearchViewsForUser(userId);
        if (userViews != null && userViews.size() > 0) {
            for (UserSearchViewTable userView : userViews) {
                String thisViewName;
                if (userView == null || !(thisViewName = userView.getViewName()).equalsIgnoreCase(viewName)) continue;
                bExists = true;
                break;
            }
        }
        return bExists;
    }

    static {
        MIMETypesTable = new String[]{"application/atom+xml", "application/json", "application/javascript", "application/ms-excel", "application/ogg", "application/pdf", "application/postscript", "application/xml", "application/x-woff", "application/xhtml", "application/xml-dtd", "application/xml", "application/zip", "application/x-gzip", "audio/basic", "audio/mid", "audio/mpeg", "audio/x-aiff", "audio/x-mpegurl", "audio/x-pn-realaudio", "audio/x-wav", "image/bmp", "image/cis-cod", "image/gif", "image/ef", "image/jpeg", "image/pipeg", "image/pjpeg", "image/png", "image/svg+xml", "image/tiff", "image/x-cmu-raster", "image/x-cmx", "image/x-icon", "image/x-png", "image/x-portable-anymap", "image/x-portable-bitmap", "image/x-portable-graymap", "image/x-portable-pixmap", "image/x-rgb", "image/x-xbitmap", "image/x-xpixmap", "image/x-xwindowdump", "message/rfc822", "text/css", "text/h323", "text/html", "text/iuls", "text/plain", "text/richtext", "text/scriptlet", "text/tab-separated-values", "text/webviewhtml", "text/x-component", "text/x-setext", "text/x-vcard", "video/mpeg", "video/quicktime", "video/x-la-asf", "video/x-ms-asf", "video/x-msvideo", "video/x-sgi-movie", "x-world/x-vrml"};
        ExtsTable = new String[]{"atom;xml", "json", "js", "xls;xlsx", "ogg", "pdf", "ps", "xml", "woff", "xhtml;xht;html;htm", "dtd", "xml", "zip", "gz", "au;snd", "mid;rmi", "mp3", "aif;aifc;aiff", "m3u", "ra;ram", "wav", "bmp", "cod", "gif", "ief", "jpe;jpeg;jpg", "jfif", "jpeg", "png", "svg", "tif;tiff", "ras", "cmx", "ico", "png", "pnm", "pbm", "pgm", "ppm", "rgb", "xbm", "xpm", "xwd", "mht;mhtml;nws", "css", "323", "htm;html;stm", "uls", "bas;c;h;txt", "rtx", "sct", "tsv", "htt", "htc", "etx", "vcf", "mp2;mpa;mpe;mpeg;mpg;mpv2", "mov;qt", "lsf;lsx", "asf;asr;asx", "avi", "movie", "flr;vrml;wrl;wrz;xaf;xof"};
    }
}

