/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.template;

import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.i18n.xpdl.PackageTranslationHelper;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.ProcessDefinition;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class WordTemplateCommentWrapper {
    private final List<Comment> commentsList;
    private UserFinder userFinder = FinderFactory.getUserFinder();
    private ProcessService processService = ServiceFactory.getProcessService();
    private ActivityFinder activityFinder = FinderFactory.getActivityFinder();
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public WordTemplateCommentWrapper(List<Comment> commentsList) {
        this.commentsList = commentsList;
    }

    public String getCommentsAuthors() {
        return this.commentsList.stream().map(comment -> this.findUser((Comment)comment)).collect(Collectors.joining(";"));
    }

    private String findUser(Comment comment) {
        User user = this.userFinder.findByUserName(comment.getUserId(), new String[0]);
        if (user != null && StringUtils.isNotBlank((CharSequence)user.getFullName())) {
            return user.getFullName();
        }
        return comment.getUserId();
    }

    public String getCommentsDates() {
        return this.commentsList.stream().map(comment -> dateFormat.format(comment.getCommentDate())).collect(Collectors.joining(";"));
    }

    public String getCommentsActivitiesNames() {
        return this.commentsList.stream().map(this::commentToActivityName).collect(Collectors.joining(";"));
    }

    private String commentToActivityName(Comment comment) {
        String commentProcessDefId = comment.getProcessDefId();
        String commentActivityDefId = comment.getActivityDefId();
        Optional optionalActivity = this.activityFinder.findActivity(comment.getProcessId(), comment.getActivityId(), new String[0]);
        if (optionalActivity.isPresent()) {
            Activity activity = (Activity)optionalActivity.get();
            return activity.getName();
        }
        if (StringUtils.isNotBlank((CharSequence)commentProcessDefId) && StringUtils.isNotBlank((CharSequence)commentActivityDefId)) {
            ProcessDefinition processDefinition = this.processService.getProcessDefinition(commentProcessDefId);
            return PackageTranslationHelper.getActivityName((String)processDefinition.getPackageId(), (String)commentProcessDefId, (String)commentActivityDefId);
        }
        return comment.getActivityId();
    }

    public String getCommentsContents() {
        return this.commentsList.stream().map(Comment::getComment).collect(Collectors.joining(";"));
    }
}

