/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension.DocTemplates2Pdf.table;

import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.graphic.ColumnGraphicInfo;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.graphic.GraphicUtils;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.table.TableStyle;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.workflow.WorkflowUtils;
import com.plusmpm.util.Tools;
import com.plusmpm.util.workflowData.ProcessData;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.XPathBinderAssociationIsPartialException;
import org.docx4j.model.styles.StyleUtil;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.sharedtypes.STOnOff;
import org.docx4j.wml.CTTblLook;
import org.docx4j.wml.CTTblPrBase;
import org.docx4j.wml.CTTblStylePr;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.ParaRPr;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STLineSpacingRule;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblGridCol;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.Text;
import org.docx4j.wml.Tr;
import org.docx4j.wml.TrPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableUtils {
    private static final Logger log = LoggerFactory.getLogger(TableUtils.class);

    public static String fitTextToColumn(String txt, int colWidth, String font, int fontSize, boolean isBold, boolean isItalic) {
        log.trace("***fitTextToColumn(txt=" + txt + ",colWidth=" + colWidth + ",font=" + font + ",fontSize=" + fontSize + ",isBold=" + isBold + ",isItalic=" + isItalic + ")****");
        AffineTransform af = new AffineTransform();
        FontRenderContext fr = new FontRenderContext(af, true, true);
        int style = 0;
        if (isBold && isItalic) {
            style = 3;
        } else if (isBold) {
            style = 1;
        } else if (isItalic) {
            style = 2;
        }
        Font f = new Font(font, style, fontSize);
        String newTxt = "";
        log.info("Szerokosc kolumny: " + (colWidth -= 100));
        String[] words = txt.split(" ");
        double scale = 25.0;
        scale -= (double)(colWidth / 1000);
        for (int i = 0; i < words.length; ++i) {
            String w = words[i];
            log.info("s\u0142owo: " + w);
            double width = f.getStringBounds(w, fr).getWidth() * scale;
            log.info("szeroko\u015b\u0107 s\u0142owa: " + width);
            if (width > (double)colWidth) {
                log.info("s\u0142owo si\u0119 nie miesci w kolumnie");
                int lines = (int)Math.ceil(width / (double)colWidth);
                log.info("S\u0142owo zostanie rozbite na okolo " + lines + " linii");
                int len = w.length();
                int offset = 0;
                for (int k = 0; k < lines; ++k) {
                    int endLine;
                    String line = w.substring(offset, Math.min(w.length(), len / lines + offset));
                    double lw = f.getStringBounds(line, fr).getWidth() * scale;
                    while (lw > (double)colWidth) {
                        line = line.substring(0, line.length() - 1);
                        lw = f.getStringBounds(line, fr).getWidth() * scale;
                    }
                    do {
                        if (!((lw = f.getStringBounds(line = w.substring(offset, endLine = Math.min(line.length() + 1 + offset, w.length())), fr).getWidth() * scale) > (double)colWidth)) continue;
                        line = line.substring(0, line.length() - 1);
                        break;
                    } while (endLine != w.length());
                    log.info("dodaje linie: " + line);
                    newTxt = newTxt + line + "\n";
                    if (k + 1 != lines || (offset += line.length()) >= w.length() || Tools.isNullOrEmpty((String)line)) continue;
                    --k;
                }
                continue;
            }
            if (Tools.isNullOrEmpty((String)w)) continue;
            log.info("s\u0142owo miesci sie w kolumnie");
            newTxt = newTxt + w + " ";
        }
        return newTxt;
    }

    public static Tc getCell(JAXBElement<Tc> cellElem) {
        Tc cell = null;
        if (cellElem != null) {
            log.info("Pobieranie elementu kom\u00f3rki powiod\u0142o si\u0119.");
            log.info("Pobieranie listy warto\u015bci kom\u00f3rki.");
            cell = (Tc)cellElem.getValue();
        } else {
            log.info("B\u0141\u0104D - Problem z pobraniem elementu kom\u00f3rki.");
        }
        return cell;
    }

    public static Tc getCell(List<Object> currentRowCells, int j) {
        Tc cell = null;
        try {
            log.info("Pobieranie obiektu Tc dla kolumny j = ".concat(String.valueOf(j)));
            cell = (Tc)currentRowCells.get(j);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return cell;
    }

    public static Tr getRow(List<Object> currentTableRows, int j) {
        Tr row = null;
        try {
            log.info("Pobieranie obiektu Tr dla wiersza j = ".concat(String.valueOf(j)));
            row = (Tr)currentTableRows.get(j);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return row;
    }

    public static List<Tbl> getTables(List<Object> nodes) {
        ArrayList<Tbl> tbls = new ArrayList<Tbl>();
        for (int i = 0; i < nodes.size(); ++i) {
            log.info("Pobieranie w\u0119z\u0142a dla i = ".concat(String.valueOf(i)));
            JAXBElement jaxbeTmp = (JAXBElement)nodes.get(i);
            JAXBElement elem = null;
            if (jaxbeTmp != null && jaxbeTmp.getDeclaredType().toString().equalsIgnoreCase("class org.docx4j.wml.Tbl")) {
                log.info("Wezel jest tabela.");
                elem = (JAXBElement)nodes.get(i);
            }
            log.info("Pobieranie wartosci wezla tabeli.");
            Tbl tbl = (Tbl)elem.getValue();
            tbls.add(tbl);
            log.info("Pobieranie wezla tabeli powiodlo sie.");
        }
        return tbls;
    }

    public static void removeMarkupRows(List<Tbl> tables, List<Boolean> tablesFlags, List<Boolean> headersFlags) {
        for (int i = 0; i < tables.size(); ++i) {
            tablesFlags.add(null);
            headersFlags.add(null);
            log.info("Pobranie wierszy z tabeli.");
            List currentTableRows = tables.get(i).getContent();
            if (currentTableRows != null && currentTableRows.size() > 0) {
                log.info("Pobieranie wierszy z tabeli powiod\u0142o si\u0119, liczba wierszy = ".concat(String.valueOf(currentTableRows.size())));
                if (currentTableRows.size() >= 2) {
                    log.info("Liczba wierszy >= 2.");
                    for (int j = 0; j < 2; ++j) {
                        Tr row = TableUtils.getRow(currentTableRows, j);
                        if (row != null) {
                            log.info("Pobieranie wiersza powiod\u0142o si\u0119.");
                            log.info("Pobieranie warto\u015bci kom\u00f3rek dla wiersza j = ".concat(String.valueOf(j)));
                            List cells = row.getContent();
                            if (cells.size() == 1 && cells.get(0) != null) {
                                log.info("Pierwszy wiersz posiada tylko jedn\u0105 kolumn\u0119, mo\u017ce by\u0107 znacznikiem.");
                                log.info("Pobieranie elementu kom\u00f3rki.");
                                JAXBElement cellElem = (JAXBElement)cells.get(0);
                                Tc cell = TableUtils.getCell((JAXBElement<Tc>)cellElem);
                                if (cell != null) {
                                    log.info("Pobieranie listy warto\u015bci kom\u00f3rki powiod\u0142o si\u0119.");
                                    List cellValues = cell.getContent();
                                    if (cellValues != null && cellValues.size() > 0 && cellValues.get(0) != null) {
                                        log.info("Pobieranie pierwszej warto\u015bci z listy powiod\u0142o si\u0119.");
                                        String cellValue = String.valueOf(cellValues.get(0));
                                        log.info("cellValue = ".concat(cellValue));
                                        if (cellValue.compareTo("TABLE_TO_PROCESS_MARKER") == 0) {
                                            log.info("cellValue to znacznik przetwarzania tabeli.");
                                            tablesFlags.remove(tablesFlags.size() - 1);
                                            tablesFlags.add(true);
                                        }
                                        if (cellValue.compareTo("TABLE_NOT_TO_PROCESS_MARKER") == 0) {
                                            log.info("cellValue to znacznik wy\u0142\u0105czaj\u0105cy domy\u015blne przetwarzanie tabeli.");
                                            tablesFlags.remove(tablesFlags.size() - 1);
                                            tablesFlags.add(false);
                                        }
                                        if (cellValue.compareTo("TABLE_WITHOUT_HEADERS_MARKER") != 0) continue;
                                        log.info("cellValue to znacznik usuni\u0119cia nag\u0142\u00f3wka.");
                                        headersFlags.remove(headersFlags.size() - 1);
                                        headersFlags.add(false);
                                        continue;
                                    }
                                    log.info("B\u0141\u0104D - problem z pobraniem pierwszej warto\u015bci z listy.");
                                    continue;
                                }
                                log.info("B\u0141\u0104D - Problem z pobraniem warto\u015bci kom\u00f3rki.");
                                continue;
                            }
                            log.info("Pierwszy wiersz posiada wi\u0119cej ni\u017c jedn\u0105 kolumn\u0119, nie jest znacznikiem.");
                            continue;
                        }
                        log.info("Problem z pobraniem obiektu Tr dla wiersza.");
                    }
                } else {
                    log.info("Tabela posiada tylko jeden wiersz.");
                }
            } else {
                log.info("B\u0141\u0104D - Problem z pobieraniem wierszy tabeli.");
            }
            log.info("Usuwanie wierszy znacznikowych.");
            if (tablesFlags.get(i) != null) {
                log.info("Wiersz znacznikowy przetwarzania tabeli - usuni\u0119ty.");
                currentTableRows.remove(0);
            }
            if (headersFlags.get(i) != null && !headersFlags.get(i).booleanValue()) {
                log.info("Wiersz znacznikowy usuni\u0119cia nag\u0142\u00f3wka tabeli - usuni\u0119ty.");
                currentTableRows.remove(0);
            }
            log.info("Usuwanie wierszy znacznikowych powiod\u0142o si\u0119.");
        }
    }

    public static void initTableMarkups(String templatePath, Map<String, Object> mappings, List<Map<String, String>> tablesMaps, String variablesMarker, String processId, WordprocessingMLPackage template, MainDocumentPart documentPart, List<Tbl> tables, List<Boolean> tablesFlags, List<Boolean> headersFlags, List<ColumnGraphicInfo> tablesGraphicColumnInfo, boolean pdf) throws Exception {
        log.info("Przygotowanie wartosci do uzpelnienia tabel.");
        for (int i = 0; i < tables.size(); ++i) {
            if (tablesFlags.get(i).booleanValue()) {
                log.info("Ustawianie formatowania wierszy w tabeli.");
                ArrayList<Map<String, Object>> paragraphsProperties = new ArrayList<Map<String, Object>>();
                AtomicReference<Object> rowProperties = new AtomicReference<Object>(null);
                log.info("Pobieranie wierszy z tabeli i = ".concat(String.valueOf(i)));
                List currentTableRows = tables.get(i).getContent();
                if (currentTableRows != null && currentTableRows.size() > 0) {
                    int defaultRowNo = 1;
                    TableUtils.initTableFormatting(documentPart, paragraphsProperties, rowProperties, currentTableRows);
                    log.info("Pobieranie wartosci do uzpelnienia tabeli.");
                    if (!Tools.isNullOrEmpty((String)processId)) {
                        log.info("processId rozne od null i nie jest puste.");
                        log.info("Pobieranie wezlow z wartosciami komorek z tabeli, dla wiersza: ".concat(String.valueOf(i)));
                        String tableHeaders = "";
                        Tr row = (Tr)currentTableRows.get(0);
                        List cellElements = row.getContent();
                        int columnsCount = 0;
                        log.info("Pobieranie naglowkow.");
                        for (int j = 0; j < cellElements.size(); ++j) {
                            Tc cell = null;
                            try {
                                JAXBElement cellElement = (JAXBElement)cellElements.get(j);
                                cell = (Tc)cellElement.getValue();
                                ++columnsCount;
                            }
                            catch (ClassCastException cellElement) {
                                // empty catch block
                            }
                            if (cell == null) continue;
                            tableHeaders = tableHeaders.concat(String.valueOf(cell.getEGBlockLevelElts().get(0)));
                        }
                        log.info("Pobieranie naglowkow powiodlo sie.");
                        log.info(tableHeaders);
                        log.info("headersFlags dla i = ".concat(String.valueOf(i).concat(" = ").concat(String.valueOf(headersFlags.get(i)))));
                        if (!headersFlags.get(i).booleanValue()) {
                            log.info("W tabeli o indeksie ".concat(String.valueOf(i)).concat(" nag\u0142\u00f3wek ma zosta\u0107 usuni\u0119ty."));
                            defaultRowNo = 0;
                        }
                        log.info("Usuwanie wiersza z nag\u0142\u00f3wkiem.");
                        while (currentTableRows.size() > defaultRowNo) {
                            currentTableRows.remove(currentTableRows.size() - 1);
                        }
                        log.info("Usuwanie wierszy powiodlo sie.");
                        String processDefId = WorkflowUtils.getProcessDefId(processId);
                        tableHeaders = tableHeaders.substring(1, tableHeaders.length() - 1);
                        log.info("Usuniecie nadmiarowych znacznikow zmiennych.");
                        log.info(tableHeaders);
                        tableHeaders = tableHeaders.replace(variablesMarker.concat(variablesMarker), variablesMarker);
                        log.info("Usuniecie nadmiarowych znacznikow zmiennych powiodlo sie.");
                        log.info(tableHeaders);
                        log.info("Splitowanie zmiennych.");
                        String[] splittedTableHeaders = tableHeaders.split(variablesMarker);
                        log.info("Splitowanie zmiennych powiodlo sie.");
                        log.info(splittedTableHeaders.toString());
                        ArrayList<String> tableValues = new ArrayList<String>();
                        log.info("Ustawianie naglowkow.");
                        try {
                            ProcessData processData = new ProcessData();
                            for (int j = 0; j < splittedTableHeaders.length; ++j) {
                                if (j >= columnsCount) continue;
                                if (splittedTableHeaders[j].contains("|")) {
                                    String[] tmp = splittedTableHeaders[j].split("\\|");
                                    Object tableValue = mappings.get(tmp[0]);
                                    tableValue = tableValue == null ? "" : tableValue;
                                    tableValues.add(tableValue.toString());
                                    mappings.put(splittedTableHeaders[j], tmp[1]);
                                    continue;
                                }
                                Object tableValue = mappings.get(splittedTableHeaders[j]);
                                tableValue = tableValue == null ? "" : tableValue;
                                Object mapping = ProcessData.getProcessVariableIdNameMap((String)processDefId).get(splittedTableHeaders[j]);
                                if (mapping != null) {
                                    mappings.put(splittedTableHeaders[j], mapping.toString());
                                } else {
                                    mappings.put(splittedTableHeaders[j], splittedTableHeaders[j]);
                                }
                                tableValues.add(tableValue.toString());
                            }
                        }
                        catch (Exception e) {
                            log.info("B\u0141\u0104D - problem z ustawianiem nag\u0142\u00f3wk\u00f3w.");
                            log.error(e.getMessage(), (Throwable)e);
                            throw e;
                        }
                        log.info("Ustawianie naglowkow powiodlo sie.");
                        log.info(mappings.toString());
                        log.info("Tworzenie tabel z wypelnionymi wartosciami.");
                        TableUtils.createTableWithValues(documentPart, tables.get(i), tableValues, paragraphsProperties, rowProperties.get(), tablesGraphicColumnInfo.get(i), template, pdf);
                        log.info("Tworzenie tabel z wypelnionymi wartosciami powiodlo sie.");
                        continue;
                    }
                    log.info("processId = null");
                    log.info("Tworzenie tabel z wypelnionymi wartosciami.");
                    TableUtils.createTableWithValues(documentPart, i, tables.get(i), tablesMaps.get(i), paragraphsProperties);
                    log.info("Tworzenie tabel z wypelnionymi wartosciami powiodlo sie.");
                    continue;
                }
                log.error("B\u0141\u0104D - tabela nr".concat(String.valueOf(i + 1)).concat(" w szablonie ").concat(templatePath).concat(" nie zawiera wierszy."));
                continue;
            }
            log.info("Tabela o indeksie: ".concat(String.valueOf(i)).concat(" nie ma byc uzupelniana"));
        }
    }

    private static void initTableFormatting(MainDocumentPart documentPart, List<Map<String, Object>> paragraphsProperties, AtomicReference<TrPr> rowProperties, List<Object> currentTableRows) throws JAXBException, XPathBinderAssociationIsPartialException {
        int whichRow = 1;
        if (currentTableRows.size() > 1) {
            Tr row = (Tr)currentTableRows.get(whichRow);
            log.info("Formatowanie wierszy jest pobierane z drugiego wiersza tabeli (nie z nag\u0142\u00f3wka).");
            log.info("Pobieranie paragraf\u00f3w tekstowych(kolumn) z wiersza definiujacego formatowanie.");
            List paragraphs = documentPart.getJAXBNodesViaXPath("./w:tc/w:p", (Object)row, false);
            if (paragraphs != null && paragraphs.size() > 0) {
                log.info("Pobieranie paragraf\u00f3w tekstowych (kolumn) powiodlo sie. Liczba kolumn: ".concat(String.valueOf(paragraphs.size())));
                log.info("Pobieranie formatowania poszczegolnych kolumn.");
                for (int j = 0; j < paragraphs.size(); ++j) {
                    HashMap<String, Object> paragraphProperties = new HashMap<String, Object>();
                    P pParagraph = (P)paragraphs.get(j);
                    PPr paragraph_pPr = pParagraph.getPPr();
                    paragraphProperties.put("pPr", paragraph_pPr);
                    Tc tc = (Tc)pParagraph.getParent();
                    paragraphProperties.put("tcPr", tc.getTcPr());
                    paragraphsProperties.add(paragraphProperties);
                }
                log.info("Pobieranie formatowania dla poszczegolnych kolumn powiodlo sie.");
                log.info(paragraphsProperties.toString());
            }
            log.info("Pobieranie w\u0142a\u015bciwo\u015bci wiersza z wiersza definiujacego formatowanie.");
            rowProperties.set(row.getTrPr());
            log.info("Pobranie w\u0142a\u015bciwo\u015bci kom\u00f3rki definiuj\u0105cej formatowanie.");
        }
    }

    public static void createTableWithValues(MainDocumentPart mdp, int iTableNr, Tbl table, Map<String, String> mValues, List<Map<String, Object>> lParagraphProperties) {
        int i;
        log.trace("************************* createTableWithValues() ********************");
        log.info("Tworzenie tabeli nr: ".concat(String.valueOf(iTableNr)));
        int iSize = mValues.size();
        log.info("mValues.size() = ".concat(String.valueOf(iSize)));
        int iRowsNr = 0;
        ArrayList<String[]> alColumns = new ArrayList<String[]>();
        log.info("Przygotowanie wartosci tabelarycznych.");
        for (i = 0; i < iSize; ++i) {
            alColumns.add(mValues.get("t" + String.valueOf(iTableNr + 1) + "c" + String.valueOf(i + 1)).split(";", -1));
        }
        log.info("Przygotowanie wartosci tabelarycznych powiodlo sie.");
        log.info(alColumns.toString());
        iRowsNr = ((String[])alColumns.get(0)).length;
        log.info("Uzupe\u0142nianie warto\u015bci tabelarycznych.");
        for (i = 0; i < iRowsNr; ++i) {
            Tr tr = Context.getWmlObjectFactory().createTr();
            table.getEGContentRowContent().add(tr);
            for (int j = 0; j < iSize; ++j) {
                Tc tc = Context.getWmlObjectFactory().createTc();
                tr.getEGContentCellContent().add(tc);
                TcPr tcPr = (TcPr)lParagraphProperties.get(j).get("tcPr");
                tc.setTcPr(tcPr);
                P p = mdp.createParagraphOfText(((String[])alColumns.get(j))[i]);
                try {
                    PPr pPr = null;
                    if (lParagraphProperties.size() > j) {
                        pPr = (PPr)lParagraphProperties.get(j).get("pPr");
                    }
                    p.setPPr(pPr);
                    ObjectFactory factory = Context.getWmlObjectFactory();
                    R r = (R)p.getContent().get(0);
                    Text t = (Text)r.getContent().get(0);
                    log.info(t.getValue());
                    String[] rows = t.getValue().split("\n");
                    int index = 0;
                    p.getContent().remove(r);
                    for (String row : rows) {
                        R run = factory.createR();
                        Text text = factory.createText();
                        text.setValue(row);
                        run.getContent().add(text);
                        p.getContent().add(run);
                        if (pPr != null) {
                            RPr rPr = StyleUtil.apply((ParaRPr)pPr.getRPr(), (RPr)factory.createRPr());
                            run.setRPr(rPr);
                        }
                        if (index < rows.length - 1) {
                            R brRun = factory.createR();
                            brRun.getContent().add(factory.createBr());
                            p.getContent().add(brRun);
                        }
                        ++index;
                    }
                }
                catch (Exception e) {
                    p = mdp.createParagraphOfText(((String[])alColumns.get(j))[i]);
                }
                tc.getEGBlockLevelElts().add(p);
            }
        }
        log.info("Uzupe\u0142nienie warto\u015bci tabelarycznych powiod\u0142o si\u0119.");
    }

    /*
     * Unable to fully structure code
     */
    public static void createTableWithValues(MainDocumentPart mdp, Tbl table, List<String> lValues, List<Map<String, Object>> lParagraphProperties, TrPr rowProperties, ColumnGraphicInfo columnGraphicInfo, WordprocessingMLPackage template, boolean pdf) {
        TableUtils.log.trace("************************* createTableWithValues() ********************");
        for (i = 0; i < lValues.size(); ++i) {
            lValues.set(i, lValues.get(i).replaceAll("@", "Xsuncode-atX"));
        }
        iSize = lValues.size();
        TableUtils.log.info("mValues.size() = ".concat(String.valueOf(iSize)));
        iRowsNr = 0;
        alColumns = new ArrayList<String[]>();
        TableUtils.log.info("Splitowanie wartosci tabelarycznych.");
        for (i = 0; i < iSize; ++i) {
            alColumns.add(lValues.get(i).split(";", -1));
            tmpLength = ((String[])alColumns.get(i)).length;
            if (tmpLength <= iRowsNr) continue;
            iRowsNr = tmpLength;
        }
        TableUtils.log.info("Splitowanie wartosci tabelarycznych powiodlo sie.");
        TableUtils.log.info(alColumns.toString());
        TableUtils.log.info("Uzupe\u0142nianie warto\u015bci tabelarycznych.");
        for (i = 0; i < iRowsNr; ++i) {
            tr = Context.getWmlObjectFactory().createTr();
            if (rowProperties != null) {
                trPr = (TrPr)XmlUtils.deepCopy((Object)rowProperties, (JAXBContext)mdp.getJAXBContext());
                tr.setTrPr(trPr);
            }
            table.getEGContentRowContent().add(tr);
            for (j = 0; j < iSize; ++j) {
                pImages = new ArrayList<P>();
                tc = Context.getWmlObjectFactory().createTc();
                tr.getEGContentCellContent().add(tc);
                tcPr = (TcPr)lParagraphProperties.get(j).get("tcPr");
                tc.setTcPr(tcPr);
                tgc = (TblGridCol)table.getTblGrid().getGridCol().get(j);
                colWidth = tgc.getW().intValue();
                p = null;
                if (i < ((String[])alColumns.get(j)).length) {
                    txt = ((String[])alColumns.get(j))[i];
                    font = "Times New Roman";
                    isBold = false;
                    isItalic = false;
                    size = 12;
                    ppr = null;
                    if (j < lParagraphProperties.size()) {
                        ppr = (PPr)lParagraphProperties.get(j).get("pPr");
                        try {
                            font = ppr.getRPr().getRFonts().getAscii();
                        }
                        catch (Exception e) {
                            TableUtils.log.info("nie mozna wczytac czcionki");
                        }
                        try {
                            isBold = ppr.getRPr().getB().isVal();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            isItalic = ppr.getRPr().getI().isVal();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            TableUtils.log.info(ppr.getRPr().getSz().getVal().toString());
                            size = (int)Math.ceil(ppr.getRPr().getSz().getVal().doubleValue() / 2.0);
                        }
                        catch (Exception e) {
                            TableUtils.log.warn(e.getMessage());
                        }
                        TableUtils.log.info(String.valueOf(colWidth));
                    }
                    newTxt = TableUtils.fitTextToColumn(txt.replaceAll("Xsuncode-atX", "@"), colWidth, font, size, isBold, isItalic).replaceAll("@", "Xsuncode-atX");
                    try {
                        skip = false;
                        if (columnGraphicInfo != null) {
                            if (!columnGraphicInfo.getGraphicColumn().booleanValue()) {
                                p = mdp.createParagraphOfText(newTxt);
                            } else {
                                gPropertie = columnGraphicInfo.getGraphicProperties(j);
                                if (gPropertie == null) {
                                    p = mdp.createParagraphOfText(newTxt);
                                } else {
                                    fileID = -1L;
                                    try {
                                        fileIdsTxt = txt.split(",");
                                        factory = Context.getWmlObjectFactory();
                                        if (fileIdsTxt.length > 0) {
                                            p = factory.createP();
                                            maxImageInRow = gPropertie.getMaxImageInRow() < 1 ? fileIdsTxt.length : gPropertie.getMaxImageInRow();
                                            colWitdh = tgc.getW().intValue() / maxImageInRow;
                                            nrImage = 0;
                                            for (String fileidTxt : fileIdsTxt) {
                                                if (nrImage % maxImageInRow == 0) {
                                                    p = factory.createP();
                                                    pImages.add(p);
                                                }
                                                fileID = Long.parseLong(fileidTxt);
                                                rImage = GraphicUtils.addImageToR(template, colWitdh, gPropertie, fileID);
                                                skip = true;
                                                if (nrImage % maxImageInRow >= 0 && nrImage % maxImageInRow < maxImageInRow - 1 && maxImageInRow > 1 && nrImage < fileIdsTxt.length - 1) {
                                                    if (pdf) {
                                                        rtab = factory.createRTab();
                                                        rtabWrapped = factory.createRTab(rtab);
                                                        rImage.getContent().add(rtabWrapped);
                                                    } else {
                                                        text = factory.createText();
                                                        text.setSpace("preserve");
                                                        text.setValue(" ");
                                                        rImage.getContent().add(text);
                                                    }
                                                }
                                                p.getContent().add(rImage);
                                                ++nrImage;
                                            }
                                        }
                                    }
                                    catch (NumberFormatException nfe) {
                                        TableUtils.log.error(txt + "\t is not FileID", (Throwable)nfe);
                                        p = mdp.createParagraphOfText(newTxt);
                                        skip = false;
                                    }
                                }
                            }
                        }
                        p.setPPr(ppr);
                        if (skip.booleanValue()) ** GOTO lbl153
                        factory = Context.getWmlObjectFactory();
                        r = (R)p.getContent().get(0);
                        t = (Text)r.getContent().get(0);
                        TableUtils.log.info(t.getValue());
                        rows = t.getValue().split("\n");
                        index = 0;
                        p.getContent().remove(r);
                        for (String row : rows) {
                            run = factory.createR();
                            text = factory.createText();
                            text.setValue(row);
                            run.getContent().add(text);
                            p.getContent().add(run);
                            if (ppr != null) {
                                rPr = StyleUtil.apply((ParaRPr)ppr.getRPr(), (RPr)factory.createRPr());
                                run.setRPr(rPr);
                            }
                            if (index < rows.length - 1) {
                                brRun = factory.createR();
                                brRun.getContent().add(factory.createBr());
                                p.getContent().add(brRun);
                            }
                            ++index;
                        }
                    }
                    catch (Exception e) {
                        TableUtils.log.error(e.getMessage(), (Throwable)e);
                        p = mdp.createParagraphOfText(newTxt);
                    }
                } else {
                    p = mdp.createParagraphOfText("");
                }
lbl153:
                // 4 sources

                if (p != null) {
                    if (j < lParagraphProperties.size()) {
                        p.setPPr((PPr)lParagraphProperties.get(j).get("pPr"));
                    }
                    if (pImages.isEmpty()) {
                        tc.getContent().add(p);
                        continue;
                    }
                    spacing = Context.getWmlObjectFactory().createPPrBaseSpacing();
                    spacing.setLineRule(STLineSpacingRule.AT_LEAST);
                    spacing.setBeforeLines(new BigInteger("10"));
                    spacing.setAfterLines(new BigInteger("10"));
                    for (P p1 : pImages) {
                        if (j < lParagraphProperties.size()) {
                            ppr = (PPr)lParagraphProperties.get(j).get("pPr");
                            ppr.setSpacing(spacing);
                            p1.setPPr(ppr);
                        }
                        tc.getContent().add(p1);
                    }
                    continue;
                }
                TableUtils.log.info("B\u0141\u0104D - problem z utworzeniem komorki tekstowej.");
            }
        }
        TableUtils.log.info("Uzupe\u0142nienie warto\u015bci tabelarycznych powiod\u0142o si\u0119.");
    }

    public static void copyTableStylesToRPr(WordprocessingMLPackage template) {
        List<Tbl> tables;
        log.info("************************* copyTableStylesToRPr() ********************");
        MainDocumentPart documentBody = template.getMainDocumentPart();
        StyleDefinitionsPart styles = documentBody.getStyleDefinitionsPart();
        try {
            log.info("Pobieranie tabel.");
            tables = TableUtils.getTables(documentBody.getJAXBNodesViaXPath("//w:tbl", false));
            log.info("Prawid\u0142owo pobrano tabele.");
        }
        catch (JAXBException | XPathBinderAssociationIsPartialException e) {
            log.info("Nie uda\u0142o si\u0119 pobra\u0107 tabel z dokumentu.");
            return;
        }
        for (Tbl table : tables) {
            Tr row;
            int rowIndex;
            TableStyle tableStyle = new TableStyle();
            try {
                log.info("Pobieranie TblPr i TblStyle.");
                TblPr tablePr = table.getTblPr();
                CTTblPrBase.TblStyle tblStyle = tablePr.getTblStyle();
                log.info("Pobieranie stylu tabeli.");
                String tblStyleName = tblStyle.getVal();
                log.info("tblStyleName = {}", (Object)tblStyleName);
                CTTblLook tableLook = tablePr.getTblLook();
                log.info("Pobieranie po\u0142o\u017ce\u0144 styl\u00f3w.");
                tableStyle.setFirstColumnMarked(tableLook.getFirstColumn() == STOnOff.ONE);
                tableStyle.setLastColumnMarked(tableLook.getLastColumn() == STOnOff.ONE);
                tableStyle.setFirstRowMarked(tableLook.getFirstRow() == STOnOff.ONE);
                tableStyle.setLastRowMarked(tableLook.getLastRow() == STOnOff.ONE);
                log.info("tableStyle = {}", (Object)tableStyle);
                boolean shouldContinue = tableStyle.isAnyStyleMarked();
                log.info("Czy s\u0105 jakie\u015b style do przeniesienia? {}", (Object)(shouldContinue ? "tak, kontynuowanie." : "nie, pomijanie tabeli."));
                if (!shouldContinue) continue;
                log.info("Pobieranie styl\u00f3w z tblStylePr");
                for (CTTblStylePr tblStylePr : styles.getStyleById(tblStyleName).getTblStylePr()) {
                    tableStyle.applyRPrStyleByType(tblStylePr);
                }
                log.info("Pobrano style z tblStylePr");
            }
            catch (NullPointerException e) {
                log.info("Brak styli w tabeli (lub b\u0142\u0105d przy odczycie styli), pomijanie tabeli.");
                continue;
            }
            log.info("Kopiowanie styli tabeli bezpo\u015brednio do RPr.");
            List rows = table.getContent();
            int rowsLength = rows.size();
            int firstRowIndex = -1;
            int lastRowIndex = -1;
            for (rowIndex = 0; rowIndex < rowsLength; ++rowIndex) {
                row = TableUtils.getRow(rows, rowIndex);
                if (row == null) continue;
                if (firstRowIndex == -1) {
                    firstRowIndex = rowIndex;
                }
                lastRowIndex = rowIndex;
            }
            for (rowIndex = 0; rowIndex < rowsLength; ++rowIndex) {
                Tc cell;
                int cellIndex;
                row = TableUtils.getRow(rows, rowIndex);
                if (row == null) continue;
                List cells = row.getContent();
                int cellsLength = cells.size();
                int firstColumnIndex = -1;
                int lastColumnIndex = -1;
                for (cellIndex = 0; cellIndex < cellsLength; ++cellIndex) {
                    cell = TableUtils.getCell(cells, cellIndex);
                    if (cell == null) continue;
                    firstColumnIndex = firstColumnIndex == -1 ? cellIndex : firstColumnIndex;
                    lastColumnIndex = cellIndex;
                }
                for (cellIndex = 0; cellIndex < cellsLength; ++cellIndex) {
                    cell = TableUtils.getCell(cells, cellIndex);
                    if (cell == null) continue;
                    List cellContent = cell.getContent();
                    for (Object cellContentObj : cellContent) {
                        RPr rPrToApply;
                        if (!(cellContentObj instanceof P)) continue;
                        P p = (P)cellContentObj;
                        if (tableStyle.isFirstRowMarked() && rowIndex == firstRowIndex) {
                            rPrToApply = tableStyle.getFirstRowRPr();
                        } else if (tableStyle.isLastRowMarked() && rowIndex == lastRowIndex) {
                            rPrToApply = tableStyle.getLastRowRPr();
                        } else if (tableStyle.isFirstColumnMarked() && cellIndex == firstColumnIndex) {
                            rPrToApply = tableStyle.getFirstColumnRPr();
                        } else {
                            if (!tableStyle.isLastColumnMarked() || cellIndex != lastColumnIndex) continue;
                            rPrToApply = tableStyle.getLastColumnRPr();
                        }
                        List pContent = p.getContent();
                        for (Object rObj : pContent) {
                            if (!(rObj instanceof R)) continue;
                            R r = (R)rObj;
                            r.setRPr(StyleUtil.apply((RPr)rPrToApply, (RPr)r.getRPr()));
                        }
                    }
                }
            }
            log.info("Kopiowanie styli tabeli do RPr zako\u0144czone powodzeniem.");
        }
    }
}

