/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.database.sql;

import com.plusmpm.CUF.database.sql.CufNativeSql;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PostgresNativeSQL
implements CufNativeSql {
    @Override
    public List<String> getCreateSynchronizedTableQuery(String tableName, String[] columnNames, String[] columnTypes) {
        return Arrays.asList(this.sequenceQuery(tableName), this.createQuery(tableName, columnNames, columnTypes));
    }

    private String sequenceQuery(String tableName) {
        StringBuilder sequenceCreateQuery = new StringBuilder("CREATE SEQUENCE ");
        sequenceCreateQuery.append(tableName);
        sequenceCreateQuery.append("_id_seq");
        return sequenceCreateQuery.toString();
    }

    private String createQuery(String tableName, String[] columnNames, String[] columnTypes) {
        StringBuilder tableCreateQuery = new StringBuilder();
        tableCreateQuery.append("CREATE TABLE ");
        tableCreateQuery.append(tableName);
        tableCreateQuery.append(" (id int8 DEFAULT nextval('");
        tableCreateQuery.append(tableName);
        tableCreateQuery.append("_id_seq') PRIMARY KEY");
        for (int i = 0; i < columnNames.length; ++i) {
            tableCreateQuery.append(", ");
            tableCreateQuery.append(columnNames[i]);
            tableCreateQuery.append(" ");
            tableCreateQuery.append(this.getColumnTypeAsString(columnTypes[i]));
        }
        tableCreateQuery.append(", criteria varchar(1024), dateofrecordcheck timestamp, connectionname varchar(1024))");
        return tableCreateQuery.toString();
    }

    @Override
    public String getColumnTypeAsString(String columnType) {
        if (columnType.compareToIgnoreCase("integer") == 0 || columnType.compareToIgnoreCase("int8") == 0) {
            return "int8";
        }
        if (columnType.compareToIgnoreCase("float") == 0 || columnType.compareToIgnoreCase("float8") == 0) {
            return "float8";
        }
        if (columnType.compareToIgnoreCase("double") == 0 || columnType.compareToIgnoreCase("double8") == 0) {
            return "double8";
        }
        if (columnType.compareToIgnoreCase("timestamp") == 0) {
            return "timestamp";
        }
        return "varchar(1024)";
    }

    @Override
    public List<String> getCreateColumnQuery(String tableName, String columnName, String columnType) {
        ArrayList<String> queries = new ArrayList<String>();
        String createColumnQuery = "ALTER TABLE " + tableName + " ADD COLUMN " + columnName + " " + this.getColumnTypeAsString(columnType);
        queries.add(createColumnQuery);
        if (columnType.compareToIgnoreCase("varchar") == 0) {
            String setDefaultColumnQuery = "ALTER TABLE " + tableName + " ALTER COLUMN " + columnName + " SET DEFAULT ''";
            queries.add(setDefaultColumnQuery);
            String updateQuery = "UPDATE " + tableName + " SET " + columnName + " = '' WHERE " + columnName + " IS NULL";
            queries.add(updateQuery);
        }
        return queries;
    }

    @Override
    public void setStatementParameter(PreparedStatement statement, String columnType, String value, int position) throws NumberFormatException, SQLException {
        if (columnType.compareToIgnoreCase("integer") == 0 || columnType.compareToIgnoreCase("int8") == 0) {
            statement.setInt(position, Integer.valueOf(value));
        } else if (columnType.compareToIgnoreCase("float") == 0 || columnType.compareToIgnoreCase("float8") == 0) {
            statement.setFloat(position, Float.valueOf(value).floatValue());
        } else if (columnType.compareToIgnoreCase("double") == 0 || columnType.compareToIgnoreCase("double8") == 0) {
            statement.setDouble(position, Double.valueOf(value));
        } else if (columnType.compareToIgnoreCase("timestamp") == 0) {
            statement.setTimestamp(position, Timestamp.valueOf(value));
        } else {
            statement.setString(position, value);
        }
    }

    @Override
    public List<String> getClearTableQueries(String sTableName) {
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder clearTableQuery = new StringBuilder();
        clearTableQuery.append("DELETE FROM ");
        clearTableQuery.append(sTableName);
        queries.add(clearTableQuery.toString());
        StringBuilder restartSequenceQuery = new StringBuilder();
        restartSequenceQuery.append("ALTER SEQUENCE ");
        restartSequenceQuery.append(sTableName);
        restartSequenceQuery.append("_id_seq");
        restartSequenceQuery.append(" RESTART");
        queries.add(restartSequenceQuery.toString());
        return queries;
    }

    @Override
    public List<String> getDropTableQueries(String tableName) {
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder deleteTableQuery = new StringBuilder();
        deleteTableQuery.append("DROP TABLE ");
        deleteTableQuery.append(tableName);
        queries.add(deleteTableQuery.toString());
        StringBuilder deleteSeqQuery = new StringBuilder();
        deleteSeqQuery.append("DROP SEQUENCE ");
        deleteSeqQuery.append(tableName);
        deleteSeqQuery.append("_id_seq");
        queries.add(deleteSeqQuery.toString());
        return queries;
    }
}

