/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.io.office.model.writer;

import com.suncode.cuf.io.office.model.writer.ResolvableValueWriter;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Workbook;

public class DateValueWriter
implements ResolvableValueWriter {
    private final String DATE_FORMAT = "yyyy-MM-dd";

    @Override
    public void setCellType(Cell cell, Workbook workbook, CreationHelper helper) {
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setDataFormat(helper.createDataFormat().getFormat("yyyy-MM-dd"));
        cell.setCellStyle(cellStyle);
    }

    @Override
    public void setCellValue(Cell cell, Object value) {
        if (!StringUtils.isEmpty((String)value.toString())) {
            Date d = (Date)value;
            cell.setCellValue(d);
        }
    }

    @Override
    public boolean isValidValue(Object value) {
        return true;
    }

    @Override
    public boolean canResolveValue(Class<?> type) {
        return type.equals(Date.class);
    }

    @Override
    public int getPriority() {
        return 10;
    }
}

