/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.hibernate;

import com.suncode.cuf.database.config.DatabaseConfig;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class SessionFactoryBuilder {
    private static final String DATASOURCE_PREFIX = "java:/comp/env/";

    public static SessionFactory buildSessionFactory(DatabaseConfig config) {
        Configuration cfg = new Configuration();
        if (config.hasConnectionDatasource()) {
            cfg.setProperty("hibernate.connection.datasource", DATASOURCE_PREFIX + config.getConnectionDatasource());
        } else {
            SessionFactoryBuilder.checkConfigParams(config);
            cfg.setProperty("hibernate.connection.driver_class", config.getDriverClassName());
            cfg.setProperty("hibernate.connection.url", config.getUrl());
            cfg.setProperty("hibernate.connection.username", config.getUserName());
            cfg.setProperty("hibernate.connection.password", config.getPassword());
        }
        SessionFactoryBuilder.checkDialect(config);
        cfg.setProperty("hibernate.dialect", config.getDialectClassName());
        cfg.setProperty("hibernate.hbm2ddl.auto", "validate");
        cfg.setProperty("hibernate.current_session_context_class", "thread");
        return cfg.buildSessionFactory();
    }

    private static void checkDialect(DatabaseConfig config) {
        if (StringUtils.isBlank((String)config.getDriverClassName())) {
            throw new IllegalArgumentException("Nie podano klasy dialect'u");
        }
    }

    private static void checkConfigParams(DatabaseConfig config) {
        if (StringUtils.isBlank((String)config.getDriverClassName())) {
            throw new IllegalArgumentException("Nie podano klasy sterownika");
        }
        if (StringUtils.isBlank((String)config.getUrl())) {
            throw new IllegalArgumentException("Nie podano URL");
        }
        if (StringUtils.isBlank((String)config.getUserName())) {
            throw new IllegalArgumentException("Nie podano nazwy u\u017cytkownika");
        }
        if (StringUtils.isBlank((String)config.getPassword())) {
            throw new IllegalArgumentException("Nie podano has\u0142a");
        }
    }
}

