/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.automatictask.mail.receivers;

import com.suncode.cuf.automatictask.mail.ReceiverTypes;
import com.suncode.cuf.automatictask.mail.SendMailSender;
import com.suncode.cuf.automatictask.mail.receivers.Receiver;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import org.springframework.stereotype.Component;

@Component
public class UsersInVariableReceiver
implements Receiver {
    private String variableId;

    @Override
    public ReceiverTypes getType() {
        return ReceiverTypes.VAR_USER;
    }

    @Override
    public void send(String receiverId, String subject, String content, List<WfDocument> attachments, List<String> excludedEmails, String processId) throws MessagingException {
        String[] receivers;
        this.variableId = receiverId;
        ProcessService processService = ServiceFactory.getProcessService();
        UserService userService = ServiceFactory.getUserService();
        Map processContext = processService.getProcessContext(processId);
        for (String sUserName : receivers = processContext.get(this.variableId).toString().split(";")) {
            User user = userService.getUser(sUserName, new String[0]);
            if (excludedEmails.contains(user.getEmail())) continue;
            SendMailSender.getInstance().send(user.getEmail(), subject, content, attachments);
            excludedEmails.add(user.getEmail());
        }
    }
}

