/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.plusmpm.CUF.database.storage.DynamicTableStorage;
import com.plusmpm.CUF.database.storage.DynamicTableStorageManager;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.util.Tools;
import com.plusmpm.util.json.extjs.gson.GsonCustomUtils;
import com.plusmpm.util.json.extjs.objects.JsonStore;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DynamicTableStorageSave
extends HttpServlet {
    public static Logger log = Logger.getLogger(DynamicTableStorageSave.class);
    private static final long serialVersionUID = 1L;

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)"************************* DynamicTableStorageSave Servlet ****************************");
        PrintWriter printWriter = null;
        JsonStore jsonStore = null;
        GsonCustomUtils gsonCustomUtils = null;
        boolean bSuccess = false;
        String answerMessage = "";
        DynamicTableStorage storage = null;
        HashMap<Integer, String> headers = null;
        int recordCounter = 0;
        try {
            List<DynamicTableStorage> defaultStorage;
            String storageName = request.getParameter("storageName");
            String username = request.getParameter("username");
            String tabTitle = request.getParameter("tabTitle");
            String content = request.getParameter("content");
            String colIds = request.getParameter("colIds");
            String[] colIdsTab = null;
            String setAsDefault = request.getParameter("setAsDefault");
            boolean bSetAsDefault = false;
            if (Tools.isNullOrEmpty((String)storageName)) {
                throw new CUFException("Nie podano nazwy zestawu danych.");
            }
            if (Tools.isNullOrEmpty((String)username)) {
                throw new CUFException("Nie zidentyfikowano w\u0142a\u015bciciela zestawu. Nie mo\u017cna zapisa\u0107 zestawu danych.");
            }
            if (Tools.isNullOrEmpty((String)tabTitle)) {
                throw new CUFException("Tabela nie posiada tytu\u0142u. Nie mo\u017cna zapisa\u0107 zestawu danych.");
            }
            if (Tools.isNullOrEmpty((String)colIds)) {
                throw new CUFException("Nie podano identyfikator\u00f3w kolumn tabeli dynamicznej.");
            }
            if (Tools.isNullOrEmpty((String)content)) {
                throw new CUFException("Nie podano zawarto\u015bci tabeli dynamicznej.");
            }
            if (DynamicTableStorageManager.exists(storageName, username, tabTitle)) {
                throw new CUFException("Tw\u00f3j zestaw danych o nazwie " + storageName + " dla tabeli " + tabTitle + " ju\u017c istnieje.");
            }
            if (!Tools.isNullOrEmpty((String)setAsDefault)) {
                bSetAsDefault = Boolean.parseBoolean(setAsDefault);
            }
            headers = new HashMap<Integer, String>();
            colIdsTab = colIds.split(";");
            String[] rows = content.split("<row>");
            if (rows.length == 1) {
                throw new CUFException("Nie podano zawarto\u015bci tabeli dynamicznej.");
            }
            if (bSetAsDefault && (defaultStorage = DynamicTableStorageManager.getDefaultDynamicTableStorageForUser(username, tabTitle)) != null && defaultStorage.size() > 0) {
                log.info((Object)"Zmiana wpisu domyslnego");
                for (DynamicTableStorage oneData : defaultStorage) {
                    oneData.setDefaultStorage("false");
                    DynamicTableStorageManager.update(oneData);
                }
            }
            for (int i = 0; i < rows.length; ++i) {
                String[] colsRec = rows[i].split("<col>");
                for (int j = 0; j < colsRec.length; ++j) {
                    if (i == 0) {
                        headers.put(j, colsRec[j]);
                        continue;
                    }
                    if (colIdsTab.length != headers.size()) {
                        throw new CUFException("Niepoprawnie odczytano tabel\u0119 dynamiczn\u0105.");
                    }
                    storage = new DynamicTableStorage();
                    storage.setStorageName(storageName);
                    storage.setUsername(username);
                    storage.setTabTitle(tabTitle);
                    storage.setColumnId(colIdsTab[j]);
                    storage.setColumnName((String)headers.get(j));
                    storage.setRowNumber(i);
                    storage.setCellValue(colsRec[j]);
                    if (bSetAsDefault) {
                        storage.setDefaultStorage("true");
                    }
                    DynamicTableStorageManager.save(storage);
                    ++recordCounter;
                }
            }
            bSuccess = true;
            answerMessage = "Zapis zestawu danych o nazwie " + storageName + " zako\u0144czony powodzeniem.";
            log.info((Object)("Zapisano " + recordCounter + " wierszy tabeli dynamnicznej pod identyfikatorem " + storageName));
        }
        catch (CUFException e) {
            bSuccess = false;
            answerMessage = e.getMessage();
            log.warn((Object)answerMessage);
        }
        catch (Exception e) {
            bSuccess = false;
            answerMessage = "B\u0142\u0105d zapisu zestawu danych.";
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                jsonStore = new JsonStore();
                jsonStore.setSuccess(Boolean.valueOf(bSuccess));
                jsonStore.setMessage(answerMessage);
                gsonCustomUtils = new GsonCustomUtils();
                String sJsonData = gsonCustomUtils.getJsonForExtJsonStore(jsonStore);
                response.setContentType("application/json;charset=UTF-8");
                printWriter = response.getWriter();
                printWriter.print(sJsonData);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }
}

