/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.plusmpm.CUF.database.storage.DynamicTableStorage;
import com.plusmpm.CUF.database.storage.DynamicTableStorageManager;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.util.Tools;
import com.plusmpm.util.json.extjs.gson.GsonCustomUtils;
import com.plusmpm.util.json.extjs.objects.JsonStore;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DynamicTableStorageLoad
extends HttpServlet {
    public static Logger log = Logger.getLogger(DynamicTableStorageLoad.class);
    private static final long serialVersionUID = 1L;

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)"************************* DynamicTableStorageLoad Servlet ****************************");
        PrintWriter printWriter = null;
        JsonStore jsonStore = null;
        GsonCustomUtils gsonCustomUtils = null;
        boolean bSuccess = false;
        String answerMessage = "";
        ArrayList content = null;
        ArrayList records = null;
        String respText = "";
        try {
            content = new ArrayList();
            records = new ArrayList();
            String storageName = request.getParameter("storageName");
            String owner = request.getParameter("owner");
            String tabTitle = request.getParameter("tabTitle");
            String colIds = request.getParameter("colIds");
            String[] keys = null;
            if (Tools.isNullOrEmpty((String)storageName)) {
                throw new CUFException("Brak zestawu danych o nazwie " + storageName + ".");
            }
            if (Tools.isNullOrEmpty((String)owner)) {
                throw new CUFException("Nie zidentyfikowano w\u0142a\u015bciciela zestawu. Nie mozna pobrac zestawu danych o nazwie " + storageName + ".");
            }
            if (Tools.isNullOrEmpty((String)tabTitle)) {
                throw new CUFException("Tabela nie posiada tytu\u0142u. Nie mozna pobrac zestawu danych o nazwie " + storageName + ".");
            }
            if (Tools.isNullOrEmpty((String)colIds)) {
                throw new CUFException("Nie podano identyfikatorow kolumn dla zestawu danych o nazwie " + storageName + ".");
            }
            keys = colIds.split(";");
            int noOfRecords = DynamicTableStorageManager.getDynamicTableStorageNoOfRecords(storageName, owner, tabTitle);
            if (noOfRecords == 0) {
                throw new CUFException("Zestaw danych o nazwie " + storageName + " nie posiada rekord\u00f3w.");
            }
            log.info((Object)("Rozpoznano zestaw danych o nazwie " + storageName + ". Pobieranie rekordow"));
            for (int row = 1; row <= noOfRecords; ++row) {
                List<DynamicTableStorage> record = DynamicTableStorageManager.getDynamicTableStorageRecord(storageName, owner, tabTitle, row);
                if (record == null || record.size() == 0) {
                    throw new Exception();
                }
                HashMap<String, String> oneMap = new HashMap<String, String>();
                for (DynamicTableStorage oneData : record) {
                    oneMap.put(oneData.getColumnId(), oneData.getCellValue());
                }
                content.add(oneMap);
            }
            for (int i = 0; i < content.size(); ++i) {
                if (i != 0) {
                    respText = respText.concat("@row@");
                }
                Map oneResult = (Map)content.get(i);
                for (int j = 0; j < keys.length; ++j) {
                    String cellValue = (String)oneResult.get(keys[j]);
                    if (cellValue == null) {
                        cellValue = "";
                    }
                    respText = respText.concat(cellValue);
                    if (j >= keys.length - 1) continue;
                    respText = respText.concat("@col@");
                }
            }
            HashMap<String, String> answer = new HashMap<String, String>();
            answer.put("content", respText);
            records.add(answer);
            bSuccess = true;
            answerMessage = "Przygotowano zestaw danych o nazwie " + storageName + " do zaladowania do tabeli dynamicznej " + tabTitle;
            log.info((Object)("Przygotowano zestaw danych o nazwie " + storageName + " do zaladowania do tabeli dynamicznej " + tabTitle));
        }
        catch (CUFException e) {
            bSuccess = false;
            answerMessage = e.getMessage();
            log.warn((Object)answerMessage);
        }
        catch (Exception e) {
            bSuccess = false;
            answerMessage = "B\u0142\u0105d podczas pobierania zestawu danych.";
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                jsonStore = new JsonStore();
                jsonStore.setSuccess(Boolean.valueOf(bSuccess));
                jsonStore.setMessage(answerMessage);
                jsonStore.setRecords(records);
                gsonCustomUtils = new GsonCustomUtils();
                String sJsonData = gsonCustomUtils.getJsonForExtJsonStore(jsonStore);
                response.setContentType("application/json;charset=UTF-8");
                printWriter = response.getWriter();
                printWriter.print(sJsonData);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }
}

