/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension.right;

import com.plusmpm.CUF.util.extension.right.RightService;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;

public class RightServiceImpl
implements RightService {
    private static Map<String, String> levels;

    @Override
    public void addRight(String resourceId, boolean isGroup, String module) {
        this.validate(resourceId, isGroup, module);
        Authorization.addRight((String)module, (String)resourceId, (boolean)isGroup);
    }

    public void validate(String resourceId, boolean isGroup, String module) {
        if (StringUtils.isBlank((String)resourceId)) {
            throw new IllegalArgumentException("Nie podano resourceId");
        }
        if (StringUtils.isBlank((String)module)) {
            throw new IllegalArgumentException("Nie podano module");
        }
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        if (isGroup) {
            try {
                uga.doesGroupExist(resourceId);
            }
            catch (BaseException e) {
                throw new IllegalArgumentException("Grupa: " + resourceId + " nie istnieje ", e);
            }
        }
        try {
            uga.doesUserExist(resourceId);
        }
        catch (BaseException e) {
            throw new IllegalArgumentException("U\u017cytkownik: " + resourceId + " nie istnieje ", e);
        }
    }

    @Override
    public Map<String, String> getLevelNames() {
        if (levels == null) {
            levels = new HashMap<String, String>();
            levels.put("System", RightTreeBuilder.builder().system().build());
            levels.put("Administracja", RightTreeBuilder.builder().system().admin().build());
            levels.put("Archiwum", RightTreeBuilder.builder().system().archive().build());
            levels.put("Klasy dokument\u00f3w", RightTreeBuilder.builder().system().archive().docClasses().build());
            levels.put("Zestawy dokument\u00f3w", RightTreeBuilder.builder().system().archive().links().build());
            levels.put("Obieg dokument\u00f3w", RightTreeBuilder.builder().system().workflow().build());
            levels.put("Tworzenie proces\u00f3w", RightTreeBuilder.builder().system().workflow().processes().create().build());
            levels.put("Kalendarz", RightTreeBuilder.builder().system().workflow().calendar().build());
            levels.put("Wyszukiwanie proces\u00f3w", RightTreeBuilder.builder().system().processes().view().build());
            levels.put("Statystyki proces\u00f3w", RightTreeBuilder.builder().system().processes().stats().build());
            levels.put("Raporty", RightTreeBuilder.builder().system().reports().build());
            levels.put("Konto u\u017cytkownika", RightTreeBuilder.builder().system().userAccount().build());
            levels.put("Modu\u0142y", RightTreeBuilder.builder().system().plugins().build());
        }
        return levels;
    }
}

