/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.IndexTable;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.pwfl.archive.Link;
import com.suncode.pwfl.archive.LinkConnection;
import com.suncode.pwfl.archive.LinkIndex;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.util.SpringContext;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Set;
import jxl.CellView;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.log4j.Logger;

public class ExportLinks
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ExportLinks.class);

    @AdvancedTask(name="ExportLinksToXLS", description="ExportLinksToXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ExportLinksToXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************************ ExportLinksToXLS(sXLSPath=" + sXLSPath + ") *************************"));
        long startTime = new Date().getTime();
        File xls = new File(sXLSPath);
        WorkbookSettings wbs = new WorkbookSettings();
        WritableWorkbook workbook = null;
        WritableFont times12font = null;
        WritableCellFormat times12format = null;
        CellView cellView = null;
        int columnPos = 0;
        int rowPos = 1;
        LinkService linkService = (LinkService)SpringContext.getBean(LinkService.class);
        DBManagement dbm = new DBManagement();
        List allDocLinksList = null;
        List indexesForDocLinkList = null;
        List connectionsForDocLinkList = null;
        try {
            int i;
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            wbs.setEncoding("ISO-8859-2");
            workbook = Workbook.createWorkbook((File)xls, (WorkbookSettings)wbs);
            WritableSheet docLinksSheet = workbook.createSheet("Zestawy dokument\u00f3w", 0);
            log.info((Object)"Utworzono arkusz do eksportu zestaw\u00f3w dokument\u00f3w");
            String[] colIDsLink = new String[]{"Nazwa zestawu", "Opis zestawu"};
            String[] colIDsIndex = new String[]{"Nazwa indeksu", "Opis indeksu", "Typ indeksu", "Warto\u015bci"};
            String[] colIDsDocClass = new String[]{"Klasa dokument\u00f3w", "Indeks z zestawu", "Powi\u0105zanie"};
            String[] colIDsProtection = new String[]{"Nazwa u\u017cytkownika/grupy", "Grupa", "Poziom uprawnienia"};
            times12font = new WritableFont(WritableFont.TIMES, 12);
            times12font.setBoldStyle(WritableFont.BOLD);
            times12font.setColour(Colour.BLACK);
            cellView = new CellView();
            cellView.setAutosize(true);
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.AQUA);
            for (i = 0; i < colIDsLink.length; ++i) {
                CUFTools.addCellToXLSSheet(docLinksSheet, columnPos, 0, colIDsLink[i], times12format, cellView);
                ++columnPos;
            }
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.YELLOW);
            for (i = 0; i < colIDsIndex.length; ++i) {
                CUFTools.addCellToXLSSheet(docLinksSheet, columnPos, 0, colIDsIndex[i], times12format, cellView);
                ++columnPos;
            }
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.ORANGE);
            for (i = 0; i < colIDsDocClass.length; ++i) {
                CUFTools.addCellToXLSSheet(docLinksSheet, columnPos, 0, colIDsDocClass[i], times12format, cellView);
                ++columnPos;
            }
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.LIGHT_GREEN);
            for (i = 0; i < colIDsProtection.length; ++i) {
                CUFTools.addCellToXLSSheet(docLinksSheet, columnPos, 0, colIDsProtection[i], times12format, cellView);
                ++columnPos;
            }
            log.info((Object)"Utworzono naglowki w arkuszu");
            log.info((Object)"Pobieranie zestawow dokumentow");
            allDocLinksList = linkService.getAll(new String[0]);
            if (allDocLinksList != null && allDocLinksList.size() > 0) {
                for (Link oneLink : allDocLinksList) {
                    columnPos = 0;
                    if (oneLink == null) continue;
                    Long linkId = oneLink.getId();
                    String linkName = oneLink.getName();
                    String linkDescr = oneLink.getDescription();
                    log.info((Object)("Eksportowanie danych o zestawie dokumentow " + linkName));
                    CUFTools.addCellToXLSSheet(docLinksSheet, columnPos, rowPos, linkName, null, cellView);
                    CUFTools.addCellToXLSSheet(docLinksSheet, ++columnPos, rowPos, linkDescr, null, cellView);
                    ++columnPos;
                    log.info((Object)("Pobieranie indeksow dla zestawu dokumentow " + linkName));
                    indexesForDocLinkList = linkService.getLinkIndicesForLink(linkId);
                    if (indexesForDocLinkList.size() > 0) {
                        for (LinkIndex linkIndex : indexesForDocLinkList) {
                            if (linkIndex == null) continue;
                            ++rowPos;
                            columnPos = 2;
                            String indexName = linkIndex.getName();
                            String indexDescr = linkIndex.getDescription();
                            String indexType = linkIndex.getType();
                            String indexDefaultValues = linkIndex.getValues();
                            log.info((Object)("Eksportowanie danych o indeksie " + indexName));
                            CUFTools.addCellToXLSSheet(docLinksSheet, columnPos, rowPos, indexName, null, cellView);
                            CUFTools.addCellToXLSSheet(docLinksSheet, ++columnPos, rowPos, indexDescr, null, cellView);
                            CUFTools.addCellToXLSSheet(docLinksSheet, ++columnPos, rowPos, indexType, null, cellView);
                            CUFTools.addCellToXLSSheet(docLinksSheet, ++columnPos, rowPos, indexDefaultValues, null, cellView);
                            ++columnPos;
                        }
                    } else {
                        log.info((Object)("Brak indeksow dla zestawu dokumentow " + linkName));
                    }
                    log.info((Object)("Pobieranie powiazan dla zestawu dokumentow " + linkName));
                    connectionsForDocLinkList = linkService.getLinkConnectionsForLink(linkId, new String[]{"linkIndex", "documentClass", "documentClassIndex"});
                    if (connectionsForDocLinkList != null && connectionsForDocLinkList.size() > 0) {
                        for (LinkConnection oneLinkConnection : connectionsForDocLinkList) {
                            if (oneLinkConnection == null) continue;
                            ++rowPos;
                            columnPos = 6;
                            Long docClassId = oneLinkConnection.getDocumentClass().getId();
                            String docClassName = "";
                            Long linkIndexId = oneLinkConnection.getLinkIndex().getId();
                            String linkIndexName = "";
                            Long docClassIndexId = oneLinkConnection.getDocumentClassIndex().getId();
                            String docClassIndexName = "";
                            log.info((Object)("Eksportowanie danych o powiazaniu indeksow dla zestawu dokumentow " + linkName));
                            if (docClassId != null) {
                                DocClassTable docClassTable = DBManagement.getDocClass((String)docClassId.toString());
                                if (docClassTable != null) {
                                    docClassName = docClassTable.getDocClassName();
                                }
                            }
                            CUFTools.addCellToXLSSheet(docLinksSheet, columnPos, rowPos, docClassName, null, cellView);
                            ++columnPos;
                            if (linkIndexId == null || docClassIndexId == null) continue;
                            LinkIndex linkIndex = linkService.getLinkIndex(linkIndexId, new String[0]);
                            IndexTable docClassIndexTable = DBManagement.getIndex((String)docClassIndexId.toString());
                            if (linkIndex == null || docClassIndexTable == null) continue;
                            linkIndexName = linkIndex.getName();
                            docClassIndexName = docClassIndexTable.getIndexName();
                            CUFTools.addCellToXLSSheet(docLinksSheet, columnPos, rowPos, linkIndexName, null, cellView);
                            CUFTools.addCellToXLSSheet(docLinksSheet, ++columnPos, rowPos, docClassIndexName, null, cellView);
                            ++columnPos;
                        }
                    } else {
                        log.info((Object)("Brak powiazan dla zestawu dokumentow " + linkName));
                    }
                    log.info((Object)("Pobieranie praw dla zestawu dokumentow " + linkName));
                    Set resourceIdsForRight = null;
                    boolean bIsGroup = false;
                    resourceIdsForRight = Authorization.listRights((String)RightTreeBuilder.builder().system().archive().links().custom((Object)linkId).delete().build(), (boolean)bIsGroup);
                    if (resourceIdsForRight != null && resourceIdsForRight.size() > 0) {
                        for (String recourceId : resourceIdsForRight) {
                            if (recourceId.equalsIgnoreCase("admin")) continue;
                            columnPos = 9;
                            CUFTools.addCellToXLSSheet(docLinksSheet, columnPos, ++rowPos, recourceId, null, cellView);
                            CUFTools.addCellToXLSSheet(docLinksSheet, ++columnPos, rowPos, String.valueOf(bIsGroup), null, cellView);
                            CUFTools.addCellToXLSSheet(docLinksSheet, ++columnPos, rowPos, "Usuwanie", null, cellView);
                            ++columnPos;
                        }
                    }
                    if ((resourceIdsForRight = Authorization.listRights((String)RightTreeBuilder.builder().system().archive().links().custom((Object)linkId).modify().build(), (boolean)bIsGroup)) != null && resourceIdsForRight.size() > 0) {
                        for (String recourceId : resourceIdsForRight) {
                            if (recourceId.equalsIgnoreCase("admin")) continue;
                            columnPos = 9;
                            CUFTools.addCellToXLSSheet(docLinksSheet, columnPos, ++rowPos, recourceId, null, cellView);
                            CUFTools.addCellToXLSSheet(docLinksSheet, ++columnPos, rowPos, String.valueOf(bIsGroup), null, cellView);
                            CUFTools.addCellToXLSSheet(docLinksSheet, ++columnPos, rowPos, "Modyfikacja", null, cellView);
                            ++columnPos;
                        }
                    }
                    if ((resourceIdsForRight = Authorization.listRights((String)RightTreeBuilder.builder().system().archive().links().custom((Object)linkId).read().build(), (boolean)bIsGroup)) != null && resourceIdsForRight.size() > 0) {
                        for (String recourceId : resourceIdsForRight) {
                            if (recourceId.equalsIgnoreCase("admin")) continue;
                            columnPos = 9;
                            CUFTools.addCellToXLSSheet(docLinksSheet, columnPos, ++rowPos, recourceId, null, cellView);
                            CUFTools.addCellToXLSSheet(docLinksSheet, ++columnPos, rowPos, String.valueOf(bIsGroup), null, cellView);
                            CUFTools.addCellToXLSSheet(docLinksSheet, ++columnPos, rowPos, "Odczyt", null, cellView);
                            ++columnPos;
                        }
                    }
                    bIsGroup = true;
                    resourceIdsForRight = Authorization.listRights((String)RightTreeBuilder.builder().system().archive().links().custom((Object)linkId).delete().build(), (boolean)bIsGroup);
                    if (resourceIdsForRight != null && resourceIdsForRight.size() > 0) {
                        for (String recourceId : resourceIdsForRight) {
                            if (recourceId.equalsIgnoreCase("SharkGroup") || recourceId.equalsIgnoreCase("Administrators")) continue;
                            columnPos = 9;
                            CUFTools.addCellToXLSSheet(docLinksSheet, columnPos, ++rowPos, recourceId, null, cellView);
                            CUFTools.addCellToXLSSheet(docLinksSheet, ++columnPos, rowPos, String.valueOf(bIsGroup), null, cellView);
                            CUFTools.addCellToXLSSheet(docLinksSheet, ++columnPos, rowPos, "Usuwanie", null, cellView);
                            ++columnPos;
                        }
                    }
                    if ((resourceIdsForRight = Authorization.listRights((String)RightTreeBuilder.builder().system().archive().links().custom((Object)linkId).modify().build(), (boolean)bIsGroup)) != null && resourceIdsForRight.size() > 0) {
                        for (String recourceId : resourceIdsForRight) {
                            if (recourceId.equalsIgnoreCase("SharkGroup") || recourceId.equalsIgnoreCase("Administrators")) continue;
                            columnPos = 9;
                            CUFTools.addCellToXLSSheet(docLinksSheet, columnPos, ++rowPos, recourceId, null, cellView);
                            CUFTools.addCellToXLSSheet(docLinksSheet, ++columnPos, rowPos, String.valueOf(bIsGroup), null, cellView);
                            CUFTools.addCellToXLSSheet(docLinksSheet, ++columnPos, rowPos, "Modyfikacja", null, cellView);
                            ++columnPos;
                        }
                    }
                    if ((resourceIdsForRight = Authorization.listRights((String)RightTreeBuilder.builder().system().archive().links().custom((Object)linkId).read().build(), (boolean)bIsGroup)) != null && resourceIdsForRight.size() > 0) {
                        for (String recourceId : resourceIdsForRight) {
                            if (recourceId.equalsIgnoreCase("SharkGroup") || recourceId.equalsIgnoreCase("Administrators")) continue;
                            columnPos = 9;
                            CUFTools.addCellToXLSSheet(docLinksSheet, columnPos, ++rowPos, recourceId, null, cellView);
                            CUFTools.addCellToXLSSheet(docLinksSheet, ++columnPos, rowPos, String.valueOf(bIsGroup), null, cellView);
                            CUFTools.addCellToXLSSheet(docLinksSheet, ++columnPos, rowPos, "Odczyt", null, cellView);
                            ++columnPos;
                        }
                    }
                    ++rowPos;
                }
            } else {
                log.info((Object)"Brak zestawow dokumentow w systemie");
            }
            workbook.write();
            workbook.close();
            log.info((Object)("Eksport zestawow dokumentow do pliku " + sXLSPath + " zakonczony sukcesem"));
        }
        catch (CUFException e) {
            taskLog.error((Object)e.getMessage());
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            try {
                if (xls != null && xls.exists()) {
                    log.warn((Object)("Blad podczas eksportowania zestawow dokumentow. Usuwanie niepoprawnie utworzonego pliku xls z lokalizacji " + sXLSPath));
                    workbook.close();
                    xls.delete();
                    log.info((Object)"Niepoprawnie utworzony plik xls zostal usuniety");
                }
            }
            catch (Exception ex) {
                taskLog.error((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)ex);
            }
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ExportLinksToXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }
}

