/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.io.office.model.reader;

import com.google.common.base.CharMatcher;
import com.suncode.cuf.io.office.model.reader.ResolvableValueReader;
import com.suncode.cuf.io.office.model.reader.ValueReader;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringValueReader
implements ResolvableValueReader {
    private static final Logger log = LoggerFactory.getLogger(StringValueReader.class);

    @Override
    public boolean isValid(int type, Cell cell) {
        return true;
    }

    @Override
    public Object readCellValue(int type, Cell cell, CellValue cellValue, ValueReader reader) {
        if (type != CellType.STRING.getCode()) {
            cell.setCellType(CellType.STRING);
        }
        return CharMatcher.WHITESPACE.trimFrom((CharSequence)cell.getStringCellValue());
    }

    @Override
    public boolean canResolveValue(int cellType, Cell cell) {
        return this.isValid(cellType, cell);
    }

    @Override
    public int getPriority() {
        return 0;
    }
}

