/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.automatictask.mail.receivers;

import com.suncode.cuf.automatictask.mail.ReceiverTypes;
import com.suncode.cuf.automatictask.mail.SendMailSender;
import com.suncode.cuf.automatictask.mail.receivers.Receiver;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class EmailsInVariableReceiver
implements Receiver {
    private Logger log = Logger.getLogger(EmailsInVariableReceiver.class);
    private String variableId;

    @Override
    public ReceiverTypes getType() {
        return ReceiverTypes.VAR_EMAIL;
    }

    @Override
    public void send(String receiverId, String subject, String content, List<WfDocument> attachments, List<String> excludedEmails, String processId) throws MessagingException {
        String[] receivers;
        this.variableId = receiverId;
        ProcessService processService = ServiceFactory.getProcessService();
        Map processContext = processService.getProcessContext(processId);
        for (String sAddress : receivers = processContext.get(this.variableId).toString().split(";")) {
            if (sAddress.split("@").length > 1) {
                if (excludedEmails.contains(sAddress)) continue;
                SendMailSender.getInstance().send(sAddress, subject, content, attachments);
                excludedEmails.add(sAddress);
                continue;
            }
            this.log.warn((Object)"Niepoprawny adres email");
        }
    }
}

