/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.files.Files;
import com.plusmpm.database.files.FilesManager;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.Tools;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class DownloadDocument
extends HttpServlet {
    public static Logger log = Logger.getLogger(DownloadDocument.class);
    private static final long serialVersionUID = 1L;

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)"************************* DownloadDocument Servlet ****************************");
        ServletOutputStream outputStream = null;
        FileInputStream in = null;
        FilesManager manager = new FilesManager();
        Files file = null;
        String filePath = "";
        File oFile = null;
        String mimetype = null;
        long lFileId = new Long(-1L);
        try {
            String sFileId = request.getParameter("fileId");
            try {
                lFileId = Long.parseLong(sFileId);
            }
            catch (NumberFormatException e) {
                throw new CUFException("Podany identyfikator pliku nie jest wartoscia liczbowa");
            }
            file = manager.GetFile(Long.valueOf(lFileId));
            if (file == null) {
                throw new CUFException("Brak pliku o identyfikatorze " + sFileId);
            }
            String fileName = file.getName();
            filePath = file.getPath() + fileName;
            oFile = new File(filePath);
            if (oFile == null || !oFile.exists()) {
                throw new CUFException("Plik nie istnieje we wskazanej dla niego lokalizacji " + filePath);
            }
            String userName = (String)request.getSession().getAttribute("username");
            boolean hasRights = Authorization.hasRightsToReadFile((String)userName, (Long)Long.valueOf(sFileId));
            if (!hasRights) {
                throw new CUFException("Brak praw do pobierania dokumentu - u\u017cytkownik " + userName);
            }
            in = new FileInputStream(oFile);
            if (in == null || in.available() == 0) {
                throw new CUFException("Nie udalo sie pobrac pliku");
            }
            byte[] bbuf = IOUtils.toByteArray((InputStream)in);
            String sExt = "";
            int lastDotPos = fileName.lastIndexOf(".");
            if (lastDotPos != -1) {
                sExt = fileName.substring(lastDotPos + 1, fileName.length());
            }
            if (Tools.isNullOrEmpty((String)(mimetype = CUFTools.getMIMETypeFromExt(sExt)))) {
                mimetype = "application/octet-stream";
            }
            response.setContentType(mimetype);
            response.setContentLength((int)oFile.length());
            response.setHeader("Content-Disposition", "attachment; filename=\"" + file.getOrg_name() + "\"");
            outputStream = response.getOutputStream();
            outputStream.write(bbuf);
            outputStream.flush();
            outputStream.close();
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

