/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.documentViews.DocumentViewsMethods;
import com.plusmpm.database.documentViews.DocumentViewsTable;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import java.io.File;
import java.util.Date;
import java.util.List;
import jxl.CellView;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.log4j.Logger;

public class ExportDocumentViews
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ExportDocumentViews.class);

    @AdvancedTask(name="ExportDocumentViewsToXLS", description="ExportDocumentViewsToXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ExportDocumentViewsToXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************ ExportDocumentViewsToXLS(sXLSPath=" + sXLSPath + ") ************"));
        long startTime = new Date().getTime();
        File xls = new File(sXLSPath);
        WorkbookSettings wbs = new WorkbookSettings();
        WritableWorkbook workbook = null;
        WritableFont times12font = null;
        WritableCellFormat times12format = null;
        CellView cellView = null;
        DBManagement dbm = new DBManagement();
        List documentViews = null;
        int colPos = 0;
        int rowPos = 0;
        try {
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            wbs.setEncoding("ISO-8859-2");
            workbook = Workbook.createWorkbook((File)xls, (WorkbookSettings)wbs);
            WritableSheet documentViewSheet = workbook.createSheet("Widoki dokument\u00f3w", 0);
            log.info((Object)"Utworzono arkusz do eksportu widokow dokumentow");
            String[] colIDs = new String[]{"Nazwa widoku", "Opis", "Nazwa procesu", "Nazwa zadania", "U\u017cytkownik", "Klasa dokument\u00f3w", "Najnowsze", "Ilo\u015b\u0107", "Wyra\u017cenie regularne", "Wy\u015bwietl na", "Office 365"};
            times12font = new WritableFont(WritableFont.TIMES, 12);
            times12font.setBoldStyle(WritableFont.BOLD);
            times12font.setColour(Colour.BLACK);
            cellView = new CellView();
            cellView.setAutosize(true);
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.AQUA);
            for (int i = 0; i < colIDs.length; ++i) {
                CUFTools.addCellToXLSSheet(documentViewSheet, colPos, 0, colIDs[i], times12format, cellView);
                ++colPos;
            }
            log.info((Object)"Utworzono naglowki w arkuszu");
            log.info((Object)"Pobieranie widokow dokumentow z systemu");
            documentViews = DocumentViewsMethods.getAllDocumentViews();
            if (documentViews != null && documentViews.size() > 0) {
                for (DocumentViewsTable documentView : documentViews) {
                    if (documentView == null) continue;
                    colPos = 0;
                    ++rowPos;
                    String viewName = documentView.getDocument_view_name();
                    String viewDescr = documentView.getDocument_view_desc();
                    String procDefId = documentView.getProc_def_id();
                    String processName = "";
                    String actDefId = documentView.getTask_def_id();
                    String activityName = "";
                    String userId = documentView.getUser_id();
                    Long lDocClassId = documentView.getDoc_class_id();
                    String docClassName = "";
                    boolean bNewest = documentView.getIs_descending();
                    String newest = "";
                    String showOn = documentView.getShowOn().name();
                    Integer iAmount = documentView.getAmount();
                    String amount = "";
                    String regex = documentView.getRegex();
                    boolean bDisplayByOffice365 = documentView.getDisplayByOffice365();
                    String displayByOffice365 = "";
                    CUFTools.addCellToXLSSheet(documentViewSheet, colPos, rowPos, viewName, null, cellView);
                    CUFTools.addCellToXLSSheet(documentViewSheet, ++colPos, rowPos, viewDescr, null, cellView);
                    processName = CUFTools.getProcessNameForProcDefId(procDefId);
                    CUFTools.addCellToXLSSheet(documentViewSheet, ++colPos, rowPos, processName, null, cellView);
                    activityName = actDefId.equalsIgnoreCase("") ? "Ka\u017cde" : CUFTools.getActivityNameForActDefId(procDefId, actDefId);
                    CUFTools.addCellToXLSSheet(documentViewSheet, ++colPos, rowPos, activityName, null, cellView);
                    ++colPos;
                    if (Tools.isNullOrEmpty((String)userId)) {
                        userId = "Ka\u017cdy";
                    }
                    CUFTools.addCellToXLSSheet(documentViewSheet, colPos, rowPos, userId, null, cellView);
                    ++colPos;
                    if (lDocClassId != null) {
                        DocClassTable docClassTable = DBManagement.getDocClass((String)lDocClassId.toString());
                        if (docClassTable != null) {
                            docClassName = docClassTable.getDocClassName();
                        }
                    } else {
                        docClassName = "Ka\u017cda";
                    }
                    CUFTools.addCellToXLSSheet(documentViewSheet, colPos, rowPos, docClassName, null, cellView);
                    newest = bNewest ? "tak" : "nie";
                    displayByOffice365 = bDisplayByOffice365 ? "tak" : "nie";
                    CUFTools.addCellToXLSSheet(documentViewSheet, ++colPos, rowPos, newest, null, cellView);
                    amount = iAmount.toString();
                    CUFTools.addCellToXLSSheet(documentViewSheet, ++colPos, rowPos, amount, null, cellView);
                    CUFTools.addCellToXLSSheet(documentViewSheet, ++colPos, rowPos, regex, null, cellView);
                    CUFTools.addCellToXLSSheet(documentViewSheet, ++colPos, rowPos, showOn, null, cellView);
                    CUFTools.addCellToXLSSheet(documentViewSheet, ++colPos, rowPos, displayByOffice365, null, cellView);
                    ++colPos;
                }
            } else {
                log.info((Object)"Brak widokow dokumentow zdefiniowanych w systemie");
            }
            workbook.write();
            workbook.close();
            log.info((Object)("Eksport widokow dokumentow do pliku " + sXLSPath + " zakonczony sukcesem"));
        }
        catch (CUFException e) {
            taskLog.error((Object)e.getMessage());
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            try {
                if (xls != null && xls.exists()) {
                    log.warn((Object)("Blad podczas eksportowania widokow dokumentow. Usuwanie niepoprawnie utworzonego pliku xls z lokalizacji " + sXLSPath));
                    workbook.close();
                    xls.delete();
                    log.info((Object)"Niepoprawnie utworzony plik xls zostal usuniety");
                }
            }
            catch (Exception ex) {
                taskLog.error((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)ex);
            }
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ExportDocumentViewsToXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }
}

