/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.DataChoosers;

import com.plusmpm.database.DBManagement;
import com.plusmpm.util.Tools;
import com.plusmpm.util.form.datachooser.DataChooser;
import com.suncode.cuf.administartion.user.UserHelper;
import com.suncode.cuf.util.CUFFactory;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.util.FinderFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanToPropertyValueTransformer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.log4j.Logger;

public class GetUsersInOUWithRole
implements DataChooser {
    public static Logger log = Logger.getLogger(GetUsersInOUWithRole.class);
    public static int size = 0;
    private OrganizationalUnitFinder ous = FinderFactory.getOrganizationalUnitFinder();

    public List<Map<String, String>> getDataChooserResult(int startItem, int limit, String orderProperty, String order, Map<String, String> criteria, Map<String, String> customKeys) {
        log.trace((Object)"************************* GetUsersInOUWithRole Data Chooser ********************");
        ArrayList<Map<String, String>> results = null;
        DBManagement dbm = new DBManagement();
        try {
            List<String> roleIds;
            results = new ArrayList<Map<String, String>>();
            String OUVariable = customKeys.get("OUVariable");
            String roles = customKeys.get("roles");
            String OUName = null;
            OUName = !Tools.isNullOrEmpty((String)OUVariable) ? criteria.get(OUVariable) : customKeys.get("OUName");
            List OUTable = this.ous.findByName(OUName, new String[0]);
            if (OUTable == null || OUTable.size() == 0) {
                log.warn((Object)("Jednostka organizacyjna o nazwie " + OUName + " nie istnieje w systemie"));
                return null;
            }
            List ouIds = (List)CollectionUtils.collect((Collection)OUTable, (Transformer)new BeanToPropertyValueTransformer("id"));
            List<String> usersInOUWithRoles = this.GetUsersInOUWithRoles(ouIds, roleIds = Arrays.asList(roles.split(";")));
            if (usersInOUWithRoles == null || usersInOUWithRoles.isEmpty()) {
                return null;
            }
            size = usersInOUWithRoles.size();
            for (String userId : usersInOUWithRoles) {
                HashMap<String, String> oneResult = new HashMap<String, String>();
                String userInOUName = Tools.GetRealUserName((String)userId);
                oneResult.put("userId", userId);
                oneResult.put("userRealName", userInOUName);
                results.add(oneResult);
            }
            return results;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public int getDataChooserResultSize(Map<String, String> criteria, Map<String, String> customKeys) {
        log.trace((Object)"************************* getDataChooserResultSize ********************");
        return size;
    }

    private List<String> GetUsersInOUWithRoles(List<Long> ouIds, List<String> roleIds) {
        UserHelper eus = CUFFactory.getUserHelper();
        return eus.getUsersInOusWithRoles(ouIds, roleIds);
    }
}

