/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.plusmpm.CUF.util.extension.ArchiveServices;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.database.files.Files;
import com.plusmpm.database.files.FilesManager;
import com.plusmpm.util.Tools;
import com.plusmpm.util.json.extjs.gson.GsonCustomUtils;
import com.plusmpm.util.json.extjs.objects.JsonStore;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;

public class GetDocumentsInfo
extends HttpServlet {
    public static Logger log = Logger.getLogger(GetDocumentsInfo.class);
    private static final long serialVersionUID = 1L;

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)"************************* GetDocumentInfo Servlet ****************************");
        PrintWriter printWriter = null;
        JsonStore jsonStore = null;
        GsonCustomUtils gsonCustomUtils = null;
        ArrayList records = null;
        boolean bSuccess = false;
        String answerMessage = "";
        String sOrgName = "";
        String sDescription = "";
        String sDate = "";
        Date dDate = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sSize = "";
        Long lSize = null;
        String sOwner = "";
        String sName = "";
        String sDocId = "";
        String sDocClassName = "";
        String sExpirationDate = "";
        String sVersion = "";
        String sState = "";
        String sComment = "";
        FilesManager manager = new FilesManager();
        Files file = null;
        long lFileId = new Long(-1L);
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        int iLp = 1;
        try {
            String[] sFileIdsTab;
            records = new ArrayList();
            String sFileIds = request.getParameter("fileIds");
            if (Tools.isNullOrEmpty((String)sFileIds)) {
                throw new CUFException("Brak identyfikatorow dokumentow");
            }
            for (String sFileId : sFileIdsTab = sFileIds.split(",")) {
                String userId;
                try {
                    lFileId = Long.parseLong(sFileId);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)"Podany identyfikator pliku nie jest wartoscia liczbowa");
                    continue;
                }
                file = manager.GetFile(Long.valueOf(lFileId));
                if (file == null) {
                    log.warn((Object)("Brak pliku o identyfikatorze " + sFileId));
                    continue;
                }
                sOrgName = file.getOrg_name();
                sDescription = file.getDescription();
                sDocClassName = ArchiveServices.GetDocClassNameForDocument(sFileId);
                if (Tools.isNullOrEmpty((String)sDescription)) {
                    sDescription = "Doc";
                }
                if ((dDate = file.getDate()) != null) {
                    sDate = sdf.format(dDate);
                }
                if ((lSize = file.getSize()) != null) {
                    sSize = lSize.toString();
                }
                if (Tools.isNullOrEmpty((String)(sOwner = uga.getUserRealName(userId = file.getUploader())))) {
                    sOwner = userId;
                } else {
                    sOwner.trim();
                }
                sName = file.getName();
                sDocId = ArchiveServices.GetDocIdForDocument(sFileId);
                sExpirationDate = ArchiveServices.GetExpirationDateForDocument(sFileId);
                sVersion = ArchiveServices.GetVersionForFile(sFileId);
                sState = ArchiveServices.GetStateForFile(sFileId);
                if (sState != null && sState.equalsIgnoreCase("STATE_READY")) {
                    sState = "Dost\u0119pny";
                } else if (sState != null && sState.equalsIgnoreCase("STATE_EDIT")) {
                    sState = "W edycji";
                }
                sComment = ArchiveServices.GetCommentForFile(sFileId);
                HashMap<String, String> docInfo = new HashMap<String, String>();
                docInfo.put("lp", String.valueOf(iLp));
                docInfo.put("fileId", sFileId);
                docInfo.put("orgName", sOrgName);
                docInfo.put("description", sDescription);
                docInfo.put("date", sDate);
                docInfo.put("size", sSize);
                docInfo.put("owner", sOwner);
                docInfo.put("name", sName);
                docInfo.put("docId", sDocId);
                docInfo.put("docClassName", sDocClassName);
                docInfo.put("expirationDate", sExpirationDate);
                docInfo.put("version", sVersion);
                docInfo.put("state", sState);
                docInfo.put("comment", sComment);
                records.add(docInfo);
                ++iLp;
            }
            bSuccess = true;
            answerMessage = "Pobrano informacje o dokumentach.";
        }
        catch (CUFException e) {
            bSuccess = false;
            answerMessage = e.getMessage();
            log.warn((Object)answerMessage);
        }
        catch (Exception e) {
            bSuccess = false;
            answerMessage = "B\u0142\u0105d podczas pobierania informacji o dokumentach.";
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                jsonStore = new JsonStore();
                jsonStore.setSuccess(Boolean.valueOf(bSuccess));
                jsonStore.setMessage(answerMessage);
                jsonStore.setRecords(records);
                gsonCustomUtils = new GsonCustomUtils();
                String sJsonData = gsonCustomUtils.getJsonForExtJsonStore(jsonStore);
                response.setContentType("application/json;charset=UTF-8");
                printWriter = response.getWriter();
                printWriter.print(sJsonData);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }
}

