/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.database.storage;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.CUF.database.formTemplate.FormTemplate;
import com.plusmpm.CUF.database.formTemplate.FromTemplateService;
import com.plusmpm.CUF.database.storage.DynamicTableStorage;
import com.plusmpm.CUF.database.storage.DynamicTableStorageManager;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.suncode.cuf.web.dto.form.FormTemplateDto;
import com.suncode.cuf.web.dto.form.FormTemplateGridDto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.springframework.util.Assert;

public class StorageFromTemplateConverter
extends AbstractAdvancedTask {
    public static final String STORAGE_CATEGORY = "STORAGE";

    public String convert(String activityMapping) throws Exception {
        taskLog.info((Object)"Rozpoczynam konwertowanie danych...");
        Map<String, StorageMapping> storageMapping = StorageMapping.parseMapping(activityMapping);
        taskLog.info((Object)("Mapping nazw tabel do zada\u0144: " + storageMapping));
        List<DynamicTableStorage> storages = DynamicTableStorageManager.getAll();
        HashMap<StorageKey, Object> templates = new HashMap<StorageKey, Object>();
        this.sortDynamicTableStorage(storages);
        for (DynamicTableStorage storage : storages) {
            taskLog.trace((Object)("Przetwarzanie wpisu: " + this.storageToString(storage)));
            StorageKey key = new StorageKey(storage.getStorageName(), storage.getUsername(), storage.getTabTitle());
            Object template = (FormTemplateDto)templates.get(key);
            if (template == null) {
                template = new FormTemplateDto();
                ((FormTemplateDto)template).setName(storage.getStorageName());
                ((FormTemplateDto)template).setOwner(storage.getUsername());
                ((FormTemplateDto)template).setCategory(this.storageCategory(storage));
                ((FormTemplateDto)template).setDefaultTemplate(Boolean.valueOf(storage.getDefaultStorage()));
                ((FormTemplateDto)template).setVersion(2);
                StorageMapping mapping = storageMapping.get(storage.getTabTitle());
                if (mapping == null) {
                    String msg = "Brak mappingu zadania dla tabelki [" + storage.getTabTitle() + "]";
                    taskLog.error((Object)msg);
                    throw new IllegalArgumentException(msg);
                }
                ((FormTemplateDto)template).setProcessType(mapping.process);
                ((FormTemplateDto)template).setActivityType(mapping.activity);
                templates.put(key, template);
            }
            FormTemplateGridDto grid = this.findGrid(storage.getTabTitle(), (FormTemplateDto)template);
            this.addStorage(storage, grid);
        }
        taskLog.info((Object)"Zako\u0144czono przygotowywanie danych - rozpoczynam kopiowanie");
        FromTemplateService templateService = new FromTemplateService();
        int done = 0;
        int size = templates.size();
        for (FormTemplateDto templateDto : templates.values()) {
            FormTemplate template = new FormTemplate();
            template.setTemplateName(templateDto.getName());
            template.setUserId(templateDto.getOwner());
            template.setCategory(templateDto.getCategory());
            template.setProcessDefId(templateDto.getProcessType());
            template.setActivityDefId(templateDto.getActivityType());
            template.setDefault(templateDto.isDefaultTemplate());
            template.setVersion(templateDto.getVersion());
            ObjectMapper mapper = new ObjectMapper();
            template.setData(mapper.writeValueAsString((Object)templateDto));
            taskLog.info((Object)("Kopiowanie szablonu [" + templateDto + "]"));
            taskLog.trace((Object)("JSON=" + template.getData()));
            try {
                templateService.save(template);
                ++done;
            }
            catch (Exception e) {
                taskLog.error((Object)("ERROR: zapis szablonu [" + templateDto + "] zako\u0144czy\u0142 si\u0119 b\u0142\u0119dem"), (Throwable)e);
            }
        }
        String result = "Przetworzono " + done + "/" + size + " szablon\u00f3w";
        taskLog.info((Object)("Zako\u0144czono konwersj\u0119 danych." + result));
        return result;
    }

    private String storageCategory(DynamicTableStorage storage) {
        return "STORAGE[" + storage.getTabTitle() + "]";
    }

    private FormTemplateGridDto findGrid(String tableTitle, FormTemplateDto template) {
        List<FormTemplateGridDto> grids = template.getGrids();
        if (grids == null) {
            grids = new ArrayList<FormTemplateGridDto>();
            template.setGrids(grids);
        }
        FormTemplateGridDto templateGrid = null;
        for (FormTemplateGridDto grid : grids) {
            if (!tableTitle.equals(grid.getTitle())) continue;
            templateGrid = grid;
            break;
        }
        if (templateGrid == null) {
            templateGrid = new FormTemplateGridDto();
            templateGrid.setTitle(tableTitle);
            grids.add(templateGrid);
        }
        return templateGrid;
    }

    private void addStorage(DynamicTableStorage storage, FormTemplateGridDto grid) {
        Map<String, Object> row = this.getGridRow(storage.getRowNumber() - 1, grid);
        row.put(storage.getColumnId(), storage.getCellValue());
    }

    private Map<String, Object> getGridRow(int index, FormTemplateGridDto grid) {
        List<Map<String, Object>> rows = grid.getData();
        if (rows == null) {
            rows = new ArrayList<Map<String, Object>>();
            grid.setData(rows);
        }
        if (index >= rows.size()) {
            for (int i = rows.size(); i <= index; ++i) {
                rows.add(new HashMap());
            }
        }
        return rows.get(index);
    }

    private void sortDynamicTableStorage(List<DynamicTableStorage> storages) {
        Collections.sort(storages, new Comparator<DynamicTableStorage>(){

            @Override
            public int compare(DynamicTableStorage o1, DynamicTableStorage o2) {
                int comp = o1.getStorageName().compareTo(o2.getStorageName());
                if (comp == 0 && (comp = o1.getUsername().compareTo(o2.getUsername())) == 0 && (comp = o1.getTabTitle().compareTo(o2.getTabTitle())) == 0 && (comp = Integer.valueOf(o1.getRowNumber()).compareTo(o2.getRowNumber())) == 0) {
                    comp = o1.getColumnId().compareTo(o2.getColumnId());
                }
                return comp;
            }
        });
    }

    private String storageToString(DynamicTableStorage storage) {
        return "id:" + storage.getId() + " storageName:" + storage.getStorageName() + " tabTitle:" + storage.getTabTitle() + " username:" + storage.getUsername() + " column:" + storage.getColumnId() + " value:" + storage.getCellValue() + " default:" + storage.getDefaultStorage();
    }

    static class StorageMapping {
        private String name;
        private String process;
        private String activity;

        public StorageMapping(String name, String process, String activity) {
            Assert.hasText((String)name);
            Assert.hasText((String)process);
            Assert.hasText((String)activity);
            this.name = name;
            this.process = process;
            this.activity = activity;
        }

        public static Map<String, StorageMapping> parseMapping(String mapping) {
            HashMap<String, StorageMapping> mappingMap = new HashMap<String, StorageMapping>();
            String name = null;
            String process = null;
            String activity = null;
            String[] mappingParts = mapping.split(":");
            for (int i = 0; i < mappingParts.length; ++i) {
                int part = i % 3;
                switch (part) {
                    case 0: {
                        name = mappingParts[i];
                        break;
                    }
                    case 1: {
                        process = mappingParts[i];
                        break;
                    }
                    case 2: {
                        activity = mappingParts[i];
                    }
                }
                if (part != 2) continue;
                StorageMapping storageMapping = new StorageMapping(name, process, activity);
                mappingMap.put(storageMapping.name, storageMapping);
                activity = null;
                process = null;
                name = null;
            }
            return mappingMap;
        }

        public String toString() {
            return "StorageMapping(" + this.name + "," + this.process + "," + this.activity + ")";
        }
    }

    static class StorageKey {
        private String storageName;
        private String username;
        private String tabTitle;

        public StorageKey(String storageName, String username, String tabTitle) {
            this.storageName = storageName;
            this.username = username;
            this.tabTitle = tabTitle;
        }

        public boolean equals(Object obj) {
            if (obj instanceof StorageKey) {
                StorageKey key = (StorageKey)obj;
                return new EqualsBuilder().append((Object)this.storageName, (Object)key.storageName).append((Object)this.username, (Object)key.username).append((Object)this.tabTitle, (Object)key.tabTitle).isEquals();
            }
            return false;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.storageName).append((Object)this.username).append((Object)this.tabTitle).toHashCode();
        }
    }
}

