/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension.DocTemplates2Pdf.graphic;

import com.google.common.io.ByteStreams;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.graphic.ColumnGraphicProperties;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.graphic.NoImage;
import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.config.Environment;
import com.suncode.pwfl.util.ServiceFactory;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.util.Date;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.R;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphicUtils {
    private static final Logger log = LoggerFactory.getLogger(GraphicUtils.class);

    public static R addImageToR(WordprocessingMLPackage template, int colWitdh, ColumnGraphicProperties gPropertie, Long fileID) throws IOException, Exception {
        R r;
        Integer widthImage = gPropertie.getWidth();
        Integer heigthImage = gPropertie.getHeight();
        int maxW = colWitdh - 200;
        if (widthImage < 0 || heigthImage < 0) {
            r = GraphicUtils.addDocPrev(fileID, maxW, null, template);
        } else {
            if (widthImage > maxW) {
                widthImage = maxW;
            }
            r = GraphicUtils.addDocPrev(fileID, widthImage, heigthImage, template);
        }
        return r;
    }

    private static R addDocPrev(Long fileID, Integer width, Integer height, WordprocessingMLPackage template) throws IOException, Exception {
        FileService fileService = ServiceFactory.getFileService();
        WfFile wfFile = fileService.getFile(fileID, new String[0]);
        String extension = "";
        String fileName = "fileID: " + fileID;
        String descriptionFile = "No file in archvie with file id\t+" + fileID;
        if (wfFile == null) {
            log.info("No file in archive with fileID:\t" + fileID);
        } else {
            descriptionFile = wfFile.getDescription();
            fileName = wfFile.getFileName();
            extension = FilenameUtils.getExtension((String)wfFile.getFileName());
        }
        BinaryPartAbstractImage imagePart = null;
        try {
            File image = new File(wfFile.getFullPath());
            if (extension.equalsIgnoreCase("PDF")) {
                image = GraphicUtils.convertPDF2Image(image);
            }
            byte[] fileContent = Files.readAllBytes(image.toPath());
            imagePart = BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)template, (byte[])fileContent);
            if (extension.equalsIgnoreCase("PDF")) {
                image.delete();
            }
        }
        catch (Exception e) {
            log.info("No image preview form :\t" + fileName, (Throwable)e);
            InputStream imageStream = NoImage.getInputStream(extension);
            byte[] fileContent = ByteStreams.toByteArray((InputStream)imageStream);
            imagePart = BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)template, (byte[])fileContent);
        }
        Inline inline = null;
        int imageWitdh = imagePart.getImageInfo().getSize().getWidthPx();
        int imageTwipWidth = UnitsOfMeasurement.pxToTwip((float)imageWitdh);
        if (width > imageTwipWidth) {
            width = imageTwipWidth;
        }
        if (height == null || height < 0) {
            inline = imagePart.createImageInline(fileName, descriptionFile, 1, 2, width == null || width < 0 ? 20L : (long)width.intValue(), false);
        } else {
            int imageHeigth = imagePart.getImageInfo().getSize().getHeightPx();
            int imageTwipHeigth = UnitsOfMeasurement.pxToTwip((float)imageHeigth);
            double ratio = (double)imageTwipHeigth / (double)imageTwipWidth;
            double tempTwipH = ratio * (double)width.intValue();
            double tempTwipW = width.intValue();
            if (tempTwipH > (double)height.intValue()) {
                tempTwipH = height.intValue();
                tempTwipW = tempTwipH / ratio;
            }
            long w = UnitsOfMeasurement.twipToEMU((double)tempTwipW);
            long h = UnitsOfMeasurement.twipToEMU((double)tempTwipH);
            inline = imagePart.createImageInline(fileName, descriptionFile, 1, 2, w, h, false);
        }
        ObjectFactory factory = Context.getWmlObjectFactory();
        R r = factory.createR();
        Drawing drawing = factory.createDrawing();
        r.getContent().add(drawing);
        drawing.getAnchorOrInline().add(inline);
        return r;
    }

    private static File convertPDF2Image(File pdf) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(pdf, "r");
        FileChannel channel = raf.getChannel();
        MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
        PDFFile pdffile = new PDFFile((ByteBuffer)buf);
        PDFPage page = pdffile.getPage(0);
        int width = (int)page.getBBox().getWidth();
        int height = (int)page.getBBox().getHeight();
        Rectangle rect = new Rectangle(0, 0, width, height);
        int rotation = page.getRotation();
        Rectangle rect1 = rect;
        if (rotation == 90 || rotation == 270) {
            rect1 = new Rectangle(0, 0, rect.height, rect.width);
        }
        BufferedImage img = (BufferedImage)page.getImage(rect.width, rect.height, (Rectangle2D)rect1, null, true, true);
        String tmpDir = Environment.get((String)"java.io.tmpdir");
        File imagePdfFile = new File(tmpDir + "\\" + pdf.getName() + "_" + new Date().getTime() + ".png");
        ImageIO.write((RenderedImage)img, "png", imagePdfFile);
        return imagePdfFile;
    }
}

