/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.automatictask.mail.receivers;

import com.suncode.cuf.automatictask.mail.ReceiverTypes;
import com.suncode.cuf.automatictask.mail.SendMailSender;
import com.suncode.cuf.automatictask.mail.receivers.Receiver;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.RoleService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.List;
import javax.mail.MessagingException;
import org.springframework.stereotype.Component;

@Component
public class RoleReceiver
implements Receiver {
    private String roleId;

    @Override
    public ReceiverTypes getType() {
        return ReceiverTypes.ROLE;
    }

    @Override
    public void send(String receiverId, String subject, String content, List<WfDocument> attachments, List<String> excludedEmails, String processId) throws MessagingException {
        this.roleId = receiverId;
        ProcessService processService = ServiceFactory.getProcessService();
        Process process = processService.getProcess(processId, new String[]{"processDefinition"});
        String packageId = process.getProcessDefinition().getPackageId();
        String processDefId = process.getProcessDefinition().getProcessDefinitionId();
        RoleService roleService = ServiceFactory.getRoleService();
        UserFinder userFinder = FinderFactory.getUserFinder();
        Role role = roleService.getRole(packageId, processDefId, this.roleId);
        for (User user : userFinder.getAll(new String[0])) {
            if (!roleService.doesUserHasRole(user.getUserName(), role.getId()) || excludedEmails.contains(user.getEmail())) continue;
            SendMailSender.getInstance().send(user.getEmail(), subject, content, attachments);
            excludedEmails.add(user.getEmail());
        }
    }
}

