/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration.helper;

import com.suncode.cuf.plannedtask.administration.structure.helper.StructureMappings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class StructureAdapter {
    public List<Map<String, String>> convertImportingStructure(List<Map<String, Object>> rawData, StructureMappings mappings) {
        return this.convertStructure(rawData, mappings, true);
    }

    public List<Map<String, String>> convertExportingStructure(List<Map<String, Object>> systemData, StructureMappings mappings) {
        return this.convertStructure(systemData, mappings, false);
    }

    private List<Map<String, String>> convertStructure(List<Map<String, Object>> data, StructureMappings mappings, boolean reverse) {
        Map<String, String> colMappings = null;
        colMappings = reverse ? mappings.getReverseColumnMappings() : mappings.getColumnMappings();
        ArrayList<Map<String, String>> exported = new ArrayList<Map<String, String>>();
        for (Map<String, Object> map : data) {
            HashMap<String, String> convertedMap = new HashMap<String, String>();
            for (String key : map.keySet()) {
                String convertedKey = colMappings.get(key);
                convertedMap.put(convertedKey, this.castToString(map.get(key)));
            }
            exported.add(convertedMap);
        }
        return exported;
    }

    private String castToString(Object object) {
        if (object == null) {
            return null;
        }
        return String.valueOf(object);
    }
}

