/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.form.datachooser.internal.filter;

import com.suncode.cuf.exception.CUFServiceException;
import com.suncode.cuf.form.datachooser.internal.filter.CriteriaFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class CriteriaFilterHolder {
    private static CriteriaFilterHolder instance;
    private Map<String, CriteriaFilter> filters = new HashMap<String, CriteriaFilter>();
    private CriteriaFilter defaultFilter;

    private CriteriaFilterHolder() {
        Reflections reflections = new Reflections(this.getClass().getPackage().getName(), new Scanner[0]);
        Set subTypes = reflections.getSubTypesOf(CriteriaFilter.class);
        for (Class type : subTypes) {
            try {
                CriteriaFilter cf = (CriteriaFilter)type.newInstance();
                this.filters.put(cf.getGroup() + "." + cf.getName(), cf);
            }
            catch (Exception e) {
                throw new CUFServiceException("Can't create class: " + type, e);
            }
        }
        this.defaultFilter = this.filters.get("standard.ilike");
    }

    public static CriteriaFilterHolder getInstance() {
        if (instance == null) {
            instance = new CriteriaFilterHolder();
        }
        return instance;
    }

    public static CriteriaFilter getFilter(String name) {
        CriteriaFilter cf = CriteriaFilterHolder.getInstance().filters.get(name);
        if (cf == null) {
            return CriteriaFilterHolder.getInstance().defaultFilter;
        }
        return cf;
    }
}

