/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.io.office.model;

import com.suncode.cuf.exception.CUFServiceException;
import com.suncode.cuf.io.office.model.SheetDefinition;
import com.suncode.cuf.io.office.model.writer.ValueWriter;
import com.suncode.cuf.util.collection.map.MapUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ExportSheetDefinition
extends SheetDefinition {
    private static final Logger log = LoggerFactory.getLogger(ExportSheetDefinition.class);
    private String[] keysOrder;
    private KeysSource keysSource = KeysSource.DATA;
    private Map<String, ValueWriter> valueWriters = new HashMap<String, ValueWriter>();
    private Map<String, String> mappings;

    public ExportSheetDefinition(String name, List<Map<String, Object>> data) {
        super(name, data);
    }

    public void setKeysSource(KeysSource keysSource) {
        Assert.notNull((Object)((Object)keysSource));
        this.keysSource = keysSource;
    }

    public String[] getKeysOrder() {
        if (this.keysOrder != null) {
            return this.keysOrder;
        }
        if (this.keysSource == KeysSource.DATA) {
            this.keysOrder = this.readKeysFromData();
        } else if (this.keysSource == KeysSource.MAPPING) {
            this.keysOrder = this.readKeysFromMappings();
        }
        if (this.keysOrder == null) {
            this.keysOrder = this.readKeysFromData();
            if (this.keysOrder == null) {
                this.keysOrder = this.readKeysFromMappings();
                if (this.keysOrder == null) {
                    throw new CUFServiceException("Can't read sheet keys");
                }
            }
        }
        return this.keysOrder;
    }

    private String[] readKeysFromMappings() {
        String[] keys = null;
        if (this.mappings == null || this.mappings.isEmpty()) {
            log.info("No data.");
        } else {
            keys = MapUtils.keysToArray(this.mappings);
        }
        return keys;
    }

    private String[] readKeysFromData() {
        String[] keys = null;
        if (this.data.isEmpty()) {
            log.info("No data.");
        } else {
            keys = MapUtils.keysToArray((Map)this.data.get(0));
        }
        return keys;
    }

    public void setKeysOrder(String[] keysOrder) {
        this.keysOrder = keysOrder;
    }

    public Map<String, String> getMappings() {
        return this.mappings;
    }

    public void setMappings(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    public void setData(List<Map<String, Object>> data) {
        this.data = this.convertObjectToCell(data);
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String[] getHeaders() {
        if (this.headers == null) {
            String[] keys = this.getKeysOrder();
            this.headers = new String[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                String header;
                String key = keys[i];
                this.headers[i] = header = this.getHeader(key);
            }
        }
        return this.headers;
    }

    private String getHeader(String key) {
        if (this.mappings != null) {
            return this.mappings.get(key);
        }
        return key;
    }

    public Map<String, ValueWriter> getValueWriters() {
        return this.valueWriters;
    }

    public void setValueWriters(Map<String, ValueWriter> valueWriters) {
        this.valueWriters = valueWriters;
    }

    public void setValueWriter(String key, ValueWriter valueWriter) {
        this.valueWriters.put(key, valueWriter);
    }

    public static enum KeysSource {
        DATA,
        MAPPING;

    }
}

