PW.ScheduledTasks.register("import-structure-task", {
  buildParams: function (form) {
    form.addField("path_to_excel_file");
    form.addCombobox({
      id: "read_mode",
      values: [
        ["APPEND", "Append"],
        ["STANDARD", "Standard"],
        ["OVERRIDE", "Override"],
      ],
      listeners: {
        change: function (field, newValue) {
          if (newValue !== "OVERRIDE") {
            form.setValue("assign_users_tasks", " ");
            form.setValue("unused_users", " ");
          }
          update(form);
        },
      },
    });
    form.addField("unused_users");
    form.addField("assign_users_tasks");

    setTimeout(() => {
      update(form);
    }, 100);
  },
});

function update(form) {
  if (form.getValue("read_mode") === "OVERRIDE") {
    form.show("unused_users");
    form.show("assign_users_tasks");
    return;
  }
  form.hide("unused_users");
  form.hide("assign_users_tasks");
}
