/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension.DocTemplates2Pdf;

import com.documents4j.api.DocumentType;
import com.documents4j.api.IConverter;
import com.documents4j.throwables.ConverterAccessException;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.PdfOfficeConverter;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.exception.InvalidTemplateException;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.graphic.ColumnGraphicInfo;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.graphic.DelegatedFileConversionImageHandler;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.pdf.PdfUtils;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.table.DynamicTablesResolver;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.table.TableInfo;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.table.TableUtils;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.workflow.WorkflowUtils;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.TempFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.tika.Tika;
import org.docx4j.Docx4J;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.fonts.BestMatchingMapper;
import org.docx4j.fonts.Mapper;
import org.docx4j.model.images.ConversionImageHandler;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.Document;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TrPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepeareDoc {
    private static final Logger log = LoggerFactory.getLogger(PrepeareDoc.class);
    public static final String TAB_TO_PROC_STR = "TABLE_TO_PROCESS_MARKER";
    public static final String TAB_NOT_TO_PROC_STR = "TABLE_NOT_TO_PROCESS_MARKER";
    public static final String TAB_WOUT_HDS_STRING = "TABLE_WITHOUT_HEADERS_MARKER";
    private static final SecureRandom random = new SecureRandom();
    public static final String VARIABLE_MARKER = "@";

    public static File prepeareWordDocument(String templatePath, String outputFilePath, Map<String, Object> mappings, List<Map<String, String>> tables, String variablesMarker, String processId, List<Boolean> headersAdditionalFlags, List<Boolean> tablesAdditionalFlags) {
        return PrepeareDoc.prepareDocument(templatePath, outputFilePath, mappings, tables, variablesMarker, processId, headersAdditionalFlags, tablesAdditionalFlags, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static File prepareDocument(String outputFilePath, Map<String, Object> mappings, List<Map<String, String>> tablesMaps, String variablesMarker, String processId, List<Boolean> tablesAdditionalFlags, List<Boolean> headersAdditionalFlags, boolean pdf, Long fileId) {
        block19: {
            if (fileId == null) break block19;
            TempFile tempFile = new TempFile();
            try {
                File file;
                Throwable throwable;
                InputStream inputStream;
                block17: {
                    block18: {
                        inputStream = ServiceFactory.getFileService().getFileInputStream(fileId);
                        throwable = null;
                        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile.getFile());
                        file = PrepeareDoc.prepareDocument(tempFile.getFile().getAbsolutePath(), outputFilePath, mappings, tablesMaps, variablesMarker, processId, tablesAdditionalFlags, headersAdditionalFlags, pdf);
                        if (inputStream == null) break block17;
                        if (throwable == null) break block18;
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block17;
                    }
                    inputStream.close();
                }
                return file;
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (inputStream != null) {
                                if (throwable != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    inputStream.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (Exception e) {
                        log.error("Wyst\u0105pi\u0142 b\u0142\u0105d podczas tworzenia pliku tymczasowego", (Object)e.getMessage());
                    }
                }
            }
            finally {
                tempFile.delete();
            }
        }
        return null;
    }

    public static File prepareDocument(String templatePath, String outputFilePath, Map<String, Object> mappings, List<Map<String, String>> tablesMaps, String variablesMarker, String processId, List<Boolean> tablesAdditionalFlags, List<Boolean> headersAdditionalFlags, boolean pdf) {
        block16: {
            log.trace("************************* prepareDocument() ********************");
            try {
                if (SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.PDF_CONVERTER).equals("Office")) {
                    PrepeareDoc.convertByMSWord(templatePath, templatePath, DocumentType.MS_WORD, DocumentType.PDF);
                    templatePath = templatePath + "_fix.docx";
                }
                log.info("Pobieranie szablonu dla pliku: ".concat(templatePath));
                WordprocessingMLPackage template = WordprocessingMLPackage.load((File)new File(templatePath));
                log.info("Pobieranie MainDocumentPart.");
                MainDocumentPart documentPart = template.getMainDocumentPart();
                log.info("Preparing header and footer");
                PrepeareDoc.prepareHeaderFooter(template, mappings, variablesMarker);
                log.info("Pobieranie JAXBElement - DocumentElement.");
                Document wmlDocumentEl = (Document)documentPart.getJaxbElement();
                log.info("Pobieranie wezlow table z dokumentu.");
                List nodes = documentPart.getJAXBNodesViaXPath("//w:tbl", false);
                if (nodes == null) break block16;
                log.info("Inicjowanie flag");
                List<Tbl> tables = TableUtils.getTables(nodes);
                ArrayList<Boolean> tablesFlags = new ArrayList<Boolean>();
                ArrayList<Boolean> headersFlags = new ArrayList<Boolean>();
                ArrayList<ColumnGraphicInfo> tablesGraphicColumnInfo = new ArrayList<ColumnGraphicInfo>();
                TableUtils.removeMarkupRows(tables, tablesFlags, headersFlags);
                log.info("Inicjowanie dodatkowych flag");
                if (tablesAdditionalFlags == null && headersAdditionalFlags == null) {
                    tablesAdditionalFlags = new ArrayList<Boolean>();
                    headersAdditionalFlags = new ArrayList<Boolean>();
                    List<TableInfo> tablesInfo = DynamicTablesResolver.getTables(documentPart);
                    for (TableInfo tableInfo : tablesInfo) {
                        tablesAdditionalFlags.add(tableInfo.isDynamic());
                        headersAdditionalFlags.add(!tableInfo.isHeaderless());
                        tablesGraphicColumnInfo.add(tableInfo.getColumnGraphicInfo());
                    }
                } else {
                    int tableFlagSize = tablesAdditionalFlags != null ? tablesAdditionalFlags.size() : 0;
                    int headerFlagSize = headersAdditionalFlags != null ? headersAdditionalFlags.size() : 0;
                    int size = tableFlagSize > headerFlagSize ? tableFlagSize : headerFlagSize;
                    for (int index = 0; index < size; ++index) {
                        tablesGraphicColumnInfo.add(new ColumnGraphicInfo());
                    }
                }
                log.info("Ustawianie flag wszystkich tabel.");
                boolean bTablesToProcessMarkers = true;
                if (tablesAdditionalFlags == null) {
                    log.info("whichTables = null.");
                    if (tablesFlags.contains(true) || tablesFlags.contains(false)) {
                        bTablesToProcessMarkers = false;
                    }
                    for (int i = 0; i < nodes.size(); ++i) {
                        if (tablesFlags.get(i) != null) continue;
                        tablesFlags.remove(i);
                        tablesFlags.add(i, bTablesToProcessMarkers);
                    }
                } else {
                    log.info("whichTables != null.");
                    log.info("Przepisanie warto\u015bci z whichTables do whichTablesTmp.");
                    tablesFlags.clear();
                    tablesFlags.addAll(tablesAdditionalFlags);
                    log.info("Przepisanie warto\u015bci powiod\u0142o si\u0119.");
                }
                if (headersAdditionalFlags == null) {
                    log.info("whichHeaders = null.");
                    for (int i = 0; i < nodes.size(); ++i) {
                        if (headersFlags.get(i) != null) continue;
                        headersFlags.remove(i);
                        headersFlags.add(i, true);
                    }
                } else {
                    log.info("whichHeaders != null.");
                    log.info("Przepisanie warto\u015bci z whichHeaders do whichHeadersTmp.");
                    headersFlags.clear();
                    headersFlags.addAll(headersAdditionalFlags);
                    log.info("Przepisanie warto\u015bci powiod\u0142o si\u0119.");
                }
                log.info("tablesFlags: ");
                log.info(((Object)tablesFlags).toString());
                log.info("headersFlags: ");
                log.info(((Object)headersFlags).toString());
                log.info("graphicFlags: ");
                log.info(PrepeareDoc.graphicFlags(tablesGraphicColumnInfo));
                if (tablesFlags.size() == nodes.size() && headersFlags.size() == nodes.size()) {
                    TableUtils.initTableMarkups(templatePath, mappings, tablesMaps, variablesMarker, processId, template, documentPart, tables, tablesFlags, headersFlags, tablesGraphicColumnInfo, pdf);
                    log.info("MarshalToString.");
                    String xml = XmlUtils.marshaltoString((Object)wmlDocumentEl, (boolean)true);
                    log.info("MarshalToString powiodlo sie.");
                    log.info("Uzupe\u0142nianie zmiennych w szablonie.");
                    String tmp = WorkflowUtils.replaceVariablesInTemplate(xml, mappings, variablesMarker);
                    log.info("Uzupelnianie zmiennych w szablonie powiodlo sie.");
                    log.info("UnmarshalString");
                    Object obj = XmlUtils.unmarshalString((String)tmp);
                    log.info("UnmarshalString powiodlo sie.");
                    log.info("Ustawianie elementu JAXB na uzupelniony wartosciami.");
                    documentPart.setJaxbElement((Object)((Document)obj));
                    log.info("Ustawianie elementu JAXB powiodlo sie.");
                    log.info("Kopiowanie styl\u00f3w z tabel bezpo\u015brednio do fragment\u00f3w tekstu");
                    TableUtils.copyTableStylesToRPr(template);
                    log.info("Kopiowanie styl\u00f3w zako\u0144czone.");
                    return PrepeareDoc.saveFile(template, templatePath, pdf, outputFilePath);
                }
                log.error("B\u0141\u0104D - liczba tabel do uzupelnienia na liscie tablesFlags lub headersFlags jest r\u00f3\u017cna od liczby tabel w dokumencie");
            }
            catch (InvalidTemplateException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                log.info("B\u0141\u0104D - przy pobieraniu w\u0119z\u0142\u00f3w z tabelami (z pliku XML - XPath)");
            }
        }
        return null;
    }

    private static String graphicFlags(List<ColumnGraphicInfo> tablesGraphicColumnInfo) {
        StringBuilder sb = new StringBuilder("[");
        for (int index = 0; index < tablesGraphicColumnInfo.size(); ++index) {
            if (index > 0) {
                sb.append(",");
            }
            sb.append(tablesGraphicColumnInfo.get(index).getGraphicColumn());
        }
        sb.append("]");
        return sb.toString();
    }

    private static File saveFile(WordprocessingMLPackage template, String templatePath, boolean pdf, String outputFilePath) throws Docx4JException, IOException {
        SaveToZipFile saver = new SaveToZipFile((OpcPackage)template);
        if (!pdf) {
            log.info("Zapis to pliku docx.");
            saver.save(outputFilePath);
            return new File(outputFilePath);
        }
        if (!PrepeareDoc.isDocFile(templatePath)) {
            return null;
        }
        log.info("Zapis to pliku tymczasowego docx.");
        String tempDocxFilePath = templatePath.replace(".docx", "_" + String.valueOf(System.currentTimeMillis()) + Math.abs(random.nextInt()) + ".docx");
        saver.save(tempDocxFilePath);
        log.info("Zapis do pliku tymczasowego docx powiodl sie: " + tempDocxFilePath);
        File tempdocXFile = new File(tempDocxFilePath);
        log.info(tempdocXFile.getAbsolutePath());
        if (tempdocXFile.exists()) {
            log.info("Wygenerowanie pliku .pdf");
            File tmpFile = PrepeareDoc.doc2PdfWithoutOO(tempDocxFilePath, outputFilePath);
            log.info("Wygenerowanie pliku .pdf powiodlo sie: ".concat(outputFilePath));
            log.info("Usuniecie uzupelnionego szablonu docx: ".concat(tempDocxFilePath));
            if (!tempdocXFile.delete()) {
                log.error(" - problem z usuni\u0119ciem pliku tymczasowego.");
            }
            return tmpFile;
        }
        log.error("B\u0141\u0104D - nowy dokument si\u0119 nie utworzy\u0142, nie ma uzupelnionego szablonu .docx: ".concat(tempDocxFilePath));
        return null;
    }

    private static boolean isDocFile(String path) throws IOException {
        if (path == null) {
            log.error("File path is null");
            return false;
        }
        String fileExtension = FilenameUtils.getExtension((String)path);
        if (!"doc".equals(fileExtension) && !"docx".equals(fileExtension)) {
            String mimeType;
            if ("".equals(fileExtension) && ("application/x-tika-msoffice".equals(mimeType = new Tika().detect(new File(path))) || "application/x-tika-ooxml".equals(mimeType))) {
                return true;
            }
            log.error("File " + path + " is not doc/docx file format");
            return false;
        }
        return true;
    }

    public static void prepareHeaderFooter(WordprocessingMLPackage wordMLPackage, Map<String, Object> mappings, String sVariablesMarker) {
        RelationshipsPart rp = wordMLPackage.getMainDocumentPart().getRelationshipsPart();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            if (r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header")) {
                HeaderPart hp = (HeaderPart)rp.getPart(r);
                WorkflowUtils.replaceVariablesAndSave(hp, mappings, sVariablesMarker);
                log.info("Header replaced correctly");
                continue;
            }
            if (!r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
            FooterPart fp = (FooterPart)rp.getPart(r);
            WorkflowUtils.replaceVariablesAndSave(fp, mappings, sVariablesMarker);
            log.info("Footer replaced correctly");
        }
    }

    public static void createTableWithValues(MainDocumentPart mdp, Tbl table, List<String> lValues, List<Map<String, Object>> lParagraphProperties, ColumnGraphicInfo columnGraphicInfo, WordprocessingMLPackage template, boolean pdf) {
        TableUtils.createTableWithValues(mdp, table, lValues, lParagraphProperties, null, columnGraphicInfo, template, pdf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static File doc2PdfWithoutOO(WfFile inputFile, String sOutputFilePathPdf) throws IOException {
        log.trace("************************* doc2PdfWithout(WfFile inputFile, String sOutputFilePathPdf) ********************");
        if (!PrepeareDoc.isDocFile(inputFile.getFileName())) {
            return null;
        }
        TempFile tempFile = new TempFile();
        try {
            File file;
            Throwable throwable;
            InputStream is;
            block18: {
                block19: {
                    is = ServiceFactory.getFileService().getFileInputStream(Long.valueOf(inputFile.getId()));
                    throwable = null;
                    FileUtils.copyInputStreamToFile((InputStream)is, (File)tempFile.getFile());
                    file = PrepeareDoc.doc2PdfWithoutOO(tempFile.getFile().getPath(), sOutputFilePathPdf);
                    if (is == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                is.close();
            }
            return file;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (is != null) {
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                is.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            tempFile.delete();
        }
        return null;
    }

    public static File doc2PdfWithoutOO(String sInputFilePathDocx, String sOutputFilePathPdf) {
        if (SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.PDF_CONVERTER).equals("Office")) {
            File outputFile = PrepeareDoc.convertByMSWord(sInputFilePathDocx, sOutputFilePathPdf, DocumentType.MS_WORD, DocumentType.PDF);
            if (outputFile != null) {
                return outputFile;
            }
        } else {
            log.trace("************************* doc2PdfWithout(String sInputFilePathDocx, String sOutputFilePathPdf) ********************");
            try {
                log.info("\u0141adowanie WMLPackage z pliku: ".concat(sInputFilePathDocx));
                WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load((File)new File(sInputFilePathDocx));
                if (wordMLPackage != null) {
                    log.info("\u0141adowanie WMLPackage powiod\u0142o si\u0119.");
                    log.info("WMLPackage conversion");
                    BestMatchingMapper fontMapper = new BestMatchingMapper();
                    try {
                        wordMLPackage.setFontMapper((Mapper)fontMapper);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        log.info("B\u0141\u0104D - problem z mapperem!");
                    }
                    log.info("WMLPackage conversion powiod\u0142o si\u0119.");
                    log.info("Tworzenie pliku .fo");
                    File tmp = new File(sInputFilePathDocx + ".fo");
                    log.info("Tworzenie pliku .fo powiod\u0142o si\u0119.");
                    log.info("SetSaveFO pliku .fo");
                    DelegatedFileConversionImageHandler imageHandler = new DelegatedFileConversionImageHandler();
                    FOSettings foSettings = Docx4J.createFOSettings();
                    foSettings.setFoDumpFile(tmp);
                    foSettings.setWmlPackage((OpcPackage)wordMLPackage);
                    foSettings.setImageHandler((ConversionImageHandler)imageHandler);
                    log.info("SetSaveFO powiod\u0142o si\u0119.");
                    File outputFilePdf = new File(sOutputFilePathPdf);
                    try {
                        log.info("Stworzenie FileOutputStream dla pliku: ".concat(sOutputFilePathPdf));
                        FileOutputStream os = new FileOutputStream(outputFilePdf);
                        try {
                            log.info("Ustawienie FileOutputStream.");
                            Docx4J.toFO((FOSettings)foSettings, (OutputStream)os, (int)1);
                            log.info("Ustawienie FileOutputStream powiod\u0142o si\u0119.");
                        }
                        catch (Throwable e) {
                            log.error(e.getMessage(), e);
                            log.info("B\u0141\u0104D - brak pliku, problem z utworzeniem pliku .pdf");
                        }
                        PdfUtils.removeBlankPages(sOutputFilePathPdf);
                        log.info("Zapisano do " + sOutputFilePathPdf);
                    }
                    catch (FileNotFoundException e) {
                        log.error(e.getMessage(), (Throwable)e);
                        log.info("B\u0141\u0104D - brak pliku, problem z utworzeniem pliku .pdf");
                    }
                    if (!tmp.delete()) {
                        log.info("B\u0141\u0104D - problem z usuni\u0119ciem pliku .fo");
                    }
                    imageHandler.cleanUp();
                    return outputFilePdf;
                }
                log.error("B\u0141\u0104D - przy tworzeniu PdfConversion");
            }
            catch (Docx4JException e) {
                log.error(e.getMessage(), (Throwable)e);
                log.info("B\u0141\u0104D - przy tworzeniu wordMLPackage z pliku .docx");
            }
        }
        return null;
    }

    private static File convertByMSWord(String sInputFilePathDocx, String sOutputFilePathPdf, DocumentType fromType, DocumentType toType) {
        try {
            IConverter converter = PdfOfficeConverter.getConverter();
            File wordFile = new File(sInputFilePathDocx);
            File outputFile = new File(sOutputFilePathPdf);
            try {
                converter.convert(wordFile).as(fromType).to(outputFile).as(toType).prioritizeWith(1000).execute();
            }
            catch (ConverterAccessException e) {
                converter = PdfOfficeConverter.forceReloadConverter();
                converter.convert(wordFile).as(fromType).to(outputFile).as(toType).prioritizeWith(1000).execute();
            }
            return outputFile;
        }
        catch (Exception e) {
            log.error("You are using the pdf converter from the Office (System parameters -> Documents -> PdfConverter). Make sure you have Office version at least 2010 installed");
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String replaceVariablesInTemplate(String template, Map<String, Object> mappings, String variablesMarker) {
        return WorkflowUtils.replaceVariablesInTemplate(template, mappings, variablesMarker);
    }

    public static String mergeVariablesTextNodes(String sTemplate, String sVariablesMarker, Map<String, Object> variables) {
        return WorkflowUtils.mergeVariablesTextNodes(sTemplate, sVariablesMarker, variables);
    }

    public static Long createPdfAndSaveInArchive(String sInputFilePathOldDocx, String sOutputDocClassName, HashMap<String, String> hmMappings, List<Map<String, String>> lTables, Map<String, Object> mOptionalParameters) {
        return WorkflowUtils.createPdfAndSaveInArchive(sInputFilePathOldDocx, sOutputDocClassName, hmMappings, lTables, mOptionalParameters);
    }

    public static Long createDocAndSaveInArchive(String sInputFilePathOldDocx, String sOutputDocClassName, HashMap<String, String> hmMappings, List<Map<String, String>> lTables, Map<String, Object> mOptionalParameters, boolean pdf) {
        return WorkflowUtils.createDocAndSaveInArchive(sInputFilePathOldDocx, sOutputDocClassName, hmMappings, lTables, mOptionalParameters, pdf);
    }

    public static Long createPdfAndSaveInArchive(String sInputFilePathOldDocx, String sOutputDocClassName, String sProcessId, Map<String, Object> mOptionalParameters) {
        return WorkflowUtils.createPdfAndSaveInArchive(sInputFilePathOldDocx, sOutputDocClassName, sProcessId, mOptionalParameters);
    }

    public static Long createPdfAndSaveInArchive(String sInputFilePathOldDocx, String sOutputDocClassName, Map<String, Object> mMappings, String sProcessId, Map<String, Object> mOptionalParameters) {
        return WorkflowUtils.createPdfAndSaveInArchive(sInputFilePathOldDocx, sOutputDocClassName, mMappings, sProcessId, mOptionalParameters);
    }

    public static void createTableWithValues(MainDocumentPart mdp, Tbl table, List<String> lValues, List<Map<String, Object>> lParagraphProperties, boolean pdf) {
        PrepeareDoc.createTableWithValues(mdp, table, lValues, lParagraphProperties, null, pdf);
    }

    public static void createTableWithValues(MainDocumentPart mdp, Tbl table, List<String> lValues, List<Map<String, Object>> lParagraphProperties, TrPr rowProperties, boolean pdf) {
        TableUtils.createTableWithValues(mdp, table, lValues, lParagraphProperties, rowProperties, null, null, pdf);
    }

    public static void createTableWithValues(MainDocumentPart mdp, int iTableNr, Tbl table, Map<String, String> mValues, List<Map<String, Object>> lParagraphProperties) {
        TableUtils.createTableWithValues(mdp, iTableNr, table, mValues, lParagraphProperties);
    }

    public static void createTableWithValues(MainDocumentPart mdp, Tbl table, List<String> lValues, List<Map<String, Object>> lParagraphProperties, TrPr rowProperties, ColumnGraphicInfo columnGraphicInfo, WordprocessingMLPackage template, boolean pdf) {
        TableUtils.createTableWithValues(mdp, table, lValues, lParagraphProperties, rowProperties, columnGraphicInfo, template, pdf);
    }
}

