/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.mail;

import com.plusmpm.email.MailClient;
import com.suncode.cuf.mail.Addresses;
import com.suncode.cuf.mail.FileAttachment;
import com.suncode.cuf.mail.MailConfiguration;
import com.suncode.cuf.mail.MailContent;
import com.suncode.cuf.mail.MailSender;
import com.suncode.cuf.mail.SendReport;
import com.suncode.cuf.mail.SystemMailConfiguration;
import com.suncode.pwfl.administration.email.configuration.EmailConfiguration;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.TempFile;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class MailSenderImpl
implements MailSender {
    private static final Logger log = Logger.getLogger(MailSenderImpl.class);

    @Override
    public SendReport send(MailConfiguration cfg, MailContent content, List<String> recipients) {
        if (cfg instanceof SystemMailConfiguration) {
            EmailConfiguration emailConfiguration = ((SystemMailConfiguration)cfg).getEmailConfiguration();
            return this.send(emailConfiguration, content, recipients);
        }
        return this.send(cfg, content, new Addresses(recipients));
    }

    @Override
    public SendReport send(MailConfiguration cfg, MailContent content, Addresses addresses) {
        if (cfg instanceof SystemMailConfiguration) {
            EmailConfiguration emailConfiguration = ((SystemMailConfiguration)cfg).getEmailConfiguration();
            return this.send(emailConfiguration, content, addresses);
        }
        String[] source = cfg.getSourceMail().split("@");
        MailClient client = new MailClient(source[0], cfg.getUser(), cfg.getPassword(), source[1], cfg.getHost(), cfg.getSmtpPort(), String.valueOf(cfg.isSmtpAuthEnabled()), false, cfg.getSourceMail(), String.valueOf(cfg.isSslEnabled()), String.valueOf(cfg.isTlsEnabled()));
        return this.send(client, content, addresses);
    }

    @Override
    public SendReport send(EmailConfiguration cfg, MailContent content, List<String> recipients) {
        MailClient mailClient = new MailClient(cfg);
        return this.send(mailClient, content, new Addresses(recipients));
    }

    @Override
    public SendReport send(EmailConfiguration cfg, MailContent content, Addresses addresses) {
        MailClient mailClient = new MailClient(cfg);
        return this.send(mailClient, content, addresses);
    }

    private SendReport send(MailClient client, MailContent content, Addresses addresses) {
        SendReport report = new SendReport();
        if (addresses.isSendAsOne()) {
            try {
                this.send(client, addresses.getDirectAddresses().toArray(new String[0]), addresses.getCopyAddresses().toArray(new String[0]), addresses.getHiddenCopyAddresses().toArray(new String[0]), content);
                report.getSuccessfulEmails().addAll(addresses.getDirectAddresses());
            }
            catch (MessagingException e) {
                report.getFailedEmails().addAll(addresses.getDirectAddresses());
                log.warn((Object)e.getMessage());
            }
        } else {
            for (String mail : addresses.getDirectAddresses()) {
                try {
                    this.send(client, new String[]{mail}, addresses.getCopyAddresses().toArray(new String[0]), addresses.getHiddenCopyAddresses().toArray(new String[0]), content);
                    report.getSuccessfulEmails().add(mail);
                }
                catch (MessagingException e) {
                    report.getFailedEmails().add(mail);
                    log.warn((Object)e.getMessage());
                }
            }
        }
        return report;
    }

    private void send(MailClient client, String[] mail, String[] cc, String[] bcc, MailContent content) throws MessagingException {
        if (content.hasAttachment()) {
            List<FileAttachment> attachments = content.getAttachedFiles();
            List<TempFile> tempFiles = this.attachDocuments(content, attachments);
            client.sendMessage(mail, cc, bcc, content.getSubject(), content.getContent(), this.getAttachmentsPaths(attachments), this.getAttachmentsNames(attachments), true);
            this.deleteTempFiles(tempFiles);
        } else {
            try {
                client.sendMessage(mail, cc, bcc, content.getSubject(), content.getContent(), true);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private List<TempFile> attachDocuments(MailContent content, List<FileAttachment> attachments) {
        Map<Long, String> documentsNames = content.getDocuments();
        ArrayList<TempFile> tempFiles = new ArrayList<TempFile>();
        for (Long fileId : documentsNames.keySet()) {
            TempFile tempFile = this.createTempFile(fileId);
            if (tempFile == null) continue;
            tempFiles.add(tempFile);
            attachments.add(new FileAttachment(documentsNames.get(fileId), tempFile.getFile().getPath()));
        }
        return tempFiles;
    }

    private void deleteTempFiles(List<TempFile> tempFiles) {
        for (TempFile tempFile : tempFiles) {
            FileUtils.deleteQuietly((File)tempFile.getFile());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TempFile createTempFile(Long fileId) {
        TempFile tempFile = new TempFile();
        try (InputStream inputStream = ServiceFactory.getFileService().getFileInputStream(fileId);){
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile.getFile());
            TempFile tempFile2 = tempFile;
            return tempFile2;
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while creating the temporary file");
        }
    }

    private String[] getAttachmentsNames(List<FileAttachment> attachments) {
        String[] names = new String[attachments.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = attachments.get(i).getName();
        }
        return names;
    }

    private String[] getAttachmentsPaths(List<FileAttachment> attachments) {
        String[] paths = new String[attachments.size()];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = attachments.get(i).getPath();
        }
        return paths;
    }
}

