/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.web.controller;

import com.plusmpm.i18n.I18NCustom;
import com.suncode.cuf.search.hibernate.HibernateFinder;
import com.suncode.cuf.search.hibernate.HibernateQueryDefinition;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.search.CountedResult;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"cuf/documentclass"})
public abstract class AbstractDocumentClassController {
    private static final Logger log = LoggerFactory.getLogger(AbstractDocumentClassController.class);
    @Autowired
    protected HibernateFinder finder;

    protected abstract HibernateFinder getProxy();

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public CountedResult<DocumentClass> find(HttpServletRequest request, @RequestBody HibernateQueryDefinition filter) {
        log.info("find");
        filter.setType(DocumentClass.class);
        Object list = this.getProxy().findCounted(filter);
        list = this.translate(request, (CountedResult<DocumentClass>)list);
        list = this.sort((CountedResult<DocumentClass>)list);
        return list;
    }

    private CountedResult<DocumentClass> translate(HttpServletRequest request, CountedResult<DocumentClass> list) {
        I18NCustom i18nCustom = new I18NCustom(request);
        list.getData().stream().forEach(docClass -> {
            docClass.setName(i18nCustom.getStringSilent(docClass.getName()));
            docClass.setDescription(i18nCustom.getStringSilent(docClass.getDescription()));
        });
        return list;
    }

    private CountedResult<DocumentClass> sort(CountedResult<DocumentClass> list) {
        List sorted = list.getData().stream().sorted(Comparator.comparing(DocumentClass::getName)).collect(Collectors.toList());
        list.setData(sorted);
        return list;
    }
}

