/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension;

import com.plusmpm.CUF.util.extension.SharkClientFunctions;
import com.plusmpm.database.DBManagement;
import com.plusmpm.util.AdvanceSearchResult;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.Tools;
import com.plusmpm.util.workflowData.ProcessData;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.database.DataSourceFactory;
import com.suncode.pwfl.util.SharkUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfservice.ExecutionAdministration;
import org.enhydra.shark.api.client.wfservice.SharkConnection;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public class ScheduledTasksFunction {
    public static Logger log = Logger.getLogger(ScheduledTasksFunction.class);

    public static ArrayList<String> getProcessId(String sVar, String sVarName, String sTableName) {
        log.trace((Object)("****************** getProcessId(sVar=" + sVar + ", sVarName=" + sVarName + ", sTableName=" + sTableName + ") *********************"));
        ArrayList processList = null;
        try {
            DBManagement dbm = new DBManagement();
            HashMap<String, String> hmIndecies = new HashMap<String, String>();
            hmIndecies.put(sVarName, sVar);
            String sProcessDef = sTableName;
            processList = DBManagement.SearchProcess(hmIndecies, (String)sProcessDef);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return processList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean CreateProcess(String sPkgId, String sProcessId, HashMap<String, Object> processContextMap) {
        log.trace((Object)("************** CreateProcess(sPkgId=" + sPkgId + ", sProcessId=" + sProcessId + ", HashMap<String, Object>) **************"));
        WfProcess shProcess = null;
        SharkConnection shConn = null;
        SharkTransaction sharkTransaction = null;
        String sProcName = "";
        String username = Shark.getInstance().getProperties().getProperty("SchedulerToolAgent.sharkUsername");
        String password = SystemProperties.getPassword((DefinedSystemParameter)DefinedSystemParameter.ADMIN_PASSWORD);
        log.info((Object)("Tworzenie procesu......" + sPkgId + " " + sProcessId));
        try {
            shConn = Shark.getInstance().getSharkConnection();
            sharkTransaction = Shark.getInstance().createTransaction();
            shConn.connect(sharkTransaction, username, password, "KlientTestowy", null);
            shProcess = shConn.createProcess(sharkTransaction, sPkgId, sProcessId);
            log.debug((Object)("Creating process OK ..." + sPkgId + " " + sProcessId));
            Package pack = SharkFunctions.getPackageManager().getPackageByProcessId(sProcessId);
            WorkflowProcess wp = pack.getWorkflowProcess(sProcessId);
            if (wp != null) {
                Tools.SetDefaultVariablesForCreateProcess((SharkTransaction)sharkTransaction, (String)"SYSTEM", (WfProcess)shProcess, (String)sProcessId, (Package)pack);
                SharkFunctions.SetProcessContext((SharkTransaction)sharkTransaction, (WfProcess)shProcess, processContextMap);
                log.debug((Object)("Ustawienie contextu zmiennej DocIds dla procesu :" + sProcName + "    OK"));
                DBManagement dbm = new DBManagement();
                dbm.SaveVariableValuesToDB(sharkTransaction, pack, shProcess, processContextMap);
                log.debug((Object)("Starting process:" + sProcName));
                shProcess.start(sharkTransaction);
                log.debug((Object)("Starting process:" + sProcName + " successful"));
            }
            sharkTransaction.commit();
        }
        catch (Throwable throwable) {
            log.debug((Object)("Error in Creating process:" + throwable.getMessage()), throwable);
            try {
                Shark.getInstance().emptyCaches(sharkTransaction);
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                sharkTransaction.rollback();
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (shConn != null) {
                    shConn.disconnect();
                }
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                Shark.getInstance().unlockProcesses(sharkTransaction);
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                sharkTransaction.release();
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean UpdateProces(String sProcessId, String sActivityId, HashMap<String, Object> processContextMap) throws Exception {
        boolean status;
        block24: {
            log.trace((Object)("************************* UpdateProces(sProcessId=" + sProcessId + ", sActivityId=" + sActivityId + ", HashMap<String, Object>) ********************"));
            SharkTransaction sharkTransaction = null;
            status = false;
            try {
                Package pack = SharkFunctions.getPackageManager().getPackageByProcessId(sProcessId);
                sharkTransaction = Shark.getInstance().createTransaction();
                WfProcess wfProcess = SharkFunctions.GetWfProcess((SharkTransaction)sharkTransaction, (ExecutionAdministration)SharkUtils.getExecutionAdministration(), (String)sProcessId);
                if (wfProcess != null) {
                    wfProcess.set_process_context(sharkTransaction, processContextMap);
                    WfActivity curentActivity = SharkFunctions.GetWfActivity((SharkTransaction)sharkTransaction, (ExecutionAdministration)SharkUtils.getExecutionAdministration(), (String)sProcessId, (String)sActivityId);
                    Map a = SharkFunctions.GetActivityContext((WfActivity)curentActivity);
                    if (a.size() != 0) {
                        curentActivity.set_process_context(sharkTransaction, processContextMap);
                    }
                    DBManagement dbm = new DBManagement();
                    dbm.SaveVariableValuesToDB(pack, wfProcess, processContextMap);
                }
                sharkTransaction.commit();
                status = true;
            }
            catch (Throwable throwable) {
                log.error((Object)("Error in Update process: " + throwable.getMessage()), throwable);
                if (sharkTransaction == null) break block24;
                try {
                    Shark.getInstance().emptyCaches(sharkTransaction);
                }
                catch (Exception e1) {
                    log.error((Object)e1.getMessage(), (Throwable)e1);
                }
                try {
                    sharkTransaction.rollback();
                }
                catch (Exception e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
            }
            finally {
                if (sharkTransaction != null) {
                    try {
                        Shark.getInstance().unlockProcesses(sharkTransaction);
                    }
                    catch (Exception e1) {
                        log.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                    try {
                        sharkTransaction.release();
                    }
                    catch (Exception e2) {
                        log.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                }
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean UpdateProces(Map<String, Object> SearchedContext, HashMap<String, Object> processContextMap) throws Exception {
        boolean status;
        block24: {
            log.trace((Object)"************************* UpdateProces(Map<String, Object>, HashMap<String, Object>) ********************");
            String sProcessId = SearchedContext.get("ProccessId").toString();
            String sActivityId = SearchedContext.get("ActivityId").toString();
            SharkTransaction sharkTransaction = null;
            status = false;
            Package pack = SharkFunctions.getPackageManager().getPackageByProcessId(sProcessId);
            String username = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_USERNAME").replaceAll("[\"]", "");
            String password = SystemProperties.getPassword((DefinedSystemParameter)DefinedSystemParameter.ADMIN_PASSWORD);
            sharkTransaction = Shark.getInstance().createTransaction();
            ExecutionAdministration ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
            ea.connect(sharkTransaction, username, password, "KlientTestowy", null);
            WfProcess wfProcess = SharkFunctions.GetWfProcess((SharkTransaction)sharkTransaction, (ExecutionAdministration)ea, (String)sProcessId);
            if (wfProcess != null) {
                wfProcess.set_process_context(sharkTransaction, processContextMap);
                WfActivity curentActivity = SharkFunctions.GetWfActivity((SharkTransaction)sharkTransaction, (ExecutionAdministration)ea, (String)sProcessId, (String)sActivityId);
                Map a = SharkFunctions.GetActivityContext((WfActivity)curentActivity);
                if (a.size() != 0) {
                    curentActivity.set_process_context(sharkTransaction, processContextMap);
                }
                DBManagement dbm = new DBManagement();
                dbm.SaveVariableValuesToDB(pack, wfProcess, processContextMap);
            }
            sharkTransaction.commit();
            status = true;
            if (sharkTransaction == null) break block24;
            try {
                Shark.getInstance().unlockProcesses(sharkTransaction);
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                sharkTransaction.release();
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
            break block24;
            catch (Throwable throwable) {
                try {
                    log.error((Object)("Error in Update process: " + throwable.getMessage()), throwable);
                    if (sharkTransaction != null) {
                        try {
                            Shark.getInstance().emptyCaches(sharkTransaction);
                        }
                        catch (Exception e1) {
                            log.error((Object)e1.getMessage(), (Throwable)e1);
                        }
                        try {
                            sharkTransaction.rollback();
                        }
                        catch (Exception e2) {
                            log.error((Object)e2.getMessage(), (Throwable)e2);
                        }
                    }
                    if (sharkTransaction == null) break block24;
                }
                catch (Throwable throwable2) {
                    if (sharkTransaction != null) {
                        try {
                            Shark.getInstance().unlockProcesses(sharkTransaction);
                        }
                        catch (Exception e1) {
                            log.error((Object)e1.getMessage(), (Throwable)e1);
                        }
                        try {
                            sharkTransaction.release();
                        }
                        catch (Exception e2) {
                            log.error((Object)e2.getMessage(), (Throwable)e2);
                        }
                    }
                    throw throwable2;
                }
                try {
                    Shark.getInstance().unlockProcesses(sharkTransaction);
                }
                catch (Exception e1) {
                    log.error((Object)e1.getMessage(), (Throwable)e1);
                }
                try {
                    sharkTransaction.release();
                }
                catch (Exception e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
            }
        }
        return status;
    }

    public static Map<String, Object> SearchProces(HashMap<String, String> searchVar, String sProcessDefId, String actDefVar, String processState) throws Exception {
        log.trace((Object)("************************* SearchProces(HashMap<String, String>, sProcessDefId=" + sProcessDefId + ", actDefVar=" + actDefVar + ", processState=" + processState + ") ********************"));
        Map<String, Object> mapa = null;
        try {
            ProcessData pd = new ProcessData();
            WorkflowProcess wp = null;
            Package pack = SharkFunctions.getPackageManager().getPackageByProcessDefinitionId(sProcessDefId);
            wp = pack.getWorkflowProcess(sProcessDefId);
            HashMap<String, String> hmAdSearchVar = new HashMap<String, String>();
            ArrayList activeProcVar = new ArrayList();
            ArrayList<String> activeDefVar = new ArrayList<String>();
            activeDefVar.add(actDefVar);
            hmAdSearchVar.putAll(searchVar);
            hmAdSearchVar.put("procDefId", sProcessDefId);
            if (processState.compareToIgnoreCase("STATEPREFIX_OPEN") == 0) {
                hmAdSearchVar.put("procStateSelect", "open*");
            }
            if (processState.compareToIgnoreCase("STATEPREFIX_CLOSED") == 0) {
                hmAdSearchVar.put("procStateSelect", "closed*");
            }
            if (processState.compareToIgnoreCase("STATEPREFIX_OPEN_NOT_RUNNING") == 0) {
                hmAdSearchVar.put("procStateSelect", "open.not_running*");
            }
            if (processState.compareToIgnoreCase("STATE_CLOSED_ABORTED") == 0) {
                hmAdSearchVar.put("procStateSelect", "closed.aborted*");
            }
            if (processState.compareToIgnoreCase("STATE_CLOSED_COMPLETED") == 0) {
                hmAdSearchVar.put("procStateSelect", "closed.completed*");
            }
            if (processState.compareToIgnoreCase("STATE_CLOSED_TERMINATED") == 0) {
                hmAdSearchVar.put("procStateSelect", "closed.terminated*");
            }
            if (processState.compareToIgnoreCase("STATE_OPEN_NOT_RUNNING_NOT_STARTED") == 0) {
                hmAdSearchVar.put("procStateSelect", "open.not_running.not_started*");
            }
            if (processState.compareToIgnoreCase("STATE_OPEN_NOT_RUNNING_SUSPENDED") == 0) {
                hmAdSearchVar.put("procStateSelect", "open.not_running.suspended*");
            }
            if (processState.compareToIgnoreCase("STATE_OPEN_RUNNING") == 0) {
                hmAdSearchVar.put("procStateSelect", "open.running*");
            }
            ArrayList proces = null;
            proces = pd.search(activeProcVar, activeDefVar, hmAdSearchVar, wp);
            if (proces != null && proces.size() > 0) {
                String processID = ((AdvanceSearchResult)proces.get(0)).getProcessId();
                log.debug((Object)"processID: ".concat(processID));
                log.debug((Object)"Znaleziono proces");
                mapa = SharkClientFunctions.getProcessContextMap(processID);
            } else {
                log.error((Object)"Error in Search process: metoda pd.search(...) zwrocila null");
            }
        }
        catch (Throwable throwable) {
            log.error((Object)("Error in Search process: " + throwable.getMessage()), throwable);
        }
        return mapa;
    }

    public static String getQueryFromDB(String processid, String queryName, String sTableName) {
        log.trace((Object)("************************* getQueryFromDB(processid=" + processid + ", queryName=" + queryName + ", sTableName=" + sTableName + ") ********************"));
        String queryResult = "";
        try {
            String query = "SELECT query FROM " + sTableName + " where processid='".concat(processid).concat("' and name='").concat(queryName).concat("'");
            ArrayList<HashMap<String, Object>> result = ScheduledTasksFunction.executeQuery(query);
            if (result.size() > 0 && result.get(0) != null) {
                queryResult = result.get(0).get("query").toString();
            }
        }
        catch (SQLException e) {
            log.error((Object)"Problem getting connection", (Throwable)e);
        }
        catch (NamingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return queryResult;
    }

    public static ArrayList<HashMap<String, Object>> executeQuery(String query) throws SQLException, NamingException {
        log.trace((Object)("************************* executeQuery(query=" + query + ") ********************"));
        ArrayList<HashMap<String, Object>> result = null;
        try (Connection connection = null;){
            DataSource dataSource = DataSourceFactory.getDataSource();
            connection = dataSource.getConnection();
            log.debug((Object)query);
            result = ScheduledTasksFunction.executeQuery(connection, query);
        }
        return result;
    }

    public static ArrayList<HashMap<String, Object>> executeQuery(Connection connection, String query) throws SQLException {
        log.trace((Object)("************************* executeQuery(Connection, query=" + query + ") ********************"));
        Statement stmt = connection.createStatement();
        log.debug((Object)query);
        ResultSet rs = stmt.executeQuery(query);
        ResultSet metaData = (ResultSet)((Object)rs.getMetaData());
        ArrayList<HashMap<String, Object>> result = new ArrayList<HashMap<String, Object>>();
        while (rs.next()) {
            HashMap<String, Object> oneResult = new HashMap<String, Object>();
            for (int i = 0; i < ((ResultSetMetaData)((Object)metaData)).getColumnCount(); ++i) {
                String colLabel = ((ResultSetMetaData)((Object)metaData)).getColumnLabel(i + 1);
                Object val = rs.getObject(colLabel);
                oneResult.put(colLabel, val);
            }
            result.add(oneResult);
        }
        return result;
    }
}

