/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.database.currencyExchangeRates;

import com.plusmpm.CUF.database.currencyExchangeRates.CurrencyExchangeRate;
import com.plusmpm.CUF.util.extension.CUFHibernateUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;

public class CurrencyExchangeRateManager {
    private static Logger log = Logger.getLogger(CurrencyExchangeRateManager.class);

    public static Date getExtremeCurrencyDate(boolean last) throws Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            Date date = null;
            date = last ? (Date)session.createCriteria(CurrencyExchangeRate.class).setProjection((Projection)Projections.max((String)"date")).uniqueResult() : (Date)session.createCriteria(CurrencyExchangeRate.class).setProjection((Projection)Projections.min((String)"date")).uniqueResult();
            transaction.commit();
            Date date2 = date;
            return date2;
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static void clearRatesBeforeDate(Date d) throws Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            List list = session.createCriteria(CurrencyExchangeRate.class).add((Criterion)Restrictions.lt((String)"date", (Object)d)).list();
            for (CurrencyExchangeRate cer : list) {
                session.delete((Object)cer);
            }
            transaction.commit();
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static CurrencyExchangeRate getCurrencyRate(Date startDate, Date endDate, String code) throws Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            DetachedCriteria maxDate = DetachedCriteria.forClass(CurrencyExchangeRate.class);
            maxDate.setProjection((Projection)Property.forName((String)"date").max());
            maxDate.add((Criterion)Restrictions.le((String)"date", (Object)endDate));
            maxDate.add((Criterion)Restrictions.eq((String)"code", (Object)code));
            Date x = (Date)maxDate.getExecutableCriteria(session).uniqueResult();
            Criteria crit = session.createCriteria(CurrencyExchangeRate.class);
            crit.add((Criterion)Restrictions.le((String)"date", (Object)endDate));
            crit.add((Criterion)Restrictions.eq((String)"code", (Object)code));
            crit.add(Property.forName((String)"date").eq(maxDate));
            CurrencyExchangeRate cer = (CurrencyExchangeRate)crit.uniqueResult();
            transaction.commit();
            CurrencyExchangeRate currencyExchangeRate = cer;
            return currencyExchangeRate;
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static boolean validate(CurrencyExchangeRate cer) throws Exception {
        Session hs = null;
        Transaction tx = null;
        try {
            hs = CUFHibernateUtil.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            Criteria crit = hs.createCriteria(CurrencyExchangeRate.class);
            crit.add((Criterion)Restrictions.eq((String)"code", (Object)cer.getCode()));
            crit.add((Criterion)Restrictions.eq((String)"date", (Object)cer.getDate()));
            CurrencyExchangeRate existingCer = (CurrencyExchangeRate)crit.uniqueResult();
            tx.commit();
            return existingCer == null;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            throw e;
        }
    }

    public static void save(List<CurrencyExchangeRate> list) throws Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            for (CurrencyExchangeRate cer : list) {
                if (CurrencyExchangeRateManager.validate(cer)) {
                    log.debug((Object)("code: " + cer.getCode()));
                    log.debug((Object)("data: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SS").format(cer.getDate())));
                    transaction = session.beginTransaction();
                    session.save((Object)cer);
                    transaction.commit();
                    continue;
                }
                log.debug((Object)("Obiekt o kodzie: " + cer.getCode() + "i dacie: " + new SimpleDateFormat("yyyy-MM-dd HH:mm").format(cer.getDate()) + " ju\u017c istnieje"));
            }
        }
        catch (HibernateException e) {
            if (transaction != null && transaction.isActive()) {
                transaction.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static List<String> getCurrencySet(String tableName) throws Exception {
        Session session = null;
        Transaction transaction = null;
        ArrayList<String> list = new ArrayList();
        try {
            session = CUFHibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            list = session.createSQLQuery("select distinct currency from " + tableName).list();
            transaction.commit();
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CUFHibernateUtil.closeSession();
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }
}

