/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.CUF.util.extension.ExcelWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ExportDTSchemeToExcel
extends HttpServlet {
    public static Logger log = Logger.getLogger(ExportDTSchemeToExcel.class);
    private static final long serialVersionUID = 1L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        log.debug((Object)"************************* ExportTableScheme Servlet ****************************");
        req.setCharacterEncoding("UTF-8");
        log.debug((Object)"Params:");
        List<String> headers = this.readHeaders(req.getParameter("headers"));
        for (String h : headers) {
            log.debug((Object)h);
        }
        String title = req.getParameter("title");
        String extension = req.getParameter("extension");
        log.debug((Object)("title: " + title));
        log.debug((Object)("extension: " + extension));
        if (StringUtils.isEmpty((String)title)) {
            title = "Schemat tabeli dynamicznej";
        }
        ExcelWriter ew = new ExcelWriter();
        ew.setExtension(extension);
        ServletOutputStream sos = resp.getOutputStream();
        resp.setContentType(this.getContentType(extension));
        resp.setHeader("Content-Disposition", "attachment; filename=\"" + title + "." + extension + "\"");
        long size = ew.generateScheme(headers, (OutputStream)sos);
        resp.setContentLength((int)size);
    }

    private String getContentType(String extension) {
        if (extension.equals("xls")) {
            return "application/vnd.ms-excel";
        }
        return "application/vnd.ms-excel.12";
    }

    private List<String> readHeaders(String sHeaders) throws JsonParseException, JsonMappingException, IOException {
        log.debug((Object)("headers: " + sHeaders));
        ObjectMapper om = new ObjectMapper();
        List list = (List)om.readValue(sHeaders, (TypeReference)new TypeReference<List<String>>(){});
        return list;
    }
}

