/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension;

import com.plusmpm.database.CommentsTable;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.hibernate.HibernateUtil;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.Tools;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.util.SharkUtils;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfmodel.WfActivityIterator;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfservice.AdminMisc;
import org.enhydra.shark.api.client.wfservice.ExecutionAdministration;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.hibernate.Criteria;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class ProcessManager {
    private static Logger log = Logger.getLogger(ProcessManager.class);

    public String createProcessWithCheckRights(String processDefId, String userId, Map<String, String> variables) throws Exception {
        if (this.canCreateProcess(processDefId, userId)) {
            return this.createProcess(processDefId, userId, variables);
        }
        throw new Exception("no rights");
    }

    public String getOpenActivityIdFromProcess(String processId, String userId) throws Exception {
        SharkTransaction st = null;
        try {
            st = Shark.getInstance().createTransaction();
            String username = Shark.getInstance().getProperties().getProperty("SchedulerToolAgent.sharkUsername").replaceAll("[\"]", "");
            String password = SystemProperties.getPassword((DefinedSystemParameter)DefinedSystemParameter.ADMIN_PASSWORD);
            ExecutionAdministration ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
            ea.connect(st, username, password, "KlientTestowy", null);
            WfProcess wfProcess = ea.getProcess(st, processId);
            WfActivityIterator wai = wfProcess.get_activities_in_state(st, "open.running");
            int actCount = wai.how_many(st);
            if (actCount == 0 && (actCount = (wai = wfProcess.get_activities_in_state(st, "open.not_running.not_started")).how_many(st)) == 0) {
                wai = wfProcess.get_activities_in_state(st, "open.not_running.suspended");
                actCount = wai.how_many(st);
            }
            if (actCount == 0) {
                throw new Exception("no tasks");
            }
            WfActivity act = null;
            for (int i = 0; i < actCount; ++i) {
                WfActivity a = wai.get_next_object(st);
                if (!this.isUserAssignendToActivity(userId, processId, a.key())) continue;
                act = a;
                break;
            }
            if (act == null) {
                throw new Exception("no tasks");
            }
            ea.disconnect(st);
            st.commit();
            String string = act.key();
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            Shark.getInstance().unlockProcesses(st);
            st.release();
        }
    }

    private String createProcess(String processDefId, String userId, Map<String, String> variables) throws Exception {
        String string;
        block6: {
            SharkTransaction sharkTransaction = null;
            try {
                Package pack = SharkFunctions.getPackageManager().getPackageByProcessDefinitionId(processDefId);
                sharkTransaction = Shark.getInstance().createTransaction();
                WfProcess proc = SharkUtils.getSharkConnection().createProcess(sharkTransaction, pack.getId(), processDefId);
                Tools.SetDefaultVariablesForCreateProcess((SharkTransaction)sharkTransaction, (String)userId, (WfProcess)proc, (String)processDefId, (Package)pack);
                Map processContextMap = proc.process_context(sharkTransaction);
                if (variables != null) {
                    processContextMap.putAll(variables);
                }
                proc.set_process_context(sharkTransaction, processContextMap);
                proc.start(sharkTransaction);
                DBManagement dbManagament = new DBManagement();
                dbManagament.SaveVariableValuesToDB(sharkTransaction, pack, proc, null);
                String processId = proc.key(sharkTransaction);
                sharkTransaction.commit();
                string = processId;
                if (sharkTransaction == null) break block6;
            }
            catch (Exception e) {
                try {
                    log.error((Object)e, (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    if (sharkTransaction != null) {
                        SharkFunctions.ClearSharkTransaction(sharkTransaction);
                    }
                    throw throwable;
                }
            }
            SharkFunctions.ClearSharkTransaction((SharkTransaction)sharkTransaction);
        }
        return string;
    }

    private boolean canCreateProcess(String processDefId, String userId) throws SQLException {
        int right = Authorization.checkRight((String)("system.workflow.processes.create." + processDefId), (String)userId, (boolean)false, (boolean)false);
        return right >= 0;
    }

    public void addCommentToProcess(String processId, String comment, String userId) throws Exception {
        CommentsTable ct = new CommentsTable();
        String actId = this.getOpenActivityIdFromProcess(processId, userId);
        if (!this.isUserAssignendToActivity(userId, processId, actId)) {
            throw new Exception("no tasks");
        }
        ct.setActivityId(actId);
        ct.setProcessId(processId);
        ct.setComment(comment);
        ct.setTimestamp(Long.valueOf(new Date().getTime()));
        ct.setUserId(userId);
        DBManagement dbm = new DBManagement();
        dbm.addComments(ct);
    }

    public boolean isUserAssignendToActivity(String userId, String processId, String activityId) throws Exception {
        Session hs = null;
        Transaction tx = null;
        try {
            hs = HibernateUtil.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            String query = "select count(*) from assignmentstable where ";
            query = query + "activityid=:activityId and ";
            query = query + "activityprocessid=:processId and ";
            query = query + "resourceid=:userId ";
            SQLQuery sql = hs.createSQLQuery(query);
            sql.setString("activityId", activityId);
            sql.setString("processId", processId);
            sql.setString("userId", userId);
            BigInteger count = (BigInteger)sql.uniqueResult();
            tx.commit();
            if (count.intValue() == 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    public void removeCommentFromProcess(String processId, String userId) throws Exception {
        Session hs = null;
        Transaction tx = null;
        try {
            hs = HibernateUtil.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            Criteria crit = hs.createCriteria(CommentsTable.class);
            crit.add((Criterion)Restrictions.eq((String)"userId", (Object)userId));
            crit.add((Criterion)Restrictions.eq((String)"processId", (Object)processId));
            crit.addOrder(Order.desc((String)"timestamp"));
            crit.setMaxResults(1);
            CommentsTable ct = (CommentsTable)crit.uniqueResult();
            if (ct == null) {
                throw new Exception("no tasks");
            }
            hs.delete((Object)ct);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    public void deleteProcess(String processId) throws Exception {
        String username = Shark.getInstance().getProperties().getProperty("SchedulerToolAgent.sharkUsername").replaceAll("[\"]", "");
        String password = SystemProperties.getPassword((DefinedSystemParameter)DefinedSystemParameter.ADMIN_PASSWORD);
        ExecutionAdministration ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
        ea.connect(username, password, "KlientTestowy", null);
        WfProcess wfProcess = ea.getProcess(processId);
        log.debug((Object)("Deleting process: " + processId));
        if (wfProcess.state().startsWith("open")) {
            log.debug((Object)"Aborting process.");
            wfProcess.abort();
        }
        String sProcMgrName = wfProcess.manager().name();
        AdminMisc am = Shark.getInstance().getAdminInterface().getAdminMisc();
        String procId = am.getProcessMgrProcDefId(sProcMgrName);
        DBManagement dbm = new DBManagement();
        String sIndecesTable = dbm.GetProcessTypesTable(procId);
        String query = "delete from " + sIndecesTable + " where processid = :processId";
        Session hs = null;
        Transaction tx = null;
        try {
            hs = HibernateUtil.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            SQLQuery sql = hs.createSQLQuery(query);
            sql.setString("processId", processId);
            sql.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
        ea.deleteClosedProcess(processId);
    }

    public String getProcessDefIdByProcessName(String name) {
        DBManagement dbm = new DBManagement();
        List processes = SharkFunctions.getPackageManager().getAllWorkflowProcesses();
        for (WorkflowProcess process : processes) {
            if (!process.getName().equals(name)) continue;
            return process.getId();
        }
        return null;
    }
}

