/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.ActivityAcceptor;
import com.plusmpm.CUF.util.extension.ActivityManager;
import com.plusmpm.CUF.util.extension.ExcelReader;
import com.plusmpm.CUF.util.extension.ProcessManager;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import java.io.File;
import java.io.FileInputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AcceptActivity {
    private Logger log = Logger.getLogger(AcceptActivity.class);
    private ActivityAcceptor acceptor = new ActivityAcceptor();

    public Map<String, Object> convertStrToMap(String str) {
        String[] fields;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (Tools.isNullOrEmpty((String)str)) {
            return map;
        }
        str = str.trim();
        String markerTmp = "<sunCodeMarkerTmp>";
        String marker = "<sunCodeMarker>";
        str = str.replaceAll("\\\\;", markerTmp);
        str = str.replaceAll(";", marker);
        str = str.replaceAll(markerTmp, ";");
        for (String field : fields = str.split(marker)) {
            String[] f;
            if (field.isEmpty() || (f = field.split("=")).length != 2) continue;
            map.put(f[0], f[1]);
        }
        return map;
    }

    @AdvancedTask(name="Akceptacja_zadan", description="Akceptacja_zadan_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void acceptActivity(@TaskParam(name="advancedTask.paramName.activityId", description="advancedTask.paramDesc.activityId") String activityId, @TaskParam(name="advancedTask.paramName.processId", description="advancedTask.paramDesc.processId") String processId, @TaskParam(name="advancedTask.paramName.actionName", description="advancedTask.paramDesc.actionName") String actionName, @TaskParam(name="advancedTask.paramName.login", description="advancedTask.paramDesc.login") String userName, @TaskParam(name="advancedTask.paramName.password", description="advancedTask.paramDesc.password") String password, @TaskParam(name="advancedTask.paramName.variables", description="advancedTask.paramDesc.variables") String variables) throws Throwable {
        activityId = this.readParam(activityId);
        processId = this.readParam(processId);
        actionName = this.readParam(actionName);
        userName = this.readParam(userName);
        password = this.readParam(password);
        variables = this.readParam(variables);
        Map<String, Object> contextMap = this.convertStrToMap(variables);
        this.acceptor.acceptActivity(activityId, processId, actionName, userName, password, contextMap);
    }

    private String readParam(String param) {
        if (param == null) {
            return null;
        }
        if (Tools.isNullOrEmpty((String)(param = param.trim())) || param.equals("null")) {
            param = null;
        }
        return param;
    }

    private Date readDate(String sDate) throws ParseException {
        Date date = null;
        if (!Tools.isNullOrEmpty((String)sDate)) {
            try {
                date = new SimpleDateFormat("yyyy/MM/DD HH:mm").parse(sDate);
            }
            catch (ParseException e) {
                this.log.error((Object)"Data ma nieodpowiedni format");
                throw e;
            }
        }
        return date;
    }

    @AdvancedTask(name="Akceptacja_zadan", description="Akceptacja_zadan_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void acceptActivityByName(@TaskParam(name="advancedTask.paramName.processName", description="advancedTask.paramDesc.processName") String processName, @TaskParam(name="advancedTask.paramName.taskName", description="advancedTask.paramDesc.taskName") String activityName, @TaskParam(name="advancedTask.paramName.actionName", description="advancedTask.paramDesc.actionName") String actionName, @TaskParam(name="advancedTask.paramName.varType", description="advancedTask.paramDesc.varType") String resourceType, @TaskParam(name="advancedTask.paramName.dependentValue", description="advancedTask.paramDesc.dependentValue") String resourceName, @TaskParam(name="advancedTask.paramName.login", description="advancedTask.paramDesc.login") String userName, @TaskParam(name="advancedTask.paramName.password", description="advancedTask.paramDesc.password") String password, @TaskParam(name="advancedTask.paramName.variables", description="advancedTask.paramDesc.variables") String variables, @TaskParam(name="advancedTask.paramName.startDate", description="advancedTask.paramDesc.startDate") String sStartDateFrom, @TaskParam(name="advancedTask.paramName.endDate", description="advancedTask.paramDesc.endDate") String sStartDateTo, @TaskParam(name="advancedTask.paramName.packageVersion", description="advancedTask.paramDesc.packageVersion") int xpdlVersion) throws Throwable {
        processName = this.readParam(processName);
        activityName = this.readParam(activityName);
        activityName = this.readParam(activityName);
        resourceType = this.readParam(resourceType);
        resourceName = this.readParam(resourceName);
        resourceName = this.readParam(resourceName);
        password = this.readParam(password);
        variables = this.readParam(variables);
        sStartDateFrom = this.readParam(sStartDateFrom);
        sStartDateTo = this.readParam(sStartDateTo);
        Date startDateFrom = this.readDate(sStartDateFrom);
        Date startDateTo = this.readDate(sStartDateTo);
        Map<String, Object> contextMap = this.convertStrToMap(variables);
        this.acceptor.acceptActivityByName(processName, activityName, actionName, resourceType, resourceName, userName, password, contextMap, startDateFrom, startDateTo, xpdlVersion);
        this.log.debug((Object)"zadanie zako\u0144czone pomy\u015blnie");
    }

    @AdvancedTask(name="Akceptacja_zadan", description="Akceptacja_zadan_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void acceptActivities(@TaskParam(name="advancedTask.paramName.processDefId", description="advancedTask.paramDesc.processDefId") String processDefId, @TaskParam(name="advancedTask.paramName.activityDefId", description="advancedTask.paramDesc.activityDefId") String activityDefId, @TaskParam(name="advancedTask.paramName.actionName", description="advancedTask.paramDesc.actionName") String actionName, @TaskParam(name="advancedTask.paramName.varType", description="advancedTask.paramDesc.varType") String resourceType, @TaskParam(name="advancedTask.paramName.dependentValue", description="advancedTask.paramDesc.dependentValue") String resourceName, @TaskParam(name="advancedTask.paramName.login", description="advancedTask.paramDesc.login") String userName, @TaskParam(name="advancedTask.paramName.password", description="advancedTask.paramDesc.password") String password, @TaskParam(name="advancedTask.paramName.variables", description="advancedTask.paramDesc.variables") String variables, @TaskParam(name="advancedTask.paramName.startDate", description="advancedTask.paramDesc.startDate") String sStartDateFrom, @TaskParam(name="advancedTask.paramName.endDate", description="advancedTask.paramDesc.endDate") String sStartDateTo, @TaskParam(name="advancedTask.paramName.packageVersion", description="advancedTask.paramDesc.packageVersion") int xpdlVersion) throws Throwable {
        processDefId = this.readParam(processDefId);
        activityDefId = this.readParam(activityDefId);
        actionName = this.readParam(actionName);
        resourceType = this.readParam(resourceType);
        resourceName = this.readParam(resourceName);
        userName = this.readParam(userName);
        password = this.readParam(password);
        variables = this.readParam(variables);
        sStartDateFrom = this.readParam(sStartDateFrom);
        sStartDateTo = this.readParam(sStartDateTo);
        Date startDateFrom = this.readDate(sStartDateFrom);
        Date startDateTo = this.readDate(sStartDateTo);
        Map<String, Object> contextMap = this.convertStrToMap(variables);
        this.acceptor.acceptActivities(processDefId, activityDefId, actionName, resourceType, resourceName, userName, password, contextMap, startDateFrom, startDateTo, xpdlVersion);
    }

    @AdvancedTask(name="Akceptacja_zadan", description="Akceptacja_zadan_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void acceptActivitiesWithoutActions(@TaskParam(name="advancedTask.paramName.processDefId", description="advancedTask.paramDesc.processDefId") String processDefId, @TaskParam(name="advancedTask.paramName.activityDefId", description="advancedTask.paramDesc.activityDefId") String activityDefId, @TaskParam(name="advancedTask.paramName.actionName", description="advancedTask.paramDesc.actionName") String actionName, @TaskParam(name="advancedTask.paramName.varType", description="advancedTask.paramDesc.varType") String resourceType, @TaskParam(name="advancedTask.paramName.dependentValue", description="advancedTask.paramDesc.dependentValue") String resourceName, @TaskParam(name="advancedTask.paramName.login", description="advancedTask.paramDesc.login") String userName, @TaskParam(name="advancedTask.paramName.password", description="advancedTask.paramDesc.password") String password, @TaskParam(name="advancedTask.paramName.variables", description="advancedTask.paramDesc.variables") String variables, @TaskParam(name="advancedTask.paramName.startDate", description="advancedTask.paramDesc.startDate") String sStartDateFrom, @TaskParam(name="advancedTask.paramName.endDate", description="advancedTask.paramDesc.endDate") String sStartDateTo, @TaskParam(name="advancedTask.paramName.packageVersion", description="advancedTask.paramDesc.packageVersion") int xpdlVersion) throws Throwable {
        this.acceptor.setAcceptWithoutActions(true);
        this.acceptActivities(processDefId, activityDefId, actionName, resourceType, resourceName, userName, password, variables, sStartDateFrom, sStartDateTo, xpdlVersion);
        this.acceptor.setAcceptWithoutActions(false);
    }

    @AdvancedTask(name="Akceptacja_zadan", description="Akceptacja_zadan_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void acceptActivitiesFromFile(@TaskParam(name="advancedTask.paramName.filePath", description="advancedTask.paramDesc.filePath") String path) throws Throwable {
        if (Tools.isNullOrEmpty((String)(path = path.trim()))) {
            throw new IllegalArgumentException("Nie podano \u015bcie\u017cki do pliku");
        }
        ExcelReader er = new ExcelReader();
        File f = new File(path);
        FileInputStream fis = new FileInputStream(f);
        String[] cols = new String[]{"activityId", "actionName", "userName", "variables"};
        List<Map<String, Object>> data = er.readExcel(fis, Arrays.asList(cols));
        for (Map<String, Object> map : data) {
            String activityId = (String)map.get(cols[0]);
            String actionName = (String)map.get(cols[1]);
            String userName = (String)map.get(cols[2]);
            String variables = (String)map.get(cols[3]);
            this.acceptActivity(activityId, null, actionName, userName, null, variables);
        }
    }

    @AdvancedTask(name="Akceptacja_zadan", description="Akceptacja_zadan_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void acceptActivitiesByNames(@TaskParam(name="advancedTask.paramName.processDefName", description="advancedTask.paramDesc.processDefName") String processDefName, @TaskParam(name="advancedTask.paramName.activityDefName", description="advancedTask.paramDesc.activityDefName") String activityDefName, @TaskParam(name="advancedTask.paramName.actionName", description="advancedTask.paramDesc.actionName") String actionName, @TaskParam(name="advancedTask.paramName.varType", description="advancedTask.paramDesc.varType") String resourceType, @TaskParam(name="advancedTask.paramName.dependentValue", description="advancedTask.paramDesc.dependentValue") String resourceName, @TaskParam(name="advancedTask.paramName.login", description="advancedTask.paramDesc.login") String userName, @TaskParam(name="advancedTask.paramName.password", description="advancedTask.paramDesc.password") String password, @TaskParam(name="advancedTask.paramName.variables", description="advancedTask.paramDesc.variables") String variables, @TaskParam(name="advancedTask.paramName.startDate", description="advancedTask.paramDesc.startDate") String sStartDateFrom, @TaskParam(name="advancedTask.paramName.endDate", description="advancedTask.paramDesc.endDate") String sStartDateTo, @TaskParam(name="advancedTask.paramName.packageVersion", description="advancedTask.paramDesc.packageVersion") int xpdlVersion) throws Throwable {
        ProcessManager pm = new ProcessManager();
        ActivityManager am = new ActivityManager();
        String processDefId = pm.getProcessDefIdByProcessName(processDefName);
        if (processDefId == null) {
            throw new IllegalArgumentException("Nie znaleziono procesu o podanej nazwie");
        }
        String activityDefId = am.getActivityDefIdByName(processDefId, activityDefName);
        if (activityDefId == null) {
            throw new IllegalArgumentException("Nie znaleziono zadania o podanej nazwie");
        }
        this.acceptActivities(processDefId, activityDefId, actionName, resourceType, resourceName, userName, password, variables, sStartDateFrom, sStartDateTo, xpdlVersion);
    }
}

