/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.database.sql;

import com.plusmpm.CUF.database.sql.CufNativeSql;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MicrosoftNativeSQL
implements CufNativeSql {
    @Override
    public List<String> getCreateSynchronizedTableQuery(String tableName, String[] columnNames, String[] columnTypes) {
        String[] result = new String[]{this.createQuery(tableName, columnNames, columnTypes)};
        return Arrays.asList(this.createQuery(tableName, columnNames, columnTypes));
    }

    private String createQuery(String tableName, String[] columnNames, String[] columnTypes) {
        StringBuilder tableCreateQuery = new StringBuilder();
        tableCreateQuery.append("CREATE TABLE [");
        tableCreateQuery.append(tableName);
        tableCreateQuery.append("] ([id] [bigint] IDENTITY(1,1)");
        for (int i = 0; i < columnNames.length; ++i) {
            tableCreateQuery.append(", ");
            tableCreateQuery.append(columnNames[i]);
            tableCreateQuery.append(" ");
            tableCreateQuery.append(this.getColumnTypeAsString(columnTypes[i]));
        }
        tableCreateQuery.append(", [criteria] [nvarchar](1024), [dateofrecordcheck] [datetime2](3), [connectionname] [nvarchar](1024))");
        return tableCreateQuery.toString();
    }

    @Override
    public String getColumnTypeAsString(String columnType) {
        if (columnType.compareToIgnoreCase("integer") == 0 || columnType.compareToIgnoreCase("int8") == 0) {
            return "[int]";
        }
        if (columnType.compareToIgnoreCase("float") == 0 || columnType.compareToIgnoreCase("float8") == 0) {
            return "[float]";
        }
        if (columnType.compareToIgnoreCase("double") == 0 || columnType.compareToIgnoreCase("double8") == 0) {
            return "[double]";
        }
        if (columnType.compareToIgnoreCase("datetime") == 0 || columnType.compareToIgnoreCase("datetime2") == 0 || columnType.compareToIgnoreCase("timestamp") == 0) {
            return "[datetime2](3)";
        }
        return "[nvarchar](1024)";
    }

    @Override
    public List<String> getCreateColumnQuery(String tableName, String columnName, String columnType) {
        ArrayList<String> queries = new ArrayList<String>();
        String createColumnQuery = "ALTER TABLE " + tableName + " ADD " + columnName + " " + this.getColumnTypeAsString(columnType);
        queries.add(createColumnQuery);
        if (columnType.compareToIgnoreCase("nvarchar") == 0) {
            String setDefaultColumnQuery = "ALTER TABLE " + tableName + " ADD CONSTRAINT DF_" + columnName + " DEFAULT N'' FOR " + columnName;
            queries.add(setDefaultColumnQuery);
        }
        return queries;
    }

    @Override
    public void setStatementParameter(PreparedStatement statement, String columnType, String value, int position) throws NumberFormatException, SQLException {
        if (columnType.compareToIgnoreCase("integer") == 0 || columnType.compareToIgnoreCase("int8") == 0 || columnType.compareToIgnoreCase("bigint") == 0) {
            statement.setInt(position, Integer.valueOf(value));
        } else if (columnType.compareToIgnoreCase("float") == 0 || columnType.compareToIgnoreCase("float8") == 0) {
            statement.setFloat(position, Float.valueOf(value).floatValue());
        } else if (columnType.compareToIgnoreCase("double") == 0 || columnType.compareToIgnoreCase("double8") == 0) {
            statement.setDouble(position, Double.valueOf(value));
        } else if (columnType.compareToIgnoreCase("datetime") == 0 || columnType.compareToIgnoreCase("datetime2") == 0 || columnType.compareToIgnoreCase("timestamp") == 0) {
            statement.setTimestamp(position, Timestamp.valueOf(value));
        } else {
            statement.setString(position, value);
        }
    }

    @Override
    public List<String> getClearTableQueries(String sTableName) {
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder clearTableQuery = new StringBuilder();
        clearTableQuery.append("DELETE FROM ");
        clearTableQuery.append(sTableName);
        queries.add(clearTableQuery.toString());
        return queries;
    }

    @Override
    public List<String> getDropTableQueries(String tableName) {
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder deleteTableQuery = new StringBuilder();
        deleteTableQuery.append("DROP TABLE ");
        deleteTableQuery.append(tableName);
        queries.add(deleteTableQuery.toString());
        return queries;
    }
}

