/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration.structure.helper;

import com.google.common.collect.Lists;
import com.suncode.cuf.exception.CUFServiceException;
import com.suncode.cuf.io.office.model.CellValue;
import com.suncode.cuf.io.office.model.SheetDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StructureData {
    private List<Map<String, CellValue<String>>> users;
    private List<Map<String, CellValue<String>>> positions;
    private List<Map<String, CellValue<String>>> orgUnits;
    private List<Map<String, CellValue<String>>> groups;

    public StructureData(List<SheetDefinition> sheets) {
        this.groups = this.getSheet(sheets, "Grupy");
        this.orgUnits = this.getSheet(sheets, "Jednostki organizacyjne");
        this.positions = this.getSheet(sheets, "Stanowiska");
        this.users = this.getSheet(sheets, "U\u017cytkownicy");
    }

    private List<Map<String, CellValue<String>>> getSheet(List<SheetDefinition> struct, String name) {
        for (SheetDefinition excelSheet : struct) {
            if (!excelSheet.getName().equals(name)) continue;
            ArrayList result = Lists.newArrayList();
            for (Map<String, CellValue<?>> source : excelSheet.getImportCellData()) {
                HashMap map = new HashMap();
                for (Map.Entry<String, CellValue<?>> entry : source.entrySet()) {
                    map.put(entry.getKey(), entry.getValue());
                }
                result.add(map);
            }
            return result;
        }
        throw new CUFServiceException("Sheet with name " + name + " not found");
    }

    public List<Map<String, CellValue<String>>> getUsers() {
        return this.users;
    }

    public List<Map<String, CellValue<String>>> getPositions() {
        return this.positions;
    }

    public List<Map<String, CellValue<String>>> getOrgUnits() {
        return this.orgUnits;
    }

    public List<Map<String, CellValue<String>>> getGroups() {
        return this.groups;
    }
}

