/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.database.externalDBConf.ExternalDBConf;
import com.plusmpm.CUF.database.externalDBConf.ExternalDBConfManager;
import com.plusmpm.CUF.database.queryDataChooser.QueryDataChooser;
import com.plusmpm.CUF.database.queryDataChooser.QueryDataChooserManager;
import com.plusmpm.CUF.database.sql.CufNativeSql;
import com.plusmpm.CUF.database.sql.CufNativeSqlFactory;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.pwfl.database.DBUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ExternalDBSync
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ExternalDBSync.class);
    private static boolean hasOwnConnection = true;
    private CufNativeSql nativeSql = CufNativeSqlFactory.getNativeSql();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AdvancedTask(name="ExternalDBSync", description="ExternalDBSync_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void Sync(@TaskParam(name="advancedTask.paramName.configurationName", description="advancedTask.paramDesc.configurationNameEDBS") String sNames, @TaskParam(name="advancedTask.paramName.queryName", description="advancedTask.paramDesc.queryName") String sQueryName, @TaskParam(name="tablename", description="advancedTask.paramDesc.tableNameEDBS") String sTableName, @TaskParam(name="advancedTask.paramName.criteria", description="advancedTask.paramDesc.criteria") String sCriteria) {
        log.info((Object)("************************ Sync(sNames=" + sNames + ", sQueryName=" + sQueryName + ", sTableName=" + sTableName + ", sCriteria=" + sCriteria + ") *************************"));
        long startTime = new Date().getTime();
        Connection con = null;
        Connection internalCon = null;
        ArrayList<HashMap<String, String>> results = null;
        ArrayList<HashMap<String, String>> types = null;
        List<ExternalDBConf> conParamsList = null;
        boolean deleteNeeded = false;
        try {
            String[] namesTable;
            sTableName = sTableName.toLowerCase();
            sCriteria = sCriteria.toLowerCase();
            for (String name : namesTable = sNames.split(",")) {
                log.debug((Object)("Pobieranie parametrow polaczenia z zewnetrzna baza danych dla identyfikatora: " + name));
                conParamsList = ExternalDBConfManager.getExternalDBConfForName(name);
                if (conParamsList != null && conParamsList.size() > 0) {
                    for (int i = 0; i < conParamsList.size(); ++i) {
                        results = new ArrayList();
                        types = new ArrayList();
                        String url = conParamsList.get(i).getUrl();
                        String driver = conParamsList.get(i).getDriver();
                        String login = conParamsList.get(i).getLogin();
                        String password = conParamsList.get(i).getPassword();
                        try {
                            if (driver != null) {
                                Class.forName(driver);
                            }
                        }
                        catch (Exception e) {
                            taskLog.error((Object)e.getMessage());
                            log.debug((Object)"Niepoprawny sterownik");
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                        try {
                            con = DriverManager.getConnection(url, login, password);
                            if (con != null) {
                                log.debug((Object)("Uzyskano polaczenie z " + url));
                                log.debug((Object)("Pobieranie zapytania dla identyfikatora: " + sQueryName));
                                List<QueryDataChooser> sQueries = QueryDataChooserManager.getQueryDataChooserForName(sQueryName);
                                if (sQueries != null && sQueries.size() > 0) {
                                    String sQuery = sQueries.get(0).getQuery();
                                    results = this.executeQuery(con, sQuery);
                                    results = this.lowerCase(results);
                                    types = this.getTypes(con, sQuery);
                                    types = this.lowerCase(types);
                                    if (results != null && results.size() > 0 && types != null && types.size() > 0) {
                                        String[] columnNames = new String[results.get(0).size()];
                                        String[] columnTypes = new String[results.get(0).size()];
                                        Iterator<String> namesIterator = results.get(0).keySet().iterator();
                                        int counter = 0;
                                        while (namesIterator.hasNext()) {
                                            columnNames[counter] = namesIterator.next();
                                            columnTypes[counter] = types.get(0).get(columnNames[counter]);
                                            log.debug((Object)("Pole: " + columnNames[counter] + ", typ: " + columnTypes[counter]));
                                            ++counter;
                                        }
                                        internalCon = DBUtils.connectToDB();
                                        if (internalCon != null) {
                                            DatabaseMetaData databaseMetaData = internalCon.getMetaData();
                                            if (databaseMetaData.supportsTransactionIsolationLevel(1)) {
                                                internalCon.setTransactionIsolation(1);
                                            }
                                            ResultSet tables = databaseMetaData.getTables(null, null, sTableName, null);
                                            Statement statement = null;
                                            if (tables.next()) {
                                                log.debug((Object)("Tabela " + sTableName + " istnieje w wewnetrznej bazie danych"));
                                                log.debug((Object)"Sprawdzanie zgodnosci ilosci kolumn");
                                                deleteNeeded = true;
                                                statement = internalCon.createStatement();
                                                ResultSet allFromTable = statement.executeQuery("SELECT * FROM " + sTableName);
                                                ResultSetMetaData checkColumnsData = allFromTable.getMetaData();
                                                boolean columnExists = false;
                                                for (int l = 0; l < columnNames.length; ++l) {
                                                    columnExists = false;
                                                    for (int k = 1; k < checkColumnsData.getColumnCount() + 1; ++k) {
                                                        if (checkColumnsData.getColumnName(k).compareToIgnoreCase(columnNames[l]) != 0) continue;
                                                        columnExists = true;
                                                        break;
                                                    }
                                                    if (columnExists) continue;
                                                    log.debug((Object)("Dodawanie nowej kolumny " + columnNames[l] + " typu " + columnTypes[l] + " do tabeli " + sTableName));
                                                    List<String> createColumnQueries = this.nativeSql.getCreateColumnQuery(sTableName, columnNames[l], columnTypes[l]);
                                                    for (String query : createColumnQueries) {
                                                        log.debug((Object)("Query: " + query));
                                                        statement.addBatch(query);
                                                    }
                                                }
                                                statement.executeBatch();
                                            } else {
                                                log.debug((Object)("Tabela " + sTableName + " nie istnieje w wewnetrznej bazie danych"));
                                                log.debug((Object)("Tworzenie tabeli " + sTableName));
                                                deleteNeeded = false;
                                                try {
                                                    statement = internalCon.createStatement();
                                                    List<String> batchQueries = this.getCreateIndicesTableQueries(sTableName, columnNames, columnTypes);
                                                    if (batchQueries.size() > 1) {
                                                        for (String createQuery : batchQueries) {
                                                            statement.addBatch(createQuery);
                                                            log.debug((Object)("Query: " + createQuery));
                                                        }
                                                        statement.executeBatch();
                                                    } else {
                                                        log.debug((Object)("Query: " + batchQueries.get(0)));
                                                        statement.executeUpdate(batchQueries.get(0));
                                                    }
                                                }
                                                catch (SQLException sqle) {
                                                    taskLog.error((Object)sqle.getMessage());
                                                    log.error((Object)sqle.getMessage(), (Throwable)sqle);
                                                }
                                            }
                                            long time = this.addResults(internalCon, results, columnNames, columnTypes, sTableName, sCriteria, name);
                                            if (deleteNeeded) {
                                                boolean state = false;
                                                if (time != -1L) {
                                                    log.debug((Object)"Usuwanie nieautualnych rekordow");
                                                    state = this.deleteResults(internalCon, sTableName, name, time);
                                                } else {
                                                    log.debug((Object)"Rekordy nie beda usuwane, gdyz wystapil blad w funkcji dodawania rekordow (funkcja addResults)");
                                                }
                                                if (state) {
                                                    log.debug((Object)"Proces usuwania nieaktualnych rekordow zakonczony powodzeniem");
                                                } else {
                                                    log.debug((Object)("Proces usuwania nieaktualnych rekordow zakonczony niepowodzeniem. Mozliwosc wystepowania niepoprawnych danych w tabeli " + sTableName));
                                                }
                                            }
                                            if (statement != null) {
                                                statement.close();
                                            }
                                        } else {
                                            log.debug((Object)"Brak polaczenia z wewnetrzna baza danych");
                                        }
                                        try {
                                            if (internalCon == null || internalCon.isClosed()) continue;
                                            internalCon.close();
                                        }
                                        catch (Exception e) {
                                            taskLog.error((Object)e.getMessage());
                                            log.error((Object)e.getMessage(), (Throwable)e);
                                        }
                                        continue;
                                    }
                                    if (results == null || results.size() == 0) {
                                        log.debug((Object)"Brak wynikow zapytania");
                                    }
                                    if (types != null && types.size() != 0) continue;
                                    log.debug((Object)"Blad w uzyskaniu typow kolumn");
                                    continue;
                                }
                                log.warn((Object)("Brak zapytania dla identyfikatora: " + sQueryName));
                                continue;
                            }
                            log.warn((Object)"Brak polaczenia z zewnetrzna baza danych");
                            continue;
                        }
                        catch (Exception e) {
                            taskLog.error((Object)e.getMessage());
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    continue;
                }
                log.warn((Object)("Brak konfiguracji polaczenia o nazwie: " + name));
            }
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (con != null && !con.isClosed()) {
                    con.close();
                }
            }
            catch (Exception e) {
                taskLog.error((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego Sync: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    @AdvancedTask(name="ClearInternalTable", description="ClearInternalTable_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ClearInternalTable(@TaskParam(name="tablename", description="advancedTask.paramDesc.tableNameEDBS") String sTableName) {
        hasOwnConnection = false;
        this.ClearInternalTable(sTableName, DBUtils.connectToDB());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AdvancedTask(name="ClearInternalTable", description="ClearInternalTable_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ClearInternalTable(@TaskParam(name="tablename", description="advancedTask.paramDesc.tableNameEDBS") String sTableName, @TaskParam(name="advancedTask.paramName.connection", description="advancedTask.paramDesc.connection") Connection con) {
        log.info((Object)("************************ ClearInternalTable(sTableName=" + sTableName + ") *************************"));
        long startTime = new Date().getTime();
        Connection internalCon = null;
        Statement statement = null;
        try {
            internalCon = DBUtils.connectToDB();
            if (internalCon != null) {
                ResultSet tables;
                DatabaseMetaData databaseMetaData = internalCon.getMetaData();
                if (databaseMetaData.supportsTransactionIsolationLevel(1) && con.getTransactionIsolation() != 1) {
                    internalCon.setTransactionIsolation(1);
                }
                if ((tables = databaseMetaData.getTables(null, null, sTableName, null)).next()) {
                    statement = internalCon.createStatement();
                    List<String> clearQueries = this.nativeSql.getClearTableQueries(sTableName);
                    for (String query : clearQueries) {
                        log.debug((Object)query);
                        statement.addBatch(query);
                    }
                    statement.executeBatch();
                    log.info((Object)("Tabela " + sTableName + " zostala wyczyszczona"));
                } else {
                    log.warn((Object)("Tabela " + sTableName + " nie istnieje w wewnetrznej bazie danych. Sprawdz parametr zadania"));
                }
            } else {
                log.warn((Object)"Brak polaczenia z wewnetrzna baza danych");
            }
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (!hasOwnConnection) {
                try {
                    if (internalCon != null && !internalCon.isClosed()) {
                        internalCon.close();
                    }
                }
                catch (Exception e) {
                    taskLog.error((Object)e.getMessage());
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                taskLog.error((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            hasOwnConnection = true;
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ClearInternalTable: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AdvancedTask(name="DeleteInternalTable", description="DeleteInternalTable_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void DeleteInternalTable(@TaskParam(name="tablename", description="advancedTask.paramDesc.tableNameEDBS") String sTableName) {
        log.info((Object)("************************ DeleteInternalTable(sTableName=" + sTableName + ") *************************"));
        long startTime = new Date().getTime();
        Connection internalCon = null;
        Statement statement = null;
        try {
            internalCon = DBUtils.connectToDB();
            if (internalCon != null) {
                ResultSet tables;
                DatabaseMetaData databaseMetaData = internalCon.getMetaData();
                if (databaseMetaData.supportsTransactionIsolationLevel(1)) {
                    internalCon.setTransactionIsolation(1);
                }
                if ((tables = databaseMetaData.getTables(null, null, sTableName, null)).next()) {
                    statement = internalCon.createStatement();
                    List<String> queries = this.nativeSql.getDropTableQueries(sTableName);
                    for (String query : queries) {
                        log.debug((Object)query);
                        statement.addBatch(query);
                    }
                    statement.executeBatch();
                    log.info((Object)("Tabela " + sTableName + " zostala usunieta z wewnetrznej bazy danych"));
                } else {
                    log.warn((Object)("Tabela " + sTableName + " nie istnieje w wewnetrznej bazie danych. Sprawdz parametr zadania"));
                }
            } else {
                log.warn((Object)"Brak polaczenia z wewnetrzna baza danych");
            }
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (internalCon != null && !internalCon.isClosed()) {
                    internalCon.close();
                }
            }
            catch (Exception e) {
                taskLog.error((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                taskLog.error((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego DeleteInternalTable: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    private ArrayList<HashMap<String, String>> getTypes(Connection con, String query) throws Exception {
        log.trace((Object)("************************* getTypes(Connection, query=" + query + ") ********************"));
        ArrayList<HashMap<String, String>> results = null;
        Statement stmt = null;
        ResultSet rset = null;
        try {
            results = new ArrayList<HashMap<String, String>>();
            DatabaseMetaData metaData = con.getMetaData();
            if (metaData.supportsTransactionIsolationLevel(1)) {
                con.setTransactionIsolation(1);
            }
            stmt = con.createStatement();
            rset = stmt.executeQuery(query);
            ResultSetMetaData rsmd = rset.getMetaData();
            int numColumns = rsmd.getColumnCount();
            while (rset.next()) {
                HashMap<String, String> oneRow = new HashMap<String, String>();
                for (int i = 1; i < numColumns + 1; ++i) {
                    String columnName = rsmd.getColumnName(i);
                    String type = rsmd.getColumnTypeName(i);
                    oneRow.put(columnName, type);
                }
                results.add(oneRow);
            }
            ArrayList<HashMap<String, String>> arrayList = results;
            return arrayList;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private List<String> getCreateIndicesTableQueries(String tableName, String[] columnNames, String[] columnTypes) throws IllegalArgumentException {
        log.trace((Object)("************************* getCreateIndicesTableQueries(tableName=" + tableName + ", String[], String[]) ********************"));
        if (columnNames.length != columnTypes.length) {
            throw new IllegalArgumentException("Rozmiar tablicy z nazwami kolumn jest inny ni\u017c rozmiar tablicy z typami.");
        }
        return this.nativeSql.getCreateSynchronizedTableQuery(tableName, columnNames, columnTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addResults(Connection con, ArrayList<HashMap<String, String>> newResults, String[] columnNames, String[] columnTypes, String sTableName, String sCriteria, String connectionName) throws SQLException {
        log.trace((Object)("************************* addResults(Connection, ArrayList<HashMap<String, String>>, String[], String[], sTableName=" + sTableName + ", sCriteria=" + sCriteria + ", connectionName=" + connectionName + ") ********************"));
        Statement statement = null;
        ArrayList<HashMap<String, String>> oldResults = null;
        Date date = new Date();
        long time = date.getTime();
        try {
            int i;
            int i2;
            log.info((Object)"Dodawanie i uaktualnianie rekordow");
            StringBuilder insertQuery = new StringBuilder();
            insertQuery.append("INSERT INTO ");
            insertQuery.append(sTableName);
            insertQuery.append(" (");
            for (i2 = 0; i2 < newResults.get(0).size() + 1; ++i2) {
                if (i2 != newResults.get(0).size()) {
                    insertQuery.append(columnNames[i2] + ", ");
                    continue;
                }
                insertQuery.append("criteria, dateofrecordcheck, connectionname)");
            }
            insertQuery.append(" VALUES (");
            for (i2 = 0; i2 < newResults.get(0).size() + 1; ++i2) {
                if (i2 != newResults.get(0).size()) {
                    insertQuery.append("?, ");
                    continue;
                }
                insertQuery.append("?, ?, ?)");
            }
            String sqlInsert = insertQuery.toString();
            log.debug((Object)("INSERT query: " + sqlInsert));
            StringBuilder updateQuery = new StringBuilder();
            updateQuery.append("UPDATE ");
            updateQuery.append(sTableName);
            updateQuery.append(" SET ");
            for (int i3 = 0; i3 < newResults.get(0).size() + 1; ++i3) {
                if (i3 != newResults.get(0).size()) {
                    updateQuery.append(columnNames[i3] + "=?, ");
                    continue;
                }
                updateQuery.append("criteria=?, dateofrecordcheck=?, connectionname=?");
            }
            updateQuery.append(" WHERE ");
            if (StringUtils.isBlank((String)sCriteria) && sCriteria.compareToIgnoreCase(" ") == 0) {
                log.warn((Object)"Blad w definicji kryteriow wyszukiwania");
                long i3 = -1L;
                return i3;
            }
            String[] criteriaSplit = sCriteria.split(",");
            for (int i4 = 0; i4 < criteriaSplit.length; ++i4) {
                updateQuery.append(criteriaSplit[i4]);
                if (i4 != criteriaSplit.length - 1) {
                    updateQuery.append("=? AND ");
                    continue;
                }
                updateQuery.append("=?");
            }
            String sqlUpdate = updateQuery.toString();
            log.debug((Object)("UPDATE query: " + sqlUpdate));
            String oldQuery = "SELECT * FROM " + sTableName;
            oldResults = this.executeQuery(con, oldQuery);
            oldResults = this.lowerCase(oldResults);
            statement = con.prepareStatement(sqlInsert);
            for (i = 0; i < newResults.size(); ++i) {
                newResults.get(i).put("connectionname", connectionName);
            }
            for (i = 0; i < newResults.size(); ++i) {
                int recordExists = 0;
                int range = newResults.get(i).size();
                if (oldResults != null && oldResults.size() > 0) {
                    for (int k = 0; k < oldResults.size(); ++k) {
                        recordExists = 0;
                        for (int w = 0; w < criteriaSplit.length; ++w) {
                            if (oldResults.get(k).get(criteriaSplit[w]).compareToIgnoreCase(newResults.get(i).get(criteriaSplit[w])) != 0) continue;
                            ++recordExists;
                        }
                        if (recordExists == criteriaSplit.length) break;
                    }
                    statement = recordExists == criteriaSplit.length ? con.prepareStatement(sqlUpdate) : con.prepareStatement(sqlInsert);
                }
                for (int j = 0; j < range; ++j) {
                    if (j < newResults.get(i).size() - 1) {
                        this.nativeSql.setStatementParameter((PreparedStatement)statement, columnTypes[j], newResults.get(i).get(columnNames[j]), j + 1);
                        continue;
                    }
                    statement.setString(j + 1, sCriteria);
                    statement.setTimestamp(j + 2, new Timestamp(time));
                    statement.setString(j + 3, connectionName);
                    if (recordExists != criteriaSplit.length) continue;
                    for (int z = 0; z < criteriaSplit.length; ++z) {
                        String criteriaType = "";
                        for (int e = 0; e < columnNames.length; ++e) {
                            if (criteriaSplit[z].compareToIgnoreCase(columnNames[e]) != 0) continue;
                            criteriaType = columnTypes[e];
                            break;
                        }
                        this.nativeSql.setStatementParameter((PreparedStatement)statement, criteriaType, newResults.get(i).get(criteriaSplit[z]), j + 4 + z);
                    }
                }
                statement.execute();
                statement.clearParameters();
            }
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            long l = -1L;
            return l;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                taskLog.error((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteResults(Connection con, String sTableName, String connectionName, Long time) {
        log.trace((Object)("************************* deleteResults(Connection, sTableName=" + sTableName + ", connectionName=" + connectionName + ", time=" + String.valueOf(time) + ") ********************"));
        boolean state = false;
        Statement statement = null;
        try {
            Timestamp timestamp = new Timestamp(time);
            StringBuilder deleteQuery = new StringBuilder();
            deleteQuery.append("DELETE FROM ");
            deleteQuery.append(sTableName);
            deleteQuery.append(" WHERE dateofrecordcheck<? AND connectionname=?");
            String sqlDelete = deleteQuery.toString();
            log.debug((Object)sqlDelete);
            statement = con.prepareStatement(sqlDelete);
            statement.setTimestamp(1, timestamp);
            statement.setString(2, connectionName);
            statement.execute();
            state = true;
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            state = false;
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                taskLog.error((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return state;
    }

    private ArrayList<HashMap<String, String>> lowerCase(ArrayList<HashMap<String, String>> list) {
        log.trace((Object)"************ lowerCase(ArrayList<HashMap<String, String>>) ************");
        ArrayList<HashMap<String, String>> results = new ArrayList<HashMap<String, String>>();
        try {
            for (int i = 0; i < list.size(); ++i) {
                HashMap<String, String> oneHashMap = list.get(i);
                HashMap<String, String> oneRow = new HashMap<String, String>();
                for (String key : oneHashMap.keySet()) {
                    String value = oneHashMap.get(key);
                    key = key.toLowerCase();
                    oneRow.put(key, value);
                }
                results.add(oneRow);
            }
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return results;
    }

    private ArrayList<HashMap<String, String>> executeQuery(Connection con, String query) throws Exception {
        log.trace((Object)("************************* executeQuery(Connection, query=" + query + ") ********************"));
        ArrayList<HashMap<String, String>> results = null;
        ResultSet rset = null;
        try (Statement stmt = null;){
            results = new ArrayList<HashMap<String, String>>();
            Date dtStart = new Date();
            log.debug((Object)("Wykonanie zapytania: " + query));
            DatabaseMetaData metaData = con.getMetaData();
            if (metaData.supportsTransactionIsolationLevel(1) && con.getTransactionIsolation() != 1) {
                con.setTransactionIsolation(1);
            }
            stmt = con.createStatement();
            rset = stmt.executeQuery(query);
            ResultSetMetaData rsmd = rset.getMetaData();
            int numColumns = rsmd.getColumnCount();
            while (rset.next()) {
                HashMap<String, String> oneRow = new HashMap<String, String>();
                for (int i = 1; i < numColumns + 1; ++i) {
                    String columnName = rsmd.getColumnName(i);
                    String value = rset.getString(columnName);
                    if (value == null) {
                        value = "";
                    }
                    oneRow.put(columnName, value);
                }
                results.add(oneRow);
            }
            log.debug((Object)("Ilosc zwroconych wynikow: " + results.size()));
            Date dtEnd = new Date();
            log.debug((Object)("Przyblizony czas wykonania zapytania: " + (dtEnd.getTime() - dtStart.getTime())));
            ArrayList<HashMap<String, String>> arrayList = results;
            return arrayList;
        }
    }
}

