/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.io.office;

import com.google.common.collect.Lists;
import com.suncode.cuf.exception.CUFServiceException;
import com.suncode.cuf.io.office.model.CellValue;
import com.suncode.cuf.io.office.model.DuplicatedColumnException;
import com.suncode.cuf.io.office.model.ImportSheetDefinition;
import com.suncode.cuf.io.office.model.SheetDefinition;
import com.suncode.cuf.io.office.model.reader.ValueReader;
import com.suncode.cuf.io.office.model.reader.ValueReaderResolver;
import com.suncode.cuf.util.ContextLogger;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.ValidationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;

public class ExcelReader {
    private String[] keys;
    private String[] headers;
    private static final Logger log = ContextLogger.getLogger(ExcelReader.class);
    private FormulaEvaluator evaluator;
    private boolean skipEmptyRows = true;

    public void setSkipEmptyRows(boolean skipEmptyRows) {
        this.skipEmptyRows = skipEmptyRows;
    }

    public SheetDefinition readFirstSheet(InputStream is) {
        Workbook wb = this.buildWorkbook(is);
        Sheet sheet = wb.getSheetAt(0);
        return this.readSheet(sheet, new ImportSheetDefinition(sheet.getSheetName()));
    }

    public SheetDefinition readSheet(String name, InputStream is) {
        Workbook wb = this.buildWorkbook(is);
        Sheet sheet = wb.getSheet(name);
        return this.readSheet(sheet, new ImportSheetDefinition(name));
    }

    public List<SheetDefinition> read(List<ImportSheetDefinition> importDef, InputStream is) {
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<SheetDefinition> sheets = new ArrayList<SheetDefinition>();
        Workbook wb = this.buildWorkbook(is);
        for (ImportSheetDefinition def : importDef) {
            String sheetName = def.getName();
            Sheet sheet = wb.getSheet(sheetName);
            if (sheet == null) {
                errors.add("Brak wymaganego arkusza: " + def.getName());
                continue;
            }
            SheetDefinition sheetData = this.readSheet(sheet, def);
            sheets.add(sheetData);
        }
        if (!errors.isEmpty()) {
            log.error("Znaleziona liczba b\u0142\u0119d\u00f3w: {}", (Object)errors.size());
            for (String error : errors) {
                log.error(error);
            }
            throw new CUFServiceException("Lack of obligatory sheet.");
        }
        return sheets;
    }

    public List<SheetDefinition> readAllSheets(InputStream is) {
        ArrayList<SheetDefinition> sheets = new ArrayList<SheetDefinition>();
        Workbook wb = this.buildWorkbook(is);
        for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
            String sheetName = wb.getSheetName(i);
            SheetDefinition sheetData = this.readSheet(wb.getSheet(sheetName), new ImportSheetDefinition(sheetName));
            sheets.add(sheetData);
        }
        return sheets;
    }

    private Workbook buildWorkbook(InputStream is) {
        try {
            Workbook wb = WorkbookFactory.create((InputStream)is);
            this.evaluator = wb.getCreationHelper().createFormulaEvaluator();
            return wb;
        }
        catch (Exception e) {
            throw new CUFServiceException(e);
        }
    }

    private SheetDefinition readSheet(Sheet sheet, ImportSheetDefinition importSheet) {
        log.debug("Sheet name: {}", (Object)sheet.getSheetName());
        log.debug("Reading...");
        ArrayList data = new ArrayList();
        int colCount = this.getColumnCount(sheet, importSheet);
        int rowCount = sheet.getPhysicalNumberOfRows();
        for (int i = 1; i < rowCount; ++i) {
            Row row = sheet.getRow(i);
            if (row == null) {
                log.debug("Row {} is null. End reading.", (Object)i);
                break;
            }
            Map<String, CellValue<?>> rowData = this.readRow(row, colCount, importSheet);
            if (this.skipEmptyRows && this.isEmpty(rowData)) {
                log.debug("Row {} is empty and property 'skipEmptyRows' is true: skipping", (Object)i);
                continue;
            }
            data.add(rowData);
        }
        log.debug("End reading form Excel. Data size: {}", (Object)data.size());
        return new SheetDefinition(data, sheet.getSheetName(), this.headers);
    }

    private boolean isEmpty(Map<String, CellValue<?>> row) {
        for (CellValue<?> value : row.values()) {
            if (this.isCellEmpty(value)) continue;
            return false;
        }
        return true;
    }

    private boolean isCellEmpty(CellValue<?> cellValue) {
        if (cellValue == null || cellValue.getValue() == null) {
            return true;
        }
        Object value = cellValue.getValue();
        return value instanceof String && StringUtils.isBlank((CharSequence)((String)value));
    }

    private Map<String, CellValue<?>> readRow(Row row, int colCount, ImportSheetDefinition importSheet) {
        HashMap hm = new HashMap();
        for (int i = 0; i < colCount; ++i) {
            Cell cell = row.getCell(i);
            String key = this.keys[i];
            String header = this.headers[i];
            if (hm.containsKey(key)) {
                throw new DuplicatedColumnException(key, header);
            }
            log.debug("Column [{}] Row [{}]", (Object)header, (Object)row.getRowNum());
            if (cell != null) {
                ValueReader reader = importSheet.getValueReaders().get(header);
                if (reader == null) {
                    reader = ValueReaderResolver.getInstance().resolve(cell.getCellType(), cell);
                }
                Object value = reader.readCellValue(cell.getCellType(), cell, this.evaluator.evaluate(cell), reader);
                hm.put(key, new CellValue<Object>(cell, value));
                continue;
            }
            log.debug("Cell is empty");
            CellValue<Object> value = new CellValue<Object>(row.getRowNum(), i, importSheet.getName(), null);
            hm.put(key, value);
        }
        return hm;
    }

    private int getColumnCount(Sheet sheet, ImportSheetDefinition importSheet) {
        Cell c;
        ArrayList errors = Lists.newArrayList();
        Row row = sheet.getRow(0);
        int columnCount = 0;
        for (int i = 0; i < row.getLastCellNum() && (c = row.getCell(i)) != null && !StringUtils.isBlank((CharSequence)c.getStringCellValue()); ++i) {
            if (c.getCellType() != 1) {
                errors.add("Nag\u0142\u00f3wek kolumny musi by\u0107 typu tekstowego. Prosz\u0119 sprawdzi\u0107 kolumn\u0119 [" + CellReference.convertNumToColString((int)i) + "]");
                break;
            }
            ++columnCount;
        }
        log.debug("Column count: {}", (Object)columnCount);
        this.initHeaders(row, columnCount);
        this.initKeys(importSheet.getMappings(), errors, sheet.getSheetName());
        this.validateHeaders(importSheet, sheet.getSheetName(), errors);
        if (!errors.isEmpty()) {
            for (String error : errors) {
                log.error(error);
            }
            throw new ValidationException("Incorrect Sheet Headers.");
        }
        return columnCount;
    }

    private void initKeys(Map<String, String> mappings, List<String> errors, String sheetName) {
        boolean hasMappings = mappings != null;
        this.keys = new String[this.headers.length];
        for (int i = 0; i < this.headers.length; ++i) {
            if (hasMappings) {
                if (mappings.containsKey(this.headers[i])) {
                    this.keys[i] = mappings.get(this.headers[i]);
                    continue;
                }
                String cell = new CellReference(0, i).formatAsString().replace("$", "");
                errors.add("Nag\u0142\u00f3wek kolumny " + cell + ": " + this.headers[i] + " jest niepoprawny. Sprawd\u017a arkusz: " + sheetName);
                continue;
            }
            this.keys[i] = this.headers[i];
        }
    }

    private void initHeaders(Row row, int columnCount) {
        this.headers = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            Cell c = row.getCell(i);
            this.headers[i] = c.getStringCellValue();
        }
    }

    private void validateHeaders(ImportSheetDefinition importSheet, String sheet, List<String> errors) {
        boolean hasMappings;
        Map<String, String> mappings = importSheet.getMappings();
        boolean bl = hasMappings = mappings != null;
        if (hasMappings) {
            for (Map.Entry<String, String> entry : mappings.entrySet()) {
                if (Arrays.asList(this.headers).contains(entry.getKey()) || !this.isColumnMandatory(importSheet.getOptionalColumns(), entry.getValue())) continue;
                errors.add("Brak nag\u0142\u00f3wka '" + entry.getKey() + "' w arkuszu: " + sheet);
            }
        }
    }

    private boolean isColumnMandatory(String[] optionalColumns, String columnName) {
        if (optionalColumns == null) {
            return true;
        }
        return !Arrays.asList(optionalColumns).contains(columnName);
    }
}

