/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension;

import com.plusmpm.CUF.util.extension.CUFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelReader {
    private static Logger log = Logger.getLogger(ExcelReader.class);
    private Map<String, Class> excelTypes;
    private boolean checkHeaders = true;

    public List<Map<String, Object>> readExcel(String filePath) throws Exception {
        return this.readExcel(filePath, null);
    }

    public List<Map<String, Object>> readExcel(InputStream is) throws Exception {
        return this.readExcel(is, null);
    }

    public List<Map<String, Object>> readExcel(String filePath, List<String> fields) throws Exception {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new FileNotFoundException("Nie znaleziono pliku: " + filePath);
        }
        String ext = FilenameUtils.getExtension((String)file.getName());
        if (!ext.equals("xls") && !ext.equals("xlsx")) {
            throw new CUFException("Plik posiada niew\u0142a\u015bciwe rozszerzenie: " + ext + ". Dozwolone rozszerzenia to .xls i .xlsx");
        }
        FileInputStream fis = new FileInputStream(file);
        return this.readExcel(fis, fields);
    }

    public List<Map<String, Object>> readExcel(InputStream inp, List<String> fields) throws Exception {
        log.debug((Object)"Import z excela");
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        log.debug((Object)"Wczytuje arkusz");
        Workbook wb = WorkbookFactory.create((InputStream)inp);
        log.debug((Object)"Wczytanie arkusza zakonczone");
        Sheet sheet = wb.getSheetAt(0);
        Row row = sheet.getRow(0);
        if (row == null) {
            throw new CUFException("Wczytywany plik jest pusty");
        }
        int columnCount = this.getColumnCount(row);
        fields = fields != null && this.checkHeaders ? this.checkHeaders(row, fields, columnCount) : this.readHeaders(row);
        int lastRow = sheet.getLastRowNum();
        log.debug((Object)("Liczba wierszy w arkuszu: " + lastRow));
        int r = 1;
        row = sheet.getRow(r);
        FormulaEvaluator evaluator = wb.getCreationHelper().createFormulaEvaluator();
        while (r <= lastRow) {
            if (row == null) {
                log.warn((Object)("wiersz: " + r + " jest pusty. Ko\u0144cze wczytywanie"));
                break;
            }
            HashMap<String, Object> hm = new HashMap<String, Object>();
            for (int i = 0; i < columnCount; ++i) {
                Cell cell = row.getCell(i);
                String field = fields.get(i);
                log.debug((Object)("Kolumna: " + field + " wiersz: " + r));
                if (cell != null) {
                    CellValue cellValue = evaluator.evaluate(cell);
                    Object value = this.getCellValue(cell.getCellType(), cell, cellValue, field);
                    hm.put(field, value);
                    continue;
                }
                log.debug((Object)"kom\u00f3rka jest pusta");
                hm.put(field, null);
            }
            data.add(hm);
            row = sheet.getRow(++r);
        }
        log.debug((Object)"Zakonczylem import z excela");
        return data;
    }

    private int getColumnCount(Row row) {
        int last;
        for (int i = last = row.getLastCellNum() - 1; i >= 0; --i) {
            Cell c = row.getCell(i);
            if (c == null) {
                --last;
                continue;
            }
            if (c.getCellType() != 1) {
                --last;
                continue;
            }
            String v = c.getStringCellValue();
            if (!StringUtils.isBlank((String)v)) break;
            --last;
        }
        log.debug((Object)("Liczba kolumn: " + (last + 1)));
        return last + 1;
    }

    private Object getCellValue(int type, Cell cell, CellValue cellValue, String field) {
        if (type == 0) {
            if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                log.trace((Object)"Data");
                return cell.getDateCellValue();
            }
            log.trace((Object)"Double");
            double value = cellValue.getNumberValue();
            if (this.isInteger(field)) {
                log.trace((Object)("zmienna " + field + " jest typu Integer, warto\u015b\u0107: " + value));
                int val = (int)value;
                log.trace((Object)("waro\u015b\u0107 po konwersji: " + val));
                return val;
            }
            if (this.isString(field)) {
                log.trace((Object)("zmienna " + field + " jest typu String, warto\u015b\u0107: " + value));
                int val = (int)value;
                log.trace((Object)("waro\u015b\u0107 po konwersji: " + val));
                return String.valueOf(val);
            }
            return value;
        }
        if (type == 4) {
            log.trace((Object)"boolean");
            boolean value = cellValue.getBooleanValue();
            if (this.isString(field)) {
                log.trace((Object)"konwersja do String ");
                log.trace((Object)("warto\u015b\u0107 zmiennaj " + field + " to: " + value));
                return String.valueOf(value);
            }
            return value;
        }
        if (type == 1) {
            log.trace((Object)"string");
            return cellValue.getStringValue();
        }
        if (type == 2) {
            log.trace((Object)"formula");
            Object value = this.getCellValue(cellValue.getCellType(), cell, cellValue, field);
            return value;
        }
        if (type == 3) {
            log.trace((Object)"blank");
            return null;
        }
        throw new RuntimeException("Nieobs\u0142ugiwany typ kom\u00f3rki: " + cell.getCellType());
    }

    private boolean isString(String field) {
        return this.isTypeOf(field, String.class);
    }

    private boolean isTypeOf(String id, Class clazz) {
        Class cl = this.getExcelTypes().get(id);
        return cl != null && cl.equals(clazz);
    }

    private boolean isInteger(String field) {
        return this.isTypeOf(field, Integer.class);
    }

    private List<String> readHeaders(Row firstRow) {
        ArrayList<String> orderedFields = new ArrayList<String>();
        for (int i = 0; i < firstRow.getLastCellNum(); ++i) {
            String header = firstRow.getCell(i).getStringCellValue();
            orderedFields.add(header);
        }
        return orderedFields;
    }

    private List<String> checkHeaders(Row firstRow, List<String> fields, int colCount) throws CUFException {
        log.debug((Object)("Wymagane kolumny: " + StringUtils.join(fields.iterator(), (String)",")));
        ArrayList<String> orderedFields = new ArrayList<String>();
        if (colCount < fields.size()) {
            String h = "";
            for (String f : fields) {
                h = h + f + ", ";
            }
            if (!h.isEmpty()) {
                h = h.substring(0, h.length() - 1);
            }
            throw new CUFException("Niepoprawne nag\u0142\u00f3wki. Plik powinien zawiera\u0107 nast\u0119puj\u0105ce kolumny: " + h);
        }
        for (int i = 0; i < colCount; ++i) {
            String header = firstRow.getCell(i).getStringCellValue();
            if (!fields.contains(header)) {
                throw new CUFException("Niepoprawne nag\u0142\u00f3wki. Plik zawiera kolumn\u0119 o nag\u0142\u00f3wku: " + header);
            }
            orderedFields.add(header);
        }
        return orderedFields;
    }

    public Map<String, Class> getExcelTypes() {
        if (this.excelTypes == null) {
            return new HashMap<String, Class>();
        }
        return this.excelTypes;
    }

    public void setExcelTypes(Map<String, Class> excelTypes) {
        this.excelTypes = excelTypes;
    }

    public void addExcelType(String id, Class type) {
        this.getExcelTypes().put(id, type);
    }

    public boolean isCheckHeaders() {
        return this.checkHeaders;
    }

    public void setCheckHeaders(boolean checkHeaders) {
        this.checkHeaders = checkHeaders;
    }
}

