/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension.DocTemplates2Pdf.table;

import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.graphic.ColumnGraphicInfo;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.graphic.GraphicUtils;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.workflow.WorkflowUtils;
import com.plusmpm.util.Tools;
import com.plusmpm.util.workflowData.ProcessData;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.XPathBinderAssociationIsPartialException;
import org.docx4j.model.styles.StyleUtil;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.ParaRPr;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STLineSpacingRule;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblGridCol;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.Text;
import org.docx4j.wml.Tr;
import org.docx4j.wml.TrPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableUtils {
    private static final Logger log = LoggerFactory.getLogger(TableUtils.class);

    public static String fitTextToColumn(String txt, int colWidth, String font, int fontSize, boolean isBold, boolean isItalic) {
        log.trace("***fitTextToColumn(txt=" + txt + ",colWidth=" + colWidth + ",font=" + font + ",fontSize=" + fontSize + ",isBold=" + isBold + ",isItalic=" + isItalic + ")****");
        AffineTransform af = new AffineTransform();
        FontRenderContext fr = new FontRenderContext(af, true, true);
        int style = 0;
        if (isBold && isItalic) {
            style = 3;
        } else if (isBold) {
            style = 1;
        } else if (isItalic) {
            style = 2;
        }
        Font f = new Font(font, style, fontSize);
        String newTxt = "";
        log.debug("Szerokosc kolumny: " + (colWidth -= 100));
        String[] words = txt.split(" ");
        double scale = 25.0;
        scale -= (double)(colWidth / 1000);
        for (int i = 0; i < words.length; ++i) {
            String w = words[i];
            log.debug("s\u0142owo: " + w);
            double width = f.getStringBounds(w, fr).getWidth() * scale;
            log.debug("szeroko\u015b\u0107 s\u0142owa: " + width);
            if (width > (double)colWidth) {
                log.debug("s\u0142owo si\u0119 nie miesci w kolumnie");
                int lines = (int)Math.ceil(width / (double)colWidth);
                log.debug("S\u0142owo zostanie rozbite na okolo " + lines + " linii");
                int len = w.length();
                int offset = 0;
                for (int k = 0; k < lines; ++k) {
                    int endLine;
                    String line = w.substring(offset, Math.min(w.length(), len / lines + offset));
                    double lw = f.getStringBounds(line, fr).getWidth() * scale;
                    while (lw > (double)colWidth) {
                        line = line.substring(0, line.length() - 1);
                        lw = f.getStringBounds(line, fr).getWidth() * scale;
                    }
                    do {
                        if (!((lw = f.getStringBounds(line = w.substring(offset, endLine = Math.min(line.length() + 1 + offset, w.length())), fr).getWidth() * scale) > (double)colWidth)) continue;
                        line = line.substring(0, line.length() - 1);
                        break;
                    } while (endLine != w.length());
                    log.debug("dodaje linie: " + line);
                    newTxt = newTxt + line + "\n";
                    if (k + 1 != lines || (offset += line.length()) >= w.length() || Tools.isNullOrEmpty((String)line)) continue;
                    --k;
                }
                continue;
            }
            if (Tools.isNullOrEmpty((String)w)) continue;
            log.debug("s\u0142owo miesci sie w kolumnie");
            newTxt = newTxt + w + " ";
        }
        return newTxt;
    }

    public static Tc getCell(JAXBElement<Tc> cellElem) {
        Tc cell = null;
        if (cellElem != null) {
            log.debug("Pobieranie elementu kom\u00f3rki powiod\u0142o si\u0119.");
            log.debug("Pobieranie listy warto\u015bci kom\u00f3rki.");
            cell = (Tc)cellElem.getValue();
        } else {
            log.debug("B\u0141\u0104D - Problem z pobraniem elementu kom\u00f3rki.");
        }
        return cell;
    }

    public static Tr getRow(List<Object> currentTableRows, int j) {
        Tr row = null;
        try {
            log.debug("Pobieranie obiektu Tr dla wiersza j = ".concat(String.valueOf(j)));
            row = (Tr)currentTableRows.get(j);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return row;
    }

    public static List<Tbl> getTables(List<Object> nodes) {
        ArrayList<Tbl> tbls = new ArrayList<Tbl>();
        for (int i = 0; i < nodes.size(); ++i) {
            log.debug("Pobieranie w\u0119z\u0142a dla i = ".concat(String.valueOf(i)));
            JAXBElement jaxbeTmp = (JAXBElement)nodes.get(i);
            JAXBElement elem = null;
            if (jaxbeTmp != null && jaxbeTmp.getDeclaredType().toString().equalsIgnoreCase("class org.docx4j.wml.Tbl")) {
                log.debug("Wezel jest tabela.");
                elem = (JAXBElement)nodes.get(i);
            }
            log.debug("Pobieranie wartosci wezla tabeli.");
            Tbl tbl = (Tbl)elem.getValue();
            tbls.add(tbl);
            log.debug("Pobieranie wezla tabeli powiodlo sie.");
        }
        return tbls;
    }

    public static void removeMarkupRows(List<Tbl> tables, List<Boolean> tablesFlags, List<Boolean> headersFlags) {
        for (int i = 0; i < tables.size(); ++i) {
            tablesFlags.add(null);
            headersFlags.add(null);
            log.debug("Pobranie wierszy z tabeli.");
            List currentTableRows = tables.get(i).getContent();
            if (currentTableRows != null && currentTableRows.size() > 0) {
                log.debug("Pobieranie wierszy z tabeli powiod\u0142o si\u0119, liczba wierszy = ".concat(String.valueOf(currentTableRows.size())));
                if (currentTableRows.size() >= 2) {
                    log.debug("Liczba wierszy >= 2.");
                    for (int j = 0; j < 2; ++j) {
                        Tr row = TableUtils.getRow(currentTableRows, j);
                        if (row != null) {
                            log.debug("Pobieranie wiersza powiod\u0142o si\u0119.");
                            log.debug("Pobieranie warto\u015bci kom\u00f3rek dla wiersza j = ".concat(String.valueOf(j)));
                            List cells = row.getContent();
                            if (cells.size() == 1 && cells.get(0) != null) {
                                log.debug("Pierwszy wiersz posiada tylko jedn\u0105 kolumn\u0119, mo\u017ce by\u0107 znacznikiem.");
                                log.debug("Pobieranie elementu kom\u00f3rki.");
                                JAXBElement cellElem = (JAXBElement)cells.get(0);
                                Tc cell = TableUtils.getCell((JAXBElement<Tc>)cellElem);
                                if (cell != null) {
                                    log.debug("Pobieranie listy warto\u015bci kom\u00f3rki powiod\u0142o si\u0119.");
                                    List cellValues = cell.getContent();
                                    if (cellValues != null && cellValues.size() > 0 && cellValues.get(0) != null) {
                                        log.debug("Pobieranie pierwszej warto\u015bci z listy powiod\u0142o si\u0119.");
                                        String cellValue = String.valueOf(cellValues.get(0));
                                        log.debug("cellValue = ".concat(cellValue));
                                        if (cellValue.compareTo("TABLE_TO_PROCESS_MARKER") == 0) {
                                            log.debug("cellValue to znacznik przetwarzania tabeli.");
                                            tablesFlags.remove(tablesFlags.size() - 1);
                                            tablesFlags.add(true);
                                        }
                                        if (cellValue.compareTo("TABLE_NOT_TO_PROCESS_MARKER") == 0) {
                                            log.debug("cellValue to znacznik wy\u0142\u0105czaj\u0105cy domy\u015blne przetwarzanie tabeli.");
                                            tablesFlags.remove(tablesFlags.size() - 1);
                                            tablesFlags.add(false);
                                        }
                                        if (cellValue.compareTo("TABLE_WITHOUT_HEADERS_MARKER") != 0) continue;
                                        log.debug("cellValue to znacznik usuni\u0119cia nag\u0142\u00f3wka.");
                                        headersFlags.remove(headersFlags.size() - 1);
                                        headersFlags.add(false);
                                        continue;
                                    }
                                    log.debug("B\u0141\u0104D - problem z pobraniem pierwszej warto\u015bci z listy.");
                                    continue;
                                }
                                log.debug("B\u0141\u0104D - Problem z pobraniem warto\u015bci kom\u00f3rki.");
                                continue;
                            }
                            log.debug("Pierwszy wiersz posiada wi\u0119cej ni\u017c jedn\u0105 kolumn\u0119, nie jest znacznikiem.");
                            continue;
                        }
                        log.debug("Problem z pobraniem obiektu Tr dla wiersza.");
                    }
                } else {
                    log.debug("Tabela posiada tylko jeden wiersz.");
                }
            } else {
                log.debug("B\u0141\u0104D - Problem z pobieraniem wierszy tabeli.");
            }
            log.debug("Usuwanie wierszy znacznikowych.");
            if (tablesFlags.get(i) != null) {
                log.debug("Wiersz znacznikowy przetwarzania tabeli - usuni\u0119ty.");
                currentTableRows.remove(0);
            }
            if (headersFlags.get(i) != null && !headersFlags.get(i).booleanValue()) {
                log.debug("Wiersz znacznikowy usuni\u0119cia nag\u0142\u00f3wka tabeli - usuni\u0119ty.");
                currentTableRows.remove(0);
            }
            log.debug("Usuwanie wierszy znacznikowych powiod\u0142o si\u0119.");
        }
    }

    public static void initTableMarkups(String templatePath, Map<String, Object> mappings, List<Map<String, String>> tablesMaps, String variablesMarker, String processId, WordprocessingMLPackage template, MainDocumentPart documentPart, List<Tbl> tables, List<Boolean> tablesFlags, List<Boolean> headersFlags, List<ColumnGraphicInfo> tablesGraphicColumnInfo, boolean pdf) throws Exception {
        log.debug("Przygotowanie wartosci do uzpelnienia tabel.");
        for (int i = 0; i < tables.size(); ++i) {
            if (tablesFlags.get(i).booleanValue()) {
                log.debug("Ustawianie formatowania wierszy w tabeli.");
                ArrayList<Map<String, Object>> paragraphsProperties = new ArrayList<Map<String, Object>>();
                AtomicReference<Object> rowProperties = new AtomicReference<Object>(null);
                log.debug("Pobieranie wierszy z tabeli i = ".concat(String.valueOf(i)));
                List currentTableRows = tables.get(i).getContent();
                if (currentTableRows != null && currentTableRows.size() > 0) {
                    int defaultRowNo = 1;
                    TableUtils.initTableFormatting(documentPart, paragraphsProperties, rowProperties, currentTableRows);
                    log.debug("Pobieranie wartosci do uzpelnienia tabeli.");
                    if (!Tools.isNullOrEmpty((String)processId)) {
                        log.debug("processId rozne od null i nie jest puste.");
                        log.debug("Pobieranie wezlow z wartosciami komorek z tabeli, dla wiersza: ".concat(String.valueOf(i)));
                        String tableHeaders = "";
                        Tr row = (Tr)currentTableRows.get(0);
                        List cellElements = row.getContent();
                        int columnsCount = 0;
                        log.debug("Pobieranie naglowkow.");
                        for (int j = 0; j < cellElements.size(); ++j) {
                            Tc cell = null;
                            try {
                                JAXBElement cellElement = (JAXBElement)cellElements.get(j);
                                cell = (Tc)cellElement.getValue();
                                ++columnsCount;
                            }
                            catch (ClassCastException cellElement) {
                                // empty catch block
                            }
                            if (cell == null) continue;
                            tableHeaders = tableHeaders.concat(String.valueOf(cell.getEGBlockLevelElts().get(0)));
                        }
                        log.debug("Pobieranie naglowkow powiodlo sie.");
                        log.debug(tableHeaders);
                        log.debug("headersFlags dla i = ".concat(String.valueOf(i).concat(" = ").concat(String.valueOf(headersFlags.get(i)))));
                        if (!headersFlags.get(i).booleanValue()) {
                            log.debug("W tabeli o indeksie ".concat(String.valueOf(i)).concat(" nag\u0142\u00f3wek ma zosta\u0107 usuni\u0119ty."));
                            defaultRowNo = 0;
                        }
                        log.debug("Usuwanie wiersza z nag\u0142\u00f3wkiem.");
                        while (currentTableRows.size() > defaultRowNo) {
                            currentTableRows.remove(currentTableRows.size() - 1);
                        }
                        log.debug("Usuwanie wierszy powiodlo sie.");
                        String processDefId = WorkflowUtils.getProcessDefId(processId);
                        tableHeaders = tableHeaders.substring(1, tableHeaders.length() - 1);
                        log.debug("Usuniecie nadmiarowych znacznikow zmiennych.");
                        log.debug(tableHeaders);
                        tableHeaders = tableHeaders.replace(variablesMarker.concat(variablesMarker), variablesMarker);
                        log.debug("Usuniecie nadmiarowych znacznikow zmiennych powiodlo sie.");
                        log.debug(tableHeaders);
                        log.debug("Splitowanie zmiennych.");
                        String[] splittedTableHeaders = tableHeaders.split(variablesMarker);
                        log.debug("Splitowanie zmiennych powiodlo sie.");
                        log.debug(splittedTableHeaders.toString());
                        ArrayList<String> tableValues = new ArrayList<String>();
                        log.debug("Ustawianie naglowkow.");
                        try {
                            ProcessData processData = new ProcessData();
                            for (int j = 0; j < splittedTableHeaders.length; ++j) {
                                if (j >= columnsCount) continue;
                                if (splittedTableHeaders[j].contains("|")) {
                                    String[] tmp = splittedTableHeaders[j].split("\\|");
                                    Object o = mappings.get(tmp[0]);
                                    if (o == null) continue;
                                    tableValues.add(mappings.get(tmp[0]).toString());
                                    mappings.put(splittedTableHeaders[j], tmp[1]);
                                    continue;
                                }
                                if (mappings.get(splittedTableHeaders[j]) == null) continue;
                                tableValues.add(mappings.get(splittedTableHeaders[j]).toString());
                                mappings.put(splittedTableHeaders[j], ProcessData.getProcessVariableIdNameMap((String)processDefId).get(splittedTableHeaders[j]).toString());
                            }
                        }
                        catch (Exception e) {
                            log.debug("B\u0141\u0104D - problem z ustawianiem nag\u0142\u00f3wk\u00f3w.");
                            log.error(e.getMessage(), (Throwable)e);
                            throw e;
                        }
                        log.debug("Ustawianie naglowkow powiodlo sie.");
                        log.debug(mappings.toString());
                        log.debug("Tworzenie tabel z wypelnionymi wartosciami.");
                        TableUtils.createTableWithValues(documentPart, tables.get(i), tableValues, paragraphsProperties, rowProperties.get(), tablesGraphicColumnInfo.get(i), template, pdf);
                        log.debug("Tworzenie tabel z wypelnionymi wartosciami powiodlo sie.");
                        continue;
                    }
                    log.debug("processId = null");
                    log.debug("Tworzenie tabel z wypelnionymi wartosciami.");
                    TableUtils.createTableWithValues(documentPart, i, tables.get(i), tablesMaps.get(i), paragraphsProperties);
                    log.debug("Tworzenie tabel z wypelnionymi wartosciami powiodlo sie.");
                    continue;
                }
                log.error("B\u0141\u0104D - tabela nr".concat(String.valueOf(i + 1)).concat(" w szablonie ").concat(templatePath).concat(" nie zawiera wierszy."));
                continue;
            }
            log.debug("Tabela o indeksie: ".concat(String.valueOf(i)).concat(" nie ma byc uzupelniana"));
        }
    }

    private static void initTableFormatting(MainDocumentPart documentPart, List<Map<String, Object>> paragraphsProperties, AtomicReference<TrPr> rowProperties, List<Object> currentTableRows) throws JAXBException, XPathBinderAssociationIsPartialException {
        int whichRow = 1;
        if (currentTableRows.size() > 1) {
            Tr row = (Tr)currentTableRows.get(whichRow);
            log.debug("Formatowanie wierszy jest pobierane z drugiego wiersza tabeli (nie z nag\u0142\u00f3wka).");
            log.debug("Pobieranie paragraf\u00f3w tekstowych(kolumn) z wiersza definiujacego formatowanie.");
            List paragraphs = documentPart.getJAXBNodesViaXPath("./w:tc/w:p", (Object)row, false);
            if (paragraphs != null && paragraphs.size() > 0) {
                log.debug("Pobieranie paragraf\u00f3w tekstowych (kolumn) powiodlo sie. Liczba kolumn: ".concat(String.valueOf(paragraphs.size())));
                log.debug("Pobieranie formatowania poszczegolnych kolumn.");
                for (int j = 0; j < paragraphs.size(); ++j) {
                    HashMap<String, Object> paragraphProperties = new HashMap<String, Object>();
                    P pParagraph = (P)paragraphs.get(j);
                    PPr paragraph_pPr = pParagraph.getPPr();
                    paragraphProperties.put("pPr", paragraph_pPr);
                    Tc tc = (Tc)pParagraph.getParent();
                    paragraphProperties.put("tcPr", tc.getTcPr());
                    paragraphsProperties.add(paragraphProperties);
                }
                log.debug("Pobieranie formatowania dla poszczegolnych kolumn powiodlo sie.");
                log.debug(paragraphsProperties.toString());
            }
            log.debug("Pobieranie w\u0142a\u015bciwo\u015bci wiersza z wiersza definiujacego formatowanie.");
            rowProperties.set(row.getTrPr());
            log.debug("Pobranie w\u0142a\u015bciwo\u015bci kom\u00f3rki definiuj\u0105cej formatowanie.");
        }
    }

    public static void createTableWithValues(MainDocumentPart mdp, int iTableNr, Tbl table, Map<String, String> mValues, List<Map<String, Object>> lParagraphProperties) {
        int i;
        log.trace("************************* createTableWithValues() ********************");
        log.debug("Tworzenie tabeli nr: ".concat(String.valueOf(iTableNr)));
        int iSize = mValues.size();
        log.debug("mValues.size() = ".concat(String.valueOf(iSize)));
        int iRowsNr = 0;
        ArrayList<String[]> alColumns = new ArrayList<String[]>();
        log.debug("Przygotowanie wartosci tabelarycznych.");
        for (i = 0; i < iSize; ++i) {
            alColumns.add(mValues.get("t" + String.valueOf(iTableNr + 1) + "c" + String.valueOf(i + 1)).split(";", -1));
        }
        log.debug("Przygotowanie wartosci tabelarycznych powiodlo sie.");
        log.debug(alColumns.toString());
        iRowsNr = ((String[])alColumns.get(0)).length;
        log.debug("Uzupe\u0142nianie warto\u015bci tabelarycznych.");
        for (i = 0; i < iRowsNr; ++i) {
            Tr tr = Context.getWmlObjectFactory().createTr();
            table.getEGContentRowContent().add(tr);
            for (int j = 0; j < iSize; ++j) {
                Tc tc = Context.getWmlObjectFactory().createTc();
                tr.getEGContentCellContent().add(tc);
                TcPr tcPr = (TcPr)lParagraphProperties.get(j).get("tcPr");
                tc.setTcPr(tcPr);
                P p = mdp.createParagraphOfText(((String[])alColumns.get(j))[i]);
                try {
                    PPr pPr = null;
                    if (lParagraphProperties.size() > j) {
                        pPr = (PPr)lParagraphProperties.get(j).get("pPr");
                    }
                    p.setPPr(pPr);
                    ObjectFactory factory = Context.getWmlObjectFactory();
                    R r = (R)p.getContent().get(0);
                    Text t = (Text)r.getContent().get(0);
                    log.debug(t.getValue());
                    String[] rows = t.getValue().split("\n");
                    int index = 0;
                    p.getContent().remove(r);
                    for (String row : rows) {
                        R run = factory.createR();
                        Text text = factory.createText();
                        text.setValue(row);
                        run.getContent().add(text);
                        p.getContent().add(run);
                        if (pPr != null) {
                            RPr rPr = StyleUtil.apply((ParaRPr)pPr.getRPr(), (RPr)factory.createRPr());
                            run.setRPr(rPr);
                        }
                        if (index < rows.length - 1) {
                            R brRun = factory.createR();
                            brRun.getContent().add(factory.createBr());
                            p.getContent().add(brRun);
                        }
                        ++index;
                    }
                }
                catch (Exception e) {
                    p = mdp.createParagraphOfText(((String[])alColumns.get(j))[i]);
                }
                tc.getEGBlockLevelElts().add(p);
            }
        }
        log.debug("Uzupe\u0142nienie warto\u015bci tabelarycznych powiod\u0142o si\u0119.");
    }

    /*
     * Unable to fully structure code
     */
    public static void createTableWithValues(MainDocumentPart mdp, Tbl table, List<String> lValues, List<Map<String, Object>> lParagraphProperties, TrPr rowProperties, ColumnGraphicInfo columnGraphicInfo, WordprocessingMLPackage template, boolean pdf) {
        TableUtils.log.trace("************************* createTableWithValues() ********************");
        for (i = 0; i < lValues.size(); ++i) {
            lValues.set(i, lValues.get(i).replaceAll("@", "Xsuncode-atX"));
        }
        iSize = lValues.size();
        TableUtils.log.debug("mValues.size() = ".concat(String.valueOf(iSize)));
        iRowsNr = 0;
        alColumns = new ArrayList<String[]>();
        TableUtils.log.debug("Splitowanie wartosci tabelarycznych.");
        for (i = 0; i < iSize; ++i) {
            alColumns.add(lValues.get(i).split(";", -1));
            tmpLength = ((String[])alColumns.get(i)).length;
            if (tmpLength <= iRowsNr) continue;
            iRowsNr = tmpLength;
        }
        TableUtils.log.debug("Splitowanie wartosci tabelarycznych powiodlo sie.");
        TableUtils.log.debug(alColumns.toString());
        TableUtils.log.debug("Uzupe\u0142nianie warto\u015bci tabelarycznych.");
        for (i = 0; i < iRowsNr; ++i) {
            tr = Context.getWmlObjectFactory().createTr();
            if (rowProperties != null) {
                trPr = (TrPr)XmlUtils.deepCopy((Object)rowProperties, (JAXBContext)mdp.getJAXBContext());
                tr.setTrPr(trPr);
            }
            table.getEGContentRowContent().add(tr);
            for (j = 0; j < iSize; ++j) {
                pImages = new ArrayList<P>();
                tc = Context.getWmlObjectFactory().createTc();
                tr.getEGContentCellContent().add(tc);
                tcPr = (TcPr)lParagraphProperties.get(j).get("tcPr");
                tc.setTcPr(tcPr);
                tgc = (TblGridCol)table.getTblGrid().getGridCol().get(j);
                colWidth = tgc.getW().intValue();
                p = null;
                if (i < ((String[])alColumns.get(j)).length) {
                    txt = ((String[])alColumns.get(j))[i];
                    font = "Times New Roman";
                    isBold = false;
                    isItalic = false;
                    size = 12;
                    ppr = null;
                    if (j < lParagraphProperties.size()) {
                        ppr = (PPr)lParagraphProperties.get(j).get("pPr");
                        try {
                            font = ppr.getRPr().getRFonts().getAscii();
                        }
                        catch (Exception e) {
                            TableUtils.log.debug("nie mozna wczytac czcionki");
                        }
                        try {
                            isBold = ppr.getRPr().getB().isVal();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            isItalic = ppr.getRPr().getI().isVal();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            TableUtils.log.debug(ppr.getRPr().getSz().getVal().toString());
                            size = (int)Math.ceil(ppr.getRPr().getSz().getVal().doubleValue() / 2.0);
                        }
                        catch (Exception e) {
                            TableUtils.log.error(e.getMessage(), (Throwable)e);
                        }
                        TableUtils.log.debug(String.valueOf(colWidth));
                    }
                    newTxt = TableUtils.fitTextToColumn(txt, colWidth, font, size, isBold, isItalic);
                    try {
                        skip = false;
                        if (columnGraphicInfo != null) {
                            if (!columnGraphicInfo.getGraphicColumn().booleanValue()) {
                                p = mdp.createParagraphOfText(newTxt);
                            } else {
                                gPropertie = columnGraphicInfo.getGraphicProperties(j);
                                if (gPropertie == null) {
                                    p = mdp.createParagraphOfText(newTxt);
                                } else {
                                    fileID = -1L;
                                    try {
                                        fileIdsTxt = txt.split(",");
                                        factory = Context.getWmlObjectFactory();
                                        if (fileIdsTxt.length > 0) {
                                            p = factory.createP();
                                            maxImageInRow = gPropertie.getMaxImageInRow() < 1 ? fileIdsTxt.length : gPropertie.getMaxImageInRow();
                                            colWitdh = tgc.getW().intValue() / maxImageInRow;
                                            nrImage = 0;
                                            for (String fileidTxt : fileIdsTxt) {
                                                if (nrImage % maxImageInRow == 0) {
                                                    p = factory.createP();
                                                    pImages.add(p);
                                                }
                                                fileID = Long.parseLong(fileidTxt);
                                                rImage = GraphicUtils.addImageToR(template, colWitdh, gPropertie, fileID);
                                                skip = true;
                                                if (nrImage % maxImageInRow >= 0 && nrImage % maxImageInRow < maxImageInRow - 1 && maxImageInRow > 1 && nrImage < fileIdsTxt.length - 1) {
                                                    if (pdf) {
                                                        rtab = factory.createRTab();
                                                        rtabWrapped = factory.createRTab(rtab);
                                                        rImage.getContent().add(rtabWrapped);
                                                    } else {
                                                        text = factory.createText();
                                                        text.setSpace("preserve");
                                                        text.setValue(" ");
                                                        rImage.getContent().add(text);
                                                    }
                                                }
                                                p.getContent().add(rImage);
                                                ++nrImage;
                                            }
                                        }
                                    }
                                    catch (NumberFormatException nfe) {
                                        TableUtils.log.error(txt + "\t is not FileID", (Throwable)nfe);
                                        p = mdp.createParagraphOfText(newTxt);
                                        skip = false;
                                    }
                                }
                            }
                        }
                        p.setPPr(ppr);
                        if (skip.booleanValue()) ** GOTO lbl153
                        factory = Context.getWmlObjectFactory();
                        r = (R)p.getContent().get(0);
                        t = (Text)r.getContent().get(0);
                        TableUtils.log.debug(t.getValue());
                        rows = t.getValue().split("\n");
                        index = 0;
                        p.getContent().remove(r);
                        for (String row : rows) {
                            run = factory.createR();
                            text = factory.createText();
                            text.setValue(row);
                            run.getContent().add(text);
                            p.getContent().add(run);
                            if (ppr != null) {
                                rPr = StyleUtil.apply((ParaRPr)ppr.getRPr(), (RPr)factory.createRPr());
                                run.setRPr(rPr);
                            }
                            if (index < rows.length - 1) {
                                brRun = factory.createR();
                                brRun.getContent().add(factory.createBr());
                                p.getContent().add(brRun);
                            }
                            ++index;
                        }
                    }
                    catch (Exception e) {
                        TableUtils.log.error(e.getMessage(), (Throwable)e);
                        p = mdp.createParagraphOfText(newTxt);
                    }
                } else {
                    p = mdp.createParagraphOfText("");
                }
lbl153:
                // 4 sources

                if (p != null) {
                    if (j < lParagraphProperties.size()) {
                        p.setPPr((PPr)lParagraphProperties.get(j).get("pPr"));
                    }
                    if (pImages.isEmpty()) {
                        tc.getContent().add(p);
                        continue;
                    }
                    spacing = Context.getWmlObjectFactory().createPPrBaseSpacing();
                    spacing.setLineRule(STLineSpacingRule.AT_LEAST);
                    spacing.setBeforeLines(new BigInteger("10"));
                    spacing.setAfterLines(new BigInteger("10"));
                    for (P p1 : pImages) {
                        if (j < lParagraphProperties.size()) {
                            ppr = (PPr)lParagraphProperties.get(j).get("pPr");
                            ppr.setSpacing(spacing);
                            p1.setPPr(ppr);
                        }
                        tc.getContent().add(p1);
                    }
                    continue;
                }
                TableUtils.log.debug("B\u0141\u0104D - problem z utworzeniem komorki tekstowej.");
            }
        }
        TableUtils.log.debug("Uzupe\u0142nienie warto\u015bci tabelarycznych powiod\u0142o si\u0119.");
    }
}

