/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.archive.verification.internal;

import com.suncode.cuf.archive.verification.DocumentVerifier;
import com.suncode.cuf.archive.verification.model.VerificationCondition;
import com.suncode.cuf.archive.verification.model.VerificationDefinition;
import com.suncode.cuf.archive.verification.model.VerificationResult;
import com.suncode.plugin.framework.service.Provides;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Provides(value={DocumentVerifier.class})
public class DocumentVerifierImpl
implements DocumentVerifier {
    private static final Logger log = LoggerFactory.getLogger(DocumentVerifierImpl.class);

    @Override
    public VerificationResult verifyDocuments(VerificationDefinition verificationDefinition) {
        String processId = verificationDefinition.getProcessId();
        String activityId = verificationDefinition.getActivityId();
        List<WfDocument> docs = verificationDefinition.getMode().findDocuments(processId, activityId);
        VerificationResult result = this.checkConditions(verificationDefinition, docs);
        return result;
    }

    private VerificationResult checkConditions(VerificationDefinition verificationDefinition, List<WfDocument> docs) {
        for (VerificationCondition cond : verificationDefinition.getConditions()) {
            this.loadDocumentClass(cond);
            HashSet<Long> fileIds = new HashSet<Long>();
            for (WfDocument wfDocument : docs) {
                if (!this.validDocumentClass(wfDocument, cond) || !this.validFileName(wfDocument, cond)) continue;
                fileIds.add(wfDocument.getFile().getId());
            }
            int foundDocs = fileIds.size();
            if (this.validCondition(foundDocs, cond)) continue;
            String msg = this.buildMsg(foundDocs, cond);
            return new VerificationResult(msg);
        }
        return VerificationResult.SUCCESS;
    }

    private void loadDocumentClass(VerificationCondition cond) {
        DocumentClass dc = null;
        String name = cond.getDocumentClassName();
        Long id = cond.getDocumentClassId();
        if (id != null) {
            dc = (DocumentClass)ServiceFactory.getDocumentClassService().get((Serializable)id);
            if (dc == null) {
                throw new RuntimeException("Nie znaleziono klasy dokument\u00f3w o id: " + id);
            }
        } else if (StringUtils.isNotBlank((CharSequence)name)) {
            dc = ServiceFactory.getDocumentClassService().getDocumentClass(name, new String[0]);
            if (dc == null) {
                throw new RuntimeException("Nie znaleziono klasy dokument\u00f3w o nazwie: " + name);
            }
        } else {
            throw new RuntimeException("Nie podano klasy dokument\u00f3w w warunkach weryfikacji");
        }
        cond.setDocumentClassId(dc.getId());
        cond.setDocumentClassName(dc.getName());
    }

    private String buildMsg(int foundDocs, VerificationCondition cond) {
        String dcName = cond.getDocumentClassName();
        StringBuilder sb = new StringBuilder();
        sb.append("Do klasy dokument\u00f3w o nazwie ");
        sb.append(dcName);
        sb.append(" pod\u0142\u0105czono ");
        sb.append(foundDocs);
        sb.append(" dokument\u00f3w spe\u0142niaj\u0105cych wymagania. Do tej klasy dokument\u00f3w wymagane jest pod\u0142\u0105czenie ");
        sb.append(cond.getConditionType().getText());
        sb.append(" ");
        sb.append(cond.getDocumentCount());
        sb.append(" dokument\u00f3w spe\u0142niaj\u0105cych wymagania.");
        return sb.toString();
    }

    private boolean validCondition(int foundDocs, VerificationCondition cond) {
        return cond.getConditionType().checkCondition(foundDocs, cond.getDocumentCount());
    }

    private boolean validFileName(WfDocument wfDocument, VerificationCondition cond) {
        if (StringUtils.isBlank((CharSequence)cond.getFileNameRegExp())) {
            return true;
        }
        Pattern pattern = Pattern.compile(cond.getFileNameRegExp());
        String fileName = wfDocument.getFile().getFileName();
        String dcName = wfDocument.getFile().getDocumentClass().getName();
        if (pattern.matcher(fileName).matches()) {
            return true;
        }
        log.debug("Dokument o nazwie [{}] pod\u0142aczony do klasy dokumentow [{}]  nie spe\u0142nia wymog\u00f3w wyra\u017cenia regualrnego [{}]", new Object[]{fileName, dcName, cond.getFileNameRegExp()});
        return false;
    }

    private boolean validDocumentClass(WfDocument wfDocument, VerificationCondition cond) {
        Long fileId = wfDocument.getFile().getId();
        String dcName = wfDocument.getFile().getDocumentClass().getName();
        if (cond.getDocumentClassId().equals(wfDocument.getDocumentClassId())) {
            return true;
        }
        log.debug("Dokument o id [{}] nie nale\u017cy do klasy [{}]", (Object)fileId, (Object)dcName);
        return false;
    }
}

