/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension.DocTemplates2Pdf.workflow;

import com.plusmpm.CUF.util.extension.ArchiveServices;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.PrepeareDoc;
import com.plusmpm.CUF.util.extension.SharkClientFunctions;
import com.plusmpm.util.Tools;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.transaction.support.SharkTransactionCallback;
import com.suncode.pwfl.transaction.support.SharkTransactionTemplate;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.File;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;

public class WorkflowUtils {
    private static final Logger log = LoggerFactory.getLogger(WorkflowUtils.class);
    private static final SecureRandom random = new SecureRandom();

    public static String getProcessDefId(final String processId) throws Exception {
        return (String)new SharkTransactionTemplate().execute((SharkTransactionCallback)new SharkTransactionCallback<String>(){

            public String doInSharkTransaction(SharkTransaction transaction, TransactionStatus status) throws Exception {
                return Shark.getInstance().getAdminInterface().getAdminMisc().getProcessDefinitionId(transaction, processId);
            }
        });
    }

    public static <E> void replaceVariablesAndSave(JaxbXmlPart<E> part, Map<String, Object> mappings, String sVariablesMarker) {
        if (part == null) {
            return;
        }
        String xmlContent = XmlUtils.marshaltoString((Object)part.getJaxbElement(), (boolean)true);
        String hfPart = WorkflowUtils.replaceVariablesInTemplate(xmlContent, mappings, sVariablesMarker);
        try {
            Object partElement = XmlUtils.unmarshalString((String)hfPart);
            part.setJaxbElement(partElement);
        }
        catch (JAXBException e) {
            log.error("Setting header/footer failed.", (Throwable)e);
        }
    }

    public static String replaceVariablesInTemplate(String template, Map<String, Object> mappings, String variablesMarker) {
        log.trace("************************* replaceVariablesInTemplate() ********************");
        String newTemplate = template;
        log.debug("Scalanie wez\u0142\u00f3w tekstowych.");
        newTemplate = WorkflowUtils.mergeVariablesTextNodes(newTemplate, variablesMarker, mappings);
        log.debug("Scalanie w\u0119z\u0142\u00f3w tesktowych powiod\u0142o si\u0119.");
        log.debug(mappings.toString());
        log.debug("Dodawnie pelnych nazw uzytkownikow");
        mappings = WorkflowUtils.addFullUserNames(newTemplate, variablesMarker, mappings);
        for (String documentVariableKey : mappings.keySet()) {
            Object value = WorkflowUtils.getDocVariableValue(documentVariableKey, mappings);
            String tmp = WorkflowUtils.parseValue(value);
            tmp = WorkflowUtils.stripNonValidXMLCharacters(tmp);
            tmp = tmp.replace("&", "&amp;");
            tmp = tmp.replace("<", "&lt;");
            if ((tmp = tmp.replace(">", "&gt;")).contains("\r\n")) {
                tmp = tmp.replace("\r\n", "</w:t><w:br/><w:t>");
            }
            newTemplate = newTemplate.replace(variablesMarker + documentVariableKey + variablesMarker, tmp);
        }
        log.debug("Podstawianie zmiennych powiodlo sie.");
        return newTemplate.replaceAll("Xsuncode-atX", "@");
    }

    public static Map<String, Object> addFullUserNames(String newTemplate, String variablesMarker, Map<String, Object> mappings) {
        log.debug("Podstawianie zmiennych.");
        int i = 0;
        while (newTemplate.indexOf(variablesMarker + "fullusername#", i) >= 0) {
            i = newTemplate.indexOf(variablesMarker + "fullusername#", i) + 13;
            int varEndIndex = newTemplate.indexOf(variablesMarker, i);
            String variableName = newTemplate.substring(i + 1, varEndIndex);
            if (mappings.get("fullusername#" + variableName) != null) continue;
            String userName = (String)mappings.get(variableName);
            UserService us = ServiceFactory.getUserService();
            User user = us.getUser(userName, new String[0]);
            if (user != null) {
                String fullName = user.getFullName();
                mappings.put("fullusername#" + variableName, fullName);
                continue;
            }
            mappings.put("fullusername#" + variableName, userName);
        }
        return mappings;
    }

    public static Long createPdfAndSaveInArchive(String sInputFilePathOldDocx, String sOutputDocClassName, HashMap<String, String> hmMappings, List<Map<String, String>> lTables, Map<String, Object> mOptionalParameters) {
        return WorkflowUtils.createDocAndSaveInArchive(sInputFilePathOldDocx, sOutputDocClassName, hmMappings, lTables, mOptionalParameters, true);
    }

    public static Long createDocAndSaveInArchive(String sInputFilePathOldDocx, String sOutputDocClassName, HashMap<String, String> hmMappings, List<Map<String, String>> lTables, Map<String, Object> mOptionalParameters, boolean pdf) {
        log.trace("************************* Long createDocAndSaveInArchive() ********************");
        Calendar c = Calendar.getInstance();
        Long archivePdfFileId = new Long(-1L);
        File f = null;
        try {
            Object variablesMarker;
            String sVariablesMarker = "";
            log.debug("Pobieranie znacznika zmiennych - variablesMarker");
            if (mOptionalParameters == null) {
                mOptionalParameters = new HashMap<String, Object>();
            }
            sVariablesMarker = StringUtils.isNotBlank((CharSequence)((String)(variablesMarker = mOptionalParameters.get("variablesMarker")))) ? variablesMarker.toString() : "@";
            log.debug("Znacznik zmiennych variablesMarker zosta\u0142 ustawiony na : " + sVariablesMarker);
            log.debug("Ustawianie nazwy pliku wyj\u015bciowego");
            String sOutputFilePath = sInputFilePathOldDocx.replace(".docx", "_" + String.valueOf(c.getTimeInMillis()) + Math.abs(random.nextInt()));
            sOutputFilePath = sOutputFilePath + (pdf ? ".pdf" : ".docx");
            String sProcessId = "";
            if (mOptionalParameters.containsKey("processId")) {
                sProcessId = (String)mOptionalParameters.get("processId");
                log.debug("ProcessId znajduje si\u0119 w mapie mOptionalParameters.");
                log.debug(sProcessId);
            }
            List lWhichTables = null;
            if (mOptionalParameters.containsKey("whichTables")) {
                lWhichTables = (List)mOptionalParameters.get("whichTables");
                log.debug("lWhichTables znajduje si\u0119 w mapie mOptionalParameters.");
                log.debug(lWhichTables.toString());
            }
            List lWhichHeaders = null;
            if (mOptionalParameters.containsKey("whichHeaders")) {
                lWhichHeaders = (List)mOptionalParameters.get("whichHeaders");
                log.debug("lWhichHeaders znajduje si\u0119 w mapie mOptionalParameters.");
                log.debug(lWhichHeaders.toString());
            }
            HashMap<String, Object> mMappingsTmp = new HashMap<String, Object>();
            mMappingsTmp.putAll(hmMappings);
            log.debug(((Object)mMappingsTmp).toString());
            log.debug("Generowanie dokumentu z szablonu .docx");
            f = PrepeareDoc.prepareDocument(sInputFilePathOldDocx, sOutputFilePath, mMappingsTmp, lTables, sVariablesMarker, sProcessId, lWhichTables, lWhichHeaders, pdf);
            log.debug("Generowanie dokumentu z szablonu .docx powiod\u0142o si\u0119.");
            if (f != null && f.length() > 0L) {
                log.debug("Dokumentu wygenerowa\u0142 si\u0119.");
                String documentNewVersion = "FALSE";
                if (mOptionalParameters.containsKey("documentNewVersion")) {
                    documentNewVersion = mOptionalParameters.get("documentNewVersion").toString();
                    log.debug("documentNewVersion znajduje si\u0119 w mapie mOptionalParameters.");
                    log.debug(documentNewVersion);
                }
                String documentDescription = sOutputDocClassName;
                if (mOptionalParameters.containsKey("documentDescription")) {
                    documentDescription = mOptionalParameters.get("documentDescription").toString();
                    log.debug("documentDescription znajduje si\u0119 w mapie mOptionalParameters.");
                    log.debug(documentDescription);
                }
                String[] asIndices = new String[]{};
                if (mOptionalParameters.containsKey("documentIndices")) {
                    asIndices = (String[])mOptionalParameters.get("documentIndices");
                    log.debug("documentIndices znajduje si\u0119 w mapie mOptionalParameters.");
                    log.debug(asIndices.toString());
                }
                log.debug("Pod\u0142\u0105czanie dokumentu do archiwum.");
                archivePdfFileId = new Long(ArchiveServices.AddFileToArchive(sOutputDocClassName, asIndices, f, documentDescription, documentNewVersion, "admin"));
                if (archivePdfFileId >= 0L) {
                    log.debug("Pod\u0142\u0105czenie dokumentu powiod\u0142o si\u0119. Id = ".concat(String.valueOf(archivePdfFileId)));
                } else {
                    log.error("Problem z pod\u0142\u0105czeniem dokumentu do archiwum (id < 0)");
                }
                if (!f.delete()) {
                    log.error("B\u0141\u0104D - Problem z usuni\u0119ciem pliku - mo\u017ce jest otwarty");
                }
            } else {
                log.error("B\u0141\u0104D - Nie utworzy\u0142 si\u0119 plik .pdf");
                if (f != null) {
                    f.delete();
                }
            }
        }
        catch (Exception e) {
            FileUtils.deleteQuietly(f);
            archivePdfFileId = new Long(-1L);
            log.error(e.getMessage(), (Throwable)e);
        }
        return archivePdfFileId;
    }

    public static Long createPdfAndSaveInArchive(String sInputFilePathOldDocx, String sOutputDocClassName, final String sProcessId, Map<String, Object> mOptionalParameters) {
        HashMap<String, String> hmMappings = new HashMap<String, String>();
        Long lDocId = new Long(-1L);
        try {
            if (!Tools.isNullOrEmpty((String)sProcessId)) {
                log.debug("Dodawanie sProcessId do mapy mOptionalParameters. sProcessId = ".concat(sProcessId));
                if (mOptionalParameters == null) {
                    mOptionalParameters = new HashMap<String, Object>();
                }
                mOptionalParameters.put("processId", sProcessId);
                log.debug("Pobieranie mapy kontekstowej procesu - GetProcessContextMap.");
                Map mContextMap = (Map)new SharkTransactionTemplate().execute((SharkTransactionCallback)new SharkTransactionCallback<Map<String, Object>>(){

                    public Map<String, Object> doInSharkTransaction(SharkTransaction transaction, TransactionStatus status) throws Exception {
                        return SharkClientFunctions.getProcessContextMap(transaction, sProcessId);
                    }
                });
                if (mContextMap != null && mContextMap.size() > 0) {
                    for (String key : mContextMap.keySet()) {
                        hmMappings.put(key, String.valueOf(mContextMap.get(key)));
                    }
                    lDocId = WorkflowUtils.createPdfAndSaveInArchive(sInputFilePathOldDocx, sOutputDocClassName, hmMappings, null, mOptionalParameters);
                } else {
                    log.error("B\u0141AD - problem z pobieraniem mapy konekstowej procesu - mapa jest r\u00f3wna null lub nie zawiera element\u00f3w.");
                }
            } else {
                log.error("B\u0141\u0104D - sProcessId jest r\u00f3wne null lub puste.");
            }
        }
        catch (Exception e) {
            lDocId = new Long(-1L);
            log.error(e.getMessage(), (Throwable)e);
        }
        return lDocId;
    }

    public static Long createPdfAndSaveInArchive(String sInputFilePathOldDocx, String sOutputDocClassName, Map<String, Object> mMappings, String sProcessId, Map<String, Object> mOptionalParameters) {
        HashMap<String, String> hmMappings = new HashMap<String, String>();
        Long lDocId = new Long(-1L);
        try {
            if (!Tools.isNullOrEmpty((String)sProcessId)) {
                log.debug("Dodawanie sProcessId do mapy mOptionalParameters. sProcessId = ".concat(sProcessId));
                mOptionalParameters.put("processId", sProcessId);
                for (String key : mMappings.keySet()) {
                    hmMappings.put(key, String.valueOf(mMappings.get(key)));
                }
                lDocId = WorkflowUtils.createPdfAndSaveInArchive(sInputFilePathOldDocx, sOutputDocClassName, hmMappings, null, mOptionalParameters);
            } else {
                log.error("B\u0141\u0104D - sProcessId jest r\u00f3wne null lub puste.");
            }
        }
        catch (Exception e) {
            lDocId = new Long(-1L);
            log.error(e.getMessage(), (Throwable)e);
        }
        return lDocId;
    }

    private static String stripNonValidXMLCharacters(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        value.chars().mapToObj(c -> Character.valueOf((char)c)).filter(WorkflowUtils::isValidXmlChar).forEach(out::append);
        return out.toString();
    }

    private static boolean isValidXmlChar(char current) {
        return current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd' || current >= '\u10000' && current <= '\u10ffff';
    }

    private static Object getDocVariableValue(String mappingKey, Map<String, Object> mappings) {
        Object value = mappings.get(mappingKey);
        return value == null ? "" : value;
    }

    private static String parseValue(Object value) {
        if (value instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format(value);
        }
        return value.toString();
    }

    public static String mergeVariablesTextNodes(String sTemplate, String sVariablesMarker, Map<String, Object> variables) {
        log.trace("************************* mergeVariablesTextNodes(String template, String variablesMarker) ********************");
        log.debug("Wyszukiwanie i scalanie wezlow, kt\u00f3re zosta\u0142y podzielone.");
        StringBuffer mergedString = new StringBuffer(sTemplate);
        int searchingIndex = 0;
        Map<String, Object> foundTextNode = WorkflowUtils.findNextTextNode(mergedString, sVariablesMarker, searchingIndex);
        while (foundTextNode != null) {
            searchingIndex = WorkflowUtils.clearVariableTextNode(mergedString, foundTextNode, variables);
            foundTextNode = WorkflowUtils.findNextTextNode(mergedString, sVariablesMarker, searchingIndex);
        }
        log.debug("Wyszukiwanie i scalanie wezlow, kt\u00f3re zosta\u0142y podzielone powiodlo sie.");
        return mergedString.toString();
    }

    private static int clearVariableTextNode(StringBuffer mergedString, Map<String, Object> textNode, Map<String, Object> variables) {
        int searchingIndex;
        int endIndex = (Integer)textNode.get("endIndex");
        String clearedTextNode = WorkflowUtils.clearTextNode(textNode.get("content").toString());
        if (WorkflowUtils.hasAnyVariableKeyOrVariableKeyWithLabel(clearedTextNode, variables)) {
            int startIndex = (Integer)textNode.get("startIndex") + 1;
            mergedString.replace(startIndex, endIndex, clearedTextNode);
            searchingIndex = startIndex + clearedTextNode.length() + 1;
        } else {
            searchingIndex = endIndex;
        }
        return searchingIndex;
    }

    private static Map<String, Object> findNextTextNode(StringBuffer mergedString, String sVariablesMarker, int searchingIndex) {
        int startIndex = mergedString.indexOf(sVariablesMarker, searchingIndex);
        if (startIndex == -1) {
            return null;
        }
        int endIndex = mergedString.indexOf(sVariablesMarker, startIndex + 1);
        if (endIndex == -1) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("content", mergedString.substring(startIndex + 1, endIndex));
        result.put("startIndex", startIndex);
        result.put("endIndex", endIndex);
        return result;
    }

    private static boolean hasAnyVariableKeyOrVariableKeyWithLabel(String textNode, Map<String, Object> variables) {
        if (textNode.startsWith("fullusername#")) {
            textNode = textNode.substring(13);
        }
        for (String key : variables.keySet()) {
            if (!textNode.equals(key)) continue;
            return true;
        }
        return false;
    }

    private static String clearTextNode(String stringToClear) {
        StringBuffer tmp = new StringBuffer(stringToClear);
        boolean isClearingNecessary = true;
        while (isClearingNecessary) {
            int startIndex = tmp.indexOf("<");
            int endIndex = tmp.indexOf(">");
            if (startIndex > -1) {
                tmp.delete(startIndex, endIndex + 1);
                continue;
            }
            isClearingNecessary = false;
        }
        return tmp.toString();
    }
}

