/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension.DocTemplates2Pdf;

import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.exception.InvalidTemplateException;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.graphic.ColumnGraphicInfo;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.graphic.DelegatedFileConversionImageHandler;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.pdf.PdfUtils;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.table.DynamicTablesResolver;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.table.TableInfo;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.table.TableUtils;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.workflow.WorkflowUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.docx4j.Docx4J;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.fonts.BestMatchingMapper;
import org.docx4j.fonts.Mapper;
import org.docx4j.model.images.ConversionImageHandler;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.Document;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TrPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepeareDoc {
    private static final Logger log = LoggerFactory.getLogger(PrepeareDoc.class);
    public static final String TAB_TO_PROC_STR = "TABLE_TO_PROCESS_MARKER";
    public static final String TAB_NOT_TO_PROC_STR = "TABLE_NOT_TO_PROCESS_MARKER";
    public static final String TAB_WOUT_HDS_STRING = "TABLE_WITHOUT_HEADERS_MARKER";
    private static final SecureRandom random = new SecureRandom();
    public static final String VARIABLE_MARKER = "@";

    public static File prepeareWordDocument(String templatePath, String outputFilePath, Map<String, Object> mappings, List<Map<String, String>> tables, String variablesMarker, String processId, List<Boolean> headersAdditionalFlags, List<Boolean> tablesAdditionalFlags) {
        return PrepeareDoc.prepareDocument(templatePath, outputFilePath, mappings, tables, variablesMarker, processId, headersAdditionalFlags, tablesAdditionalFlags, true);
    }

    public static File prepareDocument(String templatePath, String outputFilePath, Map<String, Object> mappings, List<Map<String, String>> tablesMaps, String variablesMarker, String processId, List<Boolean> tablesAdditionalFlags, List<Boolean> headersAdditionalFlags, boolean pdf) {
        block15: {
            log.trace("************************* prepareDocument() ********************");
            try {
                log.debug("Pobieranie szablonu dla pliku: ".concat(templatePath));
                WordprocessingMLPackage template = WordprocessingMLPackage.load((File)new File(templatePath));
                log.debug("Pobieranie MainDocumentPart.");
                MainDocumentPart documentPart = template.getMainDocumentPart();
                log.debug("Preparing header and footer");
                PrepeareDoc.prepareHeaderFooter(template, mappings, variablesMarker);
                log.debug("Pobieranie JAXBElement - DocumentElement.");
                Document wmlDocumentEl = (Document)documentPart.getJaxbElement();
                log.debug("Pobieranie wezlow table z dokumentu.");
                List nodes = documentPart.getJAXBNodesViaXPath("//w:tbl", false);
                if (nodes == null) break block15;
                log.debug("Inicjowanie flag");
                List<Tbl> tables = TableUtils.getTables(nodes);
                ArrayList<Boolean> tablesFlags = new ArrayList<Boolean>();
                ArrayList<Boolean> headersFlags = new ArrayList<Boolean>();
                ArrayList<ColumnGraphicInfo> tablesGraphicColumnInfo = new ArrayList<ColumnGraphicInfo>();
                TableUtils.removeMarkupRows(tables, tablesFlags, headersFlags);
                log.debug("Inicjowanie dodatkowych flag");
                if (tablesAdditionalFlags == null && headersAdditionalFlags == null) {
                    tablesAdditionalFlags = new ArrayList<Boolean>();
                    headersAdditionalFlags = new ArrayList<Boolean>();
                    List<TableInfo> tablesInfo = DynamicTablesResolver.getTables(documentPart);
                    for (TableInfo tableInfo : tablesInfo) {
                        tablesAdditionalFlags.add(tableInfo.isDynamic());
                        headersAdditionalFlags.add(!tableInfo.isHeaderless());
                        tablesGraphicColumnInfo.add(tableInfo.getColumnGraphicInfo());
                    }
                } else {
                    int tableFlagSize = tablesAdditionalFlags != null ? tablesAdditionalFlags.size() : 0;
                    int headerFlagSize = headersAdditionalFlags != null ? headersAdditionalFlags.size() : 0;
                    int size = tableFlagSize > headerFlagSize ? tableFlagSize : headerFlagSize;
                    for (int index = 0; index < size; ++index) {
                        tablesGraphicColumnInfo.add(new ColumnGraphicInfo());
                    }
                }
                log.debug("Ustawianie flag wszystkich tabel.");
                boolean bTablesToProcessMarkers = true;
                if (tablesAdditionalFlags == null) {
                    log.debug("whichTables = null.");
                    if (tablesFlags.contains(true) || tablesFlags.contains(false)) {
                        bTablesToProcessMarkers = false;
                    }
                    for (int i = 0; i < nodes.size(); ++i) {
                        if (tablesFlags.get(i) != null) continue;
                        tablesFlags.remove(i);
                        tablesFlags.add(i, bTablesToProcessMarkers);
                    }
                } else {
                    log.debug("whichTables != null.");
                    log.debug("Przepisanie warto\u015bci z whichTables do whichTablesTmp.");
                    tablesFlags.clear();
                    tablesFlags.addAll(tablesAdditionalFlags);
                    log.debug("Przepisanie warto\u015bci powiod\u0142o si\u0119.");
                }
                if (headersAdditionalFlags == null) {
                    log.debug("whichHeaders = null.");
                    for (int i = 0; i < nodes.size(); ++i) {
                        if (headersFlags.get(i) != null) continue;
                        headersFlags.remove(i);
                        headersFlags.add(i, true);
                    }
                } else {
                    log.debug("whichHeaders != null.");
                    log.debug("Przepisanie warto\u015bci z whichHeaders do whichHeadersTmp.");
                    headersFlags.clear();
                    headersFlags.addAll(headersAdditionalFlags);
                    log.debug("Przepisanie warto\u015bci powiod\u0142o si\u0119.");
                }
                log.debug("tablesFlags: ");
                log.debug(((Object)tablesFlags).toString());
                log.debug("headersFlags: ");
                log.debug(((Object)headersFlags).toString());
                log.debug("graphicFlags: ");
                log.debug(PrepeareDoc.graphicFlags(tablesGraphicColumnInfo));
                if (tablesFlags.size() == nodes.size() && headersFlags.size() == nodes.size()) {
                    TableUtils.initTableMarkups(templatePath, mappings, tablesMaps, variablesMarker, processId, template, documentPart, tables, tablesFlags, headersFlags, tablesGraphicColumnInfo);
                    log.debug("MarshalToString.");
                    String xml = XmlUtils.marshaltoString((Object)wmlDocumentEl, (boolean)true);
                    log.debug("MarshalToString powiodlo sie.");
                    log.debug("Uzupe\u0142nianie zmiennych w szablonie.");
                    String tmp = WorkflowUtils.replaceVariablesInTemplate(xml, mappings, variablesMarker);
                    log.debug("Uzupelnianie zmiennych w szablonie powiodlo sie.");
                    log.debug("UnmarshalString");
                    Object obj = XmlUtils.unmarshalString((String)tmp);
                    log.debug("UnmarshalString powiodlo sie.");
                    log.debug("Ustawianie elementu JAXB na uzupelniony wartosciami.");
                    documentPart.setJaxbElement((Object)((Document)obj));
                    log.debug("Ustawianie elementu JAXB powiodlo sie.");
                    return PrepeareDoc.saveFile(template, templatePath, pdf, outputFilePath);
                }
                log.error("B\u0141\u0104D - liczba tabel do uzupelnienia na liscie tablesFlags lub headersFlags jest r\u00f3\u017cna od liczby tabel w dokumencie");
            }
            catch (InvalidTemplateException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                log.debug("B\u0141\u0104D - przy pobieraniu w\u0119z\u0142\u00f3w z tabelami (z pliku XML - XPath)");
            }
        }
        return null;
    }

    private static String graphicFlags(List<ColumnGraphicInfo> tablesGraphicColumnInfo) {
        StringBuilder sb = new StringBuilder("[");
        for (int index = 0; index < tablesGraphicColumnInfo.size(); ++index) {
            if (index > 0) {
                sb.append(",");
            }
            sb.append(tablesGraphicColumnInfo.get(index).getGraphicColumn());
        }
        sb.append("]");
        return sb.toString();
    }

    private static File saveFile(WordprocessingMLPackage template, String templatePath, boolean pdf, String outputFilePath) throws Docx4JException {
        SaveToZipFile saver = new SaveToZipFile((OpcPackage)template);
        if (!pdf) {
            log.debug("Zapis to pliku docx.");
            saver.save(outputFilePath);
            return new File(outputFilePath);
        }
        log.debug("Zapis to pliku tymczasowego docx.");
        String tempDocxFilePath = templatePath.replace(".docx", "_" + String.valueOf(System.currentTimeMillis()) + Math.abs(random.nextInt()) + ".docx");
        saver.save(tempDocxFilePath);
        log.debug("Zapis do pliku tymczasowego docx powiodl sie: " + tempDocxFilePath);
        File tempdocXFile = new File(tempDocxFilePath);
        log.debug(tempdocXFile.getAbsolutePath());
        if (tempdocXFile.exists()) {
            log.debug("Wygenerowanie pliku .pdf");
            File tmpFile = PrepeareDoc.doc2PdfWithoutOO(tempDocxFilePath, outputFilePath);
            log.debug("Wygenerowanie pliku .pdf powiodlo sie: ".concat(outputFilePath));
            log.debug("Usuniecie uzupelnionego szablonu docx: ".concat(tempDocxFilePath));
            if (!tempdocXFile.delete()) {
                log.error(" - problem z usuni\u0119ciem pliku tymczasowego.");
            }
            return tmpFile;
        }
        log.error("B\u0141\u0104D - nowy dokument si\u0119 nie utworzy\u0142, nie ma uzupelnionego szablonu .docx: ".concat(tempDocxFilePath));
        return null;
    }

    public static void prepareHeaderFooter(WordprocessingMLPackage wordMLPackage, Map<String, Object> mappings, String sVariablesMarker) {
        RelationshipsPart rp = wordMLPackage.getMainDocumentPart().getRelationshipsPart();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            if (r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header")) {
                HeaderPart hp = (HeaderPart)rp.getPart(r);
                WorkflowUtils.replaceVariablesAndSave(hp, mappings, sVariablesMarker);
                log.debug("Header replaced correctly");
                continue;
            }
            if (!r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
            FooterPart fp = (FooterPart)rp.getPart(r);
            WorkflowUtils.replaceVariablesAndSave(fp, mappings, sVariablesMarker);
            log.debug("Footer replaced correctly");
        }
    }

    public static void createTableWithValues(MainDocumentPart mdp, Tbl table, List<String> lValues, List<Map<String, Object>> lParagraphProperties, ColumnGraphicInfo columnGraphicInfo, WordprocessingMLPackage template) {
        TableUtils.createTableWithValues(mdp, table, lValues, lParagraphProperties, null, columnGraphicInfo, template);
    }

    public static File doc2PdfWithoutOO(String sInputFilePathDocx, String sOutputFilePathPdf) {
        log.trace("************************* doc2PdfWithout(String sInputFilePathDocx, String sOutputFilePathPdf) ********************");
        try {
            log.debug("\u0141adowanie WMLPackage z pliku: ".concat(sInputFilePathDocx));
            WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load((File)new File(sInputFilePathDocx));
            if (wordMLPackage != null) {
                log.debug("\u0141adowanie WMLPackage powiod\u0142o si\u0119.");
                log.debug("WMLPackage conversion");
                BestMatchingMapper fontMapper = new BestMatchingMapper();
                try {
                    wordMLPackage.setFontMapper((Mapper)fontMapper);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    log.debug("B\u0141\u0104D - problem z mapperem!");
                }
                log.debug("WMLPackage conversion powiod\u0142o si\u0119.");
                log.debug("Tworzenie pliku .fo");
                File tmp = new File(sInputFilePathDocx + ".fo");
                log.debug("Tworzenie pliku .fo powiod\u0142o si\u0119.");
                log.debug("SetSaveFO pliku .fo");
                DelegatedFileConversionImageHandler imageHandler = new DelegatedFileConversionImageHandler();
                FOSettings foSettings = Docx4J.createFOSettings();
                foSettings.setFoDumpFile(tmp);
                foSettings.setWmlPackage((OpcPackage)wordMLPackage);
                foSettings.setImageHandler((ConversionImageHandler)imageHandler);
                log.debug("SetSaveFO powiod\u0142o si\u0119.");
                File outputFilePdf = new File(sOutputFilePathPdf);
                try {
                    log.debug("Stworzenie FileOutputStream dla pliku: ".concat(sOutputFilePathPdf));
                    FileOutputStream os = new FileOutputStream(outputFilePdf);
                    try {
                        log.debug("Ustawienie FileOutputStream.");
                        Docx4J.toFO((FOSettings)foSettings, (OutputStream)os, (int)1);
                        log.debug("Ustawienie FileOutputStream powiod\u0142o si\u0119.");
                    }
                    catch (Throwable e) {
                        log.error(e.getMessage(), e);
                        log.debug("B\u0141\u0104D - brak pliku, problem z utworzeniem pliku .pdf");
                    }
                    PdfUtils.removeBlankPages(sOutputFilePathPdf);
                    log.debug("Zapisano do " + sOutputFilePathPdf);
                }
                catch (FileNotFoundException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    log.debug("B\u0141\u0104D - brak pliku, problem z utworzeniem pliku .pdf");
                }
                if (!tmp.delete()) {
                    log.debug("B\u0141\u0104D - problem z usuni\u0119ciem pliku .fo");
                }
                imageHandler.cleanUp();
                return outputFilePdf;
            }
            log.error("B\u0141\u0104D - przy tworzeniu PdfConversion");
        }
        catch (Docx4JException e) {
            log.error(e.getMessage(), (Throwable)e);
            log.debug("B\u0141\u0104D - przy tworzeniu wordMLPackage z pliku .docx");
        }
        return null;
    }

    public static String replaceVariablesInTemplate(String template, Map<String, Object> mappings, String variablesMarker) {
        return WorkflowUtils.replaceVariablesInTemplate(template, mappings, variablesMarker);
    }

    public static String mergeVariablesTextNodes(String sTemplate, String sVariablesMarker, Map<String, Object> variables) {
        return WorkflowUtils.mergeVariablesTextNodes(sTemplate, sVariablesMarker, variables);
    }

    public static Long createPdfAndSaveInArchive(String sInputFilePathOldDocx, String sOutputDocClassName, HashMap<String, String> hmMappings, List<Map<String, String>> lTables, Map<String, Object> mOptionalParameters) {
        return WorkflowUtils.createPdfAndSaveInArchive(sInputFilePathOldDocx, sOutputDocClassName, hmMappings, lTables, mOptionalParameters);
    }

    public static Long createDocAndSaveInArchive(String sInputFilePathOldDocx, String sOutputDocClassName, HashMap<String, String> hmMappings, List<Map<String, String>> lTables, Map<String, Object> mOptionalParameters, boolean pdf) {
        return WorkflowUtils.createDocAndSaveInArchive(sInputFilePathOldDocx, sOutputDocClassName, hmMappings, lTables, mOptionalParameters, pdf);
    }

    public static Long createPdfAndSaveInArchive(String sInputFilePathOldDocx, String sOutputDocClassName, String sProcessId, Map<String, Object> mOptionalParameters) {
        return WorkflowUtils.createPdfAndSaveInArchive(sInputFilePathOldDocx, sOutputDocClassName, sProcessId, mOptionalParameters);
    }

    public static Long createPdfAndSaveInArchive(String sInputFilePathOldDocx, String sOutputDocClassName, Map<String, Object> mMappings, String sProcessId, Map<String, Object> mOptionalParameters) {
        return WorkflowUtils.createPdfAndSaveInArchive(sInputFilePathOldDocx, sOutputDocClassName, mMappings, sProcessId, mOptionalParameters);
    }

    public static void createTableWithValues(MainDocumentPart mdp, Tbl table, List<String> lValues, List<Map<String, Object>> lParagraphProperties) {
        PrepeareDoc.createTableWithValues(mdp, table, lValues, lParagraphProperties, null);
    }

    public static void createTableWithValues(MainDocumentPart mdp, Tbl table, List<String> lValues, List<Map<String, Object>> lParagraphProperties, TrPr rowProperties) {
        TableUtils.createTableWithValues(mdp, table, lValues, lParagraphProperties, rowProperties, null, null);
    }

    public static void createTableWithValues(MainDocumentPart mdp, int iTableNr, Tbl table, Map<String, String> mValues, List<Map<String, Object>> lParagraphProperties) {
        TableUtils.createTableWithValues(mdp, iTableNr, table, mValues, lParagraphProperties);
    }

    public static void createTableWithValues(MainDocumentPart mdp, Tbl table, List<String> lValues, List<Map<String, Object>> lParagraphProperties, TrPr rowProperties, ColumnGraphicInfo columnGraphicInfo, WordprocessingMLPackage template) {
        TableUtils.createTableWithValues(mdp, table, lValues, lParagraphProperties, rowProperties, columnGraphicInfo, template);
    }
}

